// chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace connectors_internals::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "connectors_internals.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDeviceTrustStateMinVersion = 0,
    kDeleteDeviceTrustKeyMinVersion = 0,
    kGetClientCertificateStateMinVersion = 0,
    kGetSignalsReportingStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDeviceTrustState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteDeviceTrustKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetClientCertificateState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSignalsReportingState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetDeviceTrustStateCallback = base::OnceCallback<void(DeviceTrustStatePtr)>;
  using GetDeviceTrustStateMojoCallback = base::OnceCallback<void(DeviceTrustStatePtr)>;

  virtual void GetDeviceTrustState(GetDeviceTrustStateCallback callback) = 0;

  using DeleteDeviceTrustKeyCallback = base::OnceCallback<void()>;
  using DeleteDeviceTrustKeyMojoCallback = base::OnceCallback<void()>;

  virtual void DeleteDeviceTrustKey(DeleteDeviceTrustKeyCallback callback) = 0;

  using GetClientCertificateStateCallback = base::OnceCallback<void(ClientCertificateStatePtr)>;
  using GetClientCertificateStateMojoCallback = base::OnceCallback<void(ClientCertificateStatePtr)>;

  virtual void GetClientCertificateState(GetClientCertificateStateCallback callback) = 0;

  using GetSignalsReportingStateCallback = base::OnceCallback<void(SignalsReportingStatePtr)>;
  using GetSignalsReportingStateMojoCallback = base::OnceCallback<void(SignalsReportingStatePtr)>;

  virtual void GetSignalsReportingState(GetSignalsReportingStateCallback callback) = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDeviceTrustState(GetDeviceTrustStateCallback callback) final;
  
  void DeleteDeviceTrustKey(DeleteDeviceTrustKeyCallback callback) final;
  
  void GetClientCertificateState(GetClientCertificateStateCallback callback) final;
  
  void GetSignalsReportingState(GetSignalsReportingStateCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  Int32Value {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Int32Value, T>::value>;
  using DataView = Int32ValueDataView;
  using Data_ = internal::Int32Value_Data;

  template <typename... Args>
  static Int32ValuePtr New(Args&&... args) {
    return Int32ValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Int32ValuePtr From(const U& u) {
    return mojo::TypeConverter<Int32ValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Int32Value>::Convert(*this);
  }


  Int32Value();

  explicit Int32Value(
      int32_t value);


  ~Int32Value();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Int32ValuePtr>
  Int32ValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Int32Value::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Int32Value::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Int32Value::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Int32Value::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Int32Value::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Int32Value::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Int32Value_UnserializedMessageContext<
            UserType, Int32Value::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Int32Value::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Int32Value::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Int32Value_UnserializedMessageContext<
            UserType, Int32Value::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Int32Value::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Int32Value::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Int32Value::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Int32Value::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Int32Value::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  ConsentMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConsentMetadata, T>::value>;
  using DataView = ConsentMetadataDataView;
  using Data_ = internal::ConsentMetadata_Data;

  template <typename... Args>
  static ConsentMetadataPtr New(Args&&... args) {
    return ConsentMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConsentMetadataPtr From(const U& u) {
    return mojo::TypeConverter<ConsentMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConsentMetadata>::Convert(*this);
  }


  ConsentMetadata();

  ConsentMetadata(
      bool can_collect_signals,
      bool consent_received);


  ~ConsentMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConsentMetadataPtr>
  ConsentMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConsentMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConsentMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConsentMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConsentMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConsentMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConsentMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConsentMetadata_UnserializedMessageContext<
            UserType, ConsentMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConsentMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConsentMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConsentMetadata_UnserializedMessageContext<
            UserType, ConsentMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConsentMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool can_collect_signals;
  
  bool consent_received;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConsentMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConsentMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConsentMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConsentMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  KeyUploadStatus {
 public:
  using DataView = KeyUploadStatusDataView;
  using Data_ = internal::KeyUploadStatus_Data;
  using Tag = Data_::KeyUploadStatus_Tag;

  template <typename... Args>
  static KeyUploadStatusPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |sync_key_response_code|.
  static KeyUploadStatusPtr NewSyncKeyResponseCode(
      Int32ValuePtr value);
  // Construct an instance holding |upload_client_error|.
  static KeyUploadStatusPtr NewUploadClientError(
      const std::string& value);

  template <typename U>
  static KeyUploadStatusPtr From(const U& u) {
    return mojo::TypeConverter<KeyUploadStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KeyUploadStatus>::Convert(*this);
  }
  ~KeyUploadStatus();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  KeyUploadStatus(const KeyUploadStatus& other) = delete;
  KeyUploadStatus& operator=(const KeyUploadStatus& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = KeyUploadStatusPtr>
  KeyUploadStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, KeyUploadStatus>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, KeyUploadStatus>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_sync_key_response_code() const { return tag_ == Tag::kSyncKeyResponseCode; }
  const Int32ValuePtr& get_sync_key_response_code() const {
    CHECK(tag_ == Tag::kSyncKeyResponseCode);
    return data_.sync_key_response_code;
  }
  Int32ValuePtr& get_sync_key_response_code() {
    CHECK(tag_ == Tag::kSyncKeyResponseCode);
    return data_.sync_key_response_code;
  }
  void set_sync_key_response_code(Int32ValuePtr sync_key_response_code);

  bool is_upload_client_error() const { return tag_ == Tag::kUploadClientError; }
  const std::string& get_upload_client_error() const {
    CHECK(tag_ == Tag::kUploadClientError);
    return data_.upload_client_error;
  }
  std::string& get_upload_client_error() {
    CHECK(tag_ == Tag::kUploadClientError);
    return data_.upload_client_error;
  }
  void set_upload_client_error(const std::string& upload_client_error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KeyUploadStatus::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<KeyUploadStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSyncKeyResponseCode)>,
        Int32ValuePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUploadClientError)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    Int32ValuePtr sync_key_response_code;
    std::string upload_client_error;
  };

  KeyUploadStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kSyncKeyResponseCode)>,
      Int32ValuePtr value);
  KeyUploadStatus(
      std::in_place_index_t<static_cast<size_t>(Tag::kUploadClientError)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  LoadedKeyInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadedKeyInfo, T>::value>;
  using DataView = LoadedKeyInfoDataView;
  using Data_ = internal::LoadedKeyInfo_Data;

  template <typename... Args>
  static LoadedKeyInfoPtr New(Args&&... args) {
    return LoadedKeyInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadedKeyInfoPtr From(const U& u) {
    return mojo::TypeConverter<LoadedKeyInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadedKeyInfo>::Convert(*this);
  }


  LoadedKeyInfo();

  LoadedKeyInfo(
      KeyTrustLevel trust_level,
      KeyType key_type,
      const std::string& encoded_spki_hash,
      KeyUploadStatusPtr key_upload_status,
      bool has_ssl_key);

LoadedKeyInfo(const LoadedKeyInfo&) = delete;
LoadedKeyInfo& operator=(const LoadedKeyInfo&) = delete;

  ~LoadedKeyInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadedKeyInfoPtr>
  LoadedKeyInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadedKeyInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoadedKeyInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoadedKeyInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadedKeyInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadedKeyInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadedKeyInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadedKeyInfo_UnserializedMessageContext<
            UserType, LoadedKeyInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoadedKeyInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoadedKeyInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadedKeyInfo_UnserializedMessageContext<
            UserType, LoadedKeyInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadedKeyInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  KeyTrustLevel trust_level;
  
  KeyType key_type;
  
  std::string encoded_spki_hash;
  
  KeyUploadStatusPtr key_upload_status;
  
  bool has_ssl_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadedKeyInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadedKeyInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadedKeyInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadedKeyInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  KeyInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<KeyInfo, T>::value>;
  using DataView = KeyInfoDataView;
  using Data_ = internal::KeyInfo_Data;

  template <typename... Args>
  static KeyInfoPtr New(Args&&... args) {
    return KeyInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KeyInfoPtr From(const U& u) {
    return mojo::TypeConverter<KeyInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KeyInfo>::Convert(*this);
  }


  KeyInfo();

  KeyInfo(
      KeyManagerInitializedValue is_key_manager_initialized,
      LoadedKeyInfoPtr loaded_key_info,
      KeyManagerPermanentFailure permanent_failure);

KeyInfo(const KeyInfo&) = delete;
KeyInfo& operator=(const KeyInfo&) = delete;

  ~KeyInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KeyInfoPtr>
  KeyInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, KeyInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, KeyInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, KeyInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeyInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KeyInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::KeyInfo_UnserializedMessageContext<
            UserType, KeyInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<KeyInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return KeyInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::KeyInfo_UnserializedMessageContext<
            UserType, KeyInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<KeyInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  KeyManagerInitializedValue is_key_manager_initialized;
  
  LoadedKeyInfoPtr loaded_key_info;
  
  KeyManagerPermanentFailure permanent_failure;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, KeyInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, KeyInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, KeyInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, KeyInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  DeviceTrustState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceTrustState, T>::value>;
  using DataView = DeviceTrustStateDataView;
  using Data_ = internal::DeviceTrustState_Data;

  template <typename... Args>
  static DeviceTrustStatePtr New(Args&&... args) {
    return DeviceTrustStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceTrustStatePtr From(const U& u) {
    return mojo::TypeConverter<DeviceTrustStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceTrustState>::Convert(*this);
  }


  DeviceTrustState();

  DeviceTrustState(
      bool is_enabled,
      std::vector<std::string> policy_enabled_levels,
      KeyInfoPtr key_info,
      const std::string& signals_json,
      ConsentMetadataPtr consent_metadata);

DeviceTrustState(const DeviceTrustState&) = delete;
DeviceTrustState& operator=(const DeviceTrustState&) = delete;

  ~DeviceTrustState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceTrustStatePtr>
  DeviceTrustStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceTrustState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceTrustState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceTrustState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceTrustState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceTrustState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceTrustState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceTrustState_UnserializedMessageContext<
            UserType, DeviceTrustState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceTrustState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceTrustState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceTrustState_UnserializedMessageContext<
            UserType, DeviceTrustState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceTrustState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_enabled;
  
  std::vector<std::string> policy_enabled_levels;
  
  KeyInfoPtr key_info;
  
  std::string signals_json;
  
  ConsentMetadataPtr consent_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceTrustState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceTrustState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceTrustState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceTrustState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CertificateMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertificateMetadata, T>::value>;
  using DataView = CertificateMetadataDataView;
  using Data_ = internal::CertificateMetadata_Data;

  template <typename... Args>
  static CertificateMetadataPtr New(Args&&... args) {
    return CertificateMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertificateMetadataPtr From(const U& u) {
    return mojo::TypeConverter<CertificateMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertificateMetadata>::Convert(*this);
  }


  CertificateMetadata();

  CertificateMetadata(
      const std::string& serial_number,
      const std::string& fingerprint,
      const std::string& creation_date_string,
      const std::string& expiration_date_string,
      const std::string& subject_display_name,
      const std::string& issuer_display_name);


  ~CertificateMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertificateMetadataPtr>
  CertificateMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertificateMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CertificateMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CertificateMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertificateMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertificateMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertificateMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertificateMetadata_UnserializedMessageContext<
            UserType, CertificateMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CertificateMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CertificateMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertificateMetadata_UnserializedMessageContext<
            UserType, CertificateMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertificateMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string serial_number;
  
  std::string fingerprint;
  
  std::string creation_date_string;
  
  std::string expiration_date_string;
  
  std::string subject_display_name;
  
  std::string issuer_display_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertificateMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertificateMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertificateMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertificateMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ClientIdentity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClientIdentity, T>::value>;
  using DataView = ClientIdentityDataView;
  using Data_ = internal::ClientIdentity_Data;

  template <typename... Args>
  static ClientIdentityPtr New(Args&&... args) {
    return ClientIdentityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClientIdentityPtr From(const U& u) {
    return mojo::TypeConverter<ClientIdentityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClientIdentity>::Convert(*this);
  }


  ClientIdentity();

  ClientIdentity(
      const std::string& identity_name,
      LoadedKeyInfoPtr loaded_key_info,
      CertificateMetadataPtr certificate_metadata);

ClientIdentity(const ClientIdentity&) = delete;
ClientIdentity& operator=(const ClientIdentity&) = delete;

  ~ClientIdentity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClientIdentityPtr>
  ClientIdentityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClientIdentity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClientIdentity::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClientIdentity::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientIdentity::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientIdentity::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClientIdentity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClientIdentity_UnserializedMessageContext<
            UserType, ClientIdentity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClientIdentity::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClientIdentity::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClientIdentity_UnserializedMessageContext<
            UserType, ClientIdentity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClientIdentity::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string identity_name;
  
  LoadedKeyInfoPtr loaded_key_info;
  
  CertificateMetadataPtr certificate_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClientIdentity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClientIdentity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClientIdentity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClientIdentity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ClientCertificateState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClientCertificateState, T>::value>;
  using DataView = ClientCertificateStateDataView;
  using Data_ = internal::ClientCertificateState_Data;

  template <typename... Args>
  static ClientCertificateStatePtr New(Args&&... args) {
    return ClientCertificateStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClientCertificateStatePtr From(const U& u) {
    return mojo::TypeConverter<ClientCertificateStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClientCertificateState>::Convert(*this);
  }


  ClientCertificateState();

  ClientCertificateState(
      std::vector<std::string> policy_enabled_levels,
      ClientIdentityPtr managed_profile_identity,
      ClientIdentityPtr managed_browser_identity);

ClientCertificateState(const ClientCertificateState&) = delete;
ClientCertificateState& operator=(const ClientCertificateState&) = delete;

  ~ClientCertificateState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClientCertificateStatePtr>
  ClientCertificateStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClientCertificateState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClientCertificateState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClientCertificateState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientCertificateState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientCertificateState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClientCertificateState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClientCertificateState_UnserializedMessageContext<
            UserType, ClientCertificateState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClientCertificateState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClientCertificateState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClientCertificateState_UnserializedMessageContext<
            UserType, ClientCertificateState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClientCertificateState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> policy_enabled_levels;
  
  ClientIdentityPtr managed_profile_identity;
  
  ClientIdentityPtr managed_browser_identity;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClientCertificateState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClientCertificateState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClientCertificateState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClientCertificateState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SignalsReportingState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignalsReportingState, T>::value>;
  using DataView = SignalsReportingStateDataView;
  using Data_ = internal::SignalsReportingState_Data;

  template <typename... Args>
  static SignalsReportingStatePtr New(Args&&... args) {
    return SignalsReportingStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignalsReportingStatePtr From(const U& u) {
    return mojo::TypeConverter<SignalsReportingStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignalsReportingState>::Convert(*this);
  }


  SignalsReportingState();

  SignalsReportingState(
      const std::optional<std::string>& error_info,
      bool status_report_enabled,
      bool signals_report_enabled,
      const std::string& last_upload_attempt_timestamp,
      const std::string& last_upload_success_timestamp,
      const std::string& last_signals_upload_config,
      bool can_collect_all_fields);


  ~SignalsReportingState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignalsReportingStatePtr>
  SignalsReportingStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignalsReportingState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SignalsReportingState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SignalsReportingState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignalsReportingState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignalsReportingState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignalsReportingState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignalsReportingState_UnserializedMessageContext<
            UserType, SignalsReportingState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SignalsReportingState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SignalsReportingState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignalsReportingState_UnserializedMessageContext<
            UserType, SignalsReportingState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignalsReportingState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> error_info;
  
  bool status_report_enabled;
  
  bool signals_report_enabled;
  
  std::string last_upload_attempt_timestamp;
  
  std::string last_upload_success_timestamp;
  
  std::string last_signals_upload_config;
  
  bool can_collect_all_fields;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignalsReportingState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignalsReportingState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignalsReportingState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignalsReportingState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
KeyUploadStatusPtr KeyUploadStatus::Clone() const {
  switch (tag_) {
    case Tag::kSyncKeyResponseCode:
      return NewSyncKeyResponseCode(
          mojo::Clone(data_.sync_key_response_code));
    case Tag::kUploadClientError:
      return NewUploadClientError(
          mojo::Clone(data_.upload_client_error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, KeyUploadStatus>::value>::type*>
bool KeyUploadStatus::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSyncKeyResponseCode:
      return mojo::Equals(data_.sync_key_response_code, other.data_.sync_key_response_code);
    case Tag::kUploadClientError:
      return mojo::Equals(data_.upload_client_error, other.data_.upload_client_error);
  }

  return false;
}
template <typename StructPtrType>
Int32ValuePtr Int32Value::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, Int32Value::EnableIfSame<T>*>
bool Int32Value::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, Int32Value::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
LoadedKeyInfoPtr LoadedKeyInfo::Clone() const {
  return New(
      mojo::Clone(trust_level),
      mojo::Clone(key_type),
      mojo::Clone(encoded_spki_hash),
      mojo::Clone(key_upload_status),
      mojo::Clone(has_ssl_key)
  );
}

template <typename T, LoadedKeyInfo::EnableIfSame<T>*>
bool LoadedKeyInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->trust_level, other_struct.trust_level))
    return false;
  if (!mojo::Equals(this->key_type, other_struct.key_type))
    return false;
  if (!mojo::Equals(this->encoded_spki_hash, other_struct.encoded_spki_hash))
    return false;
  if (!mojo::Equals(this->key_upload_status, other_struct.key_upload_status))
    return false;
  if (!mojo::Equals(this->has_ssl_key, other_struct.has_ssl_key))
    return false;
  return true;
}

template <typename T, LoadedKeyInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.trust_level < rhs.trust_level)
    return true;
  if (rhs.trust_level < lhs.trust_level)
    return false;
  if (lhs.key_type < rhs.key_type)
    return true;
  if (rhs.key_type < lhs.key_type)
    return false;
  if (lhs.encoded_spki_hash < rhs.encoded_spki_hash)
    return true;
  if (rhs.encoded_spki_hash < lhs.encoded_spki_hash)
    return false;
  if (lhs.key_upload_status < rhs.key_upload_status)
    return true;
  if (rhs.key_upload_status < lhs.key_upload_status)
    return false;
  if (lhs.has_ssl_key < rhs.has_ssl_key)
    return true;
  if (rhs.has_ssl_key < lhs.has_ssl_key)
    return false;
  return false;
}
template <typename StructPtrType>
KeyInfoPtr KeyInfo::Clone() const {
  return New(
      mojo::Clone(is_key_manager_initialized),
      mojo::Clone(loaded_key_info),
      mojo::Clone(permanent_failure)
  );
}

template <typename T, KeyInfo::EnableIfSame<T>*>
bool KeyInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_key_manager_initialized, other_struct.is_key_manager_initialized))
    return false;
  if (!mojo::Equals(this->loaded_key_info, other_struct.loaded_key_info))
    return false;
  if (!mojo::Equals(this->permanent_failure, other_struct.permanent_failure))
    return false;
  return true;
}

template <typename T, KeyInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_key_manager_initialized < rhs.is_key_manager_initialized)
    return true;
  if (rhs.is_key_manager_initialized < lhs.is_key_manager_initialized)
    return false;
  if (lhs.loaded_key_info < rhs.loaded_key_info)
    return true;
  if (rhs.loaded_key_info < lhs.loaded_key_info)
    return false;
  if (lhs.permanent_failure < rhs.permanent_failure)
    return true;
  if (rhs.permanent_failure < lhs.permanent_failure)
    return false;
  return false;
}
template <typename StructPtrType>
ConsentMetadataPtr ConsentMetadata::Clone() const {
  return New(
      mojo::Clone(can_collect_signals),
      mojo::Clone(consent_received)
  );
}

template <typename T, ConsentMetadata::EnableIfSame<T>*>
bool ConsentMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->can_collect_signals, other_struct.can_collect_signals))
    return false;
  if (!mojo::Equals(this->consent_received, other_struct.consent_received))
    return false;
  return true;
}

template <typename T, ConsentMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.can_collect_signals < rhs.can_collect_signals)
    return true;
  if (rhs.can_collect_signals < lhs.can_collect_signals)
    return false;
  if (lhs.consent_received < rhs.consent_received)
    return true;
  if (rhs.consent_received < lhs.consent_received)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceTrustStatePtr DeviceTrustState::Clone() const {
  return New(
      mojo::Clone(is_enabled),
      mojo::Clone(policy_enabled_levels),
      mojo::Clone(key_info),
      mojo::Clone(signals_json),
      mojo::Clone(consent_metadata)
  );
}

template <typename T, DeviceTrustState::EnableIfSame<T>*>
bool DeviceTrustState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_enabled, other_struct.is_enabled))
    return false;
  if (!mojo::Equals(this->policy_enabled_levels, other_struct.policy_enabled_levels))
    return false;
  if (!mojo::Equals(this->key_info, other_struct.key_info))
    return false;
  if (!mojo::Equals(this->signals_json, other_struct.signals_json))
    return false;
  if (!mojo::Equals(this->consent_metadata, other_struct.consent_metadata))
    return false;
  return true;
}

template <typename T, DeviceTrustState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_enabled < rhs.is_enabled)
    return true;
  if (rhs.is_enabled < lhs.is_enabled)
    return false;
  if (lhs.policy_enabled_levels < rhs.policy_enabled_levels)
    return true;
  if (rhs.policy_enabled_levels < lhs.policy_enabled_levels)
    return false;
  if (lhs.key_info < rhs.key_info)
    return true;
  if (rhs.key_info < lhs.key_info)
    return false;
  if (lhs.signals_json < rhs.signals_json)
    return true;
  if (rhs.signals_json < lhs.signals_json)
    return false;
  if (lhs.consent_metadata < rhs.consent_metadata)
    return true;
  if (rhs.consent_metadata < lhs.consent_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
CertificateMetadataPtr CertificateMetadata::Clone() const {
  return New(
      mojo::Clone(serial_number),
      mojo::Clone(fingerprint),
      mojo::Clone(creation_date_string),
      mojo::Clone(expiration_date_string),
      mojo::Clone(subject_display_name),
      mojo::Clone(issuer_display_name)
  );
}

template <typename T, CertificateMetadata::EnableIfSame<T>*>
bool CertificateMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->serial_number, other_struct.serial_number))
    return false;
  if (!mojo::Equals(this->fingerprint, other_struct.fingerprint))
    return false;
  if (!mojo::Equals(this->creation_date_string, other_struct.creation_date_string))
    return false;
  if (!mojo::Equals(this->expiration_date_string, other_struct.expiration_date_string))
    return false;
  if (!mojo::Equals(this->subject_display_name, other_struct.subject_display_name))
    return false;
  if (!mojo::Equals(this->issuer_display_name, other_struct.issuer_display_name))
    return false;
  return true;
}

template <typename T, CertificateMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.serial_number < rhs.serial_number)
    return true;
  if (rhs.serial_number < lhs.serial_number)
    return false;
  if (lhs.fingerprint < rhs.fingerprint)
    return true;
  if (rhs.fingerprint < lhs.fingerprint)
    return false;
  if (lhs.creation_date_string < rhs.creation_date_string)
    return true;
  if (rhs.creation_date_string < lhs.creation_date_string)
    return false;
  if (lhs.expiration_date_string < rhs.expiration_date_string)
    return true;
  if (rhs.expiration_date_string < lhs.expiration_date_string)
    return false;
  if (lhs.subject_display_name < rhs.subject_display_name)
    return true;
  if (rhs.subject_display_name < lhs.subject_display_name)
    return false;
  if (lhs.issuer_display_name < rhs.issuer_display_name)
    return true;
  if (rhs.issuer_display_name < lhs.issuer_display_name)
    return false;
  return false;
}
template <typename StructPtrType>
ClientIdentityPtr ClientIdentity::Clone() const {
  return New(
      mojo::Clone(identity_name),
      mojo::Clone(loaded_key_info),
      mojo::Clone(certificate_metadata)
  );
}

template <typename T, ClientIdentity::EnableIfSame<T>*>
bool ClientIdentity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->identity_name, other_struct.identity_name))
    return false;
  if (!mojo::Equals(this->loaded_key_info, other_struct.loaded_key_info))
    return false;
  if (!mojo::Equals(this->certificate_metadata, other_struct.certificate_metadata))
    return false;
  return true;
}

template <typename T, ClientIdentity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.identity_name < rhs.identity_name)
    return true;
  if (rhs.identity_name < lhs.identity_name)
    return false;
  if (lhs.loaded_key_info < rhs.loaded_key_info)
    return true;
  if (rhs.loaded_key_info < lhs.loaded_key_info)
    return false;
  if (lhs.certificate_metadata < rhs.certificate_metadata)
    return true;
  if (rhs.certificate_metadata < lhs.certificate_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
ClientCertificateStatePtr ClientCertificateState::Clone() const {
  return New(
      mojo::Clone(policy_enabled_levels),
      mojo::Clone(managed_profile_identity),
      mojo::Clone(managed_browser_identity)
  );
}

template <typename T, ClientCertificateState::EnableIfSame<T>*>
bool ClientCertificateState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->policy_enabled_levels, other_struct.policy_enabled_levels))
    return false;
  if (!mojo::Equals(this->managed_profile_identity, other_struct.managed_profile_identity))
    return false;
  if (!mojo::Equals(this->managed_browser_identity, other_struct.managed_browser_identity))
    return false;
  return true;
}

template <typename T, ClientCertificateState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.policy_enabled_levels < rhs.policy_enabled_levels)
    return true;
  if (rhs.policy_enabled_levels < lhs.policy_enabled_levels)
    return false;
  if (lhs.managed_profile_identity < rhs.managed_profile_identity)
    return true;
  if (rhs.managed_profile_identity < lhs.managed_profile_identity)
    return false;
  if (lhs.managed_browser_identity < rhs.managed_browser_identity)
    return true;
  if (rhs.managed_browser_identity < lhs.managed_browser_identity)
    return false;
  return false;
}
template <typename StructPtrType>
SignalsReportingStatePtr SignalsReportingState::Clone() const {
  return New(
      mojo::Clone(error_info),
      mojo::Clone(status_report_enabled),
      mojo::Clone(signals_report_enabled),
      mojo::Clone(last_upload_attempt_timestamp),
      mojo::Clone(last_upload_success_timestamp),
      mojo::Clone(last_signals_upload_config),
      mojo::Clone(can_collect_all_fields)
  );
}

template <typename T, SignalsReportingState::EnableIfSame<T>*>
bool SignalsReportingState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_info, other_struct.error_info))
    return false;
  if (!mojo::Equals(this->status_report_enabled, other_struct.status_report_enabled))
    return false;
  if (!mojo::Equals(this->signals_report_enabled, other_struct.signals_report_enabled))
    return false;
  if (!mojo::Equals(this->last_upload_attempt_timestamp, other_struct.last_upload_attempt_timestamp))
    return false;
  if (!mojo::Equals(this->last_upload_success_timestamp, other_struct.last_upload_success_timestamp))
    return false;
  if (!mojo::Equals(this->last_signals_upload_config, other_struct.last_signals_upload_config))
    return false;
  if (!mojo::Equals(this->can_collect_all_fields, other_struct.can_collect_all_fields))
    return false;
  return true;
}

template <typename T, SignalsReportingState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error_info < rhs.error_info)
    return true;
  if (rhs.error_info < lhs.error_info)
    return false;
  if (lhs.status_report_enabled < rhs.status_report_enabled)
    return true;
  if (rhs.status_report_enabled < lhs.status_report_enabled)
    return false;
  if (lhs.signals_report_enabled < rhs.signals_report_enabled)
    return true;
  if (rhs.signals_report_enabled < lhs.signals_report_enabled)
    return false;
  if (lhs.last_upload_attempt_timestamp < rhs.last_upload_attempt_timestamp)
    return true;
  if (rhs.last_upload_attempt_timestamp < lhs.last_upload_attempt_timestamp)
    return false;
  if (lhs.last_upload_success_timestamp < rhs.last_upload_success_timestamp)
    return true;
  if (rhs.last_upload_success_timestamp < lhs.last_upload_success_timestamp)
    return false;
  if (lhs.last_signals_upload_config < rhs.last_signals_upload_config)
    return true;
  if (rhs.last_signals_upload_config < lhs.last_signals_upload_config)
    return false;
  if (lhs.can_collect_all_fields < rhs.can_collect_all_fields)
    return true;
  if (rhs.can_collect_all_fields < lhs.can_collect_all_fields)
    return false;
  return false;
}


}  // connectors_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::connectors_internals::mojom::Int32Value::DataView,
                                         ::connectors_internals::mojom::Int32ValuePtr> {
  static bool IsNull(const ::connectors_internals::mojom::Int32ValuePtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::Int32ValuePtr* output) { output->reset(); }

  static decltype(::connectors_internals::mojom::Int32Value::value) value(
      const ::connectors_internals::mojom::Int32ValuePtr& input) {
    return input->value;
  }

  static bool Read(::connectors_internals::mojom::Int32Value::DataView input, ::connectors_internals::mojom::Int32ValuePtr* output);
};


template <>
struct  StructTraits<::connectors_internals::mojom::LoadedKeyInfo::DataView,
                                         ::connectors_internals::mojom::LoadedKeyInfoPtr> {
  static bool IsNull(const ::connectors_internals::mojom::LoadedKeyInfoPtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::LoadedKeyInfoPtr* output) { output->reset(); }

  static decltype(::connectors_internals::mojom::LoadedKeyInfo::trust_level) trust_level(
      const ::connectors_internals::mojom::LoadedKeyInfoPtr& input) {
    return input->trust_level;
  }

  static decltype(::connectors_internals::mojom::LoadedKeyInfo::key_type) key_type(
      const ::connectors_internals::mojom::LoadedKeyInfoPtr& input) {
    return input->key_type;
  }

  static const decltype(::connectors_internals::mojom::LoadedKeyInfo::encoded_spki_hash)& encoded_spki_hash(
      const ::connectors_internals::mojom::LoadedKeyInfoPtr& input) {
    return input->encoded_spki_hash;
  }

  static const decltype(::connectors_internals::mojom::LoadedKeyInfo::key_upload_status)& key_upload_status(
      const ::connectors_internals::mojom::LoadedKeyInfoPtr& input) {
    return input->key_upload_status;
  }

  static decltype(::connectors_internals::mojom::LoadedKeyInfo::has_ssl_key) has_ssl_key(
      const ::connectors_internals::mojom::LoadedKeyInfoPtr& input) {
    return input->has_ssl_key;
  }

  static bool Read(::connectors_internals::mojom::LoadedKeyInfo::DataView input, ::connectors_internals::mojom::LoadedKeyInfoPtr* output);
};


template <>
struct  StructTraits<::connectors_internals::mojom::KeyInfo::DataView,
                                         ::connectors_internals::mojom::KeyInfoPtr> {
  static bool IsNull(const ::connectors_internals::mojom::KeyInfoPtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::KeyInfoPtr* output) { output->reset(); }

  static decltype(::connectors_internals::mojom::KeyInfo::is_key_manager_initialized) is_key_manager_initialized(
      const ::connectors_internals::mojom::KeyInfoPtr& input) {
    return input->is_key_manager_initialized;
  }

  static const decltype(::connectors_internals::mojom::KeyInfo::loaded_key_info)& loaded_key_info(
      const ::connectors_internals::mojom::KeyInfoPtr& input) {
    return input->loaded_key_info;
  }

  static decltype(::connectors_internals::mojom::KeyInfo::permanent_failure) permanent_failure(
      const ::connectors_internals::mojom::KeyInfoPtr& input) {
    return input->permanent_failure;
  }

  static bool Read(::connectors_internals::mojom::KeyInfo::DataView input, ::connectors_internals::mojom::KeyInfoPtr* output);
};


template <>
struct  StructTraits<::connectors_internals::mojom::ConsentMetadata::DataView,
                                         ::connectors_internals::mojom::ConsentMetadataPtr> {
  static bool IsNull(const ::connectors_internals::mojom::ConsentMetadataPtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::ConsentMetadataPtr* output) { output->reset(); }

  static decltype(::connectors_internals::mojom::ConsentMetadata::can_collect_signals) can_collect_signals(
      const ::connectors_internals::mojom::ConsentMetadataPtr& input) {
    return input->can_collect_signals;
  }

  static decltype(::connectors_internals::mojom::ConsentMetadata::consent_received) consent_received(
      const ::connectors_internals::mojom::ConsentMetadataPtr& input) {
    return input->consent_received;
  }

  static bool Read(::connectors_internals::mojom::ConsentMetadata::DataView input, ::connectors_internals::mojom::ConsentMetadataPtr* output);
};


template <>
struct  StructTraits<::connectors_internals::mojom::DeviceTrustState::DataView,
                                         ::connectors_internals::mojom::DeviceTrustStatePtr> {
  static bool IsNull(const ::connectors_internals::mojom::DeviceTrustStatePtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::DeviceTrustStatePtr* output) { output->reset(); }

  static decltype(::connectors_internals::mojom::DeviceTrustState::is_enabled) is_enabled(
      const ::connectors_internals::mojom::DeviceTrustStatePtr& input) {
    return input->is_enabled;
  }

  static const decltype(::connectors_internals::mojom::DeviceTrustState::policy_enabled_levels)& policy_enabled_levels(
      const ::connectors_internals::mojom::DeviceTrustStatePtr& input) {
    return input->policy_enabled_levels;
  }

  static const decltype(::connectors_internals::mojom::DeviceTrustState::key_info)& key_info(
      const ::connectors_internals::mojom::DeviceTrustStatePtr& input) {
    return input->key_info;
  }

  static const decltype(::connectors_internals::mojom::DeviceTrustState::signals_json)& signals_json(
      const ::connectors_internals::mojom::DeviceTrustStatePtr& input) {
    return input->signals_json;
  }

  static const decltype(::connectors_internals::mojom::DeviceTrustState::consent_metadata)& consent_metadata(
      const ::connectors_internals::mojom::DeviceTrustStatePtr& input) {
    return input->consent_metadata;
  }

  static bool Read(::connectors_internals::mojom::DeviceTrustState::DataView input, ::connectors_internals::mojom::DeviceTrustStatePtr* output);
};


template <>
struct  StructTraits<::connectors_internals::mojom::CertificateMetadata::DataView,
                                         ::connectors_internals::mojom::CertificateMetadataPtr> {
  static bool IsNull(const ::connectors_internals::mojom::CertificateMetadataPtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::CertificateMetadataPtr* output) { output->reset(); }

  static const decltype(::connectors_internals::mojom::CertificateMetadata::serial_number)& serial_number(
      const ::connectors_internals::mojom::CertificateMetadataPtr& input) {
    return input->serial_number;
  }

  static const decltype(::connectors_internals::mojom::CertificateMetadata::fingerprint)& fingerprint(
      const ::connectors_internals::mojom::CertificateMetadataPtr& input) {
    return input->fingerprint;
  }

  static const decltype(::connectors_internals::mojom::CertificateMetadata::creation_date_string)& creation_date_string(
      const ::connectors_internals::mojom::CertificateMetadataPtr& input) {
    return input->creation_date_string;
  }

  static const decltype(::connectors_internals::mojom::CertificateMetadata::expiration_date_string)& expiration_date_string(
      const ::connectors_internals::mojom::CertificateMetadataPtr& input) {
    return input->expiration_date_string;
  }

  static const decltype(::connectors_internals::mojom::CertificateMetadata::subject_display_name)& subject_display_name(
      const ::connectors_internals::mojom::CertificateMetadataPtr& input) {
    return input->subject_display_name;
  }

  static const decltype(::connectors_internals::mojom::CertificateMetadata::issuer_display_name)& issuer_display_name(
      const ::connectors_internals::mojom::CertificateMetadataPtr& input) {
    return input->issuer_display_name;
  }

  static bool Read(::connectors_internals::mojom::CertificateMetadata::DataView input, ::connectors_internals::mojom::CertificateMetadataPtr* output);
};


template <>
struct  StructTraits<::connectors_internals::mojom::ClientIdentity::DataView,
                                         ::connectors_internals::mojom::ClientIdentityPtr> {
  static bool IsNull(const ::connectors_internals::mojom::ClientIdentityPtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::ClientIdentityPtr* output) { output->reset(); }

  static const decltype(::connectors_internals::mojom::ClientIdentity::identity_name)& identity_name(
      const ::connectors_internals::mojom::ClientIdentityPtr& input) {
    return input->identity_name;
  }

  static const decltype(::connectors_internals::mojom::ClientIdentity::loaded_key_info)& loaded_key_info(
      const ::connectors_internals::mojom::ClientIdentityPtr& input) {
    return input->loaded_key_info;
  }

  static const decltype(::connectors_internals::mojom::ClientIdentity::certificate_metadata)& certificate_metadata(
      const ::connectors_internals::mojom::ClientIdentityPtr& input) {
    return input->certificate_metadata;
  }

  static bool Read(::connectors_internals::mojom::ClientIdentity::DataView input, ::connectors_internals::mojom::ClientIdentityPtr* output);
};


template <>
struct  StructTraits<::connectors_internals::mojom::ClientCertificateState::DataView,
                                         ::connectors_internals::mojom::ClientCertificateStatePtr> {
  static bool IsNull(const ::connectors_internals::mojom::ClientCertificateStatePtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::ClientCertificateStatePtr* output) { output->reset(); }

  static const decltype(::connectors_internals::mojom::ClientCertificateState::policy_enabled_levels)& policy_enabled_levels(
      const ::connectors_internals::mojom::ClientCertificateStatePtr& input) {
    return input->policy_enabled_levels;
  }

  static const decltype(::connectors_internals::mojom::ClientCertificateState::managed_profile_identity)& managed_profile_identity(
      const ::connectors_internals::mojom::ClientCertificateStatePtr& input) {
    return input->managed_profile_identity;
  }

  static const decltype(::connectors_internals::mojom::ClientCertificateState::managed_browser_identity)& managed_browser_identity(
      const ::connectors_internals::mojom::ClientCertificateStatePtr& input) {
    return input->managed_browser_identity;
  }

  static bool Read(::connectors_internals::mojom::ClientCertificateState::DataView input, ::connectors_internals::mojom::ClientCertificateStatePtr* output);
};


template <>
struct  StructTraits<::connectors_internals::mojom::SignalsReportingState::DataView,
                                         ::connectors_internals::mojom::SignalsReportingStatePtr> {
  static bool IsNull(const ::connectors_internals::mojom::SignalsReportingStatePtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::SignalsReportingStatePtr* output) { output->reset(); }

  static const decltype(::connectors_internals::mojom::SignalsReportingState::error_info)& error_info(
      const ::connectors_internals::mojom::SignalsReportingStatePtr& input) {
    return input->error_info;
  }

  static decltype(::connectors_internals::mojom::SignalsReportingState::status_report_enabled) status_report_enabled(
      const ::connectors_internals::mojom::SignalsReportingStatePtr& input) {
    return input->status_report_enabled;
  }

  static decltype(::connectors_internals::mojom::SignalsReportingState::signals_report_enabled) signals_report_enabled(
      const ::connectors_internals::mojom::SignalsReportingStatePtr& input) {
    return input->signals_report_enabled;
  }

  static const decltype(::connectors_internals::mojom::SignalsReportingState::last_upload_attempt_timestamp)& last_upload_attempt_timestamp(
      const ::connectors_internals::mojom::SignalsReportingStatePtr& input) {
    return input->last_upload_attempt_timestamp;
  }

  static const decltype(::connectors_internals::mojom::SignalsReportingState::last_upload_success_timestamp)& last_upload_success_timestamp(
      const ::connectors_internals::mojom::SignalsReportingStatePtr& input) {
    return input->last_upload_success_timestamp;
  }

  static const decltype(::connectors_internals::mojom::SignalsReportingState::last_signals_upload_config)& last_signals_upload_config(
      const ::connectors_internals::mojom::SignalsReportingStatePtr& input) {
    return input->last_signals_upload_config;
  }

  static decltype(::connectors_internals::mojom::SignalsReportingState::can_collect_all_fields) can_collect_all_fields(
      const ::connectors_internals::mojom::SignalsReportingStatePtr& input) {
    return input->can_collect_all_fields;
  }

  static bool Read(::connectors_internals::mojom::SignalsReportingState::DataView input, ::connectors_internals::mojom::SignalsReportingStatePtr* output);
};


template <>
struct  UnionTraits<::connectors_internals::mojom::KeyUploadStatus::DataView,
                                        ::connectors_internals::mojom::KeyUploadStatusPtr> {
  static bool IsNull(const ::connectors_internals::mojom::KeyUploadStatusPtr& input) { return !input; }
  static void SetToNull(::connectors_internals::mojom::KeyUploadStatusPtr* output) { output->reset(); }

  static ::connectors_internals::mojom::KeyUploadStatus::Tag GetTag(const ::connectors_internals::mojom::KeyUploadStatusPtr& input) {
    return input->which();
  }

  static const ::connectors_internals::mojom::Int32ValuePtr& sync_key_response_code(const ::connectors_internals::mojom::KeyUploadStatusPtr& input) {
    return input->get_sync_key_response_code();
  }

  static const std::string& upload_client_error(const ::connectors_internals::mojom::KeyUploadStatusPtr& input) {
    return input->get_upload_client_error();
  }

  static bool Read(::connectors_internals::mojom::KeyUploadStatus::DataView input, ::connectors_internals::mojom::KeyUploadStatusPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_H_