// chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-data-view.h"




namespace std {

template <>
struct hash<::connectors_internals::mojom::KeyManagerInitializedValue>
    : public mojo::internal::EnumHashImpl<::connectors_internals::mojom::KeyManagerInitializedValue> {};

template <>
struct hash<::connectors_internals::mojom::KeyTrustLevel>
    : public mojo::internal::EnumHashImpl<::connectors_internals::mojom::KeyTrustLevel> {};

template <>
struct hash<::connectors_internals::mojom::KeyType>
    : public mojo::internal::EnumHashImpl<::connectors_internals::mojom::KeyType> {};

template <>
struct hash<::connectors_internals::mojom::KeyManagerPermanentFailure>
    : public mojo::internal::EnumHashImpl<::connectors_internals::mojom::KeyManagerPermanentFailure> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::KeyManagerInitializedValue, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::connectors_internals::mojom::KeyManagerInitializedValue, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::connectors_internals::mojom::KeyManagerInitializedValue>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::KeyTrustLevel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::connectors_internals::mojom::KeyTrustLevel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::connectors_internals::mojom::KeyTrustLevel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::KeyType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::connectors_internals::mojom::KeyType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::connectors_internals::mojom::KeyType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::KeyManagerPermanentFailure, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::connectors_internals::mojom::KeyManagerPermanentFailure, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::connectors_internals::mojom::KeyManagerPermanentFailure>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::Int32ValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::Int32ValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::Int32Value_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::connectors_internals::mojom::internal::Int32Value_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::Int32ValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::LoadedKeyInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::LoadedKeyInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::LoadedKeyInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::connectors_internals::mojom::KeyTrustLevel>(
      Traits::trust_level(input),
      &fragment->trust_level);

    
    mojo::internal::Serialize<::connectors_internals::mojom::KeyType>(
      Traits::key_type(input),
      &fragment->key_type);

    decltype(Traits::encoded_spki_hash(input)) in_encoded_spki_hash = Traits::encoded_spki_hash(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encoded_spki_hash)::BaseType> encoded_spki_hash_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_encoded_spki_hash,
      encoded_spki_hash_fragment);

    fragment->encoded_spki_hash.Set(
        encoded_spki_hash_fragment.is_null() ? nullptr : encoded_spki_hash_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->encoded_spki_hash.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encoded_spki_hash in LoadedKeyInfo struct");

    decltype(Traits::key_upload_status(input)) in_key_upload_status = Traits::key_upload_status(input);
    mojo::internal::MessageFragment<decltype(fragment->key_upload_status)>
        key_upload_status_fragment(fragment.message());
    key_upload_status_fragment.Claim(&fragment->key_upload_status);
    
    mojo::internal::Serialize<::connectors_internals::mojom::KeyUploadStatusDataView>(
      in_key_upload_status,
      key_upload_status_fragment,
      true);

    fragment->has_ssl_key = Traits::has_ssl_key(input);
  }

  static bool Deserialize(::connectors_internals::mojom::internal::LoadedKeyInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::LoadedKeyInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::KeyInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::KeyInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::KeyInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::connectors_internals::mojom::KeyManagerInitializedValue>(
      Traits::is_key_manager_initialized(input),
      &fragment->is_key_manager_initialized);

    decltype(Traits::loaded_key_info(input)) in_loaded_key_info = Traits::loaded_key_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->loaded_key_info)::BaseType> loaded_key_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::connectors_internals::mojom::LoadedKeyInfoDataView>(
      in_loaded_key_info,
      loaded_key_info_fragment);

    fragment->loaded_key_info.Set(
        loaded_key_info_fragment.is_null() ? nullptr : loaded_key_info_fragment.data());

    
    mojo::internal::Serialize<::connectors_internals::mojom::KeyManagerPermanentFailure>(
      Traits::permanent_failure(input),
      &fragment->permanent_failure);
  }

  static bool Deserialize(::connectors_internals::mojom::internal::KeyInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::KeyInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::ConsentMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::ConsentMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::ConsentMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->can_collect_signals = Traits::can_collect_signals(input);

    fragment->consent_received = Traits::consent_received(input);
  }

  static bool Deserialize(::connectors_internals::mojom::internal::ConsentMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::ConsentMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::DeviceTrustStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::DeviceTrustStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::DeviceTrustState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_enabled = Traits::is_enabled(input);

    decltype(Traits::policy_enabled_levels(input)) in_policy_enabled_levels = Traits::policy_enabled_levels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_enabled_levels)::BaseType>
        policy_enabled_levels_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& policy_enabled_levels_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_policy_enabled_levels,
      policy_enabled_levels_fragment,
      &policy_enabled_levels_validate_params);

    fragment->policy_enabled_levels.Set(
        policy_enabled_levels_fragment.is_null() ? nullptr : policy_enabled_levels_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->policy_enabled_levels.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_enabled_levels in DeviceTrustState struct");

    decltype(Traits::key_info(input)) in_key_info = Traits::key_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_info)::BaseType> key_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::connectors_internals::mojom::KeyInfoDataView>(
      in_key_info,
      key_info_fragment);

    fragment->key_info.Set(
        key_info_fragment.is_null() ? nullptr : key_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_info in DeviceTrustState struct");

    decltype(Traits::signals_json(input)) in_signals_json = Traits::signals_json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signals_json)::BaseType> signals_json_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_signals_json,
      signals_json_fragment);

    fragment->signals_json.Set(
        signals_json_fragment.is_null() ? nullptr : signals_json_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signals_json.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signals_json in DeviceTrustState struct");

    decltype(Traits::consent_metadata(input)) in_consent_metadata = Traits::consent_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->consent_metadata)::BaseType> consent_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::connectors_internals::mojom::ConsentMetadataDataView>(
      in_consent_metadata,
      consent_metadata_fragment);

    fragment->consent_metadata.Set(
        consent_metadata_fragment.is_null() ? nullptr : consent_metadata_fragment.data());
  }

  static bool Deserialize(::connectors_internals::mojom::internal::DeviceTrustState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::DeviceTrustStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::CertificateMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::CertificateMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::CertificateMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::serial_number(input)) in_serial_number = Traits::serial_number(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serial_number)::BaseType> serial_number_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_serial_number,
      serial_number_fragment);

    fragment->serial_number.Set(
        serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->serial_number.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serial_number in CertificateMetadata struct");

    decltype(Traits::fingerprint(input)) in_fingerprint = Traits::fingerprint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fingerprint)::BaseType> fingerprint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_fingerprint,
      fingerprint_fragment);

    fragment->fingerprint.Set(
        fingerprint_fragment.is_null() ? nullptr : fingerprint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->fingerprint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fingerprint in CertificateMetadata struct");

    decltype(Traits::creation_date_string(input)) in_creation_date_string = Traits::creation_date_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_date_string)::BaseType> creation_date_string_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_creation_date_string,
      creation_date_string_fragment);

    fragment->creation_date_string.Set(
        creation_date_string_fragment.is_null() ? nullptr : creation_date_string_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation_date_string.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation_date_string in CertificateMetadata struct");

    decltype(Traits::expiration_date_string(input)) in_expiration_date_string = Traits::expiration_date_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration_date_string)::BaseType> expiration_date_string_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_expiration_date_string,
      expiration_date_string_fragment);

    fragment->expiration_date_string.Set(
        expiration_date_string_fragment.is_null() ? nullptr : expiration_date_string_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expiration_date_string.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expiration_date_string in CertificateMetadata struct");

    decltype(Traits::subject_display_name(input)) in_subject_display_name = Traits::subject_display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subject_display_name)::BaseType> subject_display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_subject_display_name,
      subject_display_name_fragment);

    fragment->subject_display_name.Set(
        subject_display_name_fragment.is_null() ? nullptr : subject_display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subject_display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subject_display_name in CertificateMetadata struct");

    decltype(Traits::issuer_display_name(input)) in_issuer_display_name = Traits::issuer_display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issuer_display_name)::BaseType> issuer_display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_issuer_display_name,
      issuer_display_name_fragment);

    fragment->issuer_display_name.Set(
        issuer_display_name_fragment.is_null() ? nullptr : issuer_display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issuer_display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuer_display_name in CertificateMetadata struct");
  }

  static bool Deserialize(::connectors_internals::mojom::internal::CertificateMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::CertificateMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::ClientIdentityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::ClientIdentityDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::ClientIdentity_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::identity_name(input)) in_identity_name = Traits::identity_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->identity_name)::BaseType> identity_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_identity_name,
      identity_name_fragment);

    fragment->identity_name.Set(
        identity_name_fragment.is_null() ? nullptr : identity_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->identity_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null identity_name in ClientIdentity struct");

    decltype(Traits::loaded_key_info(input)) in_loaded_key_info = Traits::loaded_key_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->loaded_key_info)::BaseType> loaded_key_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::connectors_internals::mojom::LoadedKeyInfoDataView>(
      in_loaded_key_info,
      loaded_key_info_fragment);

    fragment->loaded_key_info.Set(
        loaded_key_info_fragment.is_null() ? nullptr : loaded_key_info_fragment.data());

    decltype(Traits::certificate_metadata(input)) in_certificate_metadata = Traits::certificate_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->certificate_metadata)::BaseType> certificate_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::connectors_internals::mojom::CertificateMetadataDataView>(
      in_certificate_metadata,
      certificate_metadata_fragment);

    fragment->certificate_metadata.Set(
        certificate_metadata_fragment.is_null() ? nullptr : certificate_metadata_fragment.data());
  }

  static bool Deserialize(::connectors_internals::mojom::internal::ClientIdentity_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::ClientIdentityDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::ClientCertificateStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::ClientCertificateStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::ClientCertificateState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::policy_enabled_levels(input)) in_policy_enabled_levels = Traits::policy_enabled_levels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_enabled_levels)::BaseType>
        policy_enabled_levels_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& policy_enabled_levels_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_policy_enabled_levels,
      policy_enabled_levels_fragment,
      &policy_enabled_levels_validate_params);

    fragment->policy_enabled_levels.Set(
        policy_enabled_levels_fragment.is_null() ? nullptr : policy_enabled_levels_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->policy_enabled_levels.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_enabled_levels in ClientCertificateState struct");

    decltype(Traits::managed_profile_identity(input)) in_managed_profile_identity = Traits::managed_profile_identity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->managed_profile_identity)::BaseType> managed_profile_identity_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::connectors_internals::mojom::ClientIdentityDataView>(
      in_managed_profile_identity,
      managed_profile_identity_fragment);

    fragment->managed_profile_identity.Set(
        managed_profile_identity_fragment.is_null() ? nullptr : managed_profile_identity_fragment.data());

    decltype(Traits::managed_browser_identity(input)) in_managed_browser_identity = Traits::managed_browser_identity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->managed_browser_identity)::BaseType> managed_browser_identity_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::connectors_internals::mojom::ClientIdentityDataView>(
      in_managed_browser_identity,
      managed_browser_identity_fragment);

    fragment->managed_browser_identity.Set(
        managed_browser_identity_fragment.is_null() ? nullptr : managed_browser_identity_fragment.data());
  }

  static bool Deserialize(::connectors_internals::mojom::internal::ClientCertificateState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::ClientCertificateStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::SignalsReportingStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::connectors_internals::mojom::SignalsReportingStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::connectors_internals::mojom::internal::SignalsReportingState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::error_info(input)) in_error_info = Traits::error_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error_info)::BaseType> error_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_error_info,
      error_info_fragment);

    fragment->error_info.Set(
        error_info_fragment.is_null() ? nullptr : error_info_fragment.data());

    fragment->status_report_enabled = Traits::status_report_enabled(input);

    fragment->signals_report_enabled = Traits::signals_report_enabled(input);

    decltype(Traits::last_upload_attempt_timestamp(input)) in_last_upload_attempt_timestamp = Traits::last_upload_attempt_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_upload_attempt_timestamp)::BaseType> last_upload_attempt_timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_last_upload_attempt_timestamp,
      last_upload_attempt_timestamp_fragment);

    fragment->last_upload_attempt_timestamp.Set(
        last_upload_attempt_timestamp_fragment.is_null() ? nullptr : last_upload_attempt_timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_upload_attempt_timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_upload_attempt_timestamp in SignalsReportingState struct");

    decltype(Traits::last_upload_success_timestamp(input)) in_last_upload_success_timestamp = Traits::last_upload_success_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_upload_success_timestamp)::BaseType> last_upload_success_timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_last_upload_success_timestamp,
      last_upload_success_timestamp_fragment);

    fragment->last_upload_success_timestamp.Set(
        last_upload_success_timestamp_fragment.is_null() ? nullptr : last_upload_success_timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_upload_success_timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_upload_success_timestamp in SignalsReportingState struct");

    decltype(Traits::last_signals_upload_config(input)) in_last_signals_upload_config = Traits::last_signals_upload_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_signals_upload_config)::BaseType> last_signals_upload_config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_last_signals_upload_config,
      last_signals_upload_config_fragment);

    fragment->last_signals_upload_config.Set(
        last_signals_upload_config_fragment.is_null() ? nullptr : last_signals_upload_config_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_signals_upload_config.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_signals_upload_config in SignalsReportingState struct");

    fragment->can_collect_all_fields = Traits::can_collect_all_fields(input);
  }

  static bool Deserialize(::connectors_internals::mojom::internal::SignalsReportingState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::SignalsReportingStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::connectors_internals::mojom::KeyUploadStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::connectors_internals::mojom::KeyUploadStatusDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::connectors_internals::mojom::internal::KeyUploadStatus_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::connectors_internals::mojom::KeyUploadStatusDataView::Tag::kSyncKeyResponseCode: {
    decltype(Traits::sync_key_response_code(input))
    in_sync_key_response_code = Traits::sync_key_response_code(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_sync_key_response_code)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::connectors_internals::mojom::Int32ValueDataView>(
  in_sync_key_response_code,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null sync_key_response_code in KeyUploadStatus union");
    fragment->data.f_sync_key_response_code.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::connectors_internals::mojom::KeyUploadStatusDataView::Tag::kUploadClientError: {
    decltype(Traits::upload_client_error(input))
    in_upload_client_error = Traits::upload_client_error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_upload_client_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_upload_client_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null upload_client_error in KeyUploadStatus union");
    fragment->data.f_upload_client_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::connectors_internals::mojom::internal::KeyUploadStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::connectors_internals::mojom::KeyUploadStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace connectors_internals::mojom {



inline void LoadedKeyInfoDataView::GetEncodedSpkiHashDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->encoded_spki_hash.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LoadedKeyInfoDataView::GetKeyUploadStatusDataView(
    KeyUploadStatusDataView* output) {
  auto pointer = &data_->key_upload_status;
  *output = KeyUploadStatusDataView(pointer, message_);
}


inline void KeyInfoDataView::GetLoadedKeyInfoDataView(
    LoadedKeyInfoDataView* output) {
  auto pointer = data_->loaded_key_info.Get();
  *output = LoadedKeyInfoDataView(pointer, message_);
}




inline void DeviceTrustStateDataView::GetPolicyEnabledLevelsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->policy_enabled_levels.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void DeviceTrustStateDataView::GetKeyInfoDataView(
    KeyInfoDataView* output) {
  auto pointer = data_->key_info.Get();
  *output = KeyInfoDataView(pointer, message_);
}
inline void DeviceTrustStateDataView::GetSignalsJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->signals_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DeviceTrustStateDataView::GetConsentMetadataDataView(
    ConsentMetadataDataView* output) {
  auto pointer = data_->consent_metadata.Get();
  *output = ConsentMetadataDataView(pointer, message_);
}


inline void CertificateMetadataDataView::GetSerialNumberDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->serial_number.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CertificateMetadataDataView::GetFingerprintDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->fingerprint.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CertificateMetadataDataView::GetCreationDateStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->creation_date_string.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CertificateMetadataDataView::GetExpirationDateStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->expiration_date_string.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CertificateMetadataDataView::GetSubjectDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->subject_display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CertificateMetadataDataView::GetIssuerDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->issuer_display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ClientIdentityDataView::GetIdentityNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->identity_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientIdentityDataView::GetLoadedKeyInfoDataView(
    LoadedKeyInfoDataView* output) {
  auto pointer = data_->loaded_key_info.Get();
  *output = LoadedKeyInfoDataView(pointer, message_);
}
inline void ClientIdentityDataView::GetCertificateMetadataDataView(
    CertificateMetadataDataView* output) {
  auto pointer = data_->certificate_metadata.Get();
  *output = CertificateMetadataDataView(pointer, message_);
}


inline void ClientCertificateStateDataView::GetPolicyEnabledLevelsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->policy_enabled_levels.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ClientCertificateStateDataView::GetManagedProfileIdentityDataView(
    ClientIdentityDataView* output) {
  auto pointer = data_->managed_profile_identity.Get();
  *output = ClientIdentityDataView(pointer, message_);
}
inline void ClientCertificateStateDataView::GetManagedBrowserIdentityDataView(
    ClientIdentityDataView* output) {
  auto pointer = data_->managed_browser_identity.Get();
  *output = ClientIdentityDataView(pointer, message_);
}


inline void SignalsReportingStateDataView::GetErrorInfoDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_info.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignalsReportingStateDataView::GetLastUploadAttemptTimestampDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->last_upload_attempt_timestamp.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignalsReportingStateDataView::GetLastUploadSuccessTimestampDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->last_upload_success_timestamp.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignalsReportingStateDataView::GetLastSignalsUploadConfigDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->last_signals_upload_config.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void KeyUploadStatusDataView::GetSyncKeyResponseCodeDataView(
    Int32ValueDataView* output) const {
  CHECK(is_sync_key_response_code());
  *output = Int32ValueDataView(data_->data.f_sync_key_response_code.Get(), message_);
}
inline void KeyUploadStatusDataView::GetUploadClientErrorDataView(
    mojo::StringDataView* output) const {
  CHECK(is_upload_client_error());
  *output = mojo::StringDataView(data_->data.f_upload_client_error.Get(), message_);
}


}  // connectors_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::connectors_internals::mojom::KeyManagerInitializedValue> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::connectors_internals::mojom::KeyManagerInitializedValue value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::connectors_internals::mojom::KeyTrustLevel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::connectors_internals::mojom::KeyTrustLevel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::connectors_internals::mojom::KeyType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::connectors_internals::mojom::KeyType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::connectors_internals::mojom::KeyManagerPermanentFailure> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::connectors_internals::mojom::KeyManagerPermanentFailure value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_SHARED_H_