// chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_BLUETOOTH_INTERNALS_BLUETOOTH_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_BLUETOOTH_INTERNALS_BLUETOOTH_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom-forward.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/adapter.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace mojom {

class DebugLogsChangeHandlerProxy;

template <typename ImplRefTraits>
class DebugLogsChangeHandlerStub;

class DebugLogsChangeHandlerRequestValidator;


class DebugLogsChangeHandler
    : public DebugLogsChangeHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mojom.DebugLogsChangeHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DebugLogsChangeHandlerInterfaceBase;
  using Proxy_ = DebugLogsChangeHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DebugLogsChangeHandlerStub<ImplRefTraits>;

  using RequestValidator_ = DebugLogsChangeHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kChangeDebugLogsStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ChangeDebugLogsState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DebugLogsChangeHandler() = default;

  virtual void ChangeDebugLogsState(bool should_debug_logs_be_enabled) = 0;
};

class BluetoothInternalsHandlerProxy;

template <typename ImplRefTraits>
class BluetoothInternalsHandlerStub;

class BluetoothInternalsHandlerRequestValidator;
class BluetoothInternalsHandlerResponseValidator;


class BluetoothInternalsHandler
    : public BluetoothInternalsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mojom.BluetoothInternalsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BluetoothInternalsHandlerInterfaceBase;
  using Proxy_ = BluetoothInternalsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = BluetoothInternalsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = BluetoothInternalsHandlerRequestValidator;
  using ResponseValidator_ = BluetoothInternalsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAdapterMinVersion = 0,
    kGetDebugLogsChangeHandlerMinVersion = 0,
    kCheckSystemPermissionsMinVersion = 0,
    kRequestSystemPermissionsMinVersion = 0,
    kRequestLocationServicesMinVersion = 0,
    kStartBtsnoopMinVersion = 0,
    kIsBtsnoopFeatureEnabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAdapter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDebugLogsChangeHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckSystemPermissions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestSystemPermissions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestLocationServices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartBtsnoop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsBtsnoopFeatureEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BluetoothInternalsHandler() = default;

  using GetAdapterCallback = base::OnceCallback<void(::mojo::PendingRemote<::bluetooth::mojom::Adapter>)>;
  using GetAdapterMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<::bluetooth::mojom::Adapter>)>;

  virtual void GetAdapter(GetAdapterCallback callback) = 0;

  using GetDebugLogsChangeHandlerCallback = base::OnceCallback<void(::mojo::PendingRemote<DebugLogsChangeHandler>, bool)>;
  using GetDebugLogsChangeHandlerMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<DebugLogsChangeHandler>, bool)>;

  virtual void GetDebugLogsChangeHandler(GetDebugLogsChangeHandlerCallback callback) = 0;

  using CheckSystemPermissionsCallback = base::OnceCallback<void(bool, bool, bool, bool)>;
  using CheckSystemPermissionsMojoCallback = base::OnceCallback<void(bool, bool, bool, bool)>;

  virtual void CheckSystemPermissions(CheckSystemPermissionsCallback callback) = 0;

  using RequestSystemPermissionsCallback = base::OnceCallback<void()>;
  using RequestSystemPermissionsMojoCallback = base::OnceCallback<void()>;

  virtual void RequestSystemPermissions(RequestSystemPermissionsCallback callback) = 0;

  using RequestLocationServicesCallback = base::OnceCallback<void()>;
  using RequestLocationServicesMojoCallback = base::OnceCallback<void()>;

  virtual void RequestLocationServices(RequestLocationServicesCallback callback) = 0;

  using StartBtsnoopCallback = base::OnceCallback<void(::mojo::PendingRemote<BluetoothBtsnoop>)>;
  using StartBtsnoopMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<BluetoothBtsnoop>)>;

  virtual void StartBtsnoop(StartBtsnoopCallback callback) = 0;

  using IsBtsnoopFeatureEnabledCallback = base::OnceCallback<void(bool)>;
  using IsBtsnoopFeatureEnabledMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsBtsnoopFeatureEnabled(IsBtsnoopFeatureEnabledCallback callback) = 0;
};

class BluetoothBtsnoopProxy;

template <typename ImplRefTraits>
class BluetoothBtsnoopStub;

class BluetoothBtsnoopRequestValidator;
class BluetoothBtsnoopResponseValidator;


class BluetoothBtsnoop
    : public BluetoothBtsnoopInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mojom.BluetoothBtsnoop";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BluetoothBtsnoopInterfaceBase;
  using Proxy_ = BluetoothBtsnoopProxy;

  template <typename ImplRefTraits>
  using Stub_ = BluetoothBtsnoopStub<ImplRefTraits>;

  using RequestValidator_ = BluetoothBtsnoopRequestValidator;
  using ResponseValidator_ = BluetoothBtsnoopResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStopMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BluetoothBtsnoop() = default;

  using StopCallback = base::OnceCallback<void(bool)>;
  using StopMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Stop(StopCallback callback) = 0;
};



class  DebugLogsChangeHandlerProxy
    : public DebugLogsChangeHandler {
 public:
  using InterfaceType = DebugLogsChangeHandler;

  explicit DebugLogsChangeHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ChangeDebugLogsState(bool should_debug_logs_be_enabled) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BluetoothInternalsHandlerProxy
    : public BluetoothInternalsHandler {
 public:
  using InterfaceType = BluetoothInternalsHandler;

  explicit BluetoothInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAdapter(GetAdapterCallback callback) final;
  
  void GetDebugLogsChangeHandler(GetDebugLogsChangeHandlerCallback callback) final;
  
  void CheckSystemPermissions(CheckSystemPermissionsCallback callback) final;
  
  void RequestSystemPermissions(RequestSystemPermissionsCallback callback) final;
  
  void RequestLocationServices(RequestLocationServicesCallback callback) final;
  
  void StartBtsnoop(StartBtsnoopCallback callback) final;
  
  void IsBtsnoopFeatureEnabled(IsBtsnoopFeatureEnabledCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BluetoothBtsnoopProxy
    : public BluetoothBtsnoop {
 public:
  using InterfaceType = BluetoothBtsnoop;

  explicit BluetoothBtsnoopProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Stop(StopCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DebugLogsChangeHandlerStubDispatch {
 public:
  static bool Accept(DebugLogsChangeHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DebugLogsChangeHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DebugLogsChangeHandler>>
class DebugLogsChangeHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DebugLogsChangeHandlerStub() = default;
  ~DebugLogsChangeHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DebugLogsChangeHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DebugLogsChangeHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BluetoothInternalsHandlerStubDispatch {
 public:
  static bool Accept(BluetoothInternalsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BluetoothInternalsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BluetoothInternalsHandler>>
class BluetoothInternalsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BluetoothInternalsHandlerStub() = default;
  ~BluetoothInternalsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BluetoothInternalsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BluetoothInternalsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BluetoothBtsnoopStubDispatch {
 public:
  static bool Accept(BluetoothBtsnoop* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BluetoothBtsnoop* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BluetoothBtsnoop>>
class BluetoothBtsnoopStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BluetoothBtsnoopStub() = default;
  ~BluetoothBtsnoopStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BluetoothBtsnoopStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BluetoothBtsnoopStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DebugLogsChangeHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BluetoothInternalsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BluetoothBtsnoopRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BluetoothInternalsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BluetoothBtsnoopResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_BLUETOOTH_INTERNALS_BLUETOOTH_INTERNALS_MOJOM_H_