// chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_APP_SERVICE_INTERNALS_APP_SERVICE_INTERNALS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_APP_SERVICE_INTERNALS_APP_SERVICE_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::app_service_internals::AppInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::app_service_internals::AppInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::app_service_internals::internal::AppInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in AppInfo struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AppInfo struct");

    decltype(Traits::debug_info(input)) in_debug_info = Traits::debug_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_info)::BaseType> debug_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_debug_info,
      debug_info_fragment);

    fragment->debug_info.Set(
        debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_info in AppInfo struct");
  }

  static bool Deserialize(::mojom::app_service_internals::internal::AppInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::app_service_internals::AppInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::app_service_internals::PreferredAppInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::app_service_internals::PreferredAppInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::app_service_internals::internal::PreferredAppInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PreferredAppInfo struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in PreferredAppInfo struct");

    decltype(Traits::preferred_filters(input)) in_preferred_filters = Traits::preferred_filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->preferred_filters)::BaseType> preferred_filters_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_preferred_filters,
      preferred_filters_fragment);

    fragment->preferred_filters.Set(
        preferred_filters_fragment.is_null() ? nullptr : preferred_filters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->preferred_filters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preferred_filters in PreferredAppInfo struct");
  }

  static bool Deserialize(::mojom::app_service_internals::internal::PreferredAppInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::app_service_internals::PreferredAppInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::app_service_internals::PromiseAppInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::app_service_internals::PromiseAppInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::app_service_internals::internal::PromiseAppInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::package_id(input)) in_package_id = Traits::package_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->package_id)::BaseType> package_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_package_id,
      package_id_fragment);

    fragment->package_id.Set(
        package_id_fragment.is_null() ? nullptr : package_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->package_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null package_id in PromiseAppInfo struct");

    decltype(Traits::debug_info(input)) in_debug_info = Traits::debug_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_info)::BaseType> debug_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_debug_info,
      debug_info_fragment);

    fragment->debug_info.Set(
        debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_info in PromiseAppInfo struct");
  }

  static bool Deserialize(::mojom::app_service_internals::internal::PromiseAppInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::app_service_internals::PromiseAppInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::app_service_internals::AppCapabilityInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::app_service_internals::AppCapabilityInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::app_service_internals::internal::AppCapabilityInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AppCapabilityInfo struct");

    decltype(Traits::debug_info(input)) in_debug_info = Traits::debug_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_info)::BaseType> debug_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_debug_info,
      debug_info_fragment);

    fragment->debug_info.Set(
        debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_info in AppCapabilityInfo struct");
  }

  static bool Deserialize(::mojom::app_service_internals::internal::AppCapabilityInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::app_service_internals::AppCapabilityInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::app_service_internals::DebugInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::app_service_internals::DebugInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::app_service_internals::internal::DebugInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::app_list(input)) in_app_list = Traits::app_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->app_list)::BaseType>
        app_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& app_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::app_service_internals::AppInfoDataView>>(
      in_app_list,
      app_list_fragment,
      &app_list_validate_params);

    fragment->app_list.Set(
        app_list_fragment.is_null() ? nullptr : app_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->app_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_list in DebugInfo struct");

    decltype(Traits::preferred_app_list(input)) in_preferred_app_list = Traits::preferred_app_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->preferred_app_list)::BaseType>
        preferred_app_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& preferred_app_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::app_service_internals::PreferredAppInfoDataView>>(
      in_preferred_app_list,
      preferred_app_list_fragment,
      &preferred_app_list_validate_params);

    fragment->preferred_app_list.Set(
        preferred_app_list_fragment.is_null() ? nullptr : preferred_app_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->preferred_app_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preferred_app_list in DebugInfo struct");

    decltype(Traits::promise_app_list(input)) in_promise_app_list = Traits::promise_app_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->promise_app_list)::BaseType>
        promise_app_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& promise_app_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::app_service_internals::PromiseAppInfoDataView>>(
      in_promise_app_list,
      promise_app_list_fragment,
      &promise_app_list_validate_params);

    fragment->promise_app_list.Set(
        promise_app_list_fragment.is_null() ? nullptr : promise_app_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->promise_app_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null promise_app_list in DebugInfo struct");

    decltype(Traits::app_capability_list(input)) in_app_capability_list = Traits::app_capability_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->app_capability_list)::BaseType>
        app_capability_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& app_capability_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::app_service_internals::AppCapabilityInfoDataView>>(
      in_app_capability_list,
      app_capability_list_fragment,
      &app_capability_list_validate_params);

    fragment->app_capability_list.Set(
        app_capability_list_fragment.is_null() ? nullptr : app_capability_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->app_capability_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_capability_list in DebugInfo struct");
  }

  static bool Deserialize(::mojom::app_service_internals::internal::DebugInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::app_service_internals::DebugInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojom::app_service_internals {

inline void AppInfoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppInfoDataView::GetDebugInfoDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->debug_info.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PreferredAppInfoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PreferredAppInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PreferredAppInfoDataView::GetPreferredFiltersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->preferred_filters.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PromiseAppInfoDataView::GetPackageIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->package_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PromiseAppInfoDataView::GetDebugInfoDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->debug_info.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AppCapabilityInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppCapabilityInfoDataView::GetDebugInfoDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->debug_info.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DebugInfoDataView::GetAppListDataView(
    mojo::ArrayDataView<AppInfoDataView>* output) {
  auto pointer = data_->app_list.Get();
  *output = mojo::ArrayDataView<AppInfoDataView>(pointer, message_);
}
inline void DebugInfoDataView::GetPreferredAppListDataView(
    mojo::ArrayDataView<PreferredAppInfoDataView>* output) {
  auto pointer = data_->preferred_app_list.Get();
  *output = mojo::ArrayDataView<PreferredAppInfoDataView>(pointer, message_);
}
inline void DebugInfoDataView::GetPromiseAppListDataView(
    mojo::ArrayDataView<PromiseAppInfoDataView>* output) {
  auto pointer = data_->promise_app_list.Get();
  *output = mojo::ArrayDataView<PromiseAppInfoDataView>(pointer, message_);
}
inline void DebugInfoDataView::GetAppCapabilityListDataView(
    mojo::ArrayDataView<AppCapabilityInfoDataView>* output) {
  auto pointer = data_->app_capability_list.Get();
  *output = mojo::ArrayDataView<AppCapabilityInfoDataView>(pointer, message_);
}



}  // mojom::app_service_internals

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_APP_SERVICE_INTERNALS_APP_SERVICE_INTERNALS_MOJOM_SHARED_H_