// chrome/browser/ui/webui/app_home/app_home.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/app_home/app_home.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "chrome/browser/web_applications/mojom/user_display_mode.mojom-shared.h"


namespace app_home::mojom {
class AppInfoDataView;

class ClickEventDataView;



}  // app_home::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::app_home::mojom::AppInfoDataView> {
  using Data = ::app_home::mojom::internal::AppInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::app_home::mojom::ClickEventDataView> {
  using Data = ::app_home::mojom::internal::ClickEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace app_home::mojom {


enum class RunOnOsLoginMode : int32_t {
  
  kNotRun = 0,
  
  kWindowed = 1,
  
  kMinimized = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RunOnOsLoginMode value);
inline bool IsKnownEnumValue(RunOnOsLoginMode value) {
  return internal::RunOnOsLoginMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AppType : int32_t {
  
  kWebApp = 0,
  
  kIsolatedWebApp = 1,
  
  kDeprecatedChromeApp = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AppType value);
inline bool IsKnownEnumValue(AppType value) {
  return internal::AppType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class AppInfoDataView {
 public:
  AppInfoDataView() = default;

  AppInfoDataView(
      internal::AppInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAppType(UserType* output) const {
    auto data_value = data_->app_type;
    return mojo::internal::Deserialize<::app_home::mojom::AppType>(
        data_value, output);
  }
  AppType app_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::app_home::mojom::AppType>(data_->app_type));
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStartUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartUrl(UserType* output) {
    
    auto* pointer = data_->start_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconUrl(UserType* output) {
    
    auto* pointer = data_->icon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool may_show_run_on_os_login_mode() const {
    return data_->may_show_run_on_os_login_mode;
  }
  bool may_toggle_run_on_os_login_mode() const {
    return data_->may_toggle_run_on_os_login_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRunOnOsLoginMode(UserType* output) const {
    auto data_value = data_->run_on_os_login_mode;
    return mojo::internal::Deserialize<::app_home::mojom::RunOnOsLoginMode>(
        data_value, output);
  }
  RunOnOsLoginMode run_on_os_login_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::app_home::mojom::RunOnOsLoginMode>(data_->run_on_os_login_mode));
  }
  bool is_locally_installed() const {
    return data_->is_locally_installed;
  }
  bool open_in_window() const {
    return data_->open_in_window;
  }
  bool may_uninstall() const {
    return data_->may_uninstall;
  }
  inline void GetStorePageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorePageUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `store_page_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStorePageUrl` instead "
    "of `ReadStorePageUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->store_page_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::AppInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClickEventDataView {
 public:
  ClickEventDataView() = default;

  ClickEventDataView(
      internal::ClickEvent_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double button() const {
    return data_->button;
  }
  bool alt_key() const {
    return data_->alt_key;
  }
  bool ctrl_key() const {
    return data_->ctrl_key;
  }
  bool meta_key() const {
    return data_->meta_key;
  }
  bool shift_key() const {
    return data_->shift_key;
  }
 private:
  internal::ClickEvent_Data* data_ = nullptr;
};


}  // app_home::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_DATA_VIEW_H_