// chrome/browser/ui/webui/access_code_cast/access_code_cast.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/access_code_cast/access_code_cast.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/access_code_cast/access_code_cast.mojom-params-data.h"
namespace access_code_cast {
namespace mojom {

NOINLINE static const char* AddSinkResultCodeToStringHelper(AddSinkResultCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AddSinkResultCode::UNKNOWN_ERROR:
      return "UNKNOWN_ERROR";
    case AddSinkResultCode::OK:
      return "OK";
    case AddSinkResultCode::AUTH_ERROR:
      return "AUTH_ERROR";
    case AddSinkResultCode::HTTP_RESPONSE_CODE_ERROR:
      return "HTTP_RESPONSE_CODE_ERROR";
    case AddSinkResultCode::RESPONSE_MALFORMED:
      return "RESPONSE_MALFORMED";
    case AddSinkResultCode::EMPTY_RESPONSE:
      return "EMPTY_RESPONSE";
    case AddSinkResultCode::INVALID_ACCESS_CODE:
      return "INVALID_ACCESS_CODE";
    case AddSinkResultCode::ACCESS_CODE_NOT_FOUND:
      return "ACCESS_CODE_NOT_FOUND";
    case AddSinkResultCode::TOO_MANY_REQUESTS:
      return "TOO_MANY_REQUESTS";
    case AddSinkResultCode::SERVICE_NOT_PRESENT:
      return "SERVICE_NOT_PRESENT";
    case AddSinkResultCode::SERVER_ERROR:
      return "SERVER_ERROR";
    case AddSinkResultCode::SINK_CREATION_ERROR:
      return "SINK_CREATION_ERROR";
    case AddSinkResultCode::CHANNEL_OPEN_ERROR:
      return "CHANNEL_OPEN_ERROR";
    case AddSinkResultCode::PROFILE_SYNC_ERROR:
      return "PROFILE_SYNC_ERROR";
    case AddSinkResultCode::INTERNAL_MEDIA_ROUTER_ERROR:
      return "INTERNAL_MEDIA_ROUTER_ERROR";
    default:
      return nullptr;
  }
}

std::string AddSinkResultCodeToString(AddSinkResultCode value) {
  const char *str = AddSinkResultCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AddSinkResultCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AddSinkResultCode value) {
  return os << AddSinkResultCodeToString(value);
}

NOINLINE static const char* CastDiscoveryMethodToStringHelper(CastDiscoveryMethod value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CastDiscoveryMethod::QR_CODE:
      return "QR_CODE";
    case CastDiscoveryMethod::INPUT_ACCESS_CODE:
      return "INPUT_ACCESS_CODE";
    default:
      return nullptr;
  }
}

std::string CastDiscoveryMethodToString(CastDiscoveryMethod value) {
  const char *str = CastDiscoveryMethodToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CastDiscoveryMethod value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CastDiscoveryMethod value) {
  return os << CastDiscoveryMethodToString(value);
}

namespace internal {


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AddSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AddSink_Params_Data* object =
      static_cast<const PageHandler_AddSink_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_code, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_code, validation_context,
                                         &access_code_validate_params)) {
    return false;
  }


  if (!::access_code_cast::mojom::internal::CastDiscoveryMethod_Data
        ::Validate(object->discovery_method, validation_context))
    return false;

  return true;
}

PageHandler_AddSink_Params_Data::PageHandler_AddSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AddSink_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AddSink_ResponseParams_Data* object =
      static_cast<const PageHandler_AddSink_ResponseParams_Data*>(data);


  if (!::access_code_cast::mojom::internal::AddSinkResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

PageHandler_AddSink_ResponseParams_Data::PageHandler_AddSink_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CastToSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CastToSink_Params_Data* object =
      static_cast<const PageHandler_CastToSink_Params_Data*>(data);

  return true;
}

PageHandler_CastToSink_Params_Data::PageHandler_CastToSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CastToSink_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CastToSink_ResponseParams_Data* object =
      static_cast<const PageHandler_CastToSink_ResponseParams_Data*>(data);


  if (!::media_router::mojom::internal::RouteRequestResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

PageHandler_CastToSink_ResponseParams_Data::PageHandler_CastToSink_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace access_code_cast

namespace perfetto {

// static
void TraceFormatTraits<::access_code_cast::mojom::AddSinkResultCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::access_code_cast::mojom::AddSinkResultCode value) {
  return std::move(context).WriteString(::access_code_cast::mojom::AddSinkResultCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::access_code_cast::mojom::CastDiscoveryMethod>::WriteIntoTrace(
   perfetto::TracedValue context, ::access_code_cast::mojom::CastDiscoveryMethod value) {
  return std::move(context).WriteString(::access_code_cast::mojom::CastDiscoveryMethodToString(value));
}

} // namespace perfetto