// chrome/browser/ui/webui/access_code_cast/access_code_cast.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_ACCESS_CODE_CAST_ACCESS_CODE_CAST_MOJOM_PARAMS_DATA_H_
#define CHROME_BROWSER_UI_WEBUI_ACCESS_CODE_CAST_ACCESS_CODE_CAST_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace access_code_cast::mojom {
namespace internal {
class  PageHandlerFactory_CreatePageHandler_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data page;
  mojo::internal::Handle_Data handler;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandlerFactory_CreatePageHandler_Params_Data>;

  PageHandlerFactory_CreatePageHandler_Params_Data();
  ~PageHandlerFactory_CreatePageHandler_Params_Data() = delete;
};
static_assert(sizeof(PageHandlerFactory_CreatePageHandler_Params_Data) == 24,
              "Bad sizeof(PageHandlerFactory_CreatePageHandler_Params_Data)");
class  PageHandler_AddSink_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> access_code;
  int32_t discovery_method;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_AddSink_Params_Data>;

  PageHandler_AddSink_Params_Data();
  ~PageHandler_AddSink_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_AddSink_Params_Data) == 24,
              "Bad sizeof(PageHandler_AddSink_Params_Data)");
class  PageHandler_AddSink_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_AddSink_ResponseParams_Data>;

  PageHandler_AddSink_ResponseParams_Data();
  ~PageHandler_AddSink_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_AddSink_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_AddSink_ResponseParams_Data)");
class  PageHandler_CastToSink_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_CastToSink_Params_Data>;

  PageHandler_CastToSink_Params_Data();
  ~PageHandler_CastToSink_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_CastToSink_Params_Data) == 8,
              "Bad sizeof(PageHandler_CastToSink_Params_Data)");
class  PageHandler_CastToSink_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_CastToSink_ResponseParams_Data>;

  PageHandler_CastToSink_ResponseParams_Data();
  ~PageHandler_CastToSink_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_CastToSink_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_CastToSink_ResponseParams_Data)");

}  // namespace internal


class PageHandlerFactory_CreatePageHandler_ParamsDataView {
 public:
  PageHandlerFactory_CreatePageHandler_ParamsDataView() = default;

  PageHandlerFactory_CreatePageHandler_ParamsDataView(
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePage() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::access_code_cast::mojom::PageInterfaceBase>>(
            &data_->page, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::access_code_cast::mojom::PageHandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandlerFactory_CreatePageHandler_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_AddSink_ParamsDataView {
 public:
  PageHandler_AddSink_ParamsDataView() = default;

  PageHandler_AddSink_ParamsDataView(
      internal::PageHandler_AddSink_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAccessCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessCode(UserType* output) {
    
    auto* pointer = data_->access_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDiscoveryMethod(UserType* output) const {
    auto data_value = data_->discovery_method;
    return mojo::internal::Deserialize<::access_code_cast::mojom::CastDiscoveryMethod>(
        data_value, output);
  }
  CastDiscoveryMethod discovery_method() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::access_code_cast::mojom::CastDiscoveryMethod>(data_->discovery_method));
  }
 private:
  internal::PageHandler_AddSink_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_AddSink_ResponseParamsDataView {
 public:
  PageHandler_AddSink_ResponseParamsDataView() = default;

  PageHandler_AddSink_ResponseParamsDataView(
      internal::PageHandler_AddSink_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResultCode(UserType* output) const {
    auto data_value = data_->result_code;
    return mojo::internal::Deserialize<::access_code_cast::mojom::AddSinkResultCode>(
        data_value, output);
  }
  AddSinkResultCode result_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::access_code_cast::mojom::AddSinkResultCode>(data_->result_code));
  }
 private:
  internal::PageHandler_AddSink_ResponseParams_Data* data_ = nullptr;
};


class PageHandler_CastToSink_ParamsDataView {
 public:
  PageHandler_CastToSink_ParamsDataView() = default;

  PageHandler_CastToSink_ParamsDataView(
      internal::PageHandler_CastToSink_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_CastToSink_Params_Data* data_ = nullptr;
};


class PageHandler_CastToSink_ResponseParamsDataView {
 public:
  PageHandler_CastToSink_ResponseParamsDataView() = default;

  PageHandler_CastToSink_ResponseParamsDataView(
      internal::PageHandler_CastToSink_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResultCode(UserType* output) const {
    auto data_value = data_->result_code;
    return mojo::internal::Deserialize<::media_router::mojom::RouteRequestResultCode>(
        data_value, output);
  }
  ::media_router::mojom::RouteRequestResultCode result_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::RouteRequestResultCode>(data_->result_code));
  }
 private:
  internal::PageHandler_CastToSink_ResponseParams_Data* data_ = nullptr;
};



inline void PageHandler_AddSink_ParamsDataView::GetAccessCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->access_code.Get();
  *output = mojo::StringDataView(pointer, message_);
}









}  // access_code_cast::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_BROWSER_UI_WEBUI_ACCESS_CODE_CAST_ACCESS_CODE_CAST_MOJOM_PARAMS_DATA_H_