// chrome/browser/ui/tabs/tab_strip_api/tab_strip_experiment_api.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_experiment_api.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_experiment_api.mojom-params-data.h"
namespace tabs_api {
namespace mojom {

namespace internal {
// static
bool TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result_Data* object = static_cast<const TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool TabStripExperimentService_UpdateTabGroupVisual_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripExperimentService_UpdateTabGroupVisual_Params_Data* object =
      static_cast<const TabStripExperimentService_UpdateTabGroupVisual_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visual_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visual_data, validation_context))
    return false;

  return true;
}

TabStripExperimentService_UpdateTabGroupVisual_Params_Data::TabStripExperimentService_UpdateTabGroupVisual_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data* object =
      static_cast<const TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data::TabStripExperimentService_UpdateTabGroupVisual_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tabs_api