// chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_TYPES_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-shared-internal.h"




#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-data-view.h"




namespace std {

template <>
struct hash<::tabs_api::mojom::NodeId_Type>
    : public mojo::internal::EnumHashImpl<::tabs_api::mojom::NodeId_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::NodeId_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tabs_api::mojom::NodeId_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tabs_api::mojom::NodeId_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::NodeIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::NodeIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::NodeId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in NodeId struct");

    
    mojo::internal::Serialize<::tabs_api::mojom::NodeId_Type>(
      Traits::type(input),
      &fragment->type);
  }

  static bool Deserialize(::tabs_api::mojom::internal::NodeId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::NodeIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::PositionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::PositionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::Position_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::parent_id(input)) in_parent_id = Traits::parent_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parent_id)::BaseType> parent_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
      in_parent_id,
      parent_id_fragment);

    fragment->parent_id.Set(
        parent_id_fragment.is_null() ? nullptr : parent_id_fragment.data());

    fragment->index = Traits::index(input);
  }

  static bool Deserialize(::tabs_api::mojom::internal::Position_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::PositionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tabs_api::mojom {

inline void NodeIdDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PositionDataView::GetParentIdDataView(
    NodeIdDataView* output) {
  auto pointer = data_->parent_id.Get();
  *output = NodeIdDataView(pointer, message_);
}



}  // tabs_api::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::tabs_api::mojom::NodeId_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tabs_api::mojom::NodeId_Type value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_TYPES_MOJOM_SHARED_H_