// chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-params-data.h"
namespace tabs_api {
namespace mojom {

NOINLINE static const char* NodeId_TypeToStringHelper(NodeId_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NodeId_Type::kUnknown:
      return "kUnknown";
    case NodeId_Type::kContent:
      return "kContent";
    case NodeId_Type::kCollection:
      return "kCollection";
    default:
      return nullptr;
  }
}

std::string NodeId_TypeToString(NodeId_Type value) {
  const char *str = NodeId_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NodeId_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NodeId_Type value) {
  return os << NodeId_TypeToString(value);
}

namespace internal {


// static
bool NodeId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NodeId_Data* object =
      static_cast<const NodeId_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }


  if (!::tabs_api::mojom::internal::NodeId_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

NodeId_Data::NodeId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Position_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Position_Data* object =
      static_cast<const Position_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->parent_id, validation_context))
    return false;

  return true;
}

Position_Data::Position_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace tabs_api

namespace perfetto {

// static
void TraceFormatTraits<::tabs_api::mojom::NodeId_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::tabs_api::mojom::NodeId_Type value) {
  return std::move(context).WriteString(::tabs_api::mojom::NodeId_TypeToString(value));
}

} // namespace perfetto