// chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_SHARED_INTERNAL_H_
#define CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-shared-internal.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared-internal.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace tabs_api::mojom {
namespace internal {
class Image_Data;
class Tab_Data;
class TabStrip_Data;
class PinnedTabs_Data;
class UnpinnedTabs_Data;
class TabGroup_Data;
class TabGroupVisualData_Data;
class SplitTab_Data;
class SplitTabVisualData_Data;
class Container_Data;
class TabCreatedContainer_Data;
class Data_Data;

struct SplitTabVisualData_Layout_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  Data_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  Data_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~Data_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<Data_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class Data_Tag : uint32_t {

    
    kTab,
    
    kTabStrip,
    
    kPinnedTabs,
    
    kUnpinnedTabs,
    
    kTabGroup,
    
    kSplitTab,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::Tab_Data> f_tab;
    mojo::internal::Pointer<internal::TabStrip_Data> f_tab_strip;
    mojo::internal::Pointer<internal::PinnedTabs_Data> f_pinned_tabs;
    mojo::internal::Pointer<internal::UnpinnedTabs_Data> f_unpinned_tabs;
    mojo::internal::Pointer<internal::TabGroup_Data> f_tab_group;
    mojo::internal::Pointer<internal::SplitTab_Data> f_split_tab;
    uint64_t unknown;
  };

  uint32_t size;
  Data_Tag tag;
  Union_ data;
};
static_assert(sizeof(Data_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(Data_Data)");
class  Image_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> data_url;

 private:
  friend class mojo::internal::MessageFragment<Image_Data>;

  Image_Data();
  ~Image_Data() = delete;
};
static_assert(sizeof(Image_Data) == 16,
              "Bad sizeof(Image_Data)");
// Used by Image::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Image_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Image_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Image_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Image_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Image_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Tab_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::tabs_api::mojom::internal::NodeId_Data> id;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<internal::Image_Data> favicon;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> alert_states;
  int32_t network_state;
  uint8_t is_active : 1;
  uint8_t is_selected : 1;
  uint8_t is_blocked : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<Tab_Data>;

  Tab_Data();
  ~Tab_Data() = delete;
};
static_assert(sizeof(Tab_Data) == 56,
              "Bad sizeof(Tab_Data)");
// Used by Tab::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Tab_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Tab_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Tab_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Tab_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Tab_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabStrip_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::tabs_api::mojom::internal::NodeId_Data> id;

 private:
  friend class mojo::internal::MessageFragment<TabStrip_Data>;

  TabStrip_Data();
  ~TabStrip_Data() = delete;
};
static_assert(sizeof(TabStrip_Data) == 16,
              "Bad sizeof(TabStrip_Data)");
// Used by TabStrip::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabStrip_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabStrip_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabStrip_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabStrip_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabStrip_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PinnedTabs_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::tabs_api::mojom::internal::NodeId_Data> id;

 private:
  friend class mojo::internal::MessageFragment<PinnedTabs_Data>;

  PinnedTabs_Data();
  ~PinnedTabs_Data() = delete;
};
static_assert(sizeof(PinnedTabs_Data) == 16,
              "Bad sizeof(PinnedTabs_Data)");
// Used by PinnedTabs::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PinnedTabs_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PinnedTabs_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PinnedTabs_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PinnedTabs_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PinnedTabs_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  UnpinnedTabs_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::tabs_api::mojom::internal::NodeId_Data> id;

 private:
  friend class mojo::internal::MessageFragment<UnpinnedTabs_Data>;

  UnpinnedTabs_Data();
  ~UnpinnedTabs_Data() = delete;
};
static_assert(sizeof(UnpinnedTabs_Data) == 16,
              "Bad sizeof(UnpinnedTabs_Data)");
// Used by UnpinnedTabs::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UnpinnedTabs_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UnpinnedTabs_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UnpinnedTabs_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UnpinnedTabs_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UnpinnedTabs_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabGroup_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::tabs_api::mojom::internal::NodeId_Data> id;
  mojo::internal::Pointer<internal::TabGroupVisualData_Data> data;

 private:
  friend class mojo::internal::MessageFragment<TabGroup_Data>;

  TabGroup_Data();
  ~TabGroup_Data() = delete;
};
static_assert(sizeof(TabGroup_Data) == 24,
              "Bad sizeof(TabGroup_Data)");
// Used by TabGroup::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabGroup_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabGroup_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabGroup_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabGroup_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabGroup_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabGroupVisualData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  int32_t color;
  uint8_t is_collapsed : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<TabGroupVisualData_Data>;

  TabGroupVisualData_Data();
  ~TabGroupVisualData_Data() = delete;
};
static_assert(sizeof(TabGroupVisualData_Data) == 24,
              "Bad sizeof(TabGroupVisualData_Data)");
// Used by TabGroupVisualData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabGroupVisualData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabGroupVisualData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabGroupVisualData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabGroupVisualData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabGroupVisualData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SplitTab_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::tabs_api::mojom::internal::NodeId_Data> id;
  mojo::internal::Pointer<internal::SplitTabVisualData_Data> data;

 private:
  friend class mojo::internal::MessageFragment<SplitTab_Data>;

  SplitTab_Data();
  ~SplitTab_Data() = delete;
};
static_assert(sizeof(SplitTab_Data) == 24,
              "Bad sizeof(SplitTab_Data)");
// Used by SplitTab::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SplitTab_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SplitTab_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SplitTab_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SplitTab_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SplitTab_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SplitTabVisualData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t layout;
  uint8_t pad0_[4];
  double split_ratio;

 private:
  friend class mojo::internal::MessageFragment<SplitTabVisualData_Data>;

  SplitTabVisualData_Data();
  ~SplitTabVisualData_Data() = delete;
};
static_assert(sizeof(SplitTabVisualData_Data) == 24,
              "Bad sizeof(SplitTabVisualData_Data)");
// Used by SplitTabVisualData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SplitTabVisualData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SplitTabVisualData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SplitTabVisualData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SplitTabVisualData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SplitTabVisualData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Container_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::Data_Data data;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Container_Data>>> children;

 private:
  friend class mojo::internal::MessageFragment<Container_Data>;

  Container_Data();
  ~Container_Data() = delete;
};
static_assert(sizeof(Container_Data) == 32,
              "Bad sizeof(Container_Data)");
// Used by Container::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Container_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Container_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Container_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Container_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Container_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TabCreatedContainer_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::Tab_Data> tab;
  mojo::internal::Pointer<::tabs_api::mojom::internal::Position_Data> position;

 private:
  friend class mojo::internal::MessageFragment<TabCreatedContainer_Data>;

  TabCreatedContainer_Data();
  ~TabCreatedContainer_Data() = delete;
};
static_assert(sizeof(TabCreatedContainer_Data) == 24,
              "Bad sizeof(TabCreatedContainer_Data)");
// Used by TabCreatedContainer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TabCreatedContainer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TabCreatedContainer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TabCreatedContainer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TabCreatedContainer_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TabCreatedContainer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // tabs_api::mojom

#endif  // CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_SHARED_INTERNAL_H_