// chrome/browser/ui/tabs/tab_strip_api/tab_strip_api.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api.mojom-params-data.h"
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api.mojom-shared-message-ids.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api.mojom-import-headers.h"
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api.mojom-test-utils.h"


namespace tabs_api::mojom {
TabsSnapshot::TabsSnapshot()
    : tab_strip(),
      stream() {}

TabsSnapshot::TabsSnapshot(
    ::tabs_api::mojom::ContainerPtr tab_strip_in,
    ::mojo::PendingAssociatedReceiver<TabsObserver> stream_in)
    : tab_strip(std::move(tab_strip_in)),
      stream(std::move(stream_in)) {}

TabsSnapshot::~TabsSnapshot() = default;

void TabsSnapshot::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_strip"), this->tab_strip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::tabs_api::mojom::ContainerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream"), this->stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<TabsObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabsSnapshot::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabsEventPtr
TabsEvent::NewTabsCreatedEvent(
    ::tabs_api::mojom::OnTabsCreatedEventPtr value) {
  return TabsEventPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTabsCreatedEvent)>,
      std::move(value));
}

TabsEventPtr
TabsEvent::NewTabsClosedEvent(
    ::tabs_api::mojom::OnTabsClosedEventPtr value) {
  return TabsEventPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTabsClosedEvent)>,
      std::move(value));
}

TabsEventPtr
TabsEvent::NewNodeMovedEvent(
    ::tabs_api::mojom::OnNodeMovedEventPtr value) {
  return TabsEventPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNodeMovedEvent)>,
      std::move(value));
}

TabsEventPtr
TabsEvent::NewDataChangedEvent(
    ::tabs_api::mojom::OnDataChangedEventPtr value) {
  return TabsEventPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDataChangedEvent)>,
      std::move(value));
}

TabsEventPtr
TabsEvent::NewCollectionCreatedEvent(
    ::tabs_api::mojom::OnCollectionCreatedEventPtr value) {
  return TabsEventPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCollectionCreatedEvent)>,
      std::move(value));
}

TabsEvent::TabsEvent(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabsCreatedEvent)>,
    ::tabs_api::mojom::OnTabsCreatedEventPtr value)
    : tag_(Tag::kTabsCreatedEvent),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTabsCreatedEvent)>,
            std::move(value)) {}

TabsEvent::TabsEvent(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabsClosedEvent)>,
    ::tabs_api::mojom::OnTabsClosedEventPtr value)
    : tag_(Tag::kTabsClosedEvent),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTabsClosedEvent)>,
            std::move(value)) {}

TabsEvent::TabsEvent(
    std::in_place_index_t<static_cast<size_t>(Tag::kNodeMovedEvent)>,
    ::tabs_api::mojom::OnNodeMovedEventPtr value)
    : tag_(Tag::kNodeMovedEvent),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNodeMovedEvent)>,
            std::move(value)) {}

TabsEvent::TabsEvent(
    std::in_place_index_t<static_cast<size_t>(Tag::kDataChangedEvent)>,
    ::tabs_api::mojom::OnDataChangedEventPtr value)
    : tag_(Tag::kDataChangedEvent),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDataChangedEvent)>,
            std::move(value)) {}

TabsEvent::TabsEvent(
    std::in_place_index_t<static_cast<size_t>(Tag::kCollectionCreatedEvent)>,
    ::tabs_api::mojom::OnCollectionCreatedEventPtr value)
    : tag_(Tag::kCollectionCreatedEvent),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCollectionCreatedEvent)>,
            std::move(value)) {}
TabsEvent::~TabsEvent() {
  DestroyActive();
}

void TabsEvent::set_tabs_created_event(::tabs_api::mojom::OnTabsCreatedEventPtr tabs_created_event) {
  if (tag_ == Tag::kTabsCreatedEvent) {
    data_.tabs_created_event = std::move(tabs_created_event);
  } else {
    DestroyActive();
    tag_ = Tag::kTabsCreatedEvent;
    new (&data_.tabs_created_event) ::tabs_api::mojom::OnTabsCreatedEventPtr(
        std::move(tabs_created_event));
  }
}

void TabsEvent::set_tabs_closed_event(::tabs_api::mojom::OnTabsClosedEventPtr tabs_closed_event) {
  if (tag_ == Tag::kTabsClosedEvent) {
    data_.tabs_closed_event = std::move(tabs_closed_event);
  } else {
    DestroyActive();
    tag_ = Tag::kTabsClosedEvent;
    new (&data_.tabs_closed_event) ::tabs_api::mojom::OnTabsClosedEventPtr(
        std::move(tabs_closed_event));
  }
}

void TabsEvent::set_node_moved_event(::tabs_api::mojom::OnNodeMovedEventPtr node_moved_event) {
  if (tag_ == Tag::kNodeMovedEvent) {
    data_.node_moved_event = std::move(node_moved_event);
  } else {
    DestroyActive();
    tag_ = Tag::kNodeMovedEvent;
    new (&data_.node_moved_event) ::tabs_api::mojom::OnNodeMovedEventPtr(
        std::move(node_moved_event));
  }
}

void TabsEvent::set_data_changed_event(::tabs_api::mojom::OnDataChangedEventPtr data_changed_event) {
  if (tag_ == Tag::kDataChangedEvent) {
    data_.data_changed_event = std::move(data_changed_event);
  } else {
    DestroyActive();
    tag_ = Tag::kDataChangedEvent;
    new (&data_.data_changed_event) ::tabs_api::mojom::OnDataChangedEventPtr(
        std::move(data_changed_event));
  }
}

void TabsEvent::set_collection_created_event(::tabs_api::mojom::OnCollectionCreatedEventPtr collection_created_event) {
  if (tag_ == Tag::kCollectionCreatedEvent) {
    data_.collection_created_event = std::move(collection_created_event);
  } else {
    DestroyActive();
    tag_ = Tag::kCollectionCreatedEvent;
    new (&data_.collection_created_event) ::tabs_api::mojom::OnCollectionCreatedEventPtr(
        std::move(collection_created_event));
  }
}


TabsEvent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabsCreatedEvent)>,
    ::tabs_api::mojom::OnTabsCreatedEventPtr value)
    : tabs_created_event(std::move(value)) {}

TabsEvent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabsClosedEvent)>,
    ::tabs_api::mojom::OnTabsClosedEventPtr value)
    : tabs_closed_event(std::move(value)) {}

TabsEvent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNodeMovedEvent)>,
    ::tabs_api::mojom::OnNodeMovedEventPtr value)
    : node_moved_event(std::move(value)) {}

TabsEvent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDataChangedEvent)>,
    ::tabs_api::mojom::OnDataChangedEventPtr value)
    : data_changed_event(std::move(value)) {}

TabsEvent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCollectionCreatedEvent)>,
    ::tabs_api::mojom::OnCollectionCreatedEventPtr value)
    : collection_created_event(std::move(value)) {}

void TabsEvent::DestroyActive() {
  switch (tag_) {

    case Tag::kTabsCreatedEvent:
      std::destroy_at(&data_.tabs_created_event);
      break;
    case Tag::kTabsClosedEvent:
      std::destroy_at(&data_.tabs_closed_event);
      break;
    case Tag::kNodeMovedEvent:
      std::destroy_at(&data_.node_moved_event);
      break;
    case Tag::kDataChangedEvent:
      std::destroy_at(&data_.data_changed_event);
      break;
    case Tag::kCollectionCreatedEvent:
      std::destroy_at(&data_.collection_created_event);
      break;
  }
}

bool TabsEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TabStripService_GetTabs_ResponseParam_ResultPtr
TabStripService_GetTabs_ResponseParam_Result::NewSuccess(
    TabsSnapshotPtr value) {
  return TabStripService_GetTabs_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

TabStripService_GetTabs_ResponseParam_ResultPtr
TabStripService_GetTabs_ResponseParam_Result::NewFailure(
    ::mojo_base::mojom::ErrorPtr value) {
  return TabStripService_GetTabs_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

TabStripService_GetTabs_ResponseParam_Result::TabStripService_GetTabs_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    TabsSnapshotPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

TabStripService_GetTabs_ResponseParam_Result::TabStripService_GetTabs_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
TabStripService_GetTabs_ResponseParam_Result::~TabStripService_GetTabs_ResponseParam_Result() {
  DestroyActive();
}

void TabStripService_GetTabs_ResponseParam_Result::set_success(TabsSnapshotPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) TabsSnapshotPtr(
        std::move(success));
  }
}

void TabStripService_GetTabs_ResponseParam_Result::set_failure(::mojo_base::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::mojo_base::mojom::ErrorPtr(
        std::move(failure));
  }
}


TabStripService_GetTabs_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    TabsSnapshotPtr value)
    : success(std::move(value)) {}

TabStripService_GetTabs_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void TabStripService_GetTabs_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool TabStripService_GetTabs_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TabStripService_GetTab_ResponseParam_ResultPtr
TabStripService_GetTab_ResponseParam_Result::NewSuccess(
    ::tabs_api::mojom::TabPtr value) {
  return TabStripService_GetTab_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

TabStripService_GetTab_ResponseParam_ResultPtr
TabStripService_GetTab_ResponseParam_Result::NewFailure(
    ::mojo_base::mojom::ErrorPtr value) {
  return TabStripService_GetTab_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

TabStripService_GetTab_ResponseParam_Result::TabStripService_GetTab_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::tabs_api::mojom::TabPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

TabStripService_GetTab_ResponseParam_Result::TabStripService_GetTab_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
TabStripService_GetTab_ResponseParam_Result::~TabStripService_GetTab_ResponseParam_Result() {
  DestroyActive();
}

void TabStripService_GetTab_ResponseParam_Result::set_success(::tabs_api::mojom::TabPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::tabs_api::mojom::TabPtr(
        std::move(success));
  }
}

void TabStripService_GetTab_ResponseParam_Result::set_failure(::mojo_base::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::mojo_base::mojom::ErrorPtr(
        std::move(failure));
  }
}


TabStripService_GetTab_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::tabs_api::mojom::TabPtr value)
    : success(std::move(value)) {}

TabStripService_GetTab_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void TabStripService_GetTab_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool TabStripService_GetTab_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TabStripService_CreateTabAt_ResponseParam_ResultPtr
TabStripService_CreateTabAt_ResponseParam_Result::NewSuccess(
    ::tabs_api::mojom::TabPtr value) {
  return TabStripService_CreateTabAt_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

TabStripService_CreateTabAt_ResponseParam_ResultPtr
TabStripService_CreateTabAt_ResponseParam_Result::NewFailure(
    ::mojo_base::mojom::ErrorPtr value) {
  return TabStripService_CreateTabAt_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

TabStripService_CreateTabAt_ResponseParam_Result::TabStripService_CreateTabAt_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::tabs_api::mojom::TabPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

TabStripService_CreateTabAt_ResponseParam_Result::TabStripService_CreateTabAt_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
TabStripService_CreateTabAt_ResponseParam_Result::~TabStripService_CreateTabAt_ResponseParam_Result() {
  DestroyActive();
}

void TabStripService_CreateTabAt_ResponseParam_Result::set_success(::tabs_api::mojom::TabPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::tabs_api::mojom::TabPtr(
        std::move(success));
  }
}

void TabStripService_CreateTabAt_ResponseParam_Result::set_failure(::mojo_base::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::mojo_base::mojom::ErrorPtr(
        std::move(failure));
  }
}


TabStripService_CreateTabAt_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::tabs_api::mojom::TabPtr value)
    : success(std::move(value)) {}

TabStripService_CreateTabAt_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void TabStripService_CreateTabAt_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool TabStripService_CreateTabAt_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TabStripService_CloseTabs_ResponseParam_ResultPtr
TabStripService_CloseTabs_ResponseParam_Result::NewSuccess(
    const ::std::monostate& value) {
  return TabStripService_CloseTabs_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

TabStripService_CloseTabs_ResponseParam_ResultPtr
TabStripService_CloseTabs_ResponseParam_Result::NewFailure(
    ::mojo_base::mojom::ErrorPtr value) {
  return TabStripService_CloseTabs_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

TabStripService_CloseTabs_ResponseParam_Result::TabStripService_CloseTabs_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

TabStripService_CloseTabs_ResponseParam_Result::TabStripService_CloseTabs_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
TabStripService_CloseTabs_ResponseParam_Result::~TabStripService_CloseTabs_ResponseParam_Result() {
  DestroyActive();
}

void TabStripService_CloseTabs_ResponseParam_Result::set_success(const ::std::monostate& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::std::monostate(
        std::move(success));
  }
}

void TabStripService_CloseTabs_ResponseParam_Result::set_failure(::mojo_base::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::mojo_base::mojom::ErrorPtr(
        std::move(failure));
  }
}


TabStripService_CloseTabs_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : success(std::move(value)) {}

TabStripService_CloseTabs_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void TabStripService_CloseTabs_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool TabStripService_CloseTabs_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TabStripService_ActivateTab_ResponseParam_ResultPtr
TabStripService_ActivateTab_ResponseParam_Result::NewSuccess(
    const ::std::monostate& value) {
  return TabStripService_ActivateTab_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

TabStripService_ActivateTab_ResponseParam_ResultPtr
TabStripService_ActivateTab_ResponseParam_Result::NewFailure(
    ::mojo_base::mojom::ErrorPtr value) {
  return TabStripService_ActivateTab_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

TabStripService_ActivateTab_ResponseParam_Result::TabStripService_ActivateTab_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

TabStripService_ActivateTab_ResponseParam_Result::TabStripService_ActivateTab_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
TabStripService_ActivateTab_ResponseParam_Result::~TabStripService_ActivateTab_ResponseParam_Result() {
  DestroyActive();
}

void TabStripService_ActivateTab_ResponseParam_Result::set_success(const ::std::monostate& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::std::monostate(
        std::move(success));
  }
}

void TabStripService_ActivateTab_ResponseParam_Result::set_failure(::mojo_base::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::mojo_base::mojom::ErrorPtr(
        std::move(failure));
  }
}


TabStripService_ActivateTab_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : success(std::move(value)) {}

TabStripService_ActivateTab_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void TabStripService_ActivateTab_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool TabStripService_ActivateTab_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TabStripService_SetSelectedTabs_ResponseParam_ResultPtr
TabStripService_SetSelectedTabs_ResponseParam_Result::NewSuccess(
    const ::std::monostate& value) {
  return TabStripService_SetSelectedTabs_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

TabStripService_SetSelectedTabs_ResponseParam_ResultPtr
TabStripService_SetSelectedTabs_ResponseParam_Result::NewFailure(
    ::mojo_base::mojom::ErrorPtr value) {
  return TabStripService_SetSelectedTabs_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

TabStripService_SetSelectedTabs_ResponseParam_Result::TabStripService_SetSelectedTabs_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

TabStripService_SetSelectedTabs_ResponseParam_Result::TabStripService_SetSelectedTabs_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
TabStripService_SetSelectedTabs_ResponseParam_Result::~TabStripService_SetSelectedTabs_ResponseParam_Result() {
  DestroyActive();
}

void TabStripService_SetSelectedTabs_ResponseParam_Result::set_success(const ::std::monostate& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::std::monostate(
        std::move(success));
  }
}

void TabStripService_SetSelectedTabs_ResponseParam_Result::set_failure(::mojo_base::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::mojo_base::mojom::ErrorPtr(
        std::move(failure));
  }
}


TabStripService_SetSelectedTabs_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : success(std::move(value)) {}

TabStripService_SetSelectedTabs_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void TabStripService_SetSelectedTabs_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool TabStripService_SetSelectedTabs_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TabStripService_MoveNode_ResponseParam_ResultPtr
TabStripService_MoveNode_ResponseParam_Result::NewSuccess(
    const ::std::monostate& value) {
  return TabStripService_MoveNode_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

TabStripService_MoveNode_ResponseParam_ResultPtr
TabStripService_MoveNode_ResponseParam_Result::NewFailure(
    ::mojo_base::mojom::ErrorPtr value) {
  return TabStripService_MoveNode_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

TabStripService_MoveNode_ResponseParam_Result::TabStripService_MoveNode_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

TabStripService_MoveNode_ResponseParam_Result::TabStripService_MoveNode_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
TabStripService_MoveNode_ResponseParam_Result::~TabStripService_MoveNode_ResponseParam_Result() {
  DestroyActive();
}

void TabStripService_MoveNode_ResponseParam_Result::set_success(const ::std::monostate& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::std::monostate(
        std::move(success));
  }
}

void TabStripService_MoveNode_ResponseParam_Result::set_failure(::mojo_base::mojom::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::mojo_base::mojom::ErrorPtr(
        std::move(failure));
  }
}


TabStripService_MoveNode_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::std::monostate& value)
    : success(std::move(value)) {}

TabStripService_MoveNode_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::mojo_base::mojom::ErrorPtr value)
    : failure(std::move(value)) {}

void TabStripService_MoveNode_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool TabStripService_MoveNode_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

TabStripService::IPCStableHashFunction TabStripService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TabStripService>(message.name())) {
    case messages::TabStripService::kGetTabs: {
      return &TabStripService::GetTabs_Sym::IPCStableHash;
    }
    case messages::TabStripService::kGetTab: {
      return &TabStripService::GetTab_Sym::IPCStableHash;
    }
    case messages::TabStripService::kCreateTabAt: {
      return &TabStripService::CreateTabAt_Sym::IPCStableHash;
    }
    case messages::TabStripService::kCloseTabs: {
      return &TabStripService::CloseTabs_Sym::IPCStableHash;
    }
    case messages::TabStripService::kActivateTab: {
      return &TabStripService::ActivateTab_Sym::IPCStableHash;
    }
    case messages::TabStripService::kSetSelectedTabs: {
      return &TabStripService::SetSelectedTabs_Sym::IPCStableHash;
    }
    case messages::TabStripService::kMoveNode: {
      return &TabStripService::MoveNode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TabStripService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TabStripService>(message.name())) {
      case messages::TabStripService::kGetTabs:
            return "Receive tabs_api::mojom::TabStripService::GetTabs";
      case messages::TabStripService::kGetTab:
            return "Receive tabs_api::mojom::TabStripService::GetTab";
      case messages::TabStripService::kCreateTabAt:
            return "Receive tabs_api::mojom::TabStripService::CreateTabAt";
      case messages::TabStripService::kCloseTabs:
            return "Receive tabs_api::mojom::TabStripService::CloseTabs";
      case messages::TabStripService::kActivateTab:
            return "Receive tabs_api::mojom::TabStripService::ActivateTab";
      case messages::TabStripService::kSetSelectedTabs:
            return "Receive tabs_api::mojom::TabStripService::SetSelectedTabs";
      case messages::TabStripService::kMoveNode:
            return "Receive tabs_api::mojom::TabStripService::MoveNode";
    }
  } else {
    switch (static_cast<messages::TabStripService>(message.name())) {
      case messages::TabStripService::kGetTabs:
            return "Receive reply tabs_api::mojom::TabStripService::GetTabs";
      case messages::TabStripService::kGetTab:
            return "Receive reply tabs_api::mojom::TabStripService::GetTab";
      case messages::TabStripService::kCreateTabAt:
            return "Receive reply tabs_api::mojom::TabStripService::CreateTabAt";
      case messages::TabStripService::kCloseTabs:
            return "Receive reply tabs_api::mojom::TabStripService::CloseTabs";
      case messages::TabStripService::kActivateTab:
            return "Receive reply tabs_api::mojom::TabStripService::ActivateTab";
      case messages::TabStripService::kSetSelectedTabs:
            return "Receive reply tabs_api::mojom::TabStripService::SetSelectedTabs";
      case messages::TabStripService::kMoveNode:
            return "Receive reply tabs_api::mojom::TabStripService::MoveNode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TabStripService::GetTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcaf49358;  // IPCStableHash for tabs_api::mojom::TabStripService::GetTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TabStripService::GetTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5173be6;  // IPCStableHash for tabs_api::mojom::TabStripService::GetTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TabStripService::CreateTabAt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff1e6e85;  // IPCStableHash for tabs_api::mojom::TabStripService::CreateTabAt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TabStripService::CloseTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x057f5392;  // IPCStableHash for tabs_api::mojom::TabStripService::CloseTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TabStripService::ActivateTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcc97535;  // IPCStableHash for tabs_api::mojom::TabStripService::ActivateTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TabStripService::SetSelectedTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcba526d;  // IPCStableHash for tabs_api::mojom::TabStripService::SetSelectedTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TabStripService::MoveNode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13398952;  // IPCStableHash for tabs_api::mojom::TabStripService::MoveNode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TabStripService_GetTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TabStripService_GetTabs_ForwardToCallback(
      TabStripService::GetTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  TabStripService_GetTabs_ForwardToCallback(const TabStripService_GetTabs_ForwardToCallback&) = delete;
  TabStripService_GetTabs_ForwardToCallback& operator=(const TabStripService_GetTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TabStripService::GetTabsCallback callback_;
};

class TabStripService_GetTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TabStripService_GetTab_ForwardToCallback(
      TabStripService::GetTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  TabStripService_GetTab_ForwardToCallback(const TabStripService_GetTab_ForwardToCallback&) = delete;
  TabStripService_GetTab_ForwardToCallback& operator=(const TabStripService_GetTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TabStripService::GetTabCallback callback_;
};

class TabStripService_CreateTabAt_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TabStripService_CreateTabAt_ForwardToCallback(
      TabStripService::CreateTabAtCallback callback
      ) : callback_(std::move(callback)) {
  }

  TabStripService_CreateTabAt_ForwardToCallback(const TabStripService_CreateTabAt_ForwardToCallback&) = delete;
  TabStripService_CreateTabAt_ForwardToCallback& operator=(const TabStripService_CreateTabAt_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TabStripService::CreateTabAtCallback callback_;
};

class TabStripService_CloseTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TabStripService_CloseTabs_ForwardToCallback(
      TabStripService::CloseTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  TabStripService_CloseTabs_ForwardToCallback(const TabStripService_CloseTabs_ForwardToCallback&) = delete;
  TabStripService_CloseTabs_ForwardToCallback& operator=(const TabStripService_CloseTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TabStripService::CloseTabsCallback callback_;
};

class TabStripService_ActivateTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TabStripService_ActivateTab_ForwardToCallback(
      TabStripService::ActivateTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  TabStripService_ActivateTab_ForwardToCallback(const TabStripService_ActivateTab_ForwardToCallback&) = delete;
  TabStripService_ActivateTab_ForwardToCallback& operator=(const TabStripService_ActivateTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TabStripService::ActivateTabCallback callback_;
};

class TabStripService_SetSelectedTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TabStripService_SetSelectedTabs_ForwardToCallback(
      TabStripService::SetSelectedTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  TabStripService_SetSelectedTabs_ForwardToCallback(const TabStripService_SetSelectedTabs_ForwardToCallback&) = delete;
  TabStripService_SetSelectedTabs_ForwardToCallback& operator=(const TabStripService_SetSelectedTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TabStripService::SetSelectedTabsCallback callback_;
};

class TabStripService_MoveNode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TabStripService_MoveNode_ForwardToCallback(
      TabStripService::MoveNodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  TabStripService_MoveNode_ForwardToCallback(const TabStripService_MoveNode_ForwardToCallback&) = delete;
  TabStripService_MoveNode_ForwardToCallback& operator=(const TabStripService_MoveNode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TabStripService::MoveNodeCallback callback_;
};

TabStripServiceProxy::TabStripServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TabStripServiceProxy::GetTabs(
    GetTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tabs_api::mojom::TabStripService::GetTabs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kGetTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_GetTabs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("GetTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TabStripService_GetTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TabStripServiceProxy::GetTab(
    const ::tabs_api::NodeId& in_id, GetTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tabs_api::mojom::TabStripService::GetTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::tabs_api::NodeId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kGetTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_GetTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in TabStripService.GetTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("GetTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TabStripService_GetTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TabStripServiceProxy::CreateTabAt(
    const std::optional<::tabs_api::Position>& in_pos, const std::optional<::GURL>& in_url, CreateTabAtCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tabs_api::mojom::TabStripService::CreateTabAt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pos"), in_pos,
                        "<value of type const std::optional<::tabs_api::Position>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kCreateTabAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_CreateTabAt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pos)::BaseType> pos_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::PositionDataView>(
    in_pos,
    pos_fragment);

  params->pos.Set(
      pos_fragment.is_null() ? nullptr : pos_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("CreateTabAt");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TabStripService_CreateTabAt_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TabStripServiceProxy::CloseTabs(
    const std::vector<::tabs_api::NodeId>& in_id, CloseTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tabs_api::mojom::TabStripService::CloseTabs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::vector<::tabs_api::NodeId>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kCloseTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_CloseTabs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType>
      id_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::tabs_api::mojom::NodeIdDataView>>(
    in_id,
    id_fragment,
    &id_validate_params);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in TabStripService.CloseTabs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("CloseTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TabStripService_CloseTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TabStripServiceProxy::ActivateTab(
    const ::tabs_api::NodeId& in_id, ActivateTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tabs_api::mojom::TabStripService::ActivateTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::tabs_api::NodeId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kActivateTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_ActivateTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in TabStripService.ActivateTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("ActivateTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TabStripService_ActivateTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TabStripServiceProxy::SetSelectedTabs(
    const std::vector<::tabs_api::NodeId>& in_selection, const ::tabs_api::NodeId& in_tab_to_activate, SetSelectedTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tabs_api::mojom::TabStripService::SetSelectedTabs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection"), in_selection,
                        "<value of type const std::vector<::tabs_api::NodeId>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_to_activate"), in_tab_to_activate,
                        "<value of type const ::tabs_api::NodeId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kSetSelectedTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_SetSelectedTabs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->selection)::BaseType>
      selection_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& selection_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::tabs_api::mojom::NodeIdDataView>>(
    in_selection,
    selection_fragment,
    &selection_validate_params);

  params->selection.Set(
      selection_fragment.is_null() ? nullptr : selection_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->selection.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null selection in TabStripService.SetSelectedTabs request");
  mojo::internal::MessageFragment<
      typename decltype(params->tab_to_activate)::BaseType> tab_to_activate_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
    in_tab_to_activate,
    tab_to_activate_fragment);

  params->tab_to_activate.Set(
      tab_to_activate_fragment.is_null() ? nullptr : tab_to_activate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_to_activate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_to_activate in TabStripService.SetSelectedTabs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("SetSelectedTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TabStripService_SetSelectedTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TabStripServiceProxy::MoveNode(
    const ::tabs_api::NodeId& in_id, const ::tabs_api::Position& in_position, MoveNodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tabs_api::mojom::TabStripService::MoveNode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::tabs_api::NodeId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type const ::tabs_api::Position&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kMoveNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_MoveNode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in TabStripService.MoveNode request");
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  
  mojo::internal::Serialize<::tabs_api::mojom::PositionDataView>(
    in_position,
    position_fragment);

  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->position.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null position in TabStripService.MoveNode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("MoveNode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TabStripService_MoveNode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TabStripService_GetTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TabStripService::GetTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TabStripService_GetTabs_ProxyToResponder> proxy(
        new TabStripService_GetTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&TabStripService_GetTabs_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static TabStripService_GetTabs_ResponseParam_ResultPtr Transform(base::expected<
  TabsSnapshotPtr,
  ::mojo_base::mojom::ErrorPtr> in) {
    return in.has_value() ? ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~TabStripService_GetTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TabStripService_GetTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TabStripService::GetTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabStripService_GetTabs_ResponseParam_ResultPtr in_result);
};

bool TabStripService_GetTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TabStripService_GetTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TabStripService_GetTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TabStripService.0
  bool success = true;
  TabStripService_GetTabs_ResponseParam_ResultPtr p_result{};
  TabStripService_GetTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TabStripService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void TabStripService_GetTabs_ProxyToResponder::Run(
    TabStripService_GetTabs_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tabs_api::mojom::TabStripService::GetTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type TabStripService_GetTabs_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kGetTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_GetTabs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("GetTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TabStripService_GetTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TabStripService::GetTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TabStripService_GetTab_ProxyToResponder> proxy(
        new TabStripService_GetTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&TabStripService_GetTab_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static TabStripService_GetTab_ResponseParam_ResultPtr Transform(base::expected<
  ::tabs_api::mojom::TabPtr,
  ::mojo_base::mojom::ErrorPtr> in) {
    return in.has_value() ? ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~TabStripService_GetTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TabStripService_GetTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TabStripService::GetTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabStripService_GetTab_ResponseParam_ResultPtr in_result);
};

bool TabStripService_GetTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TabStripService_GetTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TabStripService_GetTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TabStripService.1
  bool success = true;
  TabStripService_GetTab_ResponseParam_ResultPtr p_result{};
  TabStripService_GetTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TabStripService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void TabStripService_GetTab_ProxyToResponder::Run(
    TabStripService_GetTab_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tabs_api::mojom::TabStripService::GetTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type TabStripService_GetTab_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kGetTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_GetTab_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("GetTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TabStripService_CreateTabAt_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TabStripService::CreateTabAtCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TabStripService_CreateTabAt_ProxyToResponder> proxy(
        new TabStripService_CreateTabAt_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&TabStripService_CreateTabAt_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static TabStripService_CreateTabAt_ResponseParam_ResultPtr Transform(base::expected<
  ::tabs_api::mojom::TabPtr,
  ::mojo_base::mojom::ErrorPtr> in) {
    return in.has_value() ? ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~TabStripService_CreateTabAt_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TabStripService_CreateTabAt_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TabStripService::CreateTabAtCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabStripService_CreateTabAt_ResponseParam_ResultPtr in_result);
};

bool TabStripService_CreateTabAt_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TabStripService_CreateTabAt_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TabStripService_CreateTabAt_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TabStripService.2
  bool success = true;
  TabStripService_CreateTabAt_ResponseParam_ResultPtr p_result{};
  TabStripService_CreateTabAt_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TabStripService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void TabStripService_CreateTabAt_ProxyToResponder::Run(
    TabStripService_CreateTabAt_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tabs_api::mojom::TabStripService::CreateTabAt", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type TabStripService_CreateTabAt_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kCreateTabAt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_CreateTabAt_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("CreateTabAt");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TabStripService_CloseTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TabStripService::CloseTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TabStripService_CloseTabs_ProxyToResponder> proxy(
        new TabStripService_CloseTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&TabStripService_CloseTabs_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static TabStripService_CloseTabs_ResponseParam_ResultPtr Transform(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr> in) {
    return in.has_value() ? ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~TabStripService_CloseTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TabStripService_CloseTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TabStripService::CloseTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabStripService_CloseTabs_ResponseParam_ResultPtr in_result);
};

bool TabStripService_CloseTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TabStripService_CloseTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TabStripService_CloseTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TabStripService.3
  bool success = true;
  TabStripService_CloseTabs_ResponseParam_ResultPtr p_result{};
  TabStripService_CloseTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TabStripService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void TabStripService_CloseTabs_ProxyToResponder::Run(
    TabStripService_CloseTabs_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tabs_api::mojom::TabStripService::CloseTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type TabStripService_CloseTabs_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kCloseTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_CloseTabs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("CloseTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TabStripService_ActivateTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TabStripService::ActivateTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TabStripService_ActivateTab_ProxyToResponder> proxy(
        new TabStripService_ActivateTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&TabStripService_ActivateTab_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static TabStripService_ActivateTab_ResponseParam_ResultPtr Transform(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr> in) {
    return in.has_value() ? ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~TabStripService_ActivateTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TabStripService_ActivateTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TabStripService::ActivateTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabStripService_ActivateTab_ResponseParam_ResultPtr in_result);
};

bool TabStripService_ActivateTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TabStripService_ActivateTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TabStripService_ActivateTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TabStripService.4
  bool success = true;
  TabStripService_ActivateTab_ResponseParam_ResultPtr p_result{};
  TabStripService_ActivateTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TabStripService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void TabStripService_ActivateTab_ProxyToResponder::Run(
    TabStripService_ActivateTab_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tabs_api::mojom::TabStripService::ActivateTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type TabStripService_ActivateTab_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kActivateTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_ActivateTab_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("ActivateTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TabStripService_SetSelectedTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TabStripService::SetSelectedTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TabStripService_SetSelectedTabs_ProxyToResponder> proxy(
        new TabStripService_SetSelectedTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&TabStripService_SetSelectedTabs_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static TabStripService_SetSelectedTabs_ResponseParam_ResultPtr Transform(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr> in) {
    return in.has_value() ? ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~TabStripService_SetSelectedTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TabStripService_SetSelectedTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TabStripService::SetSelectedTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabStripService_SetSelectedTabs_ResponseParam_ResultPtr in_result);
};

bool TabStripService_SetSelectedTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TabStripService_SetSelectedTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TabStripService_SetSelectedTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TabStripService.5
  bool success = true;
  TabStripService_SetSelectedTabs_ResponseParam_ResultPtr p_result{};
  TabStripService_SetSelectedTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TabStripService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void TabStripService_SetSelectedTabs_ProxyToResponder::Run(
    TabStripService_SetSelectedTabs_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tabs_api::mojom::TabStripService::SetSelectedTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type TabStripService_SetSelectedTabs_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kSetSelectedTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_SetSelectedTabs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("SetSelectedTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TabStripService_MoveNode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TabStripService::MoveNodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TabStripService_MoveNode_ProxyToResponder> proxy(
        new TabStripService_MoveNode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&TabStripService_MoveNode_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static TabStripService_MoveNode_ResponseParam_ResultPtr Transform(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr> in) {
    return in.has_value() ? ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~TabStripService_MoveNode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TabStripService_MoveNode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TabStripService::MoveNodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabStripService_MoveNode_ResponseParam_ResultPtr in_result);
};

bool TabStripService_MoveNode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TabStripService_MoveNode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TabStripService_MoveNode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TabStripService.6
  bool success = true;
  TabStripService_MoveNode_ResponseParam_ResultPtr p_result{};
  TabStripService_MoveNode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TabStripService::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void TabStripService_MoveNode_ProxyToResponder::Run(
    TabStripService_MoveNode_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tabs_api::mojom::TabStripService::MoveNode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type TabStripService_MoveNode_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabStripService::kMoveNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabStripService_MoveNode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabStripService::Name_);
  message.set_method_name("MoveNode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TabStripServiceStubDispatch::Accept(
    TabStripService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TabStripService>(message->header()->name)) {
    case messages::TabStripService::kGetTabs: {
      break;
    }
    case messages::TabStripService::kGetTab: {
      break;
    }
    case messages::TabStripService::kCreateTabAt: {
      break;
    }
    case messages::TabStripService::kCloseTabs: {
      break;
    }
    case messages::TabStripService::kActivateTab: {
      break;
    }
    case messages::TabStripService::kSetSelectedTabs: {
      break;
    }
    case messages::TabStripService::kMoveNode: {
      break;
    }
  }
  return false;
}

// static
bool TabStripServiceStubDispatch::AcceptWithResponder(
    TabStripService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TabStripService>(message->header()->name)) {
    case messages::TabStripService::kGetTabs: {
      internal::TabStripService_GetTabs_Params_Data* params =
          reinterpret_cast<
              internal::TabStripService_GetTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TabStripService.0
      bool success = true;
      TabStripService_GetTabs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabStripService::Name_, 0, false);
        return false;
      }
      auto callback =
          TabStripService_GetTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabs(std::move(callback));
      return true;
    }
    case messages::TabStripService::kGetTab: {
      internal::TabStripService_GetTab_Params_Data* params =
          reinterpret_cast<
              internal::TabStripService_GetTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TabStripService.1
      bool success = true;
      ::tabs_api::NodeId p_id{};
      TabStripService_GetTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabStripService::Name_, 1, false);
        return false;
      }
      auto callback =
          TabStripService_GetTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTab(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::TabStripService::kCreateTabAt: {
      internal::TabStripService_CreateTabAt_Params_Data* params =
          reinterpret_cast<
              internal::TabStripService_CreateTabAt_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TabStripService.2
      bool success = true;
      std::optional<::tabs_api::Position> p_pos{};
      std::optional<::GURL> p_url{};
      TabStripService_CreateTabAt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPos(&p_pos))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabStripService::Name_, 2, false);
        return false;
      }
      auto callback =
          TabStripService_CreateTabAt_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTabAt(        
        std::move(p_pos), 
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::TabStripService::kCloseTabs: {
      internal::TabStripService_CloseTabs_Params_Data* params =
          reinterpret_cast<
              internal::TabStripService_CloseTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TabStripService.3
      bool success = true;
      std::vector<::tabs_api::NodeId> p_id{};
      TabStripService_CloseTabs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabStripService::Name_, 3, false);
        return false;
      }
      auto callback =
          TabStripService_CloseTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseTabs(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::TabStripService::kActivateTab: {
      internal::TabStripService_ActivateTab_Params_Data* params =
          reinterpret_cast<
              internal::TabStripService_ActivateTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TabStripService.4
      bool success = true;
      ::tabs_api::NodeId p_id{};
      TabStripService_ActivateTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabStripService::Name_, 4, false);
        return false;
      }
      auto callback =
          TabStripService_ActivateTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateTab(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::TabStripService::kSetSelectedTabs: {
      internal::TabStripService_SetSelectedTabs_Params_Data* params =
          reinterpret_cast<
              internal::TabStripService_SetSelectedTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TabStripService.5
      bool success = true;
      std::vector<::tabs_api::NodeId> p_selection{};
      ::tabs_api::NodeId p_tab_to_activate{};
      TabStripService_SetSelectedTabs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSelection(&p_selection))
        success = false;
      if (success && !input_data_view.ReadTabToActivate(&p_tab_to_activate))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabStripService::Name_, 5, false);
        return false;
      }
      auto callback =
          TabStripService_SetSelectedTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSelectedTabs(        
        std::move(p_selection), 
        std::move(p_tab_to_activate), std::move(callback));
      return true;
    }
    case messages::TabStripService::kMoveNode: {
      internal::TabStripService_MoveNode_Params_Data* params =
          reinterpret_cast<
              internal::TabStripService_MoveNode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TabStripService.6
      bool success = true;
      ::tabs_api::NodeId p_id{};
      ::tabs_api::Position p_position{};
      TabStripService_MoveNode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabStripService::Name_, 6, false);
        return false;
      }
      auto callback =
          TabStripService_MoveNode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveNode(        
        std::move(p_id), 
        std::move(p_position), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTabStripServiceValidationInfo[] = {
    { &internal::TabStripService_GetTabs_Params_Data::Validate,
     &internal::TabStripService_GetTabs_ResponseParams_Data::Validate},
    { &internal::TabStripService_GetTab_Params_Data::Validate,
     &internal::TabStripService_GetTab_ResponseParams_Data::Validate},
    { &internal::TabStripService_CreateTabAt_Params_Data::Validate,
     &internal::TabStripService_CreateTabAt_ResponseParams_Data::Validate},
    { &internal::TabStripService_CloseTabs_Params_Data::Validate,
     &internal::TabStripService_CloseTabs_ResponseParams_Data::Validate},
    { &internal::TabStripService_ActivateTab_Params_Data::Validate,
     &internal::TabStripService_ActivateTab_ResponseParams_Data::Validate},
    { &internal::TabStripService_SetSelectedTabs_Params_Data::Validate,
     &internal::TabStripService_SetSelectedTabs_ResponseParams_Data::Validate},
    { &internal::TabStripService_MoveNode_Params_Data::Validate,
     &internal::TabStripService_MoveNode_ResponseParams_Data::Validate},
};

bool TabStripServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tabs_api::mojom::TabStripService::Name_,
    kTabStripServiceValidationInfo);
}

bool TabStripServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::tabs_api::mojom::TabStripService::Name_,
    kTabStripServiceValidationInfo);
}
// The declaration includes the definition on other builds.

TabsObserver::IPCStableHashFunction TabsObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TabsObserver>(message.name())) {
    case messages::TabsObserver::kOnTabEvents: {
      return &TabsObserver::OnTabEvents_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TabsObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TabsObserver>(message.name())) {
      case messages::TabsObserver::kOnTabEvents:
            return "Receive tabs_api::mojom::TabsObserver::OnTabEvents";
    }
  } else {
    switch (static_cast<messages::TabsObserver>(message.name())) {
      case messages::TabsObserver::kOnTabEvents:
            return "Receive reply tabs_api::mojom::TabsObserver::OnTabEvents";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TabsObserver::OnTabEvents_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74a0494f;  // IPCStableHash for tabs_api::mojom::TabsObserver::OnTabEvents
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TabsObserverProxy::TabsObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TabsObserverProxy::OnTabEvents(
    std::vector<TabsEventPtr> in_events) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tabs_api::mojom::TabsObserver::OnTabEvents", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("events"), in_events,
                        "<value of type std::vector<TabsEventPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabsObserver::kOnTabEvents), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tabs_api::mojom::internal::TabsObserver_OnTabEvents_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->events)::BaseType>
      events_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& events_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::tabs_api::mojom::TabsEventDataView>>(
    in_events,
    events_fragment,
    &events_validate_params);

  params->events.Set(
      events_fragment.is_null() ? nullptr : events_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->events.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null events in TabsObserver.OnTabEvents request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabsObserver::Name_);
  message.set_method_name("OnTabEvents");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TabsObserverStubDispatch::Accept(
    TabsObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TabsObserver>(message->header()->name)) {
    case messages::TabsObserver::kOnTabEvents: {
      DCHECK(message->is_serialized());
      internal::TabsObserver_OnTabEvents_Params_Data* params =
          reinterpret_cast<internal::TabsObserver_OnTabEvents_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TabsObserver.0
      bool success = true;
      std::vector<TabsEventPtr> p_events{};
      TabsObserver_OnTabEvents_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvents(&p_events))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabsObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTabEvents(        
        std::move(p_events));
      return true;
    }
  }
  return false;
}

// static
bool TabsObserverStubDispatch::AcceptWithResponder(
    TabsObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TabsObserver>(message->header()->name)) {
    case messages::TabsObserver::kOnTabEvents: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTabsObserverValidationInfo[] = {
    { &internal::TabsObserver_OnTabEvents_Params_Data::Validate,
     nullptr /* no response */},
};

bool TabsObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tabs_api::mojom::TabsObserver::Name_,
    kTabsObserverValidationInfo);
}



}  // tabs_api::mojom


namespace mojo {


// static
bool StructTraits<::tabs_api::mojom::TabsSnapshot::DataView, ::tabs_api::mojom::TabsSnapshotPtr>::Read(
    ::tabs_api::mojom::TabsSnapshot::DataView input,
    ::tabs_api::mojom::TabsSnapshotPtr* output) {
  bool success = true;
  ::tabs_api::mojom::TabsSnapshotPtr result(::tabs_api::mojom::TabsSnapshot::New());
  
      if (success && !input.ReadTabStrip(&result->tab_strip))
        success = false;
      if (success) {
        result->stream =
            input.TakeStream<decltype(result->stream)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::tabs_api::mojom::TabsEvent::DataView, ::tabs_api::mojom::TabsEventPtr>::Read(
    ::tabs_api::mojom::TabsEvent::DataView input,
    ::tabs_api::mojom::TabsEventPtr* output) {
  using UnionType = ::tabs_api::mojom::TabsEvent;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kTabsCreatedEvent: {
      ::tabs_api::mojom::OnTabsCreatedEventPtr result_tabs_created_event{};
      if (!input.ReadTabsCreatedEvent(&result_tabs_created_event))
        return false;

      *output = UnionType::NewTabsCreatedEvent(
          std::move(result_tabs_created_event));
      break;
    }
    case Tag::kTabsClosedEvent: {
      ::tabs_api::mojom::OnTabsClosedEventPtr result_tabs_closed_event{};
      if (!input.ReadTabsClosedEvent(&result_tabs_closed_event))
        return false;

      *output = UnionType::NewTabsClosedEvent(
          std::move(result_tabs_closed_event));
      break;
    }
    case Tag::kNodeMovedEvent: {
      ::tabs_api::mojom::OnNodeMovedEventPtr result_node_moved_event{};
      if (!input.ReadNodeMovedEvent(&result_node_moved_event))
        return false;

      *output = UnionType::NewNodeMovedEvent(
          std::move(result_node_moved_event));
      break;
    }
    case Tag::kDataChangedEvent: {
      ::tabs_api::mojom::OnDataChangedEventPtr result_data_changed_event{};
      if (!input.ReadDataChangedEvent(&result_data_changed_event))
        return false;

      *output = UnionType::NewDataChangedEvent(
          std::move(result_data_changed_event));
      break;
    }
    case Tag::kCollectionCreatedEvent: {
      ::tabs_api::mojom::OnCollectionCreatedEventPtr result_collection_created_event{};
      if (!input.ReadCollectionCreatedEvent(&result_collection_created_event))
        return false;

      *output = UnionType::NewCollectionCreatedEvent(
          std::move(result_collection_created_event));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_Result::DataView, ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr>::Read(
    ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_Result::DataView input,
    ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultPtr* output) {
  using UnionType = ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::tabs_api::mojom::TabsSnapshotPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::mojo_base::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::tabs_api::mojom::TabStripService_GetTab_ResponseParam_Result::DataView, ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr>::Read(
    ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_Result::DataView input,
    ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultPtr* output) {
  using UnionType = ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::tabs_api::mojom::TabPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::mojo_base::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_Result::DataView, ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr>::Read(
    ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_Result::DataView input,
    ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultPtr* output) {
  using UnionType = ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::tabs_api::mojom::TabPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::mojo_base::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_Result::DataView, ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr>::Read(
    ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_Result::DataView input,
    ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultPtr* output) {
  using UnionType = ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::std::monostate result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::mojo_base::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_Result::DataView, ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr>::Read(
    ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_Result::DataView input,
    ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultPtr* output) {
  using UnionType = ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::std::monostate result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::mojo_base::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_Result::DataView, ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr>::Read(
    ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_Result::DataView input,
    ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultPtr* output) {
  using UnionType = ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::std::monostate result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::mojo_base::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_Result::DataView, ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr>::Read(
    ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_Result::DataView input,
    ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultPtr* output) {
  using UnionType = ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::std::monostate result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::mojo_base::mojom::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tabs_api::mojom {


void TabStripServiceInterceptorForTesting::GetTabs(GetTabsCallback callback) {
  GetForwardingInterface()->GetTabs(std::move(callback));
}
void TabStripServiceInterceptorForTesting::GetTab(const ::tabs_api::NodeId& id, GetTabCallback callback) {
  GetForwardingInterface()->GetTab(
    std::move(id)
    , std::move(callback));
}
void TabStripServiceInterceptorForTesting::CreateTabAt(const std::optional<::tabs_api::Position>& pos, const std::optional<::GURL>& url, CreateTabAtCallback callback) {
  GetForwardingInterface()->CreateTabAt(
    std::move(pos)
    , 
    std::move(url)
    , std::move(callback));
}
void TabStripServiceInterceptorForTesting::CloseTabs(const std::vector<::tabs_api::NodeId>& id, CloseTabsCallback callback) {
  GetForwardingInterface()->CloseTabs(
    std::move(id)
    , std::move(callback));
}
void TabStripServiceInterceptorForTesting::ActivateTab(const ::tabs_api::NodeId& id, ActivateTabCallback callback) {
  GetForwardingInterface()->ActivateTab(
    std::move(id)
    , std::move(callback));
}
void TabStripServiceInterceptorForTesting::SetSelectedTabs(const std::vector<::tabs_api::NodeId>& selection, const ::tabs_api::NodeId& tab_to_activate, SetSelectedTabsCallback callback) {
  GetForwardingInterface()->SetSelectedTabs(
    std::move(selection)
    , 
    std::move(tab_to_activate)
    , std::move(callback));
}
void TabStripServiceInterceptorForTesting::MoveNode(const ::tabs_api::NodeId& id, const ::tabs_api::Position& position, MoveNodeCallback callback) {
  GetForwardingInterface()->MoveNode(
    std::move(id)
    , 
    std::move(position)
    , std::move(callback));
}
TabStripServiceAsyncWaiter::TabStripServiceAsyncWaiter(
    TabStripService* proxy) : proxy_(proxy) {}

TabStripServiceAsyncWaiter::~TabStripServiceAsyncWaiter() = default;





void TabsObserverInterceptorForTesting::OnTabEvents(std::vector<TabsEventPtr> events) {
  GetForwardingInterface()->OnTabEvents(
    std::move(events)
    );
}
TabsObserverAsyncWaiter::TabsObserverAsyncWaiter(
    TabsObserver* proxy) : proxy_(proxy) {}

TabsObserverAsyncWaiter::~TabsObserverAsyncWaiter() = default;







}  // tabs_api::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif