// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./icons.html.js";import"//resources/cr_elements/cr_button/cr_button.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{MenuSourceType}from"//resources/mojo/ui/base/mojom/menu_source_type.mojom-webui.js";import{getCss}from"./extension_element.css.js";import{getHtml}from"./extension_element.html.js";export class ExtensionElement extends CrLitElement{static get is(){return"webui-browser-extension-element"}static get properties(){return{iconUrl:{type:String},visible:{type:Boolean,reflect:true}}}#iconUrl_accessor_storage="";get iconUrl(){return this.#iconUrl_accessor_storage}set iconUrl(value){this.#iconUrl_accessor_storage=value}#visible_accessor_storage=false;get visible(){return this.#visible_accessor_storage}set visible(value){this.#visible_accessor_storage=value}bar;extensionId;static get styles(){return getCss()}render(){return getHtml.bind(this)()}constructor(extensionId,bar){super();this.extensionId=extensionId;this.bar=bar}update(changedProperties){this.style.setProperty("--extension-icon-url",`url(${this.iconUrl})`);super.update(changedProperties)}onClick(){this.bar.onClick(this.extensionId)}onContextMenu(event){event.preventDefault();let sourceType=MenuSourceType.kNone;switch(event.pointerType){case"mouse":sourceType=MenuSourceType.kMouse;break;case"pen":sourceType=MenuSourceType.kStylus;break;case"touch":sourceType=MenuSourceType.kTouch}this.bar.onContextMenu(sourceType,this.extensionId)}}customElements.define(ExtensionElement.is,ExtensionElement);