// chrome/browser/ui/webui/user_education_internals/user_education_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';








export type UserEducationInternalsPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<UserEducationInternalsPageHandlerPendingReceiver>;

export class UserEducationInternalsPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<UserEducationInternalsPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<UserEducationInternalsPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|UserEducationInternalsPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'mojom.user_education_internals.UserEducationInternalsPageHandler',
        scope);
  }
}

export interface UserEducationInternalsPageHandlerInterface {
  getTutorials(): Promise<{
        tutorialInfos: FeaturePromoDemoPageInfo[], }>;
  startTutorial(tutorialId: string): Promise<{
        errorMessage: string, }>;
  getSessionData(): Promise<{
        sessionData: FeaturePromoDemoPageData[], }>;
  getFeaturePromos(): Promise<{
        featurePromos: FeaturePromoDemoPageInfo[], }>;
  showFeaturePromo(featureName: string): Promise<{
        errorMessage: string, }>;
  clearFeaturePromoData(featureName: string): Promise<{
        errorMessage: string, }>;
  clearSessionData(): Promise<{
        errorMessage: string, }>;
  forceNewSession(): Promise<{
        errorMessage: string, }>;
  removeGracePeriods(): Promise<{
        errorMessage: string, }>;
  getNewBadges(): Promise<{
        newBadges: FeaturePromoDemoPageInfo[], }>;
  getWhatsNewModules(): Promise<{
        whatsNewModules: WhatsNewModuleDemoPageInfo[], }>;
  getWhatsNewEditions(): Promise<{
        whatsNewEditions: WhatsNewEditionDemoPageInfo[], }>;
  getNtpPromos(): Promise<{
        ntpPromos: FeaturePromoDemoPageInfo[], }>;
  getNtpPromoPreferences(): Promise<{
        ntpPromoPreferences: FeaturePromoDemoPageData[], }>;
  clearNewBadgeData(featureName: string): Promise<{
        errorMessage: string, }>;
  clearWhatsNewData(): Promise<{
        errorMessage: string, }>;
  clearNtpPromoData(id: string): Promise<{
        errorMessage: string, }>;
  clearNtpPromoPreferences(): Promise<{
        errorMessage: string, }>;
  launchWhatsNewStaging(): void;
}

export class UserEducationInternalsPageHandlerRemote implements UserEducationInternalsPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<UserEducationInternalsPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<UserEducationInternalsPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|UserEducationInternalsPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UserEducationInternalsPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getTutorials(): Promise<{
        tutorialInfos: FeaturePromoDemoPageInfo[], }> {
    return this.proxy.sendMessage(
        0,
        UserEducationInternalsPageHandler_GetTutorials_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetTutorials_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  startTutorial(
      tutorialId: string): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        1,
        UserEducationInternalsPageHandler_StartTutorial_ParamsSpec.$,
        UserEducationInternalsPageHandler_StartTutorial_ResponseParamsSpec.$,
        [
          tutorialId
        ],
        false);
  }

  getSessionData(): Promise<{
        sessionData: FeaturePromoDemoPageData[], }> {
    return this.proxy.sendMessage(
        2,
        UserEducationInternalsPageHandler_GetSessionData_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetSessionData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getFeaturePromos(): Promise<{
        featurePromos: FeaturePromoDemoPageInfo[], }> {
    return this.proxy.sendMessage(
        3,
        UserEducationInternalsPageHandler_GetFeaturePromos_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  showFeaturePromo(
      featureName: string): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        4,
        UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsSpec.$,
        UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsSpec.$,
        [
          featureName
        ],
        false);
  }

  clearFeaturePromoData(
      featureName: string): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        5,
        UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsSpec.$,
        [
          featureName
        ],
        false);
  }

  clearSessionData(): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        6,
        UserEducationInternalsPageHandler_ClearSessionData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  forceNewSession(): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        7,
        UserEducationInternalsPageHandler_ForceNewSession_ParamsSpec.$,
        UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  removeGracePeriods(): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        8,
        UserEducationInternalsPageHandler_RemoveGracePeriods_ParamsSpec.$,
        UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getNewBadges(): Promise<{
        newBadges: FeaturePromoDemoPageInfo[], }> {
    return this.proxy.sendMessage(
        9,
        UserEducationInternalsPageHandler_GetNewBadges_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getWhatsNewModules(): Promise<{
        whatsNewModules: WhatsNewModuleDemoPageInfo[], }> {
    return this.proxy.sendMessage(
        10,
        UserEducationInternalsPageHandler_GetWhatsNewModules_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getWhatsNewEditions(): Promise<{
        whatsNewEditions: WhatsNewEditionDemoPageInfo[], }> {
    return this.proxy.sendMessage(
        11,
        UserEducationInternalsPageHandler_GetWhatsNewEditions_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getNtpPromos(): Promise<{
        ntpPromos: FeaturePromoDemoPageInfo[], }> {
    return this.proxy.sendMessage(
        12,
        UserEducationInternalsPageHandler_GetNtpPromos_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getNtpPromoPreferences(): Promise<{
        ntpPromoPreferences: FeaturePromoDemoPageData[], }> {
    return this.proxy.sendMessage(
        13,
        UserEducationInternalsPageHandler_GetNtpPromoPreferences_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  clearNewBadgeData(
      featureName: string): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        14,
        UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsSpec.$,
        [
          featureName
        ],
        false);
  }

  clearWhatsNewData(): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        15,
        UserEducationInternalsPageHandler_ClearWhatsNewData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  clearNtpPromoData(
      id: string): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        16,
        UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  clearNtpPromoPreferences(): Promise<{
        errorMessage: string, }> {
    return this.proxy.sendMessage(
        17,
        UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  launchWhatsNewStaging(): void {
    this.proxy.sendMessage(
        18,
        UserEducationInternalsPageHandler_LaunchWhatsNewStaging_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UserEducationInternalsPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UserEducationInternalsPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UserEducationInternalsPageHandlerRemote, UserEducationInternalsPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UserEducationInternalsPageHandlerRemote, UserEducationInternalsPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: UserEducationInternalsPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UserEducationInternalsPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UserEducationInternalsPageHandler_GetTutorials_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetTutorials_ResponseParamsSpec.$,
        impl.getTutorials.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UserEducationInternalsPageHandler_StartTutorial_ParamsSpec.$,
        UserEducationInternalsPageHandler_StartTutorial_ResponseParamsSpec.$,
        impl.startTutorial.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        UserEducationInternalsPageHandler_GetSessionData_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetSessionData_ResponseParamsSpec.$,
        impl.getSessionData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        UserEducationInternalsPageHandler_GetFeaturePromos_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsSpec.$,
        impl.getFeaturePromos.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsSpec.$,
        UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsSpec.$,
        impl.showFeaturePromo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsSpec.$,
        impl.clearFeaturePromoData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        UserEducationInternalsPageHandler_ClearSessionData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsSpec.$,
        impl.clearSessionData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        UserEducationInternalsPageHandler_ForceNewSession_ParamsSpec.$,
        UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsSpec.$,
        impl.forceNewSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        UserEducationInternalsPageHandler_RemoveGracePeriods_ParamsSpec.$,
        UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsSpec.$,
        impl.removeGracePeriods.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        UserEducationInternalsPageHandler_GetNewBadges_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsSpec.$,
        impl.getNewBadges.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        UserEducationInternalsPageHandler_GetWhatsNewModules_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsSpec.$,
        impl.getWhatsNewModules.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        UserEducationInternalsPageHandler_GetWhatsNewEditions_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsSpec.$,
        impl.getWhatsNewEditions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        UserEducationInternalsPageHandler_GetNtpPromos_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsSpec.$,
        impl.getNtpPromos.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        UserEducationInternalsPageHandler_GetNtpPromoPreferences_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsSpec.$,
        impl.getNtpPromoPreferences.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsSpec.$,
        impl.clearNewBadgeData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        UserEducationInternalsPageHandler_ClearWhatsNewData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsSpec.$,
        impl.clearWhatsNewData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsSpec.$,
        impl.clearNtpPromoData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsSpec.$,
        impl.clearNtpPromoPreferences.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        UserEducationInternalsPageHandler_LaunchWhatsNewStaging_ParamsSpec.$,
        null,
        impl.launchWhatsNewStaging.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UserEducationInternalsPageHandler {
  static get $interfaceName(): string {
    return "mojom.user_education_internals.UserEducationInternalsPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): UserEducationInternalsPageHandlerRemote {
    let remote = new UserEducationInternalsPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the UserEducationInternalsPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UserEducationInternalsPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UserEducationInternalsPageHandlerRemote, UserEducationInternalsPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UserEducationInternalsPageHandlerRemote, UserEducationInternalsPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getTutorials: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startTutorial: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSessionData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getFeaturePromos: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showFeaturePromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearFeaturePromoData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearSessionData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  forceNewSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeGracePeriods: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getNewBadges: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getWhatsNewModules: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getWhatsNewEditions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getNtpPromos: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getNtpPromoPreferences: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearNewBadgeData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearWhatsNewData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearNtpPromoData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearNtpPromoPreferences: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  launchWhatsNewStaging: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UserEducationInternalsPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getTutorials =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UserEducationInternalsPageHandler_GetTutorials_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetTutorials_ResponseParamsSpec.$,
        this.getTutorials.createReceiverHandler(true /* expectsResponse */),
        false);
    this.startTutorial =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UserEducationInternalsPageHandler_StartTutorial_ParamsSpec.$,
        UserEducationInternalsPageHandler_StartTutorial_ResponseParamsSpec.$,
        this.startTutorial.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getSessionData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        UserEducationInternalsPageHandler_GetSessionData_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetSessionData_ResponseParamsSpec.$,
        this.getSessionData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getFeaturePromos =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        UserEducationInternalsPageHandler_GetFeaturePromos_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsSpec.$,
        this.getFeaturePromos.createReceiverHandler(true /* expectsResponse */),
        false);
    this.showFeaturePromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsSpec.$,
        UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsSpec.$,
        this.showFeaturePromo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearFeaturePromoData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsSpec.$,
        this.clearFeaturePromoData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearSessionData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        UserEducationInternalsPageHandler_ClearSessionData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsSpec.$,
        this.clearSessionData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.forceNewSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        UserEducationInternalsPageHandler_ForceNewSession_ParamsSpec.$,
        UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsSpec.$,
        this.forceNewSession.createReceiverHandler(true /* expectsResponse */),
        false);
    this.removeGracePeriods =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        UserEducationInternalsPageHandler_RemoveGracePeriods_ParamsSpec.$,
        UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsSpec.$,
        this.removeGracePeriods.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getNewBadges =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        UserEducationInternalsPageHandler_GetNewBadges_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsSpec.$,
        this.getNewBadges.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getWhatsNewModules =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        UserEducationInternalsPageHandler_GetWhatsNewModules_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsSpec.$,
        this.getWhatsNewModules.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getWhatsNewEditions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        UserEducationInternalsPageHandler_GetWhatsNewEditions_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsSpec.$,
        this.getWhatsNewEditions.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getNtpPromos =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        UserEducationInternalsPageHandler_GetNtpPromos_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsSpec.$,
        this.getNtpPromos.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getNtpPromoPreferences =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        UserEducationInternalsPageHandler_GetNtpPromoPreferences_ParamsSpec.$,
        UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsSpec.$,
        this.getNtpPromoPreferences.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearNewBadgeData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsSpec.$,
        this.clearNewBadgeData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearWhatsNewData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        UserEducationInternalsPageHandler_ClearWhatsNewData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsSpec.$,
        this.clearWhatsNewData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearNtpPromoData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsSpec.$,
        this.clearNtpPromoData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.clearNtpPromoPreferences =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ParamsSpec.$,
        UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsSpec.$,
        this.clearNtpPromoPreferences.createReceiverHandler(true /* expectsResponse */),
        false);
    this.launchWhatsNewStaging =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        UserEducationInternalsPageHandler_LaunchWhatsNewStaging_ParamsSpec.$,
        null,
        this.launchWhatsNewStaging.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const FeaturePromoDemoPageDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FeaturePromoDemoPageInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WhatsNewModuleDemoPageInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WhatsNewEditionDemoPageInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetTutorials_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetTutorials_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_StartTutorial_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_StartTutorial_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetSessionData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetSessionData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetFeaturePromos_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearSessionData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ForceNewSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_RemoveGracePeriods_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetNewBadges_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetWhatsNewModules_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetWhatsNewEditions_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetNtpPromos_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetNtpPromoPreferences_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearWhatsNewData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserEducationInternalsPageHandler_LaunchWhatsNewStaging_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface FeaturePromoDemoPageDataMojoType {
  name: string;
  value: string;
}


export type FeaturePromoDemoPageData = FeaturePromoDemoPageDataMojoType;
mojo.internal.Struct<FeaturePromoDemoPageDataMojoType>(
    FeaturePromoDemoPageDataSpec.$,
    'FeaturePromoDemoPageData',
    [
      mojo.internal.StructField<FeaturePromoDemoPageDataMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageDataMojoType, string>(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface FeaturePromoDemoPageInfoMojoType {
  displayTitle: string;
  displayDescription: string;
  internalName: string;
  type: string;
  addedMilestone: number;
  supportedPlatforms: string[];
  requiredFeatures: string[];
  instructions: string[];
  followedByInternalName: string;
  data: FeaturePromoDemoPageData[];
}


export type FeaturePromoDemoPageInfo = FeaturePromoDemoPageInfoMojoType;
mojo.internal.Struct<FeaturePromoDemoPageInfoMojoType>(
    FeaturePromoDemoPageInfoSpec.$,
    'FeaturePromoDemoPageInfo',
    [
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, string>(
        'displayTitle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, string>(
        'displayDescription', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, string>(
        'internalName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, string>(
        'type', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, number>(
        'addedMilestone', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, string[]>(
        'supportedPlatforms', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, string[]>(
        'requiredFeatures', 48,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, string[]>(
        'instructions', 56,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, string>(
        'followedByInternalName', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeaturePromoDemoPageInfoMojoType, FeaturePromoDemoPageData[]>(
        'data', 72,
        0,
        mojo.internal.Array(FeaturePromoDemoPageDataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 88],]);





export interface WhatsNewModuleDemoPageInfoMojoType {
  displayTitle: string;
  moduleName: string;
  hasBrowserCommand: boolean;
  isFeatureEnabled: boolean;
  queuePosition: number;
}


export type WhatsNewModuleDemoPageInfo = WhatsNewModuleDemoPageInfoMojoType;
mojo.internal.Struct<WhatsNewModuleDemoPageInfoMojoType>(
    WhatsNewModuleDemoPageInfoSpec.$,
    'WhatsNewModuleDemoPageInfo',
    [
      mojo.internal.StructField<WhatsNewModuleDemoPageInfoMojoType, string>(
        'displayTitle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WhatsNewModuleDemoPageInfoMojoType, string>(
        'moduleName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WhatsNewModuleDemoPageInfoMojoType, boolean>(
        'hasBrowserCommand', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WhatsNewModuleDemoPageInfoMojoType, boolean>(
        'isFeatureEnabled', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WhatsNewModuleDemoPageInfoMojoType, number>(
        'queuePosition', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface WhatsNewEditionDemoPageInfoMojoType {
  displayTitle: string;
  editionName: string;
  isFeatureEnabled: boolean;
  hasBeenUsed: boolean;
  versionUsed: number;
}


export type WhatsNewEditionDemoPageInfo = WhatsNewEditionDemoPageInfoMojoType;
mojo.internal.Struct<WhatsNewEditionDemoPageInfoMojoType>(
    WhatsNewEditionDemoPageInfoSpec.$,
    'WhatsNewEditionDemoPageInfo',
    [
      mojo.internal.StructField<WhatsNewEditionDemoPageInfoMojoType, string>(
        'displayTitle', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WhatsNewEditionDemoPageInfoMojoType, string>(
        'editionName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WhatsNewEditionDemoPageInfoMojoType, boolean>(
        'isFeatureEnabled', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WhatsNewEditionDemoPageInfoMojoType, boolean>(
        'hasBeenUsed', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WhatsNewEditionDemoPageInfoMojoType, number>(
        'versionUsed', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface UserEducationInternalsPageHandler_GetTutorials_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_GetTutorials_Params = UserEducationInternalsPageHandler_GetTutorials_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetTutorials_ParamsMojoType>(
    UserEducationInternalsPageHandler_GetTutorials_ParamsSpec.$,
    'UserEducationInternalsPageHandler_GetTutorials_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_GetTutorials_ResponseParamsMojoType {
  tutorialInfos: FeaturePromoDemoPageInfo[];
}


export type UserEducationInternalsPageHandler_GetTutorials_ResponseParams = UserEducationInternalsPageHandler_GetTutorials_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetTutorials_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_GetTutorials_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_GetTutorials_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_GetTutorials_ResponseParamsMojoType, FeaturePromoDemoPageInfo[]>(
        'tutorialInfos', 0,
        0,
        mojo.internal.Array(FeaturePromoDemoPageInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_StartTutorial_ParamsMojoType {
  tutorialId: string;
}


export type UserEducationInternalsPageHandler_StartTutorial_Params = UserEducationInternalsPageHandler_StartTutorial_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_StartTutorial_ParamsMojoType>(
    UserEducationInternalsPageHandler_StartTutorial_ParamsSpec.$,
    'UserEducationInternalsPageHandler_StartTutorial_Params',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_StartTutorial_ParamsMojoType, string>(
        'tutorialId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_StartTutorial_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_StartTutorial_ResponseParams = UserEducationInternalsPageHandler_StartTutorial_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_StartTutorial_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_StartTutorial_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_StartTutorial_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_StartTutorial_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_GetSessionData_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_GetSessionData_Params = UserEducationInternalsPageHandler_GetSessionData_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetSessionData_ParamsMojoType>(
    UserEducationInternalsPageHandler_GetSessionData_ParamsSpec.$,
    'UserEducationInternalsPageHandler_GetSessionData_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_GetSessionData_ResponseParamsMojoType {
  sessionData: FeaturePromoDemoPageData[];
}


export type UserEducationInternalsPageHandler_GetSessionData_ResponseParams = UserEducationInternalsPageHandler_GetSessionData_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetSessionData_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_GetSessionData_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_GetSessionData_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_GetSessionData_ResponseParamsMojoType, FeaturePromoDemoPageData[]>(
        'sessionData', 0,
        0,
        mojo.internal.Array(FeaturePromoDemoPageDataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_GetFeaturePromos_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_GetFeaturePromos_Params = UserEducationInternalsPageHandler_GetFeaturePromos_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetFeaturePromos_ParamsMojoType>(
    UserEducationInternalsPageHandler_GetFeaturePromos_ParamsSpec.$,
    'UserEducationInternalsPageHandler_GetFeaturePromos_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsMojoType {
  featurePromos: FeaturePromoDemoPageInfo[];
}


export type UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParams = UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_GetFeaturePromos_ResponseParamsMojoType, FeaturePromoDemoPageInfo[]>(
        'featurePromos', 0,
        0,
        mojo.internal.Array(FeaturePromoDemoPageInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsMojoType {
  featureName: string;
}


export type UserEducationInternalsPageHandler_ShowFeaturePromo_Params = UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsMojoType>(
    UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsSpec.$,
    'UserEducationInternalsPageHandler_ShowFeaturePromo_Params',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ShowFeaturePromo_ParamsMojoType, string>(
        'featureName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParams = UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ShowFeaturePromo_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsMojoType {
  featureName: string;
}


export type UserEducationInternalsPageHandler_ClearFeaturePromoData_Params = UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsMojoType>(
    UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearFeaturePromoData_Params',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearFeaturePromoData_ParamsMojoType, string>(
        'featureName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParams = UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearFeaturePromoData_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearSessionData_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_ClearSessionData_Params = UserEducationInternalsPageHandler_ClearSessionData_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearSessionData_ParamsMojoType>(
    UserEducationInternalsPageHandler_ClearSessionData_ParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearSessionData_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_ClearSessionData_ResponseParams = UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearSessionData_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearSessionData_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ForceNewSession_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_ForceNewSession_Params = UserEducationInternalsPageHandler_ForceNewSession_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ForceNewSession_ParamsMojoType>(
    UserEducationInternalsPageHandler_ForceNewSession_ParamsSpec.$,
    'UserEducationInternalsPageHandler_ForceNewSession_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_ForceNewSession_ResponseParams = UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_ForceNewSession_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ForceNewSession_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_RemoveGracePeriods_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_RemoveGracePeriods_Params = UserEducationInternalsPageHandler_RemoveGracePeriods_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_RemoveGracePeriods_ParamsMojoType>(
    UserEducationInternalsPageHandler_RemoveGracePeriods_ParamsSpec.$,
    'UserEducationInternalsPageHandler_RemoveGracePeriods_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParams = UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_RemoveGracePeriods_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_GetNewBadges_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_GetNewBadges_Params = UserEducationInternalsPageHandler_GetNewBadges_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetNewBadges_ParamsMojoType>(
    UserEducationInternalsPageHandler_GetNewBadges_ParamsSpec.$,
    'UserEducationInternalsPageHandler_GetNewBadges_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsMojoType {
  newBadges: FeaturePromoDemoPageInfo[];
}


export type UserEducationInternalsPageHandler_GetNewBadges_ResponseParams = UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_GetNewBadges_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_GetNewBadges_ResponseParamsMojoType, FeaturePromoDemoPageInfo[]>(
        'newBadges', 0,
        0,
        mojo.internal.Array(FeaturePromoDemoPageInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_GetWhatsNewModules_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_GetWhatsNewModules_Params = UserEducationInternalsPageHandler_GetWhatsNewModules_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetWhatsNewModules_ParamsMojoType>(
    UserEducationInternalsPageHandler_GetWhatsNewModules_ParamsSpec.$,
    'UserEducationInternalsPageHandler_GetWhatsNewModules_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsMojoType {
  whatsNewModules: WhatsNewModuleDemoPageInfo[];
}


export type UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParams = UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_GetWhatsNewModules_ResponseParamsMojoType, WhatsNewModuleDemoPageInfo[]>(
        'whatsNewModules', 0,
        0,
        mojo.internal.Array(WhatsNewModuleDemoPageInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_GetWhatsNewEditions_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_GetWhatsNewEditions_Params = UserEducationInternalsPageHandler_GetWhatsNewEditions_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetWhatsNewEditions_ParamsMojoType>(
    UserEducationInternalsPageHandler_GetWhatsNewEditions_ParamsSpec.$,
    'UserEducationInternalsPageHandler_GetWhatsNewEditions_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsMojoType {
  whatsNewEditions: WhatsNewEditionDemoPageInfo[];
}


export type UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParams = UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_GetWhatsNewEditions_ResponseParamsMojoType, WhatsNewEditionDemoPageInfo[]>(
        'whatsNewEditions', 0,
        0,
        mojo.internal.Array(WhatsNewEditionDemoPageInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_GetNtpPromos_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_GetNtpPromos_Params = UserEducationInternalsPageHandler_GetNtpPromos_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetNtpPromos_ParamsMojoType>(
    UserEducationInternalsPageHandler_GetNtpPromos_ParamsSpec.$,
    'UserEducationInternalsPageHandler_GetNtpPromos_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsMojoType {
  ntpPromos: FeaturePromoDemoPageInfo[];
}


export type UserEducationInternalsPageHandler_GetNtpPromos_ResponseParams = UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_GetNtpPromos_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_GetNtpPromos_ResponseParamsMojoType, FeaturePromoDemoPageInfo[]>(
        'ntpPromos', 0,
        0,
        mojo.internal.Array(FeaturePromoDemoPageInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_GetNtpPromoPreferences_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_GetNtpPromoPreferences_Params = UserEducationInternalsPageHandler_GetNtpPromoPreferences_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetNtpPromoPreferences_ParamsMojoType>(
    UserEducationInternalsPageHandler_GetNtpPromoPreferences_ParamsSpec.$,
    'UserEducationInternalsPageHandler_GetNtpPromoPreferences_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsMojoType {
  ntpPromoPreferences: FeaturePromoDemoPageData[];
}


export type UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParams = UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_GetNtpPromoPreferences_ResponseParamsMojoType, FeaturePromoDemoPageData[]>(
        'ntpPromoPreferences', 0,
        0,
        mojo.internal.Array(FeaturePromoDemoPageDataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsMojoType {
  featureName: string;
}


export type UserEducationInternalsPageHandler_ClearNewBadgeData_Params = UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsMojoType>(
    UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearNewBadgeData_Params',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearNewBadgeData_ParamsMojoType, string>(
        'featureName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParams = UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearNewBadgeData_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearWhatsNewData_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_ClearWhatsNewData_Params = UserEducationInternalsPageHandler_ClearWhatsNewData_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearWhatsNewData_ParamsMojoType>(
    UserEducationInternalsPageHandler_ClearWhatsNewData_ParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearWhatsNewData_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParams = UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearWhatsNewData_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsMojoType {
  id: string;
}


export type UserEducationInternalsPageHandler_ClearNtpPromoData_Params = UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsMojoType>(
    UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearNtpPromoData_Params',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearNtpPromoData_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParams = UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearNtpPromoData_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_ClearNtpPromoPreferences_Params = UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ParamsMojoType>(
    UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearNtpPromoPreferences_Params',
    [
    ],
    [[0, 8],]);





export interface UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsMojoType {
  errorMessage: string;
}


export type UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParams = UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsMojoType>(
    UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsSpec.$,
    'UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParams',
    [
      mojo.internal.StructField<UserEducationInternalsPageHandler_ClearNtpPromoPreferences_ResponseParamsMojoType, string>(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UserEducationInternalsPageHandler_LaunchWhatsNewStaging_ParamsMojoType {
}


export type UserEducationInternalsPageHandler_LaunchWhatsNewStaging_Params = UserEducationInternalsPageHandler_LaunchWhatsNewStaging_ParamsMojoType;
mojo.internal.Struct<UserEducationInternalsPageHandler_LaunchWhatsNewStaging_ParamsMojoType>(
    UserEducationInternalsPageHandler_LaunchWhatsNewStaging_ParamsSpec.$,
    'UserEducationInternalsPageHandler_LaunchWhatsNewStaging_Params',
    [
    ],
    [[0, 8],]);



