// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"chrome://resources/cr_components/help_bubble/help_bubble.js";import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js";import"chrome://resources/cr_elements/cr_icon/cr_icon.js";import"chrome://resources/cr_elements/cr_menu_selector/cr_menu_selector.js";import"chrome://resources/cr_elements/cr_toast/cr_toast.js";import"chrome://resources/cr_elements/cr_toolbar/cr_toolbar.js";import"chrome://resources/cr_elements/cr_toolbar/cr_toolbar_search_field.js";import"//resources/cr_elements/icons.html.js";import"./user_education_internals_card.js";import"./user_education_whats_new_internals_card.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{HelpBubbleMixinLit}from"chrome://resources/cr_components/help_bubble/help_bubble_mixin_lit.js";import{CrContainerShadowMixinLit}from"chrome://resources/cr_elements/cr_container_shadow_mixin_lit.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./user_education_internals.css.js";import{getHtml}from"./user_education_internals.html.js";import{UserEducationInternalsPageHandler}from"./user_education_internals.mojom-webui.js";const UserEducationInternalsElementBase=CrContainerShadowMixinLit(HelpBubbleMixinLit(CrLitElement));export class UserEducationInternalsElement extends UserEducationInternalsElementBase{static get is(){return"user-education-internals"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{filter:{type:String},tutorials_:{type:Array},featurePromos_:{type:Array},featurePromoErrorMessage_:{type:String},narrow_:{type:Boolean},sessionExpanded_:{type:Boolean,value:false},ntpPromoPreferencesExpanded_:{type:Boolean,value:false}}}#filter_accessor_storage="";get filter(){return this.#filter_accessor_storage}set filter(value){this.#filter_accessor_storage=value}#tutorials__accessor_storage=[];get tutorials_(){return this.#tutorials__accessor_storage}set tutorials_(value){this.#tutorials__accessor_storage=value}#featurePromos__accessor_storage=[];get featurePromos_(){return this.#featurePromos__accessor_storage}set featurePromos_(value){this.#featurePromos__accessor_storage=value}newBadges_=[];whatsNewModules_=[];whatsNewEditions_=[];ntpPromos_=[];ntpPromoPreferences_=[];#ntpPromoPreferencesExpanded__accessor_storage=false;get ntpPromoPreferencesExpanded_(){return this.#ntpPromoPreferencesExpanded__accessor_storage}set ntpPromoPreferencesExpanded_(value){this.#ntpPromoPreferencesExpanded__accessor_storage=value}#featurePromoErrorMessage__accessor_storage="";get featurePromoErrorMessage_(){return this.#featurePromoErrorMessage__accessor_storage}set featurePromoErrorMessage_(value){this.#featurePromoErrorMessage__accessor_storage=value}#narrow__accessor_storage=false;get narrow_(){return this.#narrow__accessor_storage}set narrow_(value){this.#narrow__accessor_storage=value}#sessionExpanded__accessor_storage=false;get sessionExpanded_(){return this.#sessionExpanded__accessor_storage}set sessionExpanded_(value){this.#sessionExpanded__accessor_storage=value}sessionData_=[];handler_;constructor(){super();this.handler_=UserEducationInternalsPageHandler.getRemote()}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("featurePromos_")){if(this.shadowRoot.querySelector("#IPH_WebUiHelpBubbleTest")){this.registerHelpBubble("kWebUIIPHDemoElementIdentifier",["#IPH_WebUiHelpBubbleTest","#launch"])}}}firstUpdated(){ColorChangeUpdater.forDocument().start();this.handler_.getTutorials().then((({tutorialInfos:tutorialInfos})=>{this.tutorials_=tutorialInfos}));this.handler_.getSessionData().then((({sessionData:sessionData})=>{this.sessionData_=sessionData}));this.handler_.getFeaturePromos().then((({featurePromos:featurePromos})=>{this.featurePromos_=featurePromos}));this.handler_.getNewBadges().then((({newBadges:newBadges})=>{this.newBadges_=newBadges}));this.handler_.getWhatsNewModules().then((({whatsNewModules:whatsNewModules})=>{this.whatsNewModules_=whatsNewModules}));this.handler_.getWhatsNewEditions().then((({whatsNewEditions:whatsNewEditions})=>{this.whatsNewEditions_=whatsNewEditions}));this.handler_.getNtpPromos().then((({ntpPromos:ntpPromos})=>{this.ntpPromos_=ntpPromos}));this.handler_.getNtpPromoPreferences().then((({ntpPromoPreferences:ntpPromoPreferences})=>{this.ntpPromoPreferences_=ntpPromoPreferences}))}onSearchChanged_(e){this.filter=e.detail.toLowerCase()}startTutorial_(e){const id=e.detail;this.featurePromoErrorMessage_="";this.handler_.startTutorial(id).then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}}))}showFeaturePromo_(e){const id=e.detail;this.featurePromoErrorMessage_="";this.featurePromoErrorMessage_="Waiting to show promo...";this.$.errorMessageToast.show();this.handler_.showFeaturePromo(id).then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}}))}clearPromoData_(e){const id=e.detail;this.featurePromoErrorMessage_="";this.handler_.clearFeaturePromoData(id).then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}else{this.handler_.getFeaturePromos().then((({featurePromos:featurePromos})=>{this.featurePromos_=featurePromos;this.requestUpdate()}))}}))}clearSessionData_(){if(!confirm('This will reset the browser to a "fresh profile" state,'+" which may trigger multiple grace periods. Proceed?")){return}this.handler_.clearSessionData().then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}else{this.handler_.getSessionData().then((({sessionData:sessionData})=>{this.sessionData_=sessionData;this.requestUpdate()}))}}))}forceNewSession_(){this.handler_.forceNewSession().then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}else{this.handler_.getSessionData().then((({sessionData:sessionData})=>{this.sessionData_=sessionData;this.requestUpdate()}))}}))}removeGracePeriods_(){this.handler_.removeGracePeriods().then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}else{this.handler_.getSessionData().then((({sessionData:sessionData})=>{this.sessionData_=sessionData;this.requestUpdate()}))}}))}clearNewBadgeData_(e){const id=e.detail;this.featurePromoErrorMessage_="";this.handler_.clearNewBadgeData(id).then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}else{this.handler_.getNewBadges().then((({newBadges:newBadges})=>{this.newBadges_=newBadges;this.requestUpdate()}))}}))}clearWhatsNewData_(){this.featurePromoErrorMessage_="";this.handler_.clearWhatsNewData().then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}else{this.handler_.getWhatsNewModules().then((({whatsNewModules:whatsNewModules})=>{this.whatsNewModules_=whatsNewModules;this.requestUpdate()}));this.handler_.getWhatsNewEditions().then((({whatsNewEditions:whatsNewEditions})=>{this.whatsNewEditions_=whatsNewEditions;this.requestUpdate()}))}}))}clearNtpPromoData_(e){const id=e.detail;this.featurePromoErrorMessage_="";this.handler_.clearNtpPromoData(id).then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}else{this.handler_.getNtpPromos().then((({ntpPromos:ntpPromos})=>{this.ntpPromos_=ntpPromos;this.requestUpdate()}))}}))}clearNtpPromoPreferences_(){this.handler_.clearNtpPromoPreferences().then((({errorMessage:errorMessage})=>{this.featurePromoErrorMessage_=errorMessage;if(errorMessage!==""){this.$.errorMessageToast.show()}else{this.handler_.getNtpPromoPreferences().then((({ntpPromoPreferences:ntpPromoPreferences})=>{this.ntpPromoPreferences_=ntpPromoPreferences;this.requestUpdate()}))}}))}promoFilter_(promo){return this.filter===""||promo.displayTitle.toLowerCase().includes(this.filter)||promo.displayDescription.toLowerCase().includes(this.filter)||promo.instructions.find((instruction=>instruction.toLowerCase().includes(this.filter)))||promo.supportedPlatforms.find((platform=>platform.toLowerCase().includes(this.filter)))}whatsNewFilter_(item){return this.filter===""||item.displayTitle.toLowerCase().includes(this.filter)}onLinkClick_(event){event.preventDefault()}onSelectorActivate_(event){const url=event.detail.selected;this.$.menu.selected=url;const idx=url.lastIndexOf("#");const el=this.$.content.querySelector(url.substring(idx));el?.scrollIntoView(true)}onNarrowChanged_(e){this.narrow_=e.detail.value}onSessionExpandedChanged_(e){this.sessionExpanded_=e.detail.value}onNtpPromoPreferencesExpandedChanged_(e){this.ntpPromoPreferencesExpanded_=e.detail.value}launchWhatsNewStaging_(){this.handler_.launchWhatsNewStaging()}}customElements.define(UserEducationInternalsElement.is,UserEducationInternalsElement);