import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UsbDevicePendingReceiver as device_mojom_UsbDevicePendingReceiver, UsbDeviceClientRemote as device_mojom_UsbDeviceClientRemote, UsbDeviceInfo as device_mojom_UsbDeviceInfo } from './usb_device.mojom-webui.js';
import { UsbEnumerationOptions as device_mojom_UsbEnumerationOptions } from './usb_enumeration_options.mojom-webui.js';
export type UsbDeviceManagerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<UsbDeviceManagerPendingReceiver>;
export declare class UsbDeviceManagerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<UsbDeviceManager> {
    handle: mojo.internal.interfaceSupport.Endpoint<UsbDeviceManagerPendingReceiver>;
    constructor(handle: MojoHandle | UsbDeviceManagerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface UsbDeviceManagerInterface {
    enumerateDevicesAndSetClient(client: object): Promise<{
        results: device_mojom_UsbDeviceInfo[];
    }>;
    getDevices(options: (device_mojom_UsbEnumerationOptions | null)): Promise<{
        results: device_mojom_UsbDeviceInfo[];
    }>;
    getDevice(guid: string, blockedInterfaceClasses: number[], deviceReceiver: device_mojom_UsbDevicePendingReceiver, deviceClient: (device_mojom_UsbDeviceClientRemote | null)): void;
    getSecurityKeyDevice(guid: string, deviceReceiver: device_mojom_UsbDevicePendingReceiver, deviceClient: (device_mojom_UsbDeviceClientRemote | null)): void;
    setClient(client: object): void;
}
export declare class UsbDeviceManagerRemote implements UsbDeviceManagerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<UsbDeviceManagerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | UsbDeviceManagerPendingReceiverEndpoint);
    enumerateDevicesAndSetClient(client: object): Promise<{
        results: device_mojom_UsbDeviceInfo[];
    }>;
    getDevices(options: (device_mojom_UsbEnumerationOptions | null)): Promise<{
        results: device_mojom_UsbDeviceInfo[];
    }>;
    getDevice(guid: string, blockedInterfaceClasses: number[], deviceReceiver: device_mojom_UsbDevicePendingReceiver, deviceClient: (device_mojom_UsbDeviceClientRemote | null)): void;
    getSecurityKeyDevice(guid: string, deviceReceiver: device_mojom_UsbDevicePendingReceiver, deviceClient: (device_mojom_UsbDeviceClientRemote | null)): void;
    setClient(client: object): void;
}
/**
 * An object which receives request messages for the UsbDeviceManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class UsbDeviceManagerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<UsbDeviceManagerRemote, UsbDeviceManagerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: UsbDeviceManagerInterface);
}
export declare class UsbDeviceManager {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): UsbDeviceManagerRemote;
}
/**
 * An object which receives request messages for the UsbDeviceManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class UsbDeviceManagerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<UsbDeviceManagerRemote, UsbDeviceManagerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    enumerateDevicesAndSetClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getDevices: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getDevice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getSecurityKeyDevice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const UsbDeviceManager_GetDevices_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const UsbDeviceManager_GetDevices_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const UsbDeviceManager_GetDevice_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const UsbDeviceManager_GetSecurityKeyDevice_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const UsbDeviceManager_SetClient_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsMojoType {
    client: object;
}
export type UsbDeviceManager_EnumerateDevicesAndSetClient_Params = UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsMojoType;
export interface UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsMojoType {
    results: device_mojom_UsbDeviceInfo[];
}
export type UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams = UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsMojoType;
export interface UsbDeviceManager_GetDevices_ParamsMojoType {
    options: (device_mojom_UsbEnumerationOptions | null);
}
export type UsbDeviceManager_GetDevices_Params = UsbDeviceManager_GetDevices_ParamsMojoType;
export interface UsbDeviceManager_GetDevices_ResponseParamsMojoType {
    results: device_mojom_UsbDeviceInfo[];
}
export type UsbDeviceManager_GetDevices_ResponseParams = UsbDeviceManager_GetDevices_ResponseParamsMojoType;
export interface UsbDeviceManager_GetDevice_ParamsMojoType {
    guid: string;
    blockedInterfaceClasses: number[];
    deviceReceiver: device_mojom_UsbDevicePendingReceiver;
    deviceClient: (device_mojom_UsbDeviceClientRemote | null);
}
export type UsbDeviceManager_GetDevice_Params = UsbDeviceManager_GetDevice_ParamsMojoType;
export interface UsbDeviceManager_GetSecurityKeyDevice_ParamsMojoType {
    guid: string;
    deviceReceiver: device_mojom_UsbDevicePendingReceiver;
    deviceClient: (device_mojom_UsbDeviceClientRemote | null);
}
export type UsbDeviceManager_GetSecurityKeyDevice_Params = UsbDeviceManager_GetSecurityKeyDevice_ParamsMojoType;
export interface UsbDeviceManager_SetClient_ParamsMojoType {
    client: object;
}
export type UsbDeviceManager_SetClient_Params = UsbDeviceManager_SetClient_ParamsMojoType;
