// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{ColorSpec as tabGroups_mojom_ColorSpec}from"./tab_group_types.mojom-webui.js";import{TabAlertStateSpec as tabs_mojom_TabAlertStateSpec}from"./tabs.mojom-webui.js";import{TimeSpec as mojoBase_mojom_TimeSpec}from"//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js";import{TokenSpec as mojoBase_mojom_TokenSpec}from"//resources/mojo/mojo/public/mojom/base/token.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export class PageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tab_strip_internals.mojom.PageHandlerFactory",scope)}}export class PageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createPageHandler(page,handler){this.proxy.sendMessage(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,[page,handler],false)}}export class PageHandlerFactoryReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,impl.createPageHandler.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandlerFactory{static get $interfaceName(){return"tab_strip_internals.mojom.PageHandlerFactory"}static getRemote(){let remote=new PageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerFactoryCallbackRouter{helper_internal_;$;router_;createPageHandler;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.createPageHandler=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,this.createPageHandler.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tab_strip_internals.mojom.PageHandler",scope)}}export class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getTabStripData(){return this.proxy.sendMessage(0,PageHandler_GetTabStripData_ParamsSpec.$,PageHandler_GetTabStripData_ResponseParamsSpec.$,[],false)}}export class PageHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandler_GetTabStripData_ParamsSpec.$,PageHandler_GetTabStripData_ResponseParamsSpec.$,impl.getTabStripData.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandler{static get $interfaceName(){return"tab_strip_internals.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerCallbackRouter{helper_internal_;$;router_;getTabStripData;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getTabStripData=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandler_GetTabStripData_ParamsSpec.$,PageHandler_GetTabStripData_ResponseParamsSpec.$,this.getTabStripData.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tab_strip_internals.mojom.Page",scope)}}export class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onTabStripUpdated(data){this.proxy.sendMessage(0,Page_OnTabStripUpdated_ParamsSpec.$,null,[data],false)}}export class PageReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Page_OnTabStripUpdated_ParamsSpec.$,null,impl.onTabStripUpdated.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Page{static get $interfaceName(){return"tab_strip_internals.mojom.Page"}static getRemote(){let remote=new PageRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageCallbackRouter{helper_internal_;$;router_;onTabStripUpdated;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onTabStripUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnTabStripUpdated_ParamsSpec.$,null,this.onTabStripUpdated.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const ContainerSpec={$:{}};export const TabStripTreeSpec={$:{}};export const WindowNodeSpec={$:{}};export const NodeIdSpec={$:{}};export const TabStripModelSpec={$:{}};export const NodeSpec={$:{}};export const TabSpec={$:{}};export const TabStripCollectionSpec={$:{}};export const PinnedCollectionSpec={$:{}};export const UnpinnedCollectionSpec={$:{}};export const GroupCollectionSpec={$:{}};export const TabGroupVisualDataSpec={$:{}};export const SplitCollectionSpec={$:{}};export const SplitTabVisualDataSpec={$:{}};export const SelectionModelSpec={$:{}};export const TabRestoreDataSpec={$:{}};export const TabRestoreEntryBaseSpec={$:{}};export const TabRestoreTabSpec={$:{}};export const TabRestoreGroupSpec={$:{}};export const TabRestoreWindowSpec={$:{}};export const PageHandlerFactory_CreatePageHandler_ParamsSpec={$:{}};export const PageHandler_GetTabStripData_ParamsSpec={$:{}};export const PageHandler_GetTabStripData_ResponseParamsSpec={$:{}};export const Page_OnTabStripUpdated_ParamsSpec={$:{}};export const DataSpec={$:{}};export const TabRestoreEntrySpec={$:{}};mojo.internal.Struct(ContainerSpec.$,"Container",[mojo.internal.StructField("tabstripTree",0,0,TabStripTreeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("tabRestore",8,0,TabRestoreDataSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripTreeSpec.$,"TabStripTree",[mojo.internal.StructField("windows",0,0,mojo.internal.Array(WindowNodeSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(WindowNodeSpec.$,"WindowNode",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("tabstripModel",8,0,TabStripModelSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("selectionModel",16,0,SelectionModelSpec.$,null,false,0,undefined,undefined)],[[0,32]]);export const NodeId_TypeSpec={$:mojo.internal.Enum()};export var NodeId_Type;(function(NodeId_Type){NodeId_Type[NodeId_Type["MIN_VALUE"]=0]="MIN_VALUE";NodeId_Type[NodeId_Type["MAX_VALUE"]=5]="MAX_VALUE";NodeId_Type[NodeId_Type["kTab"]=0]="kTab";NodeId_Type[NodeId_Type["kCollection"]=1]="kCollection";NodeId_Type[NodeId_Type["kWindow"]=2]="kWindow";NodeId_Type[NodeId_Type["kTabRestoreTab"]=3]="kTabRestoreTab";NodeId_Type[NodeId_Type["kTabRestoreGroup"]=4]="kTabRestoreGroup";NodeId_Type[NodeId_Type["kTabRestoreWindow"]=5]="kTabRestoreWindow"})(NodeId_Type||(NodeId_Type={}));mojo.internal.Struct(NodeIdSpec.$,"NodeId",[mojo.internal.StructField("nodeId",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("type",8,0,NodeId_TypeSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabStripModelSpec.$,"TabStripModel",[mojo.internal.StructField("root",0,0,NodeSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NodeSpec.$,"Node",[mojo.internal.StructField("data",0,0,DataSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("children",16,0,mojo.internal.Array(NodeSpec.$,false),null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(TabSpec.$,"Tab",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",16,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("active",24,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("visible",24,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("selected",24,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("pinned",24,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("split",24,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("alertStates",32,0,mojo.internal.Array(tabs_mojom_TabAlertStateSpec.$,false),null,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(TabStripCollectionSpec.$,"TabStripCollection",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PinnedCollectionSpec.$,"PinnedCollection",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UnpinnedCollectionSpec.$,"UnpinnedCollection",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(GroupCollectionSpec.$,"GroupCollection",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("visualData",8,0,TabGroupVisualDataSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabGroupVisualDataSpec.$,"TabGroupVisualData",[mojo.internal.StructField("title",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("color",8,0,tabGroups_mojom_ColorSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("isCollapsed",12,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SplitCollectionSpec.$,"SplitCollection",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("visualData",8,0,SplitTabVisualDataSpec.$,null,false,0,undefined,undefined)],[[0,24]]);export const SplitTabVisualData_LayoutSpec={$:mojo.internal.Enum()};export var SplitTabVisualData_Layout;(function(SplitTabVisualData_Layout){SplitTabVisualData_Layout[SplitTabVisualData_Layout["MIN_VALUE"]=0]="MIN_VALUE";SplitTabVisualData_Layout[SplitTabVisualData_Layout["MAX_VALUE"]=1]="MAX_VALUE";SplitTabVisualData_Layout[SplitTabVisualData_Layout["kVertical"]=0]="kVertical";SplitTabVisualData_Layout[SplitTabVisualData_Layout["kHorizontal"]=1]="kHorizontal"})(SplitTabVisualData_Layout||(SplitTabVisualData_Layout={}));mojo.internal.Struct(SplitTabVisualDataSpec.$,"SplitTabVisualData",[mojo.internal.StructField("layout",0,0,SplitTabVisualData_LayoutSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("splitRatio",8,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SelectionModelSpec.$,"SelectionModel",[mojo.internal.StructField("activeIndex",0,0,mojo.internal.Int32,-1,false,0,undefined,undefined),mojo.internal.StructField("anchorIndex",4,0,mojo.internal.Int32,-1,false,0,undefined,undefined),mojo.internal.StructField("selectedIndices",8,0,mojo.internal.Array(mojo.internal.Int32,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabRestoreDataSpec.$,"TabRestoreData",[mojo.internal.StructField("entries",0,0,mojo.internal.Array(TabRestoreEntrySpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TabRestoreEntryBaseSpec.$,"TabRestoreEntryBase",[mojo.internal.StructField("originalId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("timestamp",8,0,mojoBase_mojom_TimeSpec.$,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabRestoreTabSpec.$,"TabRestoreTab",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("restoreEntry",8,0,TabRestoreEntryBaseSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("browserId",16,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("tabstripIndex",20,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("pinned",24,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("groupId",32,0,mojoBase_mojom_TokenSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("groupVisualData",40,0,TabGroupVisualDataSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("title",48,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",56,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined)],[[0,72]]);mojo.internal.Struct(TabRestoreGroupSpec.$,"TabRestoreGroup",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("restoreEntry",8,0,TabRestoreEntryBaseSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("browserId",16,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("groupId",24,0,mojoBase_mojom_TokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("visualData",32,0,TabGroupVisualDataSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("tabs",40,0,mojo.internal.Array(TabRestoreTabSpec.$,false),null,false,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(TabRestoreWindowSpec.$,"TabRestoreWindow",[mojo.internal.StructField("id",0,0,NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("restoreEntry",8,0,TabRestoreEntryBaseSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("selectedTabIndex",16,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("tabs",24,0,mojo.internal.Array(TabRestoreTabSpec.$,false),null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$,"PageHandlerFactory_CreatePageHandler_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_GetTabStripData_ParamsSpec.$,"PageHandler_GetTabStripData_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetTabStripData_ResponseParamsSpec.$,"PageHandler_GetTabStripData_ResponseParams",[mojo.internal.StructField("data",0,0,ContainerSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnTabStripUpdated_ParamsSpec.$,"Page_OnTabStripUpdated_Params",[mojo.internal.StructField("data",0,0,ContainerSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(DataSpec.$,"Data",{tab:{ordinal:0,type:TabSpec.$},tabStripCollection:{ordinal:1,type:TabStripCollectionSpec.$},pinnedTabCollection:{ordinal:2,type:PinnedCollectionSpec.$},unpinnedTabCollection:{ordinal:3,type:UnpinnedCollectionSpec.$},tabGroupCollection:{ordinal:4,type:GroupCollectionSpec.$},splitTabCollection:{ordinal:5,type:SplitCollectionSpec.$}});export var DataFieldTags;(function(DataFieldTags){DataFieldTags[DataFieldTags["TAB"]=0]="TAB";DataFieldTags[DataFieldTags["TAB_STRIP_COLLECTION"]=1]="TAB_STRIP_COLLECTION";DataFieldTags[DataFieldTags["PINNED_TAB_COLLECTION"]=2]="PINNED_TAB_COLLECTION";DataFieldTags[DataFieldTags["UNPINNED_TAB_COLLECTION"]=3]="UNPINNED_TAB_COLLECTION";DataFieldTags[DataFieldTags["TAB_GROUP_COLLECTION"]=4]="TAB_GROUP_COLLECTION";DataFieldTags[DataFieldTags["SPLIT_TAB_COLLECTION"]=5]="SPLIT_TAB_COLLECTION"})(DataFieldTags||(DataFieldTags={}));export function whichData(u){if(u.tab!==null&&u.tab!==undefined){return DataFieldTags.TAB}if(u.tabStripCollection!==null&&u.tabStripCollection!==undefined){return DataFieldTags.TAB_STRIP_COLLECTION}if(u.pinnedTabCollection!==null&&u.pinnedTabCollection!==undefined){return DataFieldTags.PINNED_TAB_COLLECTION}if(u.unpinnedTabCollection!==null&&u.unpinnedTabCollection!==undefined){return DataFieldTags.UNPINNED_TAB_COLLECTION}if(u.tabGroupCollection!==null&&u.tabGroupCollection!==undefined){return DataFieldTags.TAB_GROUP_COLLECTION}if(u.splitTabCollection!==null&&u.splitTabCollection!==undefined){return DataFieldTags.SPLIT_TAB_COLLECTION}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(TabRestoreEntrySpec.$,"TabRestoreEntry",{tab:{ordinal:0,type:TabRestoreTabSpec.$},window:{ordinal:1,type:TabRestoreWindowSpec.$},group:{ordinal:2,type:TabRestoreGroupSpec.$}});export var TabRestoreEntryFieldTags;(function(TabRestoreEntryFieldTags){TabRestoreEntryFieldTags[TabRestoreEntryFieldTags["TAB"]=0]="TAB";TabRestoreEntryFieldTags[TabRestoreEntryFieldTags["WINDOW"]=1]="WINDOW";TabRestoreEntryFieldTags[TabRestoreEntryFieldTags["GROUP"]=2]="GROUP"})(TabRestoreEntryFieldTags||(TabRestoreEntryFieldTags={}));export function whichTabRestoreEntry(u){if(u.tab!==null&&u.tab!==undefined){return TabRestoreEntryFieldTags.TAB}if(u.window!==null&&u.window!==undefined){return TabRestoreEntryFieldTags.WINDOW}if(u.group!==null&&u.group!==undefined){return TabRestoreEntryFieldTags.GROUP}throw new Error("no union field has been set, this is an illegal state")}