import type { TabsEvent, TabsObserverInterface, TabsObserverPendingReceiverEndpoint } from './tab_strip_api.mojom-webui.js';
type CallbackType<EventType> = (event: EventType) => void;
declare class Channel<EventType> {
    private listeners_;
    addListener(listener: CallbackType<EventType>): void;
    notify(event: EventType): void;
}
/**
 * @fileoverview
 * This file defines the TabStripObservation, a TypeScript client for the
 * TabsObserver mojom interface.
 *
 * ...
 *
 * @example
 * // Get the TabStripService remote and create a new router.
 * const service = TabStripService.getRemote();
 * const observation = new TabStripObservation();
 *
 * // Fetch the initial tab state and the observer stream handle.
 * const snapshot = await service.getTabs();
 * observationRouter.bind((snapshot.stream as any).handle);
 *
 * // Add listeners for the events you want to handle.
 * observationRouter.onTabsCreated.addListener((event) => {
 *   // Logic to add new tabs to the UI.
 *   for (const tabContainer of event.tabs) {
 *     myUi.addTab(tabContainer.tab);
 *   }
 * });
 *
 */
export declare class TabStripObservation implements TabsObserverInterface {
    readonly onDataChanged: Channel<import("./tab_strip_api_events.mojom-webui.js").OnDataChangedEventMojoType>;
    readonly onCollectionCreated: Channel<import("./tab_strip_api_events.mojom-webui.js").OnCollectionCreatedEventMojoType>;
    readonly onNodeMoved: Channel<import("./tab_strip_api_events.mojom-webui.js").OnNodeMovedEventMojoType>;
    readonly onTabsClosed: Channel<import("./tab_strip_api_events.mojom-webui.js").OnTabsClosedEventMojoType>;
    readonly onTabsCreated: Channel<import("./tab_strip_api_events.mojom-webui.js").OnTabsCreatedEventMojoType>;
    private readonly receiver_;
    constructor();
    bind(handle: TabsObserverPendingReceiverEndpoint): void;
    onTabEvents(events: TabsEvent[]): void;
    private notify_;
}
export {};
