import type { Url } from 'chrome://resources/mojo/url/mojom/url.mojom-webui.js';
import type { ProfileData, SwitchToTabInfo, Tab, TabOrganizationFeature, TabOrganizationModelStrategy, TabOrganizationSession, TabSearchSection, UnusedTabInfo, UserFeedback } from './tab_search.mojom-webui.js';
import { PageCallbackRouter, PageHandlerRemote } from './tab_search.mojom-webui.js';
/**
 * These values are persisted to logs and should not be renumbered or re-used.
 * See tools/metrics/histograms/enums.xml.
 */
export declare enum RecentlyClosedItemOpenAction {
    WITHOUT_SEARCH = 0,
    WITH_SEARCH = 1
}
export interface TabSearchApiProxy {
    closeTab(tabId: number): void;
    closeWebUiTab(): void;
    declutterTabs(tabIds: number[], urls: Url[]): void;
    acceptTabOrganization(sessionId: number, organizationId: number, tabs: Tab[]): void;
    rejectTabOrganization(sessionId: number, organizationId: number): void;
    renameTabOrganization(sessionId: number, organizationId: number, name: string): void;
    excludeFromStaleTabs(tabId: number): void;
    excludeFromDuplicateTabs(url: Url): void;
    getProfileData(): Promise<{
        profileData: ProfileData;
    }>;
    getUnusedTabs(): Promise<{
        tabs: UnusedTabInfo;
    }>;
    getTabSearchSection(): Promise<{
        section: TabSearchSection;
    }>;
    getTabOrganizationFeature(): Promise<{
        feature: TabOrganizationFeature;
    }>;
    getTabOrganizationSession(): Promise<{
        session: TabOrganizationSession;
    }>;
    getTabOrganizationModelStrategy(): Promise<{
        strategy: TabOrganizationModelStrategy;
    }>;
    getIsSplit(): Promise<{
        isSplit: boolean;
    }>;
    openRecentlyClosedEntry(id: number, withSearch: boolean, isTab: boolean, index: number): void;
    requestTabOrganization(): void;
    rejectSession(sessionId: number): void;
    restartSession(): void;
    switchToTab(info: SwitchToTabInfo): void;
    getCallbackRouter(): PageCallbackRouter;
    removeTabFromOrganization(sessionId: number, organizationId: number, tab: Tab): void;
    replaceActiveSplitTab(replacementTabId: number): void;
    saveRecentlyClosedExpandedPref(expanded: boolean): void;
    setOrganizationFeature(feature: TabOrganizationFeature): void;
    startTabGroupTutorial(): void;
    triggerFeedback(sessionId: number): void;
    triggerSignIn(): void;
    openHelpPage(): void;
    setTabOrganizationModelStrategy(strategy: TabOrganizationModelStrategy): void;
    setTabOrganizationUserInstruction(user_instruction: string): void;
    setUserFeedback(sessionId: number, feedback: UserFeedback): void;
    notifyOrganizationUiReadyToShow(): void;
    notifySearchUiReadyToShow(): void;
}
export declare class TabSearchApiProxyImpl implements TabSearchApiProxy {
    callbackRouter: PageCallbackRouter;
    handler: PageHandlerRemote;
    constructor();
    closeTab(tabId: number): void;
    closeWebUiTab(): void;
    declutterTabs(tabIds: number[], urls: Url[]): void;
    acceptTabOrganization(sessionId: number, organizationId: number, tabs: Tab[]): void;
    rejectTabOrganization(sessionId: number, organizationId: number): void;
    renameTabOrganization(sessionId: number, organizationId: number, name: string): void;
    excludeFromStaleTabs(tabId: number): void;
    excludeFromDuplicateTabs(url: Url): void;
    getProfileData(): Promise<{
        profileData: ProfileData;
    }>;
    getUnusedTabs(): Promise<{
        tabs: UnusedTabInfo;
    }>;
    getTabSearchSection(): Promise<{
        section: TabSearchSection;
    }>;
    getTabOrganizationFeature(): Promise<{
        feature: TabOrganizationFeature;
    }>;
    getTabOrganizationSession(): Promise<{
        session: TabOrganizationSession;
    }>;
    getTabOrganizationModelStrategy(): Promise<{
        strategy: TabOrganizationModelStrategy;
    }>;
    getIsSplit(): Promise<{
        isSplit: boolean;
    }>;
    openRecentlyClosedEntry(id: number, withSearch: boolean, isTab: boolean, index: number): void;
    requestTabOrganization(): void;
    rejectSession(sessionId: number): void;
    restartSession(): void;
    switchToTab(info: SwitchToTabInfo): void;
    getCallbackRouter(): PageCallbackRouter;
    removeTabFromOrganization(sessionId: number, organizationId: number, tab: Tab): void;
    replaceActiveSplitTab(replacementSplitTabId: number): void;
    saveRecentlyClosedExpandedPref(expanded: boolean): void;
    setOrganizationFeature(feature: TabOrganizationFeature): void;
    startTabGroupTutorial(): void;
    triggerFeedback(sessionId: number): void;
    triggerSignIn(): void;
    openHelpPage(): void;
    setTabOrganizationModelStrategy(strategy: TabOrganizationModelStrategy): void;
    setTabOrganizationUserInstruction(userInstruction: string): void;
    setUserFeedback(sessionId: number, feedback: UserFeedback): void;
    notifyOrganizationUiReadyToShow(): void;
    notifySearchUiReadyToShow(): void;
    static getInstance(): TabSearchApiProxy;
    static setInstance(obj: TabSearchApiProxy): void;
}
