import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { Color as tabGroups_mojom_Color } from './tab_group_types.mojom-webui.js';
import { TabAlertState as tabs_mojom_TabAlertState } from './tabs.mojom-webui.js';
import { String16 as mojoBase_mojom_String16 } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { Time as mojoBase_mojom_Time, TimeTicks as mojoBase_mojom_TimeTicks } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { Token as mojoBase_mojom_Token } from '//resources/mojo/mojo/public/mojom/base/token.mojom-webui.js';
import { Url as url_mojom_Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export declare const DeclutterCTREventSpec: {
    $: mojo.internal.MojomType;
};
export declare enum DeclutterCTREvent {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kDeclutterShown = 0,
    kCloseTabsClicked = 1
}
export declare const SelectorCTREventSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SelectorCTREvent {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kSelectorShown = 0,
    kAutoTabGroupsClicked = 1,
    kDeclutterClicked = 2
}
export declare const TabDeclutterEntryPointSpec: {
    $: mojo.internal.MojomType;
};
export declare enum TabDeclutterEntryPoint {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kNudge = 0,
    kAppMenu = 1,
    kSelector = 2
}
export declare const TabOrganizationStateSpec: {
    $: mojo.internal.MojomType;
};
export declare enum TabOrganizationState {
    MIN_VALUE = 0,
    MAX_VALUE = 4,
    kInitializing = 0,
    kNotStarted = 1,
    kInProgress = 2,
    kSuccess = 3,
    kFailure = 4
}
export declare const TabOrganizationFeatureSpec: {
    $: mojo.internal.MojomType;
};
export declare enum TabOrganizationFeature {
    MIN_VALUE = 0,
    MAX_VALUE = 3,
    kNone = 0,
    kSelector = 1,
    kAutoTabGroups = 2,
    kDeclutter = 3
}
export declare const TabOrganizationErrorSpec: {
    $: mojo.internal.MojomType;
};
export declare enum TabOrganizationError {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kNone = 0,
    kGrouping = 1,
    kGeneric = 2
}
export declare const TabOrganizationModelStrategySpec: {
    $: mojo.internal.MojomType;
};
export declare enum TabOrganizationModelStrategy {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kTopic = 0,
    kTask = 1,
    kDomain = 2
}
export declare const TabSearchSectionSpec: {
    $: mojo.internal.MojomType;
};
export declare enum TabSearchSection {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kNone = 0,
    kSearch = 1,
    kOrganize = 2
}
export declare const UserFeedbackSpec: {
    $: mojo.internal.MojomType;
};
export declare enum UserFeedback {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kUserFeedBackUnspecified = 0,
    kUserFeedBackPositive = 1,
    kUserFeedBackNegative = 2
}
export type PageHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
export declare class PageHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerFactoryInterface {
    createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}
export declare class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerFactoryPendingReceiverEndpoint);
    createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerFactoryInterface);
}
export declare class PageHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
export declare class PageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerInterface {
    closeTab(tabId: number): void;
    closeWebUiTab(): void;
    declutterTabs(tabIds: number[], urls: url_mojom_Url[]): void;
    acceptTabOrganization(sessionId: number, organizationId: number, tabs: Tab[]): void;
    rejectTabOrganization(sessionId: number, organizationId: number): void;
    renameTabOrganization(sessionId: number, organizationId: number, name: mojoBase_mojom_String16): void;
    excludeFromStaleTabs(tabId: number): void;
    excludeFromDuplicateTabs(url: url_mojom_Url): void;
    getProfileData(): Promise<{
        profileData: ProfileData;
    }>;
    getUnusedTabs(): Promise<{
        tabs: UnusedTabInfo;
    }>;
    getTabSearchSection(): Promise<{
        section: TabSearchSection;
    }>;
    getTabOrganizationFeature(): Promise<{
        feature: TabOrganizationFeature;
    }>;
    getTabOrganizationSession(): Promise<{
        session: TabOrganizationSession;
    }>;
    getTabOrganizationModelStrategy(): Promise<{
        strategy: TabOrganizationModelStrategy;
    }>;
    getIsSplit(): Promise<{
        isSplit: boolean;
    }>;
    switchToTab(switchToTabInfo: SwitchToTabInfo): void;
    openRecentlyClosedEntry(sessionId: number): void;
    requestTabOrganization(): void;
    removeTabFromOrganization(sessionId: number, organizationId: number, tab: Tab): void;
    rejectSession(sessionId: number): void;
    replaceActiveSplitTab(replacementTabId: number): void;
    restartSession(): void;
    saveRecentlyClosedExpandedPref(expanded: boolean): void;
    setOrganizationFeature(feature: TabOrganizationFeature): void;
    startTabGroupTutorial(): void;
    triggerFeedback(sessionId: number): void;
    triggerSignIn(): void;
    openHelpPage(): void;
    setTabOrganizationModelStrategy(strategy: TabOrganizationModelStrategy): void;
    setTabOrganizationUserInstruction(userInstruction: string): void;
    setUserFeedback(sessionId: number, feedback: UserFeedback): void;
    notifyOrganizationUIReadyToShow(): void;
    notifySearchUIReadyToShow(): void;
}
export declare class PageHandlerRemote implements PageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerPendingReceiverEndpoint);
    closeTab(tabId: number): void;
    closeWebUiTab(): void;
    declutterTabs(tabIds: number[], urls: url_mojom_Url[]): void;
    acceptTabOrganization(sessionId: number, organizationId: number, tabs: Tab[]): void;
    rejectTabOrganization(sessionId: number, organizationId: number): void;
    renameTabOrganization(sessionId: number, organizationId: number, name: mojoBase_mojom_String16): void;
    excludeFromStaleTabs(tabId: number): void;
    excludeFromDuplicateTabs(url: url_mojom_Url): void;
    getProfileData(): Promise<{
        profileData: ProfileData;
    }>;
    getUnusedTabs(): Promise<{
        tabs: UnusedTabInfo;
    }>;
    getTabSearchSection(): Promise<{
        section: TabSearchSection;
    }>;
    getTabOrganizationFeature(): Promise<{
        feature: TabOrganizationFeature;
    }>;
    getTabOrganizationSession(): Promise<{
        session: TabOrganizationSession;
    }>;
    getTabOrganizationModelStrategy(): Promise<{
        strategy: TabOrganizationModelStrategy;
    }>;
    getIsSplit(): Promise<{
        isSplit: boolean;
    }>;
    switchToTab(switchToTabInfo: SwitchToTabInfo): void;
    openRecentlyClosedEntry(sessionId: number): void;
    requestTabOrganization(): void;
    removeTabFromOrganization(sessionId: number, organizationId: number, tab: Tab): void;
    rejectSession(sessionId: number): void;
    replaceActiveSplitTab(replacementTabId: number): void;
    restartSession(): void;
    saveRecentlyClosedExpandedPref(expanded: boolean): void;
    setOrganizationFeature(feature: TabOrganizationFeature): void;
    startTabGroupTutorial(): void;
    triggerFeedback(sessionId: number): void;
    triggerSignIn(): void;
    openHelpPage(): void;
    setTabOrganizationModelStrategy(strategy: TabOrganizationModelStrategy): void;
    setTabOrganizationUserInstruction(userInstruction: string): void;
    setUserFeedback(sessionId: number, feedback: UserFeedback): void;
    notifyOrganizationUIReadyToShow(): void;
    notifySearchUIReadyToShow(): void;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerInterface);
}
export declare class PageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerRemote;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    closeTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    closeWebUiTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    declutterTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    acceptTabOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    rejectTabOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    renameTabOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    excludeFromStaleTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    excludeFromDuplicateTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getProfileData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getUnusedTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getTabSearchSection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getTabOrganizationFeature: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getTabOrganizationSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getTabOrganizationModelStrategy: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getIsSplit: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    switchToTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openRecentlyClosedEntry: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    requestTabOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    removeTabFromOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    rejectSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    replaceActiveSplitTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    restartSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    saveRecentlyClosedExpandedPref: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setOrganizationFeature: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    startTabGroupTutorial: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    triggerFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    triggerSignIn: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openHelpPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setTabOrganizationModelStrategy: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setTabOrganizationUserInstruction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setUserFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyOrganizationUIReadyToShow: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifySearchUIReadyToShow: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PagePendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
export declare class PagePendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<Page> {
    handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
    constructor(handle: MojoHandle | PagePendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageInterface {
    tabOrganizationSessionUpdated(session: TabOrganizationSession): void;
    tabOrganizationModelStrategyUpdated(strategy: TabOrganizationModelStrategy): void;
    hostWindowChanged(): void;
    tabsChanged(profileTabs: ProfileData): void;
    tabUpdated(tabUpdateInfo: TabUpdateInfo): void;
    tabsRemoved(tabsRemovedInfo: TabsRemovedInfo): void;
    tabSearchSectionChanged(section: TabSearchSection): void;
    tabOrganizationFeatureChanged(feature: TabOrganizationFeature): void;
    showFREChanged(show: boolean): void;
    tabOrganizationEnabledChanged(enabled: boolean): void;
    unusedTabsChanged(tabs: UnusedTabInfo): void;
    tabUnsplit(): void;
}
export declare class PageRemote implements PageInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PagePendingReceiverEndpoint);
    tabOrganizationSessionUpdated(session: TabOrganizationSession): void;
    tabOrganizationModelStrategyUpdated(strategy: TabOrganizationModelStrategy): void;
    hostWindowChanged(): void;
    tabsChanged(profileTabs: ProfileData): void;
    tabUpdated(tabUpdateInfo: TabUpdateInfo): void;
    tabsRemoved(tabsRemovedInfo: TabsRemovedInfo): void;
    tabSearchSectionChanged(section: TabSearchSection): void;
    tabOrganizationFeatureChanged(feature: TabOrganizationFeature): void;
    showFREChanged(show: boolean): void;
    tabOrganizationEnabledChanged(enabled: boolean): void;
    unusedTabsChanged(tabs: UnusedTabInfo): void;
    tabUnsplit(): void;
}
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageInterface);
}
export declare class Page {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageRemote;
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    tabOrganizationSessionUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    tabOrganizationModelStrategyUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    hostWindowChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    tabsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    tabUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    tabsRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    tabSearchSectionChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    tabOrganizationFeatureChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showFREChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    tabOrganizationEnabledChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    unusedTabsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    tabUnsplit: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const ProfileDataSpec: {
    $: mojo.internal.MojomType;
};
export declare const WindowSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabSpec: {
    $: mojo.internal.MojomType;
};
export declare const RecentlyClosedTabSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabGroupSpec: {
    $: mojo.internal.MojomType;
};
export declare const RecentlyClosedTabGroupSpec: {
    $: mojo.internal.MojomType;
};
export declare const SwitchToTabInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabOrganizationSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabOrganizationSessionSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabUpdateInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabsRemovedInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const UnusedTabInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandlerFactory_CreatePageHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_CloseTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_CloseWebUiTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_DeclutterTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_AcceptTabOrganization_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_RejectTabOrganization_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_RenameTabOrganization_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ExcludeFromStaleTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ExcludeFromDuplicateTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetProfileData_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetProfileData_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetUnusedTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetUnusedTabs_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabSearchSection_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabSearchSection_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabOrganizationFeature_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabOrganizationFeature_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabOrganizationSession_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabOrganizationSession_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabOrganizationModelStrategy_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetIsSplit_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetIsSplit_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SwitchToTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OpenRecentlyClosedEntry_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_RequestTabOrganization_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_RemoveTabFromOrganization_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_RejectSession_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ReplaceActiveSplitTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_RestartSession_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SetOrganizationFeature_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_StartTabGroupTutorial_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_TriggerFeedback_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_TriggerSignIn_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OpenHelpPage_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SetTabOrganizationModelStrategy_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SetTabOrganizationUserInstruction_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SetUserFeedback_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_NotifySearchUIReadyToShow_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabOrganizationSessionUpdated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabOrganizationModelStrategyUpdated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_HostWindowChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabsChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabUpdated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabsRemoved_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabSearchSectionChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabOrganizationFeatureChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_ShowFREChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabOrganizationEnabledChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_UnusedTabsChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_TabUnsplit_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface ProfileDataMojoType {
    windows: Window[];
    tabGroups: TabGroup[];
    recentlyClosedTabs: RecentlyClosedTab[];
    recentlyClosedTabGroups: RecentlyClosedTabGroup[];
    recentlyClosedSectionExpanded: boolean;
}
export type ProfileData = ProfileDataMojoType;
export interface WindowMojoType {
    active: boolean;
    isHostWindow: boolean;
    height: number;
    tabs: Tab[];
}
export type Window = WindowMojoType;
export interface TabMojoType {
    active: boolean;
    visible: boolean;
    pinned: boolean;
    split: boolean;
    isDefaultFavicon: boolean;
    showIcon: boolean;
    index: number;
    alertStates: tabs_mojom_TabAlertState[];
    tabId: number;
    groupId: (mojoBase_mojom_Token | null);
    title: string;
    url: url_mojom_Url;
    faviconUrl: (url_mojom_Url | null);
    lastActiveTimeTicks: mojoBase_mojom_TimeTicks;
    lastActiveElapsedText: string;
}
export type Tab = TabMojoType;
export interface RecentlyClosedTabMojoType {
    tabId: number;
    groupId: (mojoBase_mojom_Token | null);
    title: string;
    url: url_mojom_Url;
    lastActiveTime: mojoBase_mojom_Time;
    lastActiveElapsedText: string;
}
export type RecentlyClosedTab = RecentlyClosedTabMojoType;
export interface TabGroupMojoType {
    id: mojoBase_mojom_Token;
    color: tabGroups_mojom_Color;
    title: string;
}
export type TabGroup = TabGroupMojoType;
export interface RecentlyClosedTabGroupMojoType {
    sessionId: number;
    color: tabGroups_mojom_Color;
    id: mojoBase_mojom_Token;
    title: string;
    tabCount: number;
    lastActiveTime: mojoBase_mojom_Time;
    lastActiveElapsedText: string;
}
export type RecentlyClosedTabGroup = RecentlyClosedTabGroupMojoType;
export interface SwitchToTabInfoMojoType {
    tabId: number;
}
export type SwitchToTabInfo = SwitchToTabInfoMojoType;
export interface TabOrganizationMojoType {
    organizationId: number;
    firstNewTabIndex: number;
    tabs: Tab[];
    name: mojoBase_mojom_String16;
}
export type TabOrganization = TabOrganizationMojoType;
export interface TabOrganizationSessionMojoType {
    sessionId: number;
    state: TabOrganizationState;
    organizations: TabOrganization[];
    error: TabOrganizationError;
    activeTabId: number;
}
export type TabOrganizationSession = TabOrganizationSessionMojoType;
export interface TabUpdateInfoMojoType {
    inActiveWindow: boolean;
    inHostWindow: boolean;
    tab: Tab;
}
export type TabUpdateInfo = TabUpdateInfoMojoType;
export interface TabsRemovedInfoMojoType {
    tabIds: number[];
    recentlyClosedTabs: RecentlyClosedTab[];
}
export type TabsRemovedInfo = TabsRemovedInfoMojoType;
export interface UnusedTabInfoMojoType {
    staleTabs: Tab[];
    duplicateTabs: {
        [key: string]: Tab[];
    };
}
export type UnusedTabInfo = UnusedTabInfoMojoType;
export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
    page: PageRemote;
    handler: PageHandlerPendingReceiver;
}
export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
export interface PageHandler_CloseTab_ParamsMojoType {
    tabId: number;
}
export type PageHandler_CloseTab_Params = PageHandler_CloseTab_ParamsMojoType;
export interface PageHandler_CloseWebUiTab_ParamsMojoType {
}
export type PageHandler_CloseWebUiTab_Params = PageHandler_CloseWebUiTab_ParamsMojoType;
export interface PageHandler_DeclutterTabs_ParamsMojoType {
    tabIds: number[];
    urls: url_mojom_Url[];
}
export type PageHandler_DeclutterTabs_Params = PageHandler_DeclutterTabs_ParamsMojoType;
export interface PageHandler_AcceptTabOrganization_ParamsMojoType {
    sessionId: number;
    organizationId: number;
    tabs: Tab[];
}
export type PageHandler_AcceptTabOrganization_Params = PageHandler_AcceptTabOrganization_ParamsMojoType;
export interface PageHandler_RejectTabOrganization_ParamsMojoType {
    sessionId: number;
    organizationId: number;
}
export type PageHandler_RejectTabOrganization_Params = PageHandler_RejectTabOrganization_ParamsMojoType;
export interface PageHandler_RenameTabOrganization_ParamsMojoType {
    sessionId: number;
    organizationId: number;
    name: mojoBase_mojom_String16;
}
export type PageHandler_RenameTabOrganization_Params = PageHandler_RenameTabOrganization_ParamsMojoType;
export interface PageHandler_ExcludeFromStaleTabs_ParamsMojoType {
    tabId: number;
}
export type PageHandler_ExcludeFromStaleTabs_Params = PageHandler_ExcludeFromStaleTabs_ParamsMojoType;
export interface PageHandler_ExcludeFromDuplicateTabs_ParamsMojoType {
    url: url_mojom_Url;
}
export type PageHandler_ExcludeFromDuplicateTabs_Params = PageHandler_ExcludeFromDuplicateTabs_ParamsMojoType;
export interface PageHandler_GetProfileData_ParamsMojoType {
}
export type PageHandler_GetProfileData_Params = PageHandler_GetProfileData_ParamsMojoType;
export interface PageHandler_GetProfileData_ResponseParamsMojoType {
    profileData: ProfileData;
}
export type PageHandler_GetProfileData_ResponseParams = PageHandler_GetProfileData_ResponseParamsMojoType;
export interface PageHandler_GetUnusedTabs_ParamsMojoType {
}
export type PageHandler_GetUnusedTabs_Params = PageHandler_GetUnusedTabs_ParamsMojoType;
export interface PageHandler_GetUnusedTabs_ResponseParamsMojoType {
    tabs: UnusedTabInfo;
}
export type PageHandler_GetUnusedTabs_ResponseParams = PageHandler_GetUnusedTabs_ResponseParamsMojoType;
export interface PageHandler_GetTabSearchSection_ParamsMojoType {
}
export type PageHandler_GetTabSearchSection_Params = PageHandler_GetTabSearchSection_ParamsMojoType;
export interface PageHandler_GetTabSearchSection_ResponseParamsMojoType {
    section: TabSearchSection;
}
export type PageHandler_GetTabSearchSection_ResponseParams = PageHandler_GetTabSearchSection_ResponseParamsMojoType;
export interface PageHandler_GetTabOrganizationFeature_ParamsMojoType {
}
export type PageHandler_GetTabOrganizationFeature_Params = PageHandler_GetTabOrganizationFeature_ParamsMojoType;
export interface PageHandler_GetTabOrganizationFeature_ResponseParamsMojoType {
    feature: TabOrganizationFeature;
}
export type PageHandler_GetTabOrganizationFeature_ResponseParams = PageHandler_GetTabOrganizationFeature_ResponseParamsMojoType;
export interface PageHandler_GetTabOrganizationSession_ParamsMojoType {
}
export type PageHandler_GetTabOrganizationSession_Params = PageHandler_GetTabOrganizationSession_ParamsMojoType;
export interface PageHandler_GetTabOrganizationSession_ResponseParamsMojoType {
    session: TabOrganizationSession;
}
export type PageHandler_GetTabOrganizationSession_ResponseParams = PageHandler_GetTabOrganizationSession_ResponseParamsMojoType;
export interface PageHandler_GetTabOrganizationModelStrategy_ParamsMojoType {
}
export type PageHandler_GetTabOrganizationModelStrategy_Params = PageHandler_GetTabOrganizationModelStrategy_ParamsMojoType;
export interface PageHandler_GetTabOrganizationModelStrategy_ResponseParamsMojoType {
    strategy: TabOrganizationModelStrategy;
}
export type PageHandler_GetTabOrganizationModelStrategy_ResponseParams = PageHandler_GetTabOrganizationModelStrategy_ResponseParamsMojoType;
export interface PageHandler_GetIsSplit_ParamsMojoType {
}
export type PageHandler_GetIsSplit_Params = PageHandler_GetIsSplit_ParamsMojoType;
export interface PageHandler_GetIsSplit_ResponseParamsMojoType {
    isSplit: boolean;
}
export type PageHandler_GetIsSplit_ResponseParams = PageHandler_GetIsSplit_ResponseParamsMojoType;
export interface PageHandler_SwitchToTab_ParamsMojoType {
    switchToTabInfo: SwitchToTabInfo;
}
export type PageHandler_SwitchToTab_Params = PageHandler_SwitchToTab_ParamsMojoType;
export interface PageHandler_OpenRecentlyClosedEntry_ParamsMojoType {
    sessionId: number;
}
export type PageHandler_OpenRecentlyClosedEntry_Params = PageHandler_OpenRecentlyClosedEntry_ParamsMojoType;
export interface PageHandler_RequestTabOrganization_ParamsMojoType {
}
export type PageHandler_RequestTabOrganization_Params = PageHandler_RequestTabOrganization_ParamsMojoType;
export interface PageHandler_RemoveTabFromOrganization_ParamsMojoType {
    sessionId: number;
    organizationId: number;
    tab: Tab;
}
export type PageHandler_RemoveTabFromOrganization_Params = PageHandler_RemoveTabFromOrganization_ParamsMojoType;
export interface PageHandler_RejectSession_ParamsMojoType {
    sessionId: number;
}
export type PageHandler_RejectSession_Params = PageHandler_RejectSession_ParamsMojoType;
export interface PageHandler_ReplaceActiveSplitTab_ParamsMojoType {
    replacementTabId: number;
}
export type PageHandler_ReplaceActiveSplitTab_Params = PageHandler_ReplaceActiveSplitTab_ParamsMojoType;
export interface PageHandler_RestartSession_ParamsMojoType {
}
export type PageHandler_RestartSession_Params = PageHandler_RestartSession_ParamsMojoType;
export interface PageHandler_SaveRecentlyClosedExpandedPref_ParamsMojoType {
    expanded: boolean;
}
export type PageHandler_SaveRecentlyClosedExpandedPref_Params = PageHandler_SaveRecentlyClosedExpandedPref_ParamsMojoType;
export interface PageHandler_SetOrganizationFeature_ParamsMojoType {
    feature: TabOrganizationFeature;
}
export type PageHandler_SetOrganizationFeature_Params = PageHandler_SetOrganizationFeature_ParamsMojoType;
export interface PageHandler_StartTabGroupTutorial_ParamsMojoType {
}
export type PageHandler_StartTabGroupTutorial_Params = PageHandler_StartTabGroupTutorial_ParamsMojoType;
export interface PageHandler_TriggerFeedback_ParamsMojoType {
    sessionId: number;
}
export type PageHandler_TriggerFeedback_Params = PageHandler_TriggerFeedback_ParamsMojoType;
export interface PageHandler_TriggerSignIn_ParamsMojoType {
}
export type PageHandler_TriggerSignIn_Params = PageHandler_TriggerSignIn_ParamsMojoType;
export interface PageHandler_OpenHelpPage_ParamsMojoType {
}
export type PageHandler_OpenHelpPage_Params = PageHandler_OpenHelpPage_ParamsMojoType;
export interface PageHandler_SetTabOrganizationModelStrategy_ParamsMojoType {
    strategy: TabOrganizationModelStrategy;
}
export type PageHandler_SetTabOrganizationModelStrategy_Params = PageHandler_SetTabOrganizationModelStrategy_ParamsMojoType;
export interface PageHandler_SetTabOrganizationUserInstruction_ParamsMojoType {
    userInstruction: string;
}
export type PageHandler_SetTabOrganizationUserInstruction_Params = PageHandler_SetTabOrganizationUserInstruction_ParamsMojoType;
export interface PageHandler_SetUserFeedback_ParamsMojoType {
    sessionId: number;
    feedback: UserFeedback;
}
export type PageHandler_SetUserFeedback_Params = PageHandler_SetUserFeedback_ParamsMojoType;
export interface PageHandler_NotifyOrganizationUIReadyToShow_ParamsMojoType {
}
export type PageHandler_NotifyOrganizationUIReadyToShow_Params = PageHandler_NotifyOrganizationUIReadyToShow_ParamsMojoType;
export interface PageHandler_NotifySearchUIReadyToShow_ParamsMojoType {
}
export type PageHandler_NotifySearchUIReadyToShow_Params = PageHandler_NotifySearchUIReadyToShow_ParamsMojoType;
export interface Page_TabOrganizationSessionUpdated_ParamsMojoType {
    session: TabOrganizationSession;
}
export type Page_TabOrganizationSessionUpdated_Params = Page_TabOrganizationSessionUpdated_ParamsMojoType;
export interface Page_TabOrganizationModelStrategyUpdated_ParamsMojoType {
    strategy: TabOrganizationModelStrategy;
}
export type Page_TabOrganizationModelStrategyUpdated_Params = Page_TabOrganizationModelStrategyUpdated_ParamsMojoType;
export interface Page_HostWindowChanged_ParamsMojoType {
}
export type Page_HostWindowChanged_Params = Page_HostWindowChanged_ParamsMojoType;
export interface Page_TabsChanged_ParamsMojoType {
    profileTabs: ProfileData;
}
export type Page_TabsChanged_Params = Page_TabsChanged_ParamsMojoType;
export interface Page_TabUpdated_ParamsMojoType {
    tabUpdateInfo: TabUpdateInfo;
}
export type Page_TabUpdated_Params = Page_TabUpdated_ParamsMojoType;
export interface Page_TabsRemoved_ParamsMojoType {
    tabsRemovedInfo: TabsRemovedInfo;
}
export type Page_TabsRemoved_Params = Page_TabsRemoved_ParamsMojoType;
export interface Page_TabSearchSectionChanged_ParamsMojoType {
    section: TabSearchSection;
}
export type Page_TabSearchSectionChanged_Params = Page_TabSearchSectionChanged_ParamsMojoType;
export interface Page_TabOrganizationFeatureChanged_ParamsMojoType {
    feature: TabOrganizationFeature;
}
export type Page_TabOrganizationFeatureChanged_Params = Page_TabOrganizationFeatureChanged_ParamsMojoType;
export interface Page_ShowFREChanged_ParamsMojoType {
    show: boolean;
}
export type Page_ShowFREChanged_Params = Page_ShowFREChanged_ParamsMojoType;
export interface Page_TabOrganizationEnabledChanged_ParamsMojoType {
    enabled: boolean;
}
export type Page_TabOrganizationEnabledChanged_Params = Page_TabOrganizationEnabledChanged_ParamsMojoType;
export interface Page_UnusedTabsChanged_ParamsMojoType {
    tabs: UnusedTabInfo;
}
export type Page_UnusedTabsChanged_Params = Page_UnusedTabsChanged_ParamsMojoType;
export interface Page_TabUnsplit_ParamsMojoType {
}
export type Page_TabUnsplit_Params = Page_TabUnsplit_ParamsMojoType;
