// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { html } from '//resources/lit/v3_0/lit.rollup.js';
import { TabOrganizationFeature } from './tab_search.mojom-webui.js';
export function getHtml() {
    // clang-format off
    return html `
<!--_html_template_start_-->
<div ?hidden="${this.getVisibleFeature_() !== TabOrganizationFeature.kSelector}">
  <div id="buttonContainer">
    <tab-organization-selector-button id="autoTabGroupsButton"
        top
        heading="$i18n{autoTabGroupsSelectorHeading}"
        subheading="$i18n{autoTabGroupsSelectorSubheading}"
        icon="tab-search:auto-tab-groups"
        @click="${this.onAutoTabGroupsClick_}">
    </tab-organization-selector-button>
    <tab-organization-selector-button id="declutterButton"
        bottom
        heading="${this.declutterHeading_}"
        subheading="$i18n{declutterSelectorSubheading}"
        icon="tab-search:declutter"
        ?disabled="${this.disableDeclutter_}"
        @click="${this.onDeclutterClick_}">
    </tab-organization-selector-button>
  </div>
</div>

<div ?hidden="${this.getVisibleFeature_() !== TabOrganizationFeature.kAutoTabGroups}">
  <auto-tab-groups-page id="autoTabGroupsPage" show-back-button
      available-height="${this.availableHeight}"
      @back-click="${this.onBackClick_}">
  </auto-tab-groups-page>
</div>

<div ?hidden="${this.getVisibleFeature_() !== TabOrganizationFeature.kDeclutter}">
  <declutter-page id="declutterPage" show-back-button
      available-height="${this.availableHeight}"
      @back-click="${this.onBackClick_}">
  </declutter-page>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}
