import 'chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import './auto_tab_groups_group.js';
import './auto_tab_groups_results_actions.js';
import { CrFeedbackOption } from 'chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import type { CrFeedbackButtonsElement } from 'chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { TabOrganization, TabOrganizationSession } from '../tab_search.mojom-webui.js';
export interface AutoTabGroupsResultsElement {
    $: {
        feedbackButtons: CrFeedbackButtonsElement;
        header: HTMLElement;
        learnMore: HTMLElement;
        scrollable: HTMLElement;
    };
}
export declare class AutoTabGroupsResultsElement extends CrLitElement {
    static get is(): string;
    static get properties(): {
        session: {
            type: ObjectConstructor;
        };
        availableHeight: {
            type: NumberConstructor;
        };
        feedbackSelectedOption_: {
            type: NumberConstructor;
        };
    };
    accessor session: TabOrganizationSession | undefined;
    accessor availableHeight: number;
    protected accessor feedbackSelectedOption_: CrFeedbackOption;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    willUpdate(changedProperties: PropertyValues<this>): void;
    updated(changedProperties: PropertyValues<this>): void;
    firstUpdated(): void;
    focusInput(): void;
    private updateScroll_;
    protected getOrganizations_(): TabOrganization[];
    protected hasMultipleOrganizations_(): boolean;
    protected getName_(organization: TabOrganization): string;
    private getMaxScrollableHeight_;
    private onAvailableHeightChange_;
    protected onCreateAllGroupsClick_(event: CustomEvent): void;
    protected onLearnMoreClick_(): void;
    protected onLearnMoreKeyDown_(event: KeyboardEvent): void;
    protected onFeedbackKeyDown_(event: KeyboardEvent): void;
    protected onFeedbackSelectedOptionChanged_(event: CustomEvent<{
        value: CrFeedbackOption;
    }>): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'auto-tab-groups-results': AutoTabGroupsResultsElement;
    }
}
