// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_radio_button/cr_radio_button.js';
import 'chrome://resources/cr_elements/cr_radio_group/cr_radio_group.js';
import '/strings.m.js';
import './auto_tab_groups_not_started_image.js';
import { WebUiListenerMixinLit } from 'chrome://resources/cr_elements/web_ui_listener_mixin_lit.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { TabOrganizationModelStrategy } from '../tab_search.mojom-webui.js';
import { TabSearchSyncBrowserProxyImpl } from '../tab_search_sync_browser_proxy.js';
import { getCss } from './auto_tab_groups_not_started.css.js';
import { getHtml } from './auto_tab_groups_not_started.html.js';
const AutoTabGroupsNotStartedElementBase = WebUiListenerMixinLit(CrLitElement);
// Not started state for the auto tab groups UI.
export class AutoTabGroupsNotStartedElement extends AutoTabGroupsNotStartedElementBase {
    static get is() {
        return 'auto-tab-groups-not-started';
    }
    static get properties() {
        return {
            showFre: { type: Boolean },
            modelStrategy: { type: Number },
            signedIn_: { type: Boolean },
            tabOrganizationModelStrategyEnabled_: { type: Boolean },
            tabOrganizationUserInstructionEnabled_: { type: Boolean },
        };
    }
    #showFre_accessor_storage = false;
    get showFre() { return this.#showFre_accessor_storage; }
    set showFre(value) { this.#showFre_accessor_storage = value; }
    #modelStrategy_accessor_storage = TabOrganizationModelStrategy.kTopic;
    get modelStrategy() { return this.#modelStrategy_accessor_storage; }
    set modelStrategy(value) { this.#modelStrategy_accessor_storage = value; }
    #tabOrganizationModelStrategyEnabled__accessor_storage = loadTimeData.getBoolean('tabOrganizationModelStrategyEnabled');
    get tabOrganizationModelStrategyEnabled_() { return this.#tabOrganizationModelStrategyEnabled__accessor_storage; }
    set tabOrganizationModelStrategyEnabled_(value) { this.#tabOrganizationModelStrategyEnabled__accessor_storage = value; }
    #tabOrganizationUserInstructionEnabled__accessor_storage = loadTimeData.getBoolean('TabOrganizationUserInstructionEnabled');
    get tabOrganizationUserInstructionEnabled_() { return this.#tabOrganizationUserInstructionEnabled__accessor_storage; }
    set tabOrganizationUserInstructionEnabled_(value) { this.#tabOrganizationUserInstructionEnabled__accessor_storage = value; }
    #signedIn__accessor_storage = false;
    get signedIn_() { return this.#signedIn__accessor_storage; }
    set signedIn_(value) { this.#signedIn__accessor_storage = value; }
    syncBrowserProxy_ = TabSearchSyncBrowserProxyImpl.getInstance();
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    connectedCallback() {
        super.connectedCallback();
        this.syncBrowserProxy_.getSignInState().then(this.setSignedIn_.bind(this));
        this.addWebUiListener('account-info-changed', this.setSignedIn_.bind(this));
    }
    setSignedIn_(signedIn) {
        this.signedIn_ = signedIn;
    }
    getBody_() {
        if (!this.signedIn_) {
            return loadTimeData.getString('notStartedBodySignedOut');
        }
        else if (this.showFre) {
            return loadTimeData.getString('notStartedBodyFREHeader');
        }
        else {
            return loadTimeData.getString('notStartedBody');
        }
    }
    getActionButtonAriaLabel_() {
        if (!this.signedIn_) {
            return loadTimeData.getString('notStartedButtonSignedOutAriaLabel');
        }
        else if (this.showFre) {
            return loadTimeData.getString('notStartedButtonFREAriaLabel');
        }
        else {
            return loadTimeData.getString('notStartedButtonAriaLabel');
        }
    }
    getActionButtonText_() {
        if (!this.signedIn_) {
            return loadTimeData.getString('notStartedButtonSignedOut');
        }
        else if (this.showFre) {
            return loadTimeData.getString('notStartedButtonFRE');
        }
        else {
            return loadTimeData.getString('notStartedButton');
        }
    }
    onButtonClick_() {
        if (!this.signedIn_) {
            this.fire('sign-in-click');
        }
        else {
            // Start a tab organization
            this.fire('organize-tabs-click');
            chrome.metricsPrivate.recordBoolean('Tab.Organization.AllEntrypoints.Clicked', true);
            chrome.metricsPrivate.recordBoolean('Tab.Organization.TabSearch.Clicked', true);
        }
    }
    onLearnMoreClick_() {
        this.fire('learn-more-click');
    }
    onLearnMoreKeyDown_(event) {
        if (event.key === 'Enter') {
            this.onLearnMoreClick_();
        }
    }
    onModelStrategyChange_(e) {
        const modelStrategy = e.detail.value;
        if (Number(modelStrategy) !== Number(this.modelStrategy)) {
            this.fire('model-strategy-change', { value: modelStrategy });
        }
    }
    onUserInstructionInputChange_(e) {
        const value = e.target.value;
        this.fire('user-instruction-input-change', { value: value });
    }
}
customElements.define(AutoTabGroupsNotStartedElement.is, AutoTabGroupsNotStartedElement);
