import './auto_tab_groups/auto_tab_groups_page.js';
import './declutter/declutter_page.js';
import './tab_organization_selector.js';
import './tab_search_page.js';
import 'chrome://resources/cr_elements/cr_tabs/cr_tabs.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { TabSearchSection } from './tab_search.mojom-webui.js';
export declare class TabSearchAppElement extends CrLitElement {
    static get is(): string;
    static get properties(): {
        selectedTabSection_: {
            type: ObjectConstructor;
        };
        tabNames_: {
            type: ArrayConstructor;
        };
        tabOrganizationEnabled_: {
            type: BooleanConstructor;
        };
        declutterEnabled_: {
            type: BooleanConstructor;
        };
        availableHeight_: {
            type: NumberConstructor;
        };
    };
    private apiProxy_;
    private listenerIds_;
    private documentVisibilityChangedListener_;
    protected accessor selectedTabSection_: TabSearchSection;
    protected accessor tabNames_: string[];
    protected accessor tabOrganizationEnabled_: boolean;
    protected accessor declutterEnabled_: boolean;
    protected accessor availableHeight_: number;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    private updateAvailableHeight_;
    private onTabSectionChanged_;
    private onTabOrganizationEnabledChanged_;
    protected sectionToIndex_(section: TabSearchSection): number;
    private indexToSection;
    protected onSelectedTabIndexChanged_(e: CustomEvent<{
        value: number;
    }>): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'tab-search-app': TabSearchAppElement;
    }
}
