// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_grid/cr_grid.js";import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{ItemEventType}from"./url_item_delegate.js";import{getCss}from"./url_item_grid.css.js";import{getHtml}from"./url_item_grid.html.js";export class UrlItemGrid extends CrLitElement{static get is(){return"url-item-grid"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{items_:{type:Array}}}#items__accessor_storage=[];get items_(){return this.#items__accessor_storage}set items_(value){this.#items__accessor_storage=value}delegate_=null;eventTracker_=new EventTracker;disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}async setDelegate(delegate){assert(this.delegate_===null);this.delegate_=delegate;const eventTarget=this.delegate_.getEventTarget();this.eventTracker_.add(eventTarget,ItemEventType.ITEM_ADDED,this.onItemAdded_.bind(this));this.eventTracker_.add(eventTarget,ItemEventType.ITEM_REMOVED,this.onItemRemoved_.bind(this));this.eventTracker_.add(eventTarget,ItemEventType.ITEM_MOVED,this.onItemMoved_.bind(this));this.items_=await this.delegate_.getItems()}onItemAdded_(e){this.items_.splice(e.detail.index,0,e.detail.item);this.requestUpdate()}onItemMoved_(e){const oldIndex=this.items_.findIndex((item=>item.id===e.detail.id));assert(oldIndex!==-1);const[itemToMove]=this.items_.splice(oldIndex,1);this.items_.splice(e.detail.newIndex,0,itemToMove);this.requestUpdate()}onItemRemoved_(e){const index=this.items_.findIndex((item=>item.id===e.detail));assert(index!==-1);this.items_.splice(index,1);this.requestUpdate()}}customElements.define(UrlItemGrid.is,UrlItemGrid);