import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import 'chrome://resources/cr_elements/cr_radio_button/cr_radio_button.js';
import 'chrome://resources/cr_elements/cr_radio_group/cr_radio_group.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import './support_tool_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { PiiDataItem } from './browser_proxy.js';
declare enum PiiRadioButtons {
    INCLUDE_ALL = "include-all",
    INCLUDE_NONE = "include-none",
    INCLUDE_SOME = "include-some"
}
declare const PiiSelectionElementBase: typeof PolymerElement & (new (...args: any[]) => import("./support_tool_page_mixin.js").SupportToolPageMixinInterface);
export declare class PiiSelectionElement extends PiiSelectionElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        selectAll_: {
            type: BooleanConstructor;
            value: boolean;
        };
        detectedPIIItems_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        piiRadioButtonsEnum_: {
            readonly: boolean;
            type: ObjectConstructor;
            value: typeof PiiRadioButtons;
        };
        selectedRadioButton_: {
            type: StringConstructor;
            value: PiiRadioButtons;
        };
        showPIISelection_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    private selectAll_;
    private selectedRadioButton_;
    private showPIISelection_;
    private detectedPIIItems_;
    private browserProxy_;
    updateDetectedPiiItems(items: PiiDataItem[]): void;
    private onCancelClick_;
    private onExportClick_;
    private setSelectAll_;
    private onSelectedRadioButtonChanged_;
    private showDisclaimer_;
    private getPiiItemAriaLabel_;
}
declare global {
    interface HTMLElementTagNameMap {
        'pii-selection': PiiSelectionElement;
    }
}
export {};
