import './screenshot.js';
import './support_tool_shared.css.js';
import 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { DataCollectorItem } from './browser_proxy.js';
declare const DataCollectorsElementBase: typeof PolymerElement & (new (...args: any[]) => import("./support_tool_page_mixin.js").SupportToolPageMixinInterface);
export declare class DataCollectorsElement extends DataCollectorsElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        dataCollectors_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        enableScreenshot_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        allSelected_: {
            type: BooleanConstructor;
            value: boolean;
            notify: boolean;
            observer: string;
        };
    };
    private dataCollectors_;
    private enableScreenshot_;
    private allSelected_;
    private browserProxy_;
    connectedCallback(): void;
    getDataCollectors(): DataCollectorItem[];
    setScreenshotData(dataBase64: string): void;
    getEditedScreenshotBase64(): string;
    private onAllSelectedChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'data-collectors': DataCollectorsElement;
    }
}
export {};
