import 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import './profile_creation_flow/profile_type_choice.js';
import './profile_picker_main_view.js';
import './profile_switch.js';
import '/strings.m.js';
import type { CrViewManagerElement } from 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { AutogeneratedThemeColorInfo } from './manage_profiles_browser_proxy.js';
import { Routes } from './navigation_mixin.js';
export interface ProfilePickerAppElement {
    $: {
        viewManager: CrViewManagerElement;
    };
}
declare const ProfilePickerAppElementBase: typeof CrLitElement & (new (...args: any[]) => import("./navigation_mixin.js").NavigationMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin_lit.js").WebUiListenerMixinLitInterface);
declare enum AppMode {
    REGULAR = "regular",
    NO_BANNER = "no-banner",
    GLIC = "glic"
}
export declare class ProfilePickerAppElement extends ProfilePickerAppElementBase {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        /**
         * Suggested new profile theme info for the profile creation flow.
         */
        newProfileThemeInfo: {
            type: ObjectConstructor;
            notify: boolean;
        };
        /**
         * True if a new profile (local or signed-in) is being created, all
         * buttons that create a new profile are then disabled (to avoid creating
         * two profiles).
         */
        profileCreationInProgress: {
            type: BooleanConstructor;
            notify: boolean;
        };
        appMode_: {
            type: StringConstructor;
            reflect: boolean;
        };
    };
    accessor newProfileThemeInfo: AutogeneratedThemeColorInfo | undefined;
    accessor profileCreationInProgress: boolean;
    protected shouldDisplayVerticalBanners_: boolean;
    private currentRoute_;
    private manageProfilesBrowserProxy_;
    protected accessor appMode_: AppMode;
    connectedCallback(): void;
    onRouteChange(route: Routes, step: string): void;
    private updateAppMode_;
    private getDocumentTitle_;
    private initializeModules_;
    private initializeNewProfileThemeInfo_;
    private setMinimumSize_;
}
declare global {
    interface HTMLElementTagNameMap {
        'profile-picker-app': ProfilePickerAppElement;
    }
}
export {};
