import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/icons.html.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { AutogeneratedThemeColorInfo } from '../manage_profiles_browser_proxy.js';
export interface ProfileTypeChoiceElement {
    $: {
        backButton: CrButtonElement;
        notNowButton: CrButtonElement;
        signInButton: CrButtonElement;
    };
}
declare const ProfileTypeChoiceElementBase: typeof CrLitElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin_lit.js").WebUiListenerMixinLitInterface);
export declare class ProfileTypeChoiceElement extends ProfileTypeChoiceElementBase {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        profileThemeInfo: {
            type: ObjectConstructor;
        };
        /**
         * True if a new profile (local or signed-in) is being created, all
         * buttons that create a new profile are then disabled (to avoid creating
         * two profiles).
         */
        profileCreationInProgress: {
            type: BooleanConstructor;
        };
        /**
         * The disclaimer for managed devices.
         */
        managedDeviceDisclaimer_: {
            type: BooleanConstructor;
        };
    };
    accessor profileThemeInfo: AutogeneratedThemeColorInfo;
    accessor profileCreationInProgress: boolean;
    protected accessor managedDeviceDisclaimer_: boolean;
    private manageProfilesBrowserProxy_;
    firstUpdated(): void;
    private onViewEnterStart_;
    protected onNotNowClick_(): void;
    protected onSignInClick_(): void;
    protected onBackClick_(): void;
    private handleLoadSigninFinished_;
    protected getBackButtonAriaLabel_(): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'profile-type-choice': ProfileTypeChoiceElement;
    }
}
export {};
