import {css, CSSResultGroup} from '//resources/lit/v3_0/lit.rollup.js';
import {getCss as getProfilePickerShared} from './profile_picker_shared.css.js';
import {getCss as getCrHiddenStyleLit} from 'chrome://resources/cr_elements/cr_hidden_style_lit.css.js';
import {getCss as getCrSharedStyleLit} from 'chrome://resources/cr_elements/cr_shared_style_lit.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';

let instance: CSSResultGroup|null = null;
export function getCss() {
  return instance || (instance = [...[getProfilePickerShared(),getCrHiddenStyleLit(),getCrSharedStyleLit()], css`:host{--profile-item-border-width:1px;--profile-item-margin:4px;--profile-item-background:var(--google-grey-50);--picker-logo-height:44px}:host([is-glic_]){--footer-spacing:0px;--picker-logo-height:58px}.flex-container{display:flex;flex-flow:column;height:calc(100% - var(--cr-button-height) - 2 * var(--footer-spacing));justify-content:center;row-gap:30px}.title-container{--banner-width:17vw;flex:0 1 auto;margin:30px auto 0 auto;max-width:490px;padding-inline-end:var(--banner-width);padding-inline-start:var(--banner-width);text-align:center}#picker-logo{height:var(--picker-logo-height)}.title{margin-bottom:16px}#footer-text{font-size:0.75rem;margin-left:auto;margin-right:auto;margin-top:20px;max-width:370px;text-align:center}.subtitle{line-height:22px;margin-top:8px}#profilesWrapper{display:flex;flex:0 1 auto;margin-bottom:4px;margin-inline-end:140px;margin-inline-start:140px;min-height:calc(var(--profile-item-height) + 2*var(--profile-item-margin) + 2*var(--profile-item-border-width));overflow-x:hidden;overflow-y:auto}#profilesContainer{--grid-gutter:8px;align-items:center;display:grid;grid-column-gap:var(--grid-gutter);grid-row-gap:var(--grid-gutter);grid-template-columns:repeat(auto-fit,calc(var(--profile-item-width) + 2 * var(--profile-item-margin)));justify-content:center;margin:auto;max-height:100%;overflow-x:hidden;overflow-y:auto;padding-inline-end:var(--scrollbar-width);padding-inline-start:var(--scrollbar-width);width:100%}.profile-item{align-items:center;background-color:var(--profile-item-background);border-radius:8px;display:flex;flex-direction:column;height:var(--profile-item-height);justify-content:center;margin:var(--profile-item-margin);width:var(--profile-item-width)}.profile-item:focus-within,.profile-item:hover,#addProfile.profile-item:focus-within,#addProfile.profile-item:hover{background-color:var(--profile-card-hover-color)}#addProfile.profile-item{--cr-hover-background-color:none;background-color:transparent;border:var(--profile-item-border-width) dashed var(--google-grey-300);box-shadow:none;position:relative}#addProfileButtonLabel{top:0;left:0}cr-icon[icon='profiles:add']{--iron-icon-height:var(--profile-card-avatar-icon-size);--iron-icon-width:var(--profile-card-avatar-icon-size);--iron-icon-fill-color:var(--google-grey-100);--iron-icon-stroke-color:var(--google-grey-700)}#browseAsGuestButton{padding:8px 16px}#browseAsGuestButton>cr-icon{margin-inline-end:0;--iron-icon-height:20px;--iron-icon-width:20px}.footer-buttons-container{display:flex;margin-inline-start:var(--footer-spacing);column-gap:8px}:host([is-open-all-profiles-button-experiment-enabled_]) .footer{flex-direction:row-reverse}:host([is-open-all-profiles-button-experiment-enabled_]) .footer-buttons-container{margin-inline-start:0;margin-inline-end:var(--footer-spacing)}:host([is-open-all-profiles-button-experiment-enabled_]) #askOnStartup{margin-inline-end:auto;margin-inline-start:var(--footer-spacing)}cr-checkbox{--cr-checkbox-label-color:var(--cr-secondary-text-color);--cr-checkbox-label-padding-start:8px;justify-content:flex-end;margin-inline-end:var(--footer-spacing);margin-inline-start:auto;padding-inline-end:5px;padding-inline-start:5px}#button-sign-in{margin-left:10px}@media (prefers-color-scheme:dark){:host{--profile-item-background:var(--google-grey-900)}.profile-item,#addProfile.profile-item{border-color:var(--google-grey-700)}cr-icon[icon='profiles:add']{--iron-icon-fill-color:var(--google-grey-500);--iron-icon-stroke-color:rgb(48,48,50)}}`]);
}