import {css, CSSResultGroup} from '//resources/lit/v3_0/lit.rollup.js';
import {getCss as getProfilePickerShared} from './profile_picker_shared.css.js';
import {getCss as getCrHiddenStyleLit} from 'chrome://resources/cr_elements/cr_hidden_style_lit.css.js';

let instance: CSSResultGroup|null = null;
export function getCss() {
  return instance || (instance = [...[getProfilePickerShared(),getCrHiddenStyleLit()], css`:host{display:block;height:100%}:host([app-mode_="glic"]){@media (prefers-color-scheme:dark){background-color:#131314}#banner-right,#banner-left{max-width:50%;position:absolute}#banner-right{content:url(glic_banner_top_right_light.svg);right:0;top:0;@media (prefers-color-scheme:dark){content:url(glic_banner_top_right.svg)}}#banner-left{content:url(glic_banner_bottom_left_light.svg);left:0;bottom:0;@media (prefers-color-scheme:dark){content:url(glic_banner_bottom_left.svg)}}}:host([app-mode_="regular"]){#banner-right,#banner-left{max-width:320px;position:absolute;top:0;width:17vw}#banner-right{content:url(right_banner.svg);right:0;@media (prefers-color-scheme:dark){content:url(right_banner_dark.svg)}}#banner-left{content:url(left_banner.svg);left:0;@media (prefers-color-scheme:dark){content:url(left_banner_dark.svg)}}}cr-view-manager{display:flex;font-size:100%;margin:0}cr-view-manager>[slot='view']{min-height:var(--view-min-size);min-width:var(--view-min-size)}`]);
}