// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_components/theme_color_picker/theme_color_picker.js";import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_icon/cr_icon.js";import"chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js";import"chrome://resources/cr_elements/cr_input/cr_input.js";import"chrome://resources/cr_elements/cr_profile_avatar_selector/cr_profile_avatar_selector.js";import"chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js";import"chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js";import"chrome://resources/cr_elements/icons.html.js";import"chrome://resources/cr_elements/policy/cr_policy_indicator.js";import"/strings.m.js";import{I18nMixinLit}from"chrome://resources/cr_elements/i18n_mixin_lit.js";import{WebUiListenerMixinLit}from"chrome://resources/cr_elements/web_ui_listener_mixin_lit.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./profile_customization_app.css.js";import{getHtml}from"./profile_customization_app.html.js";import{ProfileCustomizationBrowserProxyImpl}from"./profile_customization_browser_proxy.js";const ProfileCustomizationAppElementBase=WebUiListenerMixinLit(I18nMixinLit(CrLitElement));export class ProfileCustomizationAppElement extends ProfileCustomizationAppElementBase{static get is(){return"profile-customization-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{isManaged_:{type:Boolean},profileName_:{type:String},pictureUrl_:{type:String},welcomeTitle_:{type:String},availableIcons_:{type:Array},selectedAvatar_:{type:Object},isLocalProfileCreation_:{type:Boolean},shouldShowDefaultProfileName_:{type:Boolean}}}#isManaged__accessor_storage=false;get isManaged_(){return this.#isManaged__accessor_storage}set isManaged_(value){this.#isManaged__accessor_storage=value}hasEnterpriseLabel=false;#profileName__accessor_storage="";get profileName_(){return this.#profileName__accessor_storage}set profileName_(value){this.#profileName__accessor_storage=value}#pictureUrl__accessor_storage="";get pictureUrl_(){return this.#pictureUrl__accessor_storage}set pictureUrl_(value){this.#pictureUrl__accessor_storage=value}#welcomeTitle__accessor_storage="";get welcomeTitle_(){return this.#welcomeTitle__accessor_storage}set welcomeTitle_(value){this.#welcomeTitle__accessor_storage=value}#availableIcons__accessor_storage=[];get availableIcons_(){return this.#availableIcons__accessor_storage}set availableIcons_(value){this.#availableIcons__accessor_storage=value}#selectedAvatar__accessor_storage=null;get selectedAvatar_(){return this.#selectedAvatar__accessor_storage}set selectedAvatar_(value){this.#selectedAvatar__accessor_storage=value}confirmedAvatar_=null;#isLocalProfileCreation__accessor_storage=loadTimeData.getBoolean("isLocalProfileCreation");get isLocalProfileCreation_(){return this.#isLocalProfileCreation__accessor_storage}set isLocalProfileCreation_(value){this.#isLocalProfileCreation__accessor_storage=value}#shouldShowDefaultProfileName__accessor_storage=loadTimeData.getBoolean("shouldShowDefaultProfileName");get shouldShowDefaultProfileName_(){return this.#shouldShowDefaultProfileName__accessor_storage}set shouldShowDefaultProfileName_(value){this.#shouldShowDefaultProfileName__accessor_storage=value}profileCustomizationBrowserProxy_=ProfileCustomizationBrowserProxyImpl.getInstance();firstUpdated(){if(!this.isLocalProfileCreation_||this.shouldShowDefaultProfileName_){this.profileName_=loadTimeData.getString("profileName")}this.addWebUiListener("on-profile-info-changed",(info=>this.setProfileInfo_(info)));this.addWebUiListener("on-available-icons-changed",(icons=>this.setAvailableIcons_(icons)));this.profileCustomizationBrowserProxy_.initialized().then((info=>this.setProfileInfo_(info)));if(this.isLocalProfileCreation_){this.profileCustomizationBrowserProxy_.getAvailableIcons().then((icons=>this.setAvailableIcons_(icons)))}}onDoneCustomizationClicked_(){this.profileCustomizationBrowserProxy_.done(this.profileName_)}isDoneButtonDisabled_(){return!this.profileName_||!this.$.nameInput.validate()}setProfileInfo_(profileInfo){this.style.setProperty("--header-background-color",profileInfo.backgroundColor);this.pictureUrl_=profileInfo.pictureUrl;this.isManaged_=profileInfo.isManaged;this.hasEnterpriseLabel=profileInfo.hasEnterpriseLabel;this.welcomeTitle_=this.isLocalProfileCreation_?this.i18n("localProfileCreationTitle"):this.i18n("profileCustomizationTitle")}getNameInputPlaceHolder_(){return this.shouldShowDefaultProfileName_?"":this.i18n("profileCustomizationInputPlaceholder")}shouldShowCancelButton_(){return!this.isLocalProfileCreation_}onSkipCustomizationClicked_(){this.profileCustomizationBrowserProxy_.skip()}onDeleteProfileClicked_(){this.profileCustomizationBrowserProxy_.deleteProfile()}onCustomizeAvatarClick_(){assert(this.isLocalProfileCreation_);this.$.viewManager.switchView("selectAvatarDialog","fade-in","fade-out")}setAvailableIcons_(icons){icons.forEach(((icon,index)=>{if(icon.selected){icons[index].selected=false;this.confirmedAvatar_=icons[index];if(!this.selectedAvatar_){this.selectedAvatar_=icons[index]}}}));this.availableIcons_=icons}onSelectAvatarConfirmClicked_(){assert(this.isLocalProfileCreation_);assert(this.selectedAvatar_);this.profileCustomizationBrowserProxy_.setAvatarIcon(this.selectedAvatar_.index);this.confirmedAvatar_=this.selectedAvatar_;this.closeSelectAvatar_()}onSelectAvatarBackClicked_(){assert(this.isLocalProfileCreation_);this.closeSelectAvatar_();this.selectedAvatar_=this.confirmedAvatar_}closeSelectAvatar_(){this.$.viewManager.switchView("customizeDialog","fade-in","fade-out")}validateInputOnBlur_(){this.$.nameInput.validate()}onProfileNameChanged_(e){this.profileName_=e.detail.value}onSelectedAvatarChanged_(e){this.selectedAvatar_=e.detail.value}}customElements.define(ProfileCustomizationAppElement.is,ProfileCustomizationAppElement);