// chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const LaunchContextSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum LaunchContext {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kWindow = 0,
  kModal = 1,
}

export const ScreenModeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ScreenMode {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kPending = 0,
  kRestricted = 1,
  kUnrestricted = 2,
  kDeadlined = 3,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history_sync_optin.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createHistorySyncOptinHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createHistorySyncOptinHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec.$,
        null,
        impl.createHistorySyncOptinHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "history_sync_optin.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createHistorySyncOptinHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createHistorySyncOptinHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec.$,
        null,
        this.createHistorySyncOptinHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history_sync_optin.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  accept(): void;
  reject(): void;
  requestAccountInfo(): void;
  updateDialogHeight(height: number): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  accept(): void {
    this.proxy.sendMessage(
        0,
        PageHandler_Accept_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  reject(): void {
    this.proxy.sendMessage(
        1,
        PageHandler_Reject_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  requestAccountInfo(): void {
    this.proxy.sendMessage(
        2,
        PageHandler_RequestAccountInfo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateDialogHeight(
      height: number): void {
    this.proxy.sendMessage(
        3,
        PageHandler_UpdateDialogHeight_ParamsSpec.$,
        null,
        [
          height
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_Accept_ParamsSpec.$,
        null,
        impl.accept.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_Reject_ParamsSpec.$,
        null,
        impl.reject.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_RequestAccountInfo_ParamsSpec.$,
        null,
        impl.requestAccountInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_UpdateDialogHeight_ParamsSpec.$,
        null,
        impl.updateDialogHeight.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "history_sync_optin.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  accept: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  reject: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestAccountInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateDialogHeight: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.accept =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_Accept_ParamsSpec.$,
        null,
        this.accept.createReceiverHandler(false /* expectsResponse */),
        false);
    this.reject =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_Reject_ParamsSpec.$,
        null,
        this.reject.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestAccountInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_RequestAccountInfo_ParamsSpec.$,
        null,
        this.requestAccountInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateDialogHeight =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_UpdateDialogHeight_ParamsSpec.$,
        null,
        this.updateDialogHeight.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history_sync_optin.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  sendAccountInfo(accountInfo: AccountInfo): void;
  sendScreenMode(screenMode: ScreenMode): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  sendAccountInfo(
      accountInfo: AccountInfo): void {
    this.proxy.sendMessage(
        0,
        Page_SendAccountInfo_ParamsSpec.$,
        null,
        [
          accountInfo
        ],
        false);
  }

  sendScreenMode(
      screenMode: ScreenMode): void {
    this.proxy.sendMessage(
        1,
        Page_SendScreenMode_ParamsSpec.$,
        null,
        [
          screenMode
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_SendAccountInfo_ParamsSpec.$,
        null,
        impl.sendAccountInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_SendScreenMode_ParamsSpec.$,
        null,
        impl.sendScreenMode.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "history_sync_optin.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  sendAccountInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  sendScreenMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.sendAccountInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_SendAccountInfo_ParamsSpec.$,
        null,
        this.sendAccountInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.sendScreenMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_SendScreenMode_ParamsSpec.$,
        null,
        this.sendScreenMode.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const AccountInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Accept_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Reject_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RequestAccountInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UpdateDialogHeight_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SendAccountInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SendScreenMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface AccountInfoMojoType {
  accountImageSrc: url_mojom_Url;
}


export type AccountInfo = AccountInfoMojoType;
mojo.internal.Struct<AccountInfoMojoType>(
    AccountInfoSpec.$,
    'AccountInfo',
    [
      mojo.internal.StructField<AccountInfoMojoType, url_mojom_Url>(
        'accountImageSrc', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreateHistorySyncOptinHandler_Params = PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsMojoType>(
    PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec.$,
    'PageHandlerFactory_CreateHistorySyncOptinHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_Accept_ParamsMojoType {
}


export type PageHandler_Accept_Params = PageHandler_Accept_ParamsMojoType;
mojo.internal.Struct<PageHandler_Accept_ParamsMojoType>(
    PageHandler_Accept_ParamsSpec.$,
    'PageHandler_Accept_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_Reject_ParamsMojoType {
}


export type PageHandler_Reject_Params = PageHandler_Reject_ParamsMojoType;
mojo.internal.Struct<PageHandler_Reject_ParamsMojoType>(
    PageHandler_Reject_ParamsSpec.$,
    'PageHandler_Reject_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RequestAccountInfo_ParamsMojoType {
}


export type PageHandler_RequestAccountInfo_Params = PageHandler_RequestAccountInfo_ParamsMojoType;
mojo.internal.Struct<PageHandler_RequestAccountInfo_ParamsMojoType>(
    PageHandler_RequestAccountInfo_ParamsSpec.$,
    'PageHandler_RequestAccountInfo_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_UpdateDialogHeight_ParamsMojoType {
  height: number;
}


export type PageHandler_UpdateDialogHeight_Params = PageHandler_UpdateDialogHeight_ParamsMojoType;
mojo.internal.Struct<PageHandler_UpdateDialogHeight_ParamsMojoType>(
    PageHandler_UpdateDialogHeight_ParamsSpec.$,
    'PageHandler_UpdateDialogHeight_Params',
    [
      mojo.internal.StructField<PageHandler_UpdateDialogHeight_ParamsMojoType, number>(
        'height', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SendAccountInfo_ParamsMojoType {
  accountInfo: AccountInfo;
}


export type Page_SendAccountInfo_Params = Page_SendAccountInfo_ParamsMojoType;
mojo.internal.Struct<Page_SendAccountInfo_ParamsMojoType>(
    Page_SendAccountInfo_ParamsSpec.$,
    'Page_SendAccountInfo_Params',
    [
      mojo.internal.StructField<Page_SendAccountInfo_ParamsMojoType, AccountInfo>(
        'accountInfo', 0,
        0,
        AccountInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SendScreenMode_ParamsMojoType {
  screenMode: ScreenMode;
}


export type Page_SendScreenMode_Params = Page_SendScreenMode_ParamsMojoType;
mojo.internal.Struct<Page_SendScreenMode_ParamsMojoType>(
    Page_SendScreenMode_ParamsSpec.$,
    'Page_SendScreenMode_Params',
    [
      mojo.internal.StructField<Page_SendScreenMode_ParamsMojoType, ScreenMode>(
        'screenMode', 0,
        0,
        ScreenModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



