// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"//resources/cr_elements/cr_toggle/cr_toggle.js";import"//resources/cr_elements/cr_checkbox/cr_checkbox.js";import"//resources/cr_elements/cr_collapse/cr_collapse.js";import"//resources/cr_elements/cr_expand_button/cr_expand_button.js";import{assert}from"//resources/js/assert.js";import{PluralStringProxyImpl}from"//resources/js/plural_string_proxy.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getInstance as getAnnouncerInstance}from"chrome://resources/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{I18nMixinLit}from"chrome://resources/cr_elements/i18n_mixin_lit.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{getCss}from"./data_section.css.js";import{getHtml}from"./data_section.html.js";function createEmptyContainer(){return{sectionTitle:"",dataItems:[],isTheme:false}}const UPDATE_REQUEST_COUNT=10;const DataSectionElementBase=I18nMixinLit(CrLitElement);export class DataSectionElement extends DataSectionElementBase{static get is(){return"data-section"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{dataContainer:{type:Object},title_:{type:String},titleWithoutCount_:{type:String},expanded_:{type:Boolean},disabled_:{type:Boolean},dataSelectedCount_:{type:Number}}}#dataContainer_accessor_storage=createEmptyContainer();get dataContainer(){return this.#dataContainer_accessor_storage}set dataContainer(value){this.#dataContainer_accessor_storage=value}#title__accessor_storage="";get title_(){return this.#title__accessor_storage}set title_(value){this.#title__accessor_storage=value}#titleWithoutCount__accessor_storage="";get titleWithoutCount_(){return this.#titleWithoutCount__accessor_storage}set titleWithoutCount_(value){this.#titleWithoutCount__accessor_storage=value}#expanded__accessor_storage=false;get expanded_(){return this.#expanded__accessor_storage}set expanded_(value){this.#expanded__accessor_storage=value}#disabled__accessor_storage=false;get disabled_(){return this.#disabled__accessor_storage}set disabled_(value){this.#disabled__accessor_storage=value}dataSelected=new Set;#dataSelectedCount__accessor_storage=0;get dataSelectedCount_(){return this.#dataSelectedCount__accessor_storage}set dataSelectedCount_(value){this.#dataSelectedCount__accessor_storage=value}intervalDurationOfUpdateHeightRequests_=null;collapseAnimationDuration_=0;async connectedCallback(){super.connectedCallback();this.initializeSectionOutput_();if(this.dataContainer.sectionTitle&&this.dataContainer.sectionTitle.length>0){this.titleWithoutCount_=await PluralStringProxyImpl.getInstance().getPluralString(this.dataContainer.sectionTitle,0)}}firstUpdated(){this.collapseAnimationDuration_=parseInt(getComputedStyle(this).getPropertyValue("--collapse-transition-duration"));this.intervalDurationOfUpdateHeightRequests_=this.collapseAnimationDuration_/UPDATE_REQUEST_COUNT}async willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("expanded_")&&this.intervalDurationOfUpdateHeightRequests_){setTimeout((()=>{this.updateViewHeightInterval_(this.intervalDurationOfUpdateHeightRequests_)}),this.intervalDurationOfUpdateHeightRequests_)}if(changedPrivateProperties.has("dataSelectedCount_")){if(this.dataContainer.sectionTitle&&this.dataContainer.sectionTitle.length>0){if(this.isThemeSection()){this.title_=this.i18n(this.dataContainer.sectionTitle,this.dataContainer.dataItems[0].title)}else{this.title_=await PluralStringProxyImpl.getInstance().getPluralString(this.dataContainer.sectionTitle,this.dataSelectedCount_)}}}}initializeSectionOutput_(){this.dataSelected.clear();assert(this.dataContainer.dataItems!==undefined&&this.dataContainer.dataItems.length!==0,"Sections should have at least one item to show.");this.dataContainer.dataItems.forEach((item=>{assert(!this.dataSelected.has(item.id),item.id+" already exists in this section."+" An Id should be unique per section");this.dataSelected.add(item.id)}));this.dataSelectedCount_=this.dataSelected.size}resetWithState_(disabled){if(disabled){this.dataSelected.clear();this.dataSelectedCount_=0}else{this.initializeSectionOutput_()}this.expanded_=false;this.disabled_=disabled}updateViewHeightInterval_(timeElapsed){this.fire("update-view-height");if(timeElapsed>=this.collapseAnimationDuration_){return}setTimeout((()=>{this.updateViewHeightInterval_(timeElapsed+this.intervalDurationOfUpdateHeightRequests_)}),this.intervalDurationOfUpdateHeightRequests_)}onExpandChanged_(e){this.expanded_=e.detail.value}onToggleChanged_(e){this.resetWithState_(!e.detail.value);this.fire("toggle-changed",{toggle:e.detail.value})}getToggleAriaLabel_(){const selectedStr=this.disabled_?this.i18n("selectAllScreenReader"):this.i18n("selectNoneScreenReader");return[this.titleWithoutCount_,selectedStr].join(". ")}isCheckboxChecked_(itemId){return this.dataSelected.has(itemId)}onCheckedChanged_(e){const currentTarget=e.currentTarget;const itemId=Number(currentTarget.dataset["id"]);if(e.detail){this.dataSelected.add(itemId)}else{this.dataSelected.delete(itemId)}this.dataSelectedCount_=this.dataSelected.size;if(this.dataSelectedCount_===0){this.resetWithState_(true);this.$.toggle.focus()}getAnnouncerInstance().announce(loadTimeData.getStringF("itemCountSelectedScreenReader",this.dataSelectedCount_))}onCheckboxFocused_(e){const currentTarget=e.currentTarget;const itemId=Number(currentTarget.dataset["id"]);if(this.dataSelectedCount_===1&&this.dataSelected.has(itemId)){getAnnouncerInstance().announce([this.titleWithoutCount_,this.i18n("lastItemSelectedScreenReader")].join(". "))}}isThemeSection(){return this.dataContainer.isTheme}isStrEmpty_(str){return!str||str.length===0}}customElements.define(DataSectionElement.is,DataSectionElement);