import type { ReadAloudSettingsChange, ReadAnythingSettingsChange } from './metrics_browser_proxy.js';
export declare enum TimeFrom {
    APP = "App",
    TOOLBAR = "Toolbar"
}
export declare enum SpeechControls {
    PLAY = "Play",
    PAUSE = "Pause",
    NEXT = "NextButton",
    PREVIOUS = "PreviousButton"
}
export declare class ReadAnythingLogger {
    private metrics;
    logEmptyState(): void;
    logSpeechStopSource(source: number): void;
    logSpeechError(errorCode: string): void;
    logTimeFrom(from: TimeFrom, startTime: number, endTime: number): void;
    logNewPage(speechPlayed: boolean): void;
    logHighlightGranularity(highlight: number): void;
    private logVoiceTypeUsedForReading_;
    private logLanguageUsedForReading_;
    logTextSettingsChange(settingsChange: ReadAnythingSettingsChange): void;
    logSpeechSettingsChange(settingsChange: ReadAloudSettingsChange): void;
    logVoiceSpeed(index: number): void;
    logSpeechPlaySession(startTime: number, voice: SpeechSynthesisVoice | null): void;
    logSpeechControlClick(control: SpeechControls): void;
    static getInstance(): ReadAnythingLogger;
    static setInstance(obj: ReadAnythingLogger): void;
}
