export declare enum ReadAnythingNewPage {
    NEW_PAGE = 0,
    SPEECH_PLAYED_ON_NEW_PAGE = 1,
    COUNT = 2
}
export declare enum ReadAnythingVoiceType {
    NATURAL = 0,
    ESPEAK = 1,
    CHROMEOS = 2,
    SYSTEM = 3,
    COUNT = 4
}
export declare enum ReadAnythingSettingsChange {
    FONT_CHANGE = 0,
    FONT_SIZE_CHANGE = 1,
    THEME_CHANGE = 2,
    LINE_HEIGHT_CHANGE = 3,
    LETTER_SPACING_CHANGE = 4,
    LINKS_ENABLED_CHANGE = 5,
    IMAGES_ENABLED_CHANGE = 6,
    COUNT = 7
}
export declare enum ReadAloudHighlightGranularity {
    HIGHLIGHT_AUTO = 0,
    HIGHLIGHT_OFF = 1,
    HIGHLIGHT_WORD = 2,
    HIGHLIGHT_PHRASE = 3,
    HIGHLIGHT_SENTENCE = 4,
    COUNT = 5
}
export declare enum ReadAloudSettingsChange {
    VOICE_SPEED_CHANGE = 0,
    VOICE_NAME_CHANGE = 1,
    HIGHLIGHT_CHANGE = 2,
    COUNT = 3
}
export declare enum ReadAnythingSpeechError {
    TEXT_TOO_LONG = 0,
    LANGUAGE_UNAVAILABLE = 1,
    VOICE_UNAVAILABE = 2,
    INVALID_ARGUMENT = 3,
    SYNTHESIS_FAILED = 4,
    SYNTHESIS_UNVAILABLE = 5,
    AUDIO_BUSY = 6,
    AUDIO_HARDWARE = 7,
    NETWORK = 8,
    COUNT = 9
}
export interface MetricsBrowserProxy {
    incrementMetricCount(action: string): void;
    recordEmptyState(): void;
    recordHighlightGranularity(highlight: number): void;
    recordLanguage(lang: string): void;
    recordNewPage(): void;
    recordNewPageWithSpeech(): void;
    recordSpeechError(error: ReadAnythingSpeechError): void;
    recordSpeechPlaybackLength(time: number): void;
    recordSpeechSettingsChange(settingsChange: ReadAloudSettingsChange): void;
    recordSpeechStopSource(source: number): void;
    recordTextSettingsChange(settingsChange: ReadAnythingSettingsChange): void;
    recordTime(umaName: string, time: number): void;
    recordVoiceSpeed(index: number): void;
    recordVoiceType(voiceType: ReadAnythingVoiceType): void;
    recordExtensionState(): void;
}
export declare class MetricsBrowserProxyImpl implements MetricsBrowserProxy {
    incrementMetricCount(umaName: string): void;
    recordEmptyState(): void;
    recordSpeechStopSource(source: number): void;
    recordSpeechError(error: ReadAnythingSpeechError): void;
    recordTime(umaName: string, time: number): void;
    recordNewPage(): void;
    recordNewPageWithSpeech(): void;
    recordHighlightGranularity(highlight: ReadAloudHighlightGranularity): void;
    recordVoiceType(voiceType: ReadAnythingVoiceType): void;
    recordLanguage(lang: string): void;
    recordTextSettingsChange(settingsChange: ReadAnythingSettingsChange): void;
    recordSpeechSettingsChange(settingsChange: ReadAloudSettingsChange): void;
    recordVoiceSpeed(index: number): void;
    recordSpeechPlaybackLength(time: number): void;
    recordExtensionState(): void;
    static getInstance(): MetricsBrowserProxy;
    static setInstance(obj: MetricsBrowserProxy): void;
}
