// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './simple_action_menu.js';
import { WebUiListenerMixinLit } from '//resources/cr_elements/web_ui_listener_mixin_lit.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { ReadAnythingSettingsChange } from '../shared/metrics_browser_proxy.js';
import { ReadAnythingLogger } from '../shared/read_anything_logger.js';
import { getHtml } from './letter_spacing_menu.html.js';
import { getIndexOfSetting } from './menu_util.js';
const LetterSpacingMenuElementBase = WebUiListenerMixinLit(CrLitElement);
// Stores and propagates the data for the letter spacing menu.
export class LetterSpacingMenuElement extends LetterSpacingMenuElementBase {
    static get is() {
        return 'letter-spacing-menu';
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return { settingsPrefs: { type: Object } };
    }
    #settingsPrefs_accessor_storage = {
        letterSpacing: 0,
        lineSpacing: 0,
        theme: 0,
        speechRate: 0,
        font: '',
        highlightGranularity: 0,
    };
    get settingsPrefs() { return this.#settingsPrefs_accessor_storage; }
    set settingsPrefs(value) { this.#settingsPrefs_accessor_storage = value; }
    options_ = [
        {
            title: loadTimeData.getString('letterSpacingStandardTitle'),
            icon: 'read-anything:letter-spacing-standard',
            data: chrome.readingMode.standardLetterSpacing,
        },
        {
            title: loadTimeData.getString('letterSpacingWideTitle'),
            icon: 'read-anything:letter-spacing-wide',
            data: chrome.readingMode.wideLetterSpacing,
        },
        {
            title: loadTimeData.getString('letterSpacingVeryWideTitle'),
            icon: 'read-anything:letter-spacing-very-wide',
            data: chrome.readingMode.veryWideLetterSpacing,
        },
    ];
    logger_ = ReadAnythingLogger.getInstance();
    open(anchor) {
        this.$.menu.open(anchor);
    }
    onLetterSpacingChange_(event) {
        chrome.readingMode.onLetterSpacingChange(event.detail.data);
        this.logger_.logTextSettingsChange(ReadAnythingSettingsChange.LETTER_SPACING_CHANGE);
    }
    restoredLetterSpacingIndex_() {
        return getIndexOfSetting(this.options_, this.settingsPrefs['letterSpacing']);
    }
}
customElements.define(LetterSpacingMenuElement.is, LetterSpacingMenuElement);
