// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './simple_action_menu.js';
import { WebUiListenerMixinLit } from '//resources/cr_elements/web_ui_listener_mixin_lit.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { ReadAloudSettingsChange } from '../shared/metrics_browser_proxy.js';
import { ReadAnythingLogger } from '../shared/read_anything_logger.js';
import { getHtml } from './highlight_menu.html.js';
import { getIndexOfSetting } from './menu_util.js';
const HighlightMenuElementBase = WebUiListenerMixinLit(CrLitElement);
// Stores and propagates the data for the highlight menu.
export class HighlightMenuElement extends HighlightMenuElementBase {
    static get is() {
        return 'highlight-menu';
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return { settingsPrefs: { type: Object } };
    }
    #settingsPrefs_accessor_storage = {
        letterSpacing: 0,
        lineSpacing: 0,
        theme: 0,
        speechRate: 0,
        font: '',
        highlightGranularity: 0,
    };
    get settingsPrefs() { return this.#settingsPrefs_accessor_storage; }
    set settingsPrefs(value) { this.#settingsPrefs_accessor_storage = value; }
    options_ = [
        {
            title: loadTimeData.getString('autoHighlightTitle'),
            data: chrome.readingMode.autoHighlighting,
        },
        {
            title: loadTimeData.getString('wordHighlightTitle'),
            data: chrome.readingMode.wordHighlighting,
        },
        ...(chrome.readingMode.isPhraseHighlightingEnabled ? [{
                title: loadTimeData.getString('phraseHighlightTitle'),
                data: chrome.readingMode.phraseHighlighting,
            }] : []),
        {
            title: loadTimeData.getString('sentenceHighlightTitle'),
            data: chrome.readingMode.sentenceHighlighting,
        },
        {
            title: loadTimeData.getString('noHighlightTitle'),
            data: chrome.readingMode.noHighlighting,
        },
    ];
    logger_ = ReadAnythingLogger.getInstance();
    open(anchor) {
        this.$.menu.open(anchor);
    }
    restoredHighlightIndex_() {
        return getIndexOfSetting(this.options_, this.settingsPrefs['highlightGranularity']);
    }
    onHighlightChange_(event) {
        chrome.readingMode.onHighlightGranularityChanged(event.detail.data);
        this.logger_.logSpeechSettingsChange(ReadAloudSettingsChange.HIGHLIGHT_CHANGE);
        this.logger_.logHighlightGranularity(event.detail.data);
    }
}
customElements.define(HighlightMenuElement.is, HighlightMenuElement);
