import './simple_action_menu.js';
import '//resources/cr_elements/md_select.css.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import type { SettingsPrefs } from '../shared/common.js';
import type { MenuStateItem } from './menu_util.js';
export interface FontSelectElement {
    $: {
        select: HTMLSelectElement;
    };
}
declare const FontSelectElementBase: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface) & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin_lit.js").WebUiListenerMixinLitInterface);
export declare class FontSelectElement extends FontSelectElementBase {
    static get is(): string;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        options: {
            type: ArrayConstructor;
        };
        settingsPrefs: {
            type: ObjectConstructor;
        };
        pageLanguage: {
            type: StringConstructor;
        };
        areFontsLoaded: {
            type: BooleanConstructor;
        };
    };
    accessor options: Array<MenuStateItem<string>>;
    accessor areFontsLoaded: boolean;
    accessor pageLanguage: string;
    accessor settingsPrefs: SettingsPrefs;
    private logger_;
    updated(changedProperties: PropertyValues<this>): void;
    constructor();
    protected onFontSelectValueChange_(event: Event): void;
    protected onKeyDown_(e: KeyboardEvent): void;
    private setFontOptions_;
    protected getFontItemLabel_(font: string): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'font-select': FontSelectElement;
    }
}
export {};
