import type { AncestorNode, ReadAloudNode } from '../read_aloud/read_aloud_types.js';
export declare const ESTIMATED_WORDS_PER_MS: number;
export declare const MIN_MS_TO_READ: number;
export declare class NodeStore {
    private domNodeToAxNodeIdMap_;
    private hiddenImageNodesIds_;
    private imageNodeIdsToFetch_;
    private textNodesSeen_;
    private countWordsTimer_?;
    private wordsSeenLastSavedTime_;
    private textNodeToAncestor_;
    clear(): void;
    clearDomNodes(): void;
    clearHiddenImageNodes(): void;
    estimateWordsSeenWithDelay(): void;
    private estimateTextShownSinceLastSave_;
    private estimateWordCount_;
    private saveWordsSeen_;
    hasAnyNode(nodes: ReadAloudNode[]): boolean;
    getDomNode(axNodeId: number): Node | undefined;
    setDomNode(domNode: Node, axNodeId: number): void;
    removeDomNode(domNode: Node): void;
    getAxId(domNode: Node): number | undefined;
    replaceDomNode(current: ChildNode, replacer: Node): void;
    hideImageNode(nodeId: number): void;
    areNodesAllHidden(nodes: ReadAloudNode[]): boolean;
    addImageToFetch(nodeId: number): void;
    hasImagesToFetch(): boolean;
    fetchImages(): void;
    setAncestor(node: ChildNode, ancestor: ParentNode, offsetInAncestor: number): void;
    getAncestor(node: Node): AncestorNode | undefined;
    static getInstance(): NodeStore;
    static setInstance(obj: NodeStore): void;
}
