import './icons.html.js';
import '../read_aloud/voice_selection_menu.js';
import '../menus/simple_action_menu.js';
import '../menus/color_menu.js';
import '../menus/font_menu.js';
import '../menus/font_select.js';
import '../menus/line_spacing_menu.js';
import '../menus/letter_spacing_menu.js';
import '../menus/highlight_menu.js';
import '../menus/rate_menu.js';
import '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import '//resources/cr_elements/icons.html.js';
import type { CrActionMenuElement } from '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrIconButtonElement } from '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { CrLazyRenderLitElement } from '//resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import { CrLitElement, type TemplateResult } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import type { ColorMenuElement } from '../menus/color_menu.js';
import type { FontMenuElement } from '../menus/font_menu.js';
import type { HighlightMenuElement } from '../menus/highlight_menu.js';
import type { LetterSpacingMenuElement } from '../menus/letter_spacing_menu.js';
import type { LineSpacingMenuElement } from '../menus/line_spacing_menu.js';
import type { RateMenuElement } from '../menus/rate_menu.js';
import type { VoiceSelectionMenuElement } from '../read_aloud/voice_selection_menu.js';
import type { SettingsPrefs } from '../shared/common.js';
export interface ReadAnythingToolbarElement {
    $: {
        rateMenu: RateMenuElement;
        colorMenu: ColorMenuElement;
        lineSpacingMenu: LineSpacingMenuElement;
        letterSpacingMenu: LetterSpacingMenuElement;
        fontMenu: FontMenuElement;
        fontSizeMenu: CrLazyRenderLitElement<CrActionMenuElement>;
        moreOptionsMenu: CrLazyRenderLitElement<CrActionMenuElement>;
        voiceSelectionMenu: VoiceSelectionMenuElement;
        highlightMenu: HighlightMenuElement;
        toolbarContainer: HTMLElement;
        more: CrIconButtonElement;
    };
}
interface MenuButton {
    id: string;
    icon: string;
    ariaLabel: string;
    openMenu: (target: HTMLElement) => void;
    announceBlock?: TemplateResult;
}
type ToggleButtonId = typeof LINK_TOGGLE_BUTTON_ID | typeof IMAGES_TOGGLE_BUTTON_ID;
interface ToggleButton {
    id: ToggleButtonId;
    icon: string;
    title: string;
}
export declare const moreOptionsClass = ".more-options-icon";
export declare const LINKS_ENABLED_ICON = "read-anything:links-enabled";
export declare const LINKS_DISABLED_ICON = "read-anything:links-disabled";
export declare const LINK_TOGGLE_BUTTON_ID = "link-toggle-button";
export declare const IMAGES_ENABLED_ICON = "read-anything:images-enabled";
export declare const IMAGES_DISABLED_ICON = "read-anything:images-disabled";
export declare const IMAGES_TOGGLE_BUTTON_ID = "images-toggle-button";
declare const ReadAnythingToolbarElementBase: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface) & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin_lit.js").WebUiListenerMixinLitInterface);
export declare class ReadAnythingToolbarElement extends ReadAnythingToolbarElementBase {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): TemplateResult<1>;
    static get properties(): {
        isSpeechActive: {
            type: BooleanConstructor;
        };
        isAudioCurrentlyPlaying: {
            type: BooleanConstructor;
        };
        isReadAloudPlayable: {
            type: BooleanConstructor;
        };
        selectedVoice: {
            type: ObjectConstructor;
        };
        availableVoices: {
            type: ArrayConstructor;
        };
        enabledLangs: {
            type: ArrayConstructor;
        };
        localeToDisplayName: {
            type: ObjectConstructor;
        };
        previewVoicePlaying: {
            type: ObjectConstructor;
        };
        settingsPrefs: {
            type: ObjectConstructor;
        };
        areFontsLoaded_: {
            type: BooleanConstructor;
        };
        textStyleOptions_: {
            type: ArrayConstructor;
        };
        textStyleToggles_: {
            type: ArrayConstructor;
        };
        hideSpinner_: {
            type: BooleanConstructor;
        };
        speechRate_: {
            type: NumberConstructor;
        };
        moreOptionsButtons_: {
            type: ArrayConstructor;
        };
        pageLanguage: {
            type: StringConstructor;
        };
    };
    accessor availableVoices: SpeechSynthesisVoice[];
    accessor enabledLangs: string[];
    accessor isSpeechActive: boolean;
    accessor isAudioCurrentlyPlaying: boolean;
    accessor isReadAloudPlayable: boolean;
    accessor localeToDisplayName: {
        [lang: string]: string;
    };
    accessor previewVoicePlaying: SpeechSynthesisVoice | null;
    accessor settingsPrefs: SettingsPrefs;
    accessor selectedVoice: SpeechSynthesisVoice | undefined;
    accessor pageLanguage: string;
    protected accessor hideSpinner_: boolean;
    protected isReadAloudEnabled_: boolean;
    protected accessor moreOptionsButtons_: MenuButton[];
    protected accessor speechRate_: number;
    protected accessor textStyleOptions_: MenuButton[];
    protected accessor textStyleToggles_: ToggleButton[];
    protected accessor areFontsLoaded_: boolean;
    private startTime_;
    private constructorTime_;
    private currentFocusId_;
    private windowResizeCallback_;
    private wasSpeechActive_;
    private spinnerDebouncerCallbackHandle_?;
    private logger_;
    private isSetupComplete_;
    updated(changedProperties: PropertyValues<this>): void;
    private maybeUpdateMoreOptions_;
    private hideElement_;
    private showElement_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    private initializeMenuButtons_;
    protected getHighlightButtonLabel_(): string;
    protected getFormattedSpeechRate_(): string;
    loadFontsStylesheet(): void;
    setFontsLoaded(): void;
    protected onResetToolbar_(): void;
    protected onToolbarOverflow_(event: CustomEvent<{
        numOverflowButtons: number;
        overflowLength: number;
    }>): void;
    restoreSettingsFromPrefs(): void;
    protected playPauseButtonAriaLabel_(): string;
    protected playPauseButtonTitle_(): string;
    protected playPauseButtonIronIcon_(): "read-anything-20:pause" | "read-anything-20:play";
    protected onNextGranularityClick_(): void;
    protected onPreviousGranularityClick_(): void;
    protected onTextStyleMenuButtonClickFromOverflow_(e: Event): void;
    protected onTextStyleMenuButtonClick_(e: Event): void;
    protected onShowRateMenuClick_(event: MouseEvent): void;
    protected onVoiceSelectionMenuClick_(event: MouseEvent): void;
    protected onMoreOptionsClick_(event: MouseEvent): void;
    protected onHighlightChange_(event: CustomEvent<{
        data: number;
    }>): void;
    protected onHighlightClick_(event: MouseEvent): void;
    private setHighlightButtonIcon_;
    protected onFontChange_(event: CustomEvent<{
        data: string;
    }>): void;
    protected onRateChange_(event: CustomEvent<{
        data: number;
    }>): void;
    protected onFontSizeIncreaseClick_(): void;
    protected onFontSizeDecreaseClick_(): void;
    protected onToggleButtonClick_(e: Event): void;
    private onToggleLinksClick_;
    private onToggleImagesClick_;
    private updateLinkToggleButton;
    private updateImagesToggleButton;
    private announceSizeChage;
    private restoreAnnounceState;
    private updateFontSize_;
    protected onFontResetClick_(): void;
    protected onPlayPauseClick_(): void;
    protected onToolbarKeyDown_(e: KeyboardEvent): void;
    protected onFontSizeMenuKeyDown_(e: KeyboardEvent): void;
    private getMoreOptionsButtons_;
    private onKeyDown_;
    private resetHideSpinnerDebouncer_;
    private onSpeechPlayingStateChanged_;
    private updateFocus_;
    protected getRateTabIndex_(): number;
    protected getToolbarAriaLabel_(): string;
    protected getVoiceSpeedLabel_(): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'read-anything-toolbar': ReadAnythingToolbarElement;
    }
}
export {};
