import './read_anything_toolbar.js';
import '/strings.m.js';
import '//read-anything-side-panel.top-chrome/shared/sp_empty_state.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_toast/cr_toast.js';
import '../read_aloud/language_toast.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { ContentListener, ContentState } from '../content/content_controller.js';
import type { LanguageToastElement } from '../read_aloud/language_toast.js';
import type { SpeechListener } from '../read_aloud/speech_controller.js';
import type { VoiceLanguageListener } from '../read_aloud/voice_language_controller.js';
import type { SettingsPrefs } from '../shared/common.js';
import type { ReadAnythingToolbarElement } from './read_anything_toolbar.js';
declare const AppElementBase: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin_lit.js").WebUiListenerMixinLitInterface);
export interface AppElement {
    $: {
        toolbar: ReadAnythingToolbarElement;
        appFlexParent: HTMLElement;
        container: HTMLElement;
        languageToast: LanguageToastElement;
        containerScroller: HTMLElement;
    };
}
export declare class AppElement extends AppElementBase implements SpeechListener, VoiceLanguageListener, ContentListener {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        isSpeechActive_: {
            type: BooleanConstructor;
        };
        isAudioCurrentlyPlaying_: {
            type: BooleanConstructor;
        };
        enabledLangs_: {
            type: ArrayConstructor;
        };
        settingsPrefs_: {
            type: ObjectConstructor;
        };
        selectedVoice_: {
            type: ObjectConstructor;
        };
        availableVoices_: {
            type: ArrayConstructor;
        };
        previewVoicePlaying_: {
            type: ObjectConstructor;
        };
        localeToDisplayName_: {
            type: ObjectConstructor;
        };
        contentState_: {
            type: ObjectConstructor;
        };
        speechEngineLoaded_: {
            type: BooleanConstructor;
        };
        willDrawAgainSoon_: {
            type: BooleanConstructor;
        };
        pageLanguage_: {
            type: StringConstructor;
        };
    };
    private startTime_;
    protected accessor contentState_: ContentState;
    private isReadAloudEnabled_;
    protected isDocsLoadMoreButtonVisible_: boolean;
    private accessor speechEngineLoaded_;
    private accessor willDrawAgainSoon_;
    protected accessor selectedVoice_: SpeechSynthesisVoice | null;
    protected accessor enabledLangs_: string[];
    protected accessor availableVoices_: SpeechSynthesisVoice[];
    protected accessor previewVoicePlaying_: SpeechSynthesisVoice | null;
    protected accessor localeToDisplayName_: {
        [locale: string]: string;
    };
    protected accessor pageLanguage_: string;
    private notificationManager_;
    private logger_;
    private styleUpdater_;
    private nodeStore_;
    private voiceLanguageController_;
    private speechController_;
    private contentController_;
    private selectionController_;
    protected accessor settingsPrefs_: SettingsPrefs;
    protected accessor isSpeechActive_: boolean;
    protected accessor isAudioCurrentlyPlaying_: boolean;
    constructor();
    disconnectedCallback(): void;
    connectedCallback(): void;
    protected onContainerScroll_(): void;
    protected onContainerScrollEnd_(): void;
    showLoading(): void;
    updateContent(): void;
    getSelection(): Selection | null;
    protected updateLinks_(): void;
    protected updateImages_(): void;
    protected onDocsLoadMoreButtonClick_(): void;
    protected onLanguageMenuOpen_(): void;
    protected onLanguageMenuClose_(): void;
    protected onPreviewVoice_(event: CustomEvent<{
        previewVoice: SpeechSynthesisVoice;
    }>): void;
    protected onVoiceMenuOpen_(event: CustomEvent): void;
    protected onVoiceMenuClose_(event: CustomEvent): void;
    protected onPlayPauseClick_(): void;
    onContentStateChange(): void;
    onNewPageDrawn(): void;
    onPlayingFromSelection(): void;
    onIsSpeechActiveChange(): void;
    onIsAudioCurrentlyPlayingChange(): void;
    onEngineStateChange(): void;
    onPreviewVoicePlaying(): void;
    onEnabledLangsChange(): void;
    onAvailableVoicesChange(): void;
    onCurrentVoiceChange(): void;
    protected onNextGranularityClick_(): void;
    protected onPreviousGranularityClick_(): void;
    protected onSelectVoice_(event: CustomEvent<{
        selectedVoice: SpeechSynthesisVoice;
    }>): void;
    protected onVoiceLanguageToggle_(event: CustomEvent<{
        language: string;
    }>): void;
    protected onSpeechRateChange_(): void;
    private restoreSettingsFromPrefs_;
    protected onLineSpacingChange_(): void;
    protected onLetterSpacingChange_(): void;
    protected onFontChange_(): void;
    protected onFontSizeChange_(): void;
    protected onThemeChange_(): void;
    protected onResetToolbar_(): void;
    protected onToolbarOverflow_(event: CustomEvent<{
        overflowLength: number;
    }>): void;
    protected onHighlightChange_(event: CustomEvent<{
        data: number;
    }>): void;
    languageChanged(): void;
    protected computeHasContent(): boolean;
    protected computeIsReadAloudPlayable(): boolean;
    protected onKeyDown_(e: KeyboardEvent): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'read-anything-app': AppElement;
    }
}
export {};
