import '//resources/cr_elements/cr_icon/cr_iconset.js';
import {getTrustedHTML} from '//resources/js/static_types.js';

const div = document.createElement('div');
div.innerHTML = getTrustedHTML`<cr-iconset name="read-anything" size="16">
  <svg>
    <defs>
      <g id="font-size" viewBox="0 0 16 16">
        <path d="M9.6 12.9333V4.8H6.4V3.06667H14.5333V4.8H11.3333V12.9333H9.6ZM3.46667 12.9333V8.11667H1.46667V6.4H7.2V8.11667H5.2V12.9333H3.46667Z"></path>
      </g>
      <g id="font-size-decrease" viewBox="0 0 16 16">
        <path d="M3.73333 8.7V7.3H12.2667V8.7H3.73333Z"></path>
      </g>
      <g id="font-size-increase-old" viewBox="0 0 14 8">
        <path d="M0.383333 8L3.46667 -9.53674e-07H5.06667L8.13333 8H6.53333L5.83333 6.01667H2.66667L1.93333 8H0.383333ZM3.08333 4.8H5.4L4.28333 1.58333H4.21667L3.08333 4.8ZM10.3833 6.46667V4.66667H8.58333V3.33333H10.3833V1.53333H11.7V3.33333H13.5V4.66667H11.7V6.46667H10.3833Z"></path>
      </g>
      <g id="font-size-decrease-old" viewBox="0 0 14 8">
        <path d="M0.383333 8L3.46667 -9.53674e-07H5.06667L8.13333 8H6.53333L5.83333 6.01667H2.66667L1.93333 8H0.383333ZM3.08333 4.8H5.4L4.28333 1.58333H4.21667L3.08333 4.8ZM8.61667 4.66667V3.33333H13.5V4.66667H8.61667Z"></path>
      </g>
      <g id="links-enabled" viewBox="0 0 18 18">
        <path d="M8.25 12.75H5.25C4.2125 12.75 3.32813 12.3844 2.59688 11.6531C1.86563 10.9219 1.5 10.0375 1.5 9C1.5 7.9625 1.86563 7.07813 2.59688 6.34688C3.32813 5.61563 4.2125 5.25 5.25 5.25H8.25V6.75H5.25C4.625 6.75 4.09375 6.96875 3.65625 7.40625C3.21875 7.84375 3 8.375 3 9C3 9.625 3.21875 10.1563 3.65625 10.5938C4.09375 11.0313 4.625 11.25 5.25 11.25H8.25V12.75ZM6 9.75V8.25H12V9.75H6ZM9.75 12.75V11.25H12.75C13.375 11.25 13.9063 11.0313 14.3438 10.5938C14.7813 10.1563 15 9.625 15 9C15 8.375 14.7813 7.84375 14.3438 7.40625C13.9063 6.96875 13.375 6.75 12.75 6.75H9.75V5.25H12.75C13.7875 5.25 14.6719 5.61563 15.4031 6.34688C16.1344 7.07813 16.5 7.9625 16.5 9C16.5 10.0375 16.1344 10.9219 15.4031 11.6531C14.6719 12.3844 13.7875 12.75 12.75 12.75H9.75Z">
      </g>
      <g id="links-disabled" viewBox="0 0 18 18">
        <path d="M14.4375 12.3375L13.3125 11.175C13.8125 11.0375 14.2187 10.7719 14.5312 10.3781C14.8437 9.98437 15 9.525 15 9C15 8.375 14.7812 7.84375 14.3437 7.40625C13.9062 6.96875 13.375 6.75 12.75 6.75H9.75V5.25H12.75C13.7875 5.25 14.6719 5.61562 15.4031 6.34687C16.1344 7.07812 16.5 7.9625 16.5 9C16.5 9.7125 16.3156 10.3687 15.9469 10.9687C15.5781 11.5687 15.075 12.025 14.4375 12.3375ZM11.8875 9.75L10.3875 8.25H12V9.75H11.8875ZM14.85 16.95L1.05 3.15L2.1 2.1L15.9 15.9L14.85 16.95ZM8.25 12.75H5.25C4.2125 12.75 3.32812 12.3844 2.59687 11.6531C1.86562 10.9219 1.5 10.0375 1.5 9C1.5 8.1375 1.7625 7.36875 2.2875 6.69375C2.8125 6.01875 3.4875 5.575 4.3125 5.3625L5.7 6.75H5.25C4.625 6.75 4.09375 6.96875 3.65625 7.40625C3.21875 7.84375 3 8.375 3 9C3 9.625 3.21875 10.1562 3.65625 10.5937C4.09375 11.0312 4.625 11.25 5.25 11.25H8.25V12.75ZM6 9.75V8.25H7.21875L8.7 9.75H6Z">
      </g>
      <g id="images-enabled" viewBox="0 0 16 16">
        <path d="M3.65003 13.7333C3.26114 13.7333 2.93336 13.6 2.6667 13.3333C2.40003 13.0556 2.2667 12.7278 2.2667 12.35V3.65C2.2667 3.27222 2.40003 2.95 2.6667 2.68333C2.93336 2.40556 3.26114 2.26667 3.65003 2.26667H12.35C12.7389 2.26667 13.0667 2.40556 13.3334 2.68333C13.6 2.95 13.7334 3.27222 13.7334 3.65V12.35C13.7334 12.7278 13.6 13.0556 13.3334 13.3333C13.0667 13.6 12.7389 13.7333 12.35 13.7333H3.65003ZM3.65003 12.35H12.35V3.65H3.65003V12.35ZM4.33336 11.25H11.6667L9.20003 7.91667L7.40003 10.3167L6.20003 8.71667L4.33336 11.25ZM3.65003 12.35V3.65V12.35Z"></path>
      </g>
      <g id="images-disabled" viewBox="0 0 16 16">
        <path d="M13.6 11.9L12.2167 10.5167V3.78333H5.48333L4.1 2.4H12.2167C12.5944 2.4 12.9167 2.53889 13.1833 2.81667C13.4611 3.08333 13.6 3.40556 13.6 3.78333V11.9ZM12.85 14.7L11.8333 13.6833H3.7C3.32222 13.6833 2.99444 13.55 2.71667 13.2833C2.45 13.0056 2.31667 12.6778 2.31667 12.3V4.18333L1.28333 3.15L2.16667 2.25L13.75 13.8333L12.85 14.7ZM4.23333 11.1667L6.05 8.7L7.5 10.5167L8 9.86667L3.7 5.58333V12.3H10.4167L9.3 11.1667H4.23333Z"></path>
      </g>
      <g id="font" viewBox="0 0 16 16">
        <path d="M4.21667 12H5.68333L6.4 9.98333H9.61667L10.3167 12H11.7833L8.76667 4H7.23333L4.21667 12ZM6.8 8.78333L7.96667 5.5H8.01667L9.16667 8.78333H6.8ZM2.85 14.5333C2.46111 14.5333 2.13333 14.4 1.86667 14.1333C1.6 13.8667 1.46667 13.5389 1.46667 13.15V2.85C1.46667 2.46111 1.6 2.13333 1.86667 1.86667C2.13333 1.6 2.46111 1.46667 2.85 1.46667H13.15C13.5389 1.46667 13.8667 1.6 14.1333 1.86667C14.4 2.13333 14.5333 2.46111 14.5333 2.85V13.15C14.5333 13.5389 14.4 13.8667 14.1333 14.1333C13.8667 14.4 13.5389 14.5333 13.15 14.5333H2.85ZM2.85 13.15H13.15V2.85H2.85V13.15ZM2.85 2.85V13.15V2.85Z"></path>
      </g>
      <g id="color" viewBox="0 0 16 16">
        <path d="M8 14.5333C7.1 14.5333 6.25 14.3667 5.45 14.0333C4.66111 13.6889 3.96667 13.2222 3.36667 12.6333C2.77778 12.0333 2.31111 11.3389 1.96667 10.55C1.63333 9.75 1.46667 8.9 1.46667 8C1.46667 7.08889 1.63889 6.23889 1.98333 5.45C2.32778 4.66111 2.8 3.97222 3.4 3.38333C4.01111 2.78333 4.72222 2.31667 5.53333 1.98333C6.34444 1.63889 7.20556 1.46667 8.11667 1.46667C9.00556 1.46667 9.83889 1.62222 10.6167 1.93333C11.3944 2.23333 12.0722 2.65 12.65 3.18333C13.2389 3.71667 13.7 4.34444 14.0333 5.06667C14.3667 5.77778 14.5333 6.54444 14.5333 7.36667C14.5333 8.44444 14.1556 9.37778 13.4 10.1667C12.6556 10.9444 11.7333 11.3333 10.6333 11.3333H9.6C9.52222 11.3333 9.45 11.3611 9.38333 11.4167C9.31667 11.4611 9.28333 11.5278 9.28333 11.6167C9.28333 11.7722 9.35556 11.8944 9.5 11.9833C9.65556 12.0611 9.73333 12.3333 9.73333 12.8C9.73333 13.2222 9.56667 13.6167 9.23333 13.9833C8.91111 14.35 8.5 14.5333 8 14.5333ZM4.45 8.6C4.72778 8.6 4.96111 8.50555 5.15 8.31667C5.35 8.11667 5.45 7.87778 5.45 7.6C5.45 7.32222 5.35 7.08889 5.15 6.9C4.96111 6.7 4.72778 6.6 4.45 6.6C4.17222 6.6 3.93333 6.7 3.73333 6.9C3.54444 7.08889 3.45 7.32222 3.45 7.6C3.45 7.87778 3.54444 8.11667 3.73333 8.31667C3.93333 8.50555 4.17222 8.6 4.45 8.6ZM6.41667 6.23333C6.69444 6.23333 6.92778 6.13889 7.11667 5.95C7.31667 5.75 7.41667 5.51111 7.41667 5.23333C7.41667 4.95555 7.31667 4.72222 7.11667 4.53333C6.92778 4.33333 6.69444 4.23333 6.41667 4.23333C6.13889 4.23333 5.9 4.33333 5.7 4.53333C5.51111 4.72222 5.41667 4.95555 5.41667 5.23333C5.41667 5.51111 5.51111 5.75 5.7 5.95C5.9 6.13889 6.13889 6.23333 6.41667 6.23333ZM9.58333 6.23333C9.86111 6.23333 10.0944 6.13889 10.2833 5.95C10.4833 5.75 10.5833 5.51111 10.5833 5.23333C10.5833 4.95555 10.4833 4.72222 10.2833 4.53333C10.0944 4.33333 9.86111 4.23333 9.58333 4.23333C9.30556 4.23333 9.06667 4.33333 8.86667 4.53333C8.67778 4.72222 8.58333 4.95555 8.58333 5.23333C8.58333 5.51111 8.67778 5.75 8.86667 5.95C9.06667 6.13889 9.30556 6.23333 9.58333 6.23333ZM11.5333 8.6C11.8111 8.6 12.0444 8.50555 12.2333 8.31667C12.4333 8.11667 12.5333 7.87778 12.5333 7.6C12.5333 7.32222 12.4333 7.08889 12.2333 6.9C12.0444 6.7 11.8111 6.6 11.5333 6.6C11.2556 6.6 11.0167 6.7 10.8167 6.9C10.6278 7.08889 10.5333 7.32222 10.5333 7.6C10.5333 7.87778 10.6278 8.11667 10.8167 8.31667C11.0167 8.50555 11.2556 8.6 11.5333 8.6ZM7.98333 13.15C8.09444 13.15 8.18333 13.1056 8.25 13.0167C8.31667 12.9278 8.35 12.8444 8.35 12.7667C8.35 12.5889 8.26667 12.4389 8.1 12.3167C7.93333 12.1944 7.85 11.9278 7.85 11.5167C7.85 11.0833 8 10.7167 8.3 10.4167C8.61111 10.1056 8.98333 9.95 9.41667 9.95H10.6333C11.3667 9.95 11.9667 9.7 12.4333 9.2C12.9111 8.68889 13.15 8.08333 13.15 7.38333C13.15 6.10556 12.6611 5.03333 11.6833 4.16667C10.7056 3.28889 9.51667 2.85 8.11667 2.85C6.65 2.85 5.40556 3.35 4.38333 4.35C3.36111 5.35 2.85 6.56667 2.85 8C2.85 9.43333 3.34444 10.65 4.33333 11.65C5.33333 12.65 6.55 13.15 7.98333 13.15Z"></path>
      </g>
      <g id="line-spacing" viewBox="0 0 16 16">
        <path d="M4.05 12.9333L1.46667 10.35L2.45 9.36667L3.36667 10.3V5.7L2.45 6.63333L1.46667 5.65L4.05 3.06667L6.65 5.65L5.66667 6.63333L4.75 5.7V10.3L5.66667 9.36667L6.65 10.35L4.05 12.9333ZM8.23333 12.1333V10.75H14.5333V12.1333H8.23333ZM8.23333 8.7V7.3H14.5333V8.7H8.23333ZM8.23333 5.25V3.86667H14.5333V5.25H8.23333Z"></path>
      </g>
      <g id="letter-spacing" viewBox="0 0 16 16">
        <path d="M4 14.5333L1.46667 12L4 9.48333L4.96667 10.45L4.11667 11.3167H11.8833L11.0333 10.45L12 9.48333L14.5333 12L12 14.5333L11.0333 13.55L11.8833 12.7H4.11667L4.96667 13.55L4 14.5333ZM4.58333 8.66667L7.3 1.46667H8.7L11.4167 8.66667H9.96667L9.35 6.9H6.61667L6 8.66667H4.58333ZM7 5.76667H8.98333L8.01667 2.96667H7.95L7 5.76667Z"></path>
      </g>
      <g id="line-spacing-standard" viewBox="0 0 20 20">
        <path d="M16.9998 5H2.99951V7.00003H16.9998V5Z"></path>
        <path d="M16.9998 9H2.99951V11H16.9998V9Z"></path>
        <path d="M16.9998 13H2.99951V15H16.9998V13Z"></path>
      </g>
       <g id="line-spacing-loose" viewBox="0 0 20 20">
        <path d="M16.9998 4H2.99951V6.00003H16.9998V4Z"></path>
        <path d="M16.9998 9H2.99951V11H16.9998V9Z"></path>
        <path d="M16.9998 14H2.99951V16H16.9998V14Z"></path>
      </g>
      <g id="line-spacing-very-loose" viewBox="0 0 20 20">
        <path d="M16.9998 3H2.99951V5.00003H16.9998V3Z"></path>
        <path d="M16.9998 9H2.99951V11H16.9998V9Z"></path>
        <path d="M16.9998 15H2.99951V17H16.9998V15Z"></path>
      </g>
      <g id="letter-spacing-standard" viewBox="0 0 14 10">
        <path d="M0.2 9.8V0.199999H1.4V9.8H0.2ZM8.6 9.8V0.199999H9.8V9.8H8.6ZM2.03333 8.2L4.43333 1.8H5.58333L7.98333 8.2H6.88333L6.31667 6.56667H3.73333L3.15 8.2H2.03333ZM4.05 5.63333H5.96667L5.03333 2.98333H4.98333L4.05 5.63333Z"></path>
      </g>
      <g id="letter-spacing-wide" viewBox="0 0 14 10">
        <path d="M0.4 9.8V0.199999H1.6V9.8H0.4ZM10.4 9.8V0.199999H11.6V9.8H10.4ZM3.03333 8.2L5.43333 1.8H6.58333L8.98333 8.2H7.88333L7.31667 6.56667H4.73333L4.15 8.2H3.03333ZM5.05 5.63333H6.96667L6.03333 2.98333H5.98333L5.05 5.63333Z"></path>
      </g>
      <g id="letter-spacing-very-wide" viewBox="0 0 14 10">
        <path d="M0.6 9.8V0.199999H1.8V9.8H0.6ZM12.2 9.8V0.199999H13.4V9.8H12.2ZM4.03333 8.2L6.43333 1.8H7.58333L9.98333 8.2H8.88333L8.31667 6.56667H5.73333L5.15 8.2H4.03333ZM6.05 5.63333H7.96667L7.03333 2.98333H6.98333L6.05 5.63333Z"></path>
      </g>
      <g id="highlight-on" viewBox="0 0 16 16">
        <path d="M9.91667 2.8H5.6V1.6H11.1167L9.91667 2.8ZM7.51667 5.2H3.2V4H8.71667L7.51667 5.2ZM5.11667 7.6H0.8V6.4H6.31667L5.11667 7.6ZM9.95 9.16667L8.45 7.65L5.23333 10.8667L6.75 12.3833L9.95 9.16667ZM9.31667 6.78333L10.8167 8.3L14.0167 5.1L12.5167 3.58333L9.31667 6.78333ZM8.03333 6.38333L11.2333 9.58333L7.6 13.2167C7.35556 13.4389 7.07222 13.5611 6.75 13.5833C6.43889 13.5944 6.17222 13.4889 5.95 13.2667L5.61667 13.6H2.41667L4.35 11.6667C4.11667 11.4444 4.00556 11.1722 4.01667 10.85C4.02778 10.5167 4.15556 10.2389 4.4 10.0167L8.03333 6.38333ZM8.03333 6.38333L11.6667 2.75C11.9 2.51667 12.1833 2.4 12.5167 2.4C12.85 2.4 13.1333 2.51667 13.3667 2.75L14.8667 4.25C15.1 4.48333 15.2167 4.76667 15.2167 5.1C15.2167 5.43333 15.1 5.71667 14.8667 5.95L11.2333 9.58333L8.03333 6.38333Z"></path>
      </g>
      <g id="highlight-off" viewBox="0 0 16 16  ">
        <path d="M9.13334 9.16669L7.63334 7.65002L4.41667 10.8667L5.93334 12.3834L9.13334 9.16669ZM8.50001 6.78336L10 8.30002L13.2 5.10002L11.7 3.58336L8.50001 6.78336ZM7.21667 6.38336L10.4167 9.58336L6.78334 13.2167C6.5389 13.4389 6.25556 13.5611 5.93334 13.5834C5.62223 13.5945 5.35556 13.4889 5.13334 13.2667L4.80001 13.6H1.60001L3.53334 11.6667C3.30001 11.4445 3.18889 11.1722 3.20001 10.85C3.21112 10.5167 3.3389 10.2389 3.58334 10.0167L7.21667 6.38336ZM7.21667 6.38336L10.85 2.75002C11.0833 2.51669 11.3667 2.40002 11.7 2.40002C12.0333 2.40002 12.3167 2.51669 12.55 2.75002L14.05 4.25002C14.2722 4.49447 14.3833 4.7778 14.3833 5.10002C14.3833 5.42225 14.2722 5.70558 14.05 5.95002L10.4167 9.58336L7.21667 6.38336Z"></path>
      </g>
      <g id="voice-selection" viewBox="0 0 16 16">
        <path
          d="M2.4 14.4V13.2C2.93333 13.2 3.45 13.1611 3.95 13.0833C4.46111 12.9944 4.96111 12.8556 5.45 12.6667C4.89444 12.5111 4.44444 12.2056 4.1 11.75C3.76667 11.2833 3.6 10.7611 3.6 10.1833V8.8H6.4V6.8H8.58333L6.28333 2.7L7.31667 2.1L9.61667 6.21667C9.83889 6.61667 9.83889 7.01667 9.61667 7.41667C9.39444 7.80556 9.05 8 8.58333 8H7.6V9C7.6 9.27778 7.5 9.51667 7.3 9.71667C7.11111 9.90556 6.87778 10 6.6 10H4.8V10.1833C4.8 10.5278 4.91111 10.8333 5.13333 11.1C5.35556 11.3556 5.63889 11.5111 5.98333 11.5667L6.28333 11.6167C6.76111 11.7056 7.03333 11.9889 7.1 12.4667C7.17778 12.9444 7.00556 13.2889 6.58333 13.5C5.92778 13.8222 5.25 14.0556 4.55 14.2C3.85 14.3333 3.13333 14.4 2.4 14.4ZM10.55 12.4L9.68333 11.5667C9.79444 11.4556 9.87778 11.3278 9.93333 11.1833C10 11.0389 10.0333 10.8833 10.0333 10.7167C10.0333 10.55 10 10.3944 9.93333 10.25C9.87778 10.1056 9.79444 9.97778 9.68333 9.86667L10.55 9.03333C10.7722 9.25556 10.9389 9.51111 11.05 9.8C11.1722 10.0778 11.2333 10.3833 11.2333 10.7167C11.2333 11.0389 11.1722 11.3444 11.05 11.6333C10.9389 11.9222 10.7722 12.1778 10.55 12.4ZM12.2333 14.1167L11.4 13.2333C11.7222 12.9111 11.9722 12.5389 12.15 12.1167C12.3389 11.6833 12.4333 11.2167 12.4333 10.7167C12.4333 10.2167 12.3389 9.75556 12.15 9.33333C11.9722 8.9 11.7222 8.52222 11.4 8.2L12.2333 7.31667C12.6667 7.75 13.0056 8.26111 13.25 8.85C13.5056 9.42778 13.6333 10.05 13.6333 10.7167C13.6333 11.3833 13.5056 12.0111 13.25 12.6C13.0056 13.1778 12.6667 13.6833 12.2333 14.1167Z">
        </path>
      </g>
  </svg>
</cr-iconset>
<cr-iconset name="read-anything-20" size="20">
  <svg>
    <defs>
      <g id="default-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="white" stroke="#C7C7C7"></circle>
        <path d="M10 19C14.9706 19 19 14.9706 19 10C19 5.02944 14.9706 1 10 1V19Z" fill="#3C3C3C"></path>
      </g>
      <g id="dark-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="#3C3C3C" stroke="#C7C7C7"></circle>
        <path d="M6 14L9.24324 6H10.7447L14 14H12.5465L11.7538 11.9441H8.24625L7.45345 14H6ZM11.3093 10.8045L10.3604 8.35754L10.036 7.44134H9.96396L9.63964 8.35754L8.69069 10.8045H11.3093Z" fill="#E3E3E3"></path>
      </g>
      <g id="blue-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="#D2E3FC" stroke="#C7C7C7"></circle>
        <path d="M6 14L9.24324 6H10.7447L14 14H12.5465L11.7538 11.9441H8.24625L7.45345 14H6ZM11.3093 10.8045L10.3604 8.35754L10.036 7.44134H9.96396L9.63964 8.35754L8.69069 10.8045H11.3093Z" fill="#1F1F1F"></path>
      </g>
      <g id="yellow-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="#FEEFC3" stroke="#C7C7C7"></circle>
        <path d="M6 14L9.24324 6H10.7447L14 14H12.5465L11.7538 11.9441H8.24625L7.45345 14H6ZM11.3093 10.8045L10.3604 8.35754L10.036 7.44134H9.96396L9.63964 8.35754L8.69069 10.8045H11.3093Z" fill="#1F1F1F"></path>
      </g>
      <g id="light-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="white" stroke="#C7C7C7"></circle>
        <path d="M6 14L9.24324 6H10.7447L14 14H12.5465L11.7538 11.9441H8.24625L7.45345 14H6ZM11.3093 10.8045L10.3604 8.35754L10.036 7.44134H9.96396L9.63964 8.35754L8.69069 10.8045H11.3093Z" fill="#1F1F1F"></path>
      </g>
      <g id="high-contrast-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="#3C3C3C" stroke="#C7C7C7"></circle>
        <path d="M6 14L9.24324 6H10.7447L14 14H12.5465L11.7538 11.9441H8.24625L7.45345 14H6ZM11.3093 10.8045L10.3604 8.35754L10.036 7.44134H9.96396L9.63964 8.35754L8.69069 10.8045H11.3093Z" fill="#FFFF00"></path>
      </g>
      <g id="low-contrast-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="#1f1f1f" stroke="#C7C7C7"></circle>
        <path d="M6 14L9.24324 6H10.7447L14 14H12.5465L11.7538 11.9441H8.24625L7.45345 14H6ZM11.3093 10.8045L10.3604 8.35754L10.036 7.44134H9.96396L9.63964 8.35754L8.69069 10.8045H11.3093Z" fill="#8f8f8f"></path>
      </g>
      <g id="sepia-light-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="#E3D5CA" stroke="#C7C7C7"></circle>
        <path d="M6 14L9.24324 6H10.7447L14 14H12.5465L11.7538 11.9441H8.24625L7.45345 14H6ZM11.3093 10.8045L10.3604 8.35754L10.036 7.44134H9.96396L9.63964 8.35754L8.69069 10.8045H11.3093Z" fill="#624E41"></path>
      </g>
      <g id="sepia-dark-theme" viewBox="0 0 20 20">
        <circle cx="10" cy="10" r="9.5" fill="#302B26" stroke="#C7C7C7"></circle>
        <path d="M6 14L9.24324 6H10.7447L14 14H12.5465L11.7538 11.9441H8.24625L7.45345 14H6ZM11.3093 10.8045L10.3604 8.35754L10.036 7.44134H9.96396L9.63964 8.35754L8.69069 10.8045H11.3093Z" fill="#9B958D"></path>
      </g>
      <g id="check-mark" viewBox="0 0 20 20">
        <path d="M8.22917 14.0625L4.70833 10.5208L5.75 9.47917L8.22917 11.9375L14.25 5.9375L15.2917 7L8.22917 14.0625Z"></path>
      </g>
      <g id="play" viewBox="0 0 18 18">
        <path d="M6.95833 12.5625L12.5625 9L6.95833 5.4375V12.5625ZM9 17.1667C7.875 17.1667 6.8125 16.9583 5.8125 16.5417C4.82639 16.1111 3.95833 15.5278 3.20833 14.7917C2.47222 14.0417 1.88889 13.1736 1.45833 12.1875C1.04167 11.1875 0.833333 10.125 0.833333 9C0.833333 7.86111 1.04167 6.79861 1.45833 5.8125C1.88889 4.82639 2.47222 3.96528 3.20833 3.22917C3.95833 2.47917 4.82639 1.89583 5.8125 1.47917C6.8125 1.04861 7.875 0.833333 9 0.833333C10.1389 0.833333 11.2014 1.04861 12.1875 1.47917C13.1736 1.89583 14.0347 2.47917 14.7708 3.22917C15.5208 3.96528 16.1042 4.83333 16.5208 5.83333C16.9514 6.81944 17.1667 7.875 17.1667 9C17.1667 10.125 16.9514 11.1875 16.5208 12.1875C16.1042 13.1736 15.5208 14.0417 14.7708 14.7917C14.0347 15.5278 13.1667 16.1111 12.1667 16.5417C11.1806 16.9583 10.125 17.1667 9 17.1667Z"></path>
      </g>
      <g id="pause" viewBox="0 0 18 18">
        <path d="M6.41667 12.0417H8V5.95833H6.41667V12.0417ZM10 12.0417H11.5833V5.95833H10V12.0417ZM9 17.1667C7.875 17.1667 6.8125 16.9583 5.8125 16.5417C4.82639 16.1111 3.95833 15.5278 3.20833 14.7917C2.47222 14.0417 1.88889 13.1736 1.45833 12.1875C1.04167 11.1875 0.833333 10.125 0.833333 9C0.833333 7.86111 1.04167 6.79861 1.45833 5.8125C1.88889 4.82639 2.47222 3.96528 3.20833 3.22917C3.95833 2.47917 4.82639 1.89583 5.8125 1.47917C6.8125 1.04861 7.875 0.833333 9 0.833333C10.1389 0.833333 11.2014 1.04861 12.1875 1.47917C13.1736 1.89583 14.0347 2.47917 14.7708 3.22917C15.5208 3.96528 16.1042 4.83333 16.5208 5.83333C16.9514 6.81944 17.1667 7.875 17.1667 9C17.1667 10.125 16.9514 11.1875 16.5208 12.1875C16.1042 13.1736 15.5208 14.0417 14.7708 14.7917C14.0347 15.5278 13.1667 16.1111 12.1667 16.5417C11.1806 16.9583 10.125 17.1667 9 17.1667Z"></path>
      </g>
      <g id="play-circle" viewBox="0 0 16 16">
        <path
          d="M6.36667 10.85L10.85 8L6.36667 5.15V10.85ZM8 14.5333C7.1 14.5333 6.25 14.3667 5.45 14.0333C4.66111 13.6889 3.96667 13.2222 3.36667 12.6333C2.77778 12.0333 2.31111 11.3389 1.96667 10.55C1.63333 9.75 1.46667 8.9 1.46667 8C1.46667 7.08889 1.63333 6.23889 1.96667 5.45C2.31111 4.66111 2.77778 3.97222 3.36667 3.38333C3.96667 2.78333 4.66111 2.31667 5.45 1.98333C6.25 1.63889 7.1 1.46667 8 1.46667C8.91111 1.46667 9.76111 1.63889 10.55 1.98333C11.3389 2.31667 12.0278 2.78333 12.6167 3.38333C13.2167 3.97222 13.6833 4.66667 14.0167 5.46667C14.3611 6.25556 14.5333 7.1 14.5333 8C14.5333 8.9 14.3611 9.75 14.0167 10.55C13.6833 11.3389 13.2167 12.0333 12.6167 12.6333C12.0278 13.2222 11.3333 13.6889 10.5333 14.0333C9.74444 14.3667 8.9 14.5333 8 14.5333ZM8 13.15C9.43333 13.15 10.65 12.65 11.65 11.65C12.65 10.65 13.15 9.43333 13.15 8C13.15 6.56667 12.65 5.35 11.65 4.35C10.65 3.35 9.43333 2.85 8 2.85C6.56667 2.85 5.35 3.35 4.35 4.35C3.35 5.35 2.85 6.56667 2.85 8C2.85 9.43333 3.35 10.65 4.35 11.65C5.35 12.65 6.56667 13.15 8 13.15Z">
        </path>
      </g>
      <g id="stop-circle" viewBox="0 0 16 16">
        <path
          d="M5.56667 10.4333H10.4333V5.56667H5.56667V10.4333ZM8 14.5333C7.1 14.5333 6.25 14.3667 5.45 14.0333C4.66111 13.6889 3.96667 13.2222 3.36667 12.6333C2.77778 12.0333 2.31111 11.3389 1.96667 10.55C1.63333 9.75 1.46667 8.9 1.46667 8C1.46667 7.08889 1.63333 6.23889 1.96667 5.45C2.31111 4.66111 2.77778 3.97222 3.36667 3.38333C3.96667 2.78333 4.66111 2.31667 5.45 1.98333C6.25 1.63889 7.1 1.46667 8 1.46667C8.91111 1.46667 9.76111 1.63889 10.55 1.98333C11.3389 2.31667 12.0278 2.78333 12.6167 3.38333C13.2167 3.97222 13.6833 4.66667 14.0167 5.46667C14.3611 6.25556 14.5333 7.1 14.5333 8C14.5333 8.9 14.3611 9.75 14.0167 10.55C13.6833 11.3389 13.2167 12.0333 12.6167 12.6333C12.0278 13.2222 11.3333 13.6889 10.5333 14.0333C9.74444 14.3667 8.9 14.5333 8 14.5333ZM8 13.15C9.43333 13.15 10.65 12.65 11.65 11.65C12.65 10.65 13.15 9.43333 13.15 8C13.15 6.56667 12.65 5.35 11.65 4.35C10.65 3.35 9.43333 2.85 8 2.85C6.56667 2.85 5.35 3.35 4.35 4.35C3.35 5.35 2.85 6.56667 2.85 8C2.85 9.43333 3.35 10.65 4.35 11.65C5.35 12.65 6.56667 13.15 8 13.15Z">
        </path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
  document.head.appendChild(iconset);
}
