import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { Url as url_mojom_Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export declare const ActionIdSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ActionId {
    MIN_VALUE = 0,
    MAX_VALUE = 25,
    kShowBookmarks = 0,
    kShowHistoryCluster = 1,
    kShowReadAnything = 2,
    kShowReadingList = 3,
    kShowLensOverlay = 4,
    kShowSearchCompanion = 5,
    kHome = 6,
    kForward = 7,
    kNewIncognitoWindow = 8,
    kShowPasswordManager = 9,
    kShowPaymentMethods = 10,
    kShowAddresses = 11,
    kShowDownloads = 12,
    kClearBrowsingData = 13,
    kPrint = 14,
    kShowTranslate = 15,
    kSendTabToSelf = 16,
    kQrCodeGenerator = 17,
    kRouteMedia = 18,
    kTaskManager = 19,
    kDevTools = 20,
    kShowChromeLabs = 21,
    kCopyLink = 22,
    kTabSearch = 23,
    kSplitTab = 24,
    kContextualTasks = 25
}
export declare const CategoryIdSpec: {
    $: mojo.internal.MojomType;
};
export declare enum CategoryId {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kNavigation = 0,
    kYourChrome = 1,
    kTools = 2
}
export type CustomizeToolbarHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarHandlerFactoryPendingReceiver>;
export declare class CustomizeToolbarHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<CustomizeToolbarHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | CustomizeToolbarHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface CustomizeToolbarHandlerFactoryInterface {
    createCustomizeToolbarHandler(client: CustomizeToolbarClientRemote, handler: CustomizeToolbarHandlerPendingReceiver): void;
}
export declare class CustomizeToolbarHandlerFactoryRemote implements CustomizeToolbarHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeToolbarHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | CustomizeToolbarHandlerFactoryPendingReceiverEndpoint);
    createCustomizeToolbarHandler(client: CustomizeToolbarClientRemote, handler: CustomizeToolbarHandlerPendingReceiver): void;
}
/**
 * An object which receives request messages for the CustomizeToolbarHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class CustomizeToolbarHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<CustomizeToolbarHandlerFactoryRemote, CustomizeToolbarHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: CustomizeToolbarHandlerFactoryInterface);
}
export declare class CustomizeToolbarHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): CustomizeToolbarHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the CustomizeToolbarHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class CustomizeToolbarHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<CustomizeToolbarHandlerFactoryRemote, CustomizeToolbarHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createCustomizeToolbarHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type CustomizeToolbarHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarHandlerPendingReceiver>;
export declare class CustomizeToolbarHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<CustomizeToolbarHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarHandlerPendingReceiver>;
    constructor(handle: MojoHandle | CustomizeToolbarHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface CustomizeToolbarHandlerInterface {
    listActions(): Promise<{
        actions: Action[];
    }>;
    listCategories(): Promise<{
        categories: Category[];
    }>;
    pinAction(actionId: ActionId, pinned: boolean): void;
    getIsCustomized(): Promise<{
        customized: boolean;
    }>;
    resetToDefault(): void;
}
export declare class CustomizeToolbarHandlerRemote implements CustomizeToolbarHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeToolbarHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | CustomizeToolbarHandlerPendingReceiverEndpoint);
    listActions(): Promise<{
        actions: Action[];
    }>;
    listCategories(): Promise<{
        categories: Category[];
    }>;
    pinAction(actionId: ActionId, pinned: boolean): void;
    getIsCustomized(): Promise<{
        customized: boolean;
    }>;
    resetToDefault(): void;
}
/**
 * An object which receives request messages for the CustomizeToolbarHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class CustomizeToolbarHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<CustomizeToolbarHandlerRemote, CustomizeToolbarHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: CustomizeToolbarHandlerInterface);
}
export declare class CustomizeToolbarHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): CustomizeToolbarHandlerRemote;
}
/**
 * An object which receives request messages for the CustomizeToolbarHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class CustomizeToolbarHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<CustomizeToolbarHandlerRemote, CustomizeToolbarHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    listActions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    listCategories: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    pinAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getIsCustomized: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    resetToDefault: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type CustomizeToolbarClientPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarClientPendingReceiver>;
export declare class CustomizeToolbarClientPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<CustomizeToolbarClient> {
    handle: mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarClientPendingReceiver>;
    constructor(handle: MojoHandle | CustomizeToolbarClientPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface CustomizeToolbarClientInterface {
    setActionPinned(actionId: ActionId, pinned: boolean): void;
    notifyActionsUpdated(): void;
}
export declare class CustomizeToolbarClientRemote implements CustomizeToolbarClientInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeToolbarClientPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | CustomizeToolbarClientPendingReceiverEndpoint);
    setActionPinned(actionId: ActionId, pinned: boolean): void;
    notifyActionsUpdated(): void;
}
/**
 * An object which receives request messages for the CustomizeToolbarClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class CustomizeToolbarClientReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<CustomizeToolbarClientRemote, CustomizeToolbarClientPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: CustomizeToolbarClientInterface);
}
export declare class CustomizeToolbarClient {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): CustomizeToolbarClientRemote;
}
/**
 * An object which receives request messages for the CustomizeToolbarClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class CustomizeToolbarClientCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<CustomizeToolbarClientRemote, CustomizeToolbarClientPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    setActionPinned: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifyActionsUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const ActionSpec: {
    $: mojo.internal.MojomType;
};
export declare const CategorySpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandler_ListActions_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandler_ListActions_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandler_ListCategories_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandler_ListCategories_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandler_PinAction_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandler_GetIsCustomized_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandler_GetIsCustomized_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarHandler_ResetToDefault_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarClient_SetActionPinned_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CustomizeToolbarClient_NotifyActionsUpdated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface ActionMojoType {
    id: ActionId;
    pinned: boolean;
    hasEnterpriseControlledPinnedState: boolean;
    displayName: string;
    category: CategoryId;
    iconUrl: url_mojom_Url;
}
export type Action = ActionMojoType;
export interface CategoryMojoType {
    id: CategoryId;
    displayName: string;
}
export type Category = CategoryMojoType;
export interface CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsMojoType {
    client: CustomizeToolbarClientRemote;
    handler: CustomizeToolbarHandlerPendingReceiver;
}
export type CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params = CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsMojoType;
export interface CustomizeToolbarHandler_ListActions_ParamsMojoType {
}
export type CustomizeToolbarHandler_ListActions_Params = CustomizeToolbarHandler_ListActions_ParamsMojoType;
export interface CustomizeToolbarHandler_ListActions_ResponseParamsMojoType {
    actions: Action[];
}
export type CustomizeToolbarHandler_ListActions_ResponseParams = CustomizeToolbarHandler_ListActions_ResponseParamsMojoType;
export interface CustomizeToolbarHandler_ListCategories_ParamsMojoType {
}
export type CustomizeToolbarHandler_ListCategories_Params = CustomizeToolbarHandler_ListCategories_ParamsMojoType;
export interface CustomizeToolbarHandler_ListCategories_ResponseParamsMojoType {
    categories: Category[];
}
export type CustomizeToolbarHandler_ListCategories_ResponseParams = CustomizeToolbarHandler_ListCategories_ResponseParamsMojoType;
export interface CustomizeToolbarHandler_PinAction_ParamsMojoType {
    actionId: ActionId;
    pinned: boolean;
}
export type CustomizeToolbarHandler_PinAction_Params = CustomizeToolbarHandler_PinAction_ParamsMojoType;
export interface CustomizeToolbarHandler_GetIsCustomized_ParamsMojoType {
}
export type CustomizeToolbarHandler_GetIsCustomized_Params = CustomizeToolbarHandler_GetIsCustomized_ParamsMojoType;
export interface CustomizeToolbarHandler_GetIsCustomized_ResponseParamsMojoType {
    customized: boolean;
}
export type CustomizeToolbarHandler_GetIsCustomized_ResponseParams = CustomizeToolbarHandler_GetIsCustomized_ResponseParamsMojoType;
export interface CustomizeToolbarHandler_ResetToDefault_ParamsMojoType {
}
export type CustomizeToolbarHandler_ResetToDefault_Params = CustomizeToolbarHandler_ResetToDefault_ParamsMojoType;
export interface CustomizeToolbarClient_SetActionPinned_ParamsMojoType {
    actionId: ActionId;
    pinned: boolean;
}
export type CustomizeToolbarClient_SetActionPinned_Params = CustomizeToolbarClient_SetActionPinned_ParamsMojoType;
export interface CustomizeToolbarClient_NotifyActionsUpdated_ParamsMojoType {
}
export type CustomizeToolbarClient_NotifyActionsUpdated_Params = CustomizeToolbarClient_NotifyActionsUpdated_ParamsMojoType;
