// chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TokenSpec as mojoBase_mojom_TokenSpec,
  Token as mojoBase_mojom_Token
} from '//resources/mojo/mojo/public/mojom/base/token.mojom-webui.js';
import {
  SkColorSpec as skia_mojom_SkColorSpec,
  SkColor as skia_mojom_SkColor
} from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const DescriptorDNameSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum DescriptorDName {

  MIN_VALUE = 0,
  MAX_VALUE = 0,
  kYellow = 0,
}

export const WallpaperSearchStatusSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum WallpaperSearchStatus {

  MIN_VALUE = 0,
  MAX_VALUE = 4,
  kOk = 0,
  kError = 1,
  kRequestThrottled = 2,
  kOffline = 3,
  kSignedOut = 4,
}

export const UserFeedbackSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UserFeedback {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnspecified = 0,
  kThumbsUp = 1,
  kThumbsDown = 2,
}



export type WallpaperSearchHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<WallpaperSearchHandlerFactoryPendingReceiver>;

export class WallpaperSearchHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<WallpaperSearchHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<WallpaperSearchHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|WallpaperSearchHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.customize_chrome.mojom.WallpaperSearchHandlerFactory',
        scope);
  }
}

export interface WallpaperSearchHandlerFactoryInterface {
  createWallpaperSearchHandler(client: WallpaperSearchClientRemote, handler: WallpaperSearchHandlerPendingReceiver): void;
}

export class WallpaperSearchHandlerFactoryRemote implements WallpaperSearchHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<WallpaperSearchHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<WallpaperSearchHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|WallpaperSearchHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WallpaperSearchHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createWallpaperSearchHandler(
      client: WallpaperSearchClientRemote,
      handler: WallpaperSearchHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsSpec.$,
        null,
        [
          client,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WallpaperSearchHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WallpaperSearchHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WallpaperSearchHandlerFactoryRemote, WallpaperSearchHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WallpaperSearchHandlerFactoryRemote, WallpaperSearchHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: WallpaperSearchHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WallpaperSearchHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsSpec.$,
        null,
        impl.createWallpaperSearchHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WallpaperSearchHandlerFactory {
  static get $interfaceName(): string {
    return "side_panel.customize_chrome.mojom.WallpaperSearchHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): WallpaperSearchHandlerFactoryRemote {
    let remote = new WallpaperSearchHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the WallpaperSearchHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WallpaperSearchHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WallpaperSearchHandlerFactoryRemote, WallpaperSearchHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WallpaperSearchHandlerFactoryRemote, WallpaperSearchHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createWallpaperSearchHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WallpaperSearchHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createWallpaperSearchHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsSpec.$,
        null,
        this.createWallpaperSearchHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type WallpaperSearchHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<WallpaperSearchHandlerPendingReceiver>;

export class WallpaperSearchHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<WallpaperSearchHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<WallpaperSearchHandlerPendingReceiver>;
  constructor(handle: MojoHandle|WallpaperSearchHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.customize_chrome.mojom.WallpaperSearchHandler',
        scope);
  }
}

export interface WallpaperSearchHandlerInterface {
  getDescriptors(): Promise<{
        descriptors: (Descriptors | null), }>;
  getInspirations(): Promise<{
        inspirationGroups: (InspirationGroup[] | null), }>;
  getWallpaperSearchResults(resultDescriptors: ResultDescriptors): Promise<{
        status: WallpaperSearchStatus,
        results: WallpaperSearchResult[], }>;
  setResultRenderTime(resultIds: mojoBase_mojom_Token[], time: number): void;
  setBackgroundToHistoryImage(resultId: mojoBase_mojom_Token, descriptors: ResultDescriptors): void;
  setBackgroundToInspirationImage(id: mojoBase_mojom_Token, backgroundUrl: url_mojom_Url): void;
  setBackgroundToWallpaperSearchResult(resultId: mojoBase_mojom_Token, time: number, descriptors: ResultDescriptors): void;
  updateHistory(): void;
  setUserFeedback(selectedOption: UserFeedback): void;
  openHelpArticle(): void;
  launchHatsSurvey(): void;
}

export class WallpaperSearchHandlerRemote implements WallpaperSearchHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<WallpaperSearchHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<WallpaperSearchHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|WallpaperSearchHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WallpaperSearchHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getDescriptors(): Promise<{
        descriptors: (Descriptors | null), }> {
    return this.proxy.sendMessage(
        0,
        WallpaperSearchHandler_GetDescriptors_ParamsSpec.$,
        WallpaperSearchHandler_GetDescriptors_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getInspirations(): Promise<{
        inspirationGroups: (InspirationGroup[] | null), }> {
    return this.proxy.sendMessage(
        1,
        WallpaperSearchHandler_GetInspirations_ParamsSpec.$,
        WallpaperSearchHandler_GetInspirations_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getWallpaperSearchResults(
      resultDescriptors: ResultDescriptors): Promise<{
        status: WallpaperSearchStatus,
        results: WallpaperSearchResult[], }> {
    return this.proxy.sendMessage(
        2,
        WallpaperSearchHandler_GetWallpaperSearchResults_ParamsSpec.$,
        WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsSpec.$,
        [
          resultDescriptors
        ],
        false);
  }

  setResultRenderTime(
      resultIds: mojoBase_mojom_Token[],
      time: number): void {
    this.proxy.sendMessage(
        3,
        WallpaperSearchHandler_SetResultRenderTime_ParamsSpec.$,
        null,
        [
          resultIds,
          time
        ],
        false);
  }

  setBackgroundToHistoryImage(
      resultId: mojoBase_mojom_Token,
      descriptors: ResultDescriptors): void {
    this.proxy.sendMessage(
        4,
        WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsSpec.$,
        null,
        [
          resultId,
          descriptors
        ],
        false);
  }

  setBackgroundToInspirationImage(
      id: mojoBase_mojom_Token,
      backgroundUrl: url_mojom_Url): void {
    this.proxy.sendMessage(
        5,
        WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsSpec.$,
        null,
        [
          id,
          backgroundUrl
        ],
        false);
  }

  setBackgroundToWallpaperSearchResult(
      resultId: mojoBase_mojom_Token,
      time: number,
      descriptors: ResultDescriptors): void {
    this.proxy.sendMessage(
        6,
        WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsSpec.$,
        null,
        [
          resultId,
          time,
          descriptors
        ],
        false);
  }

  updateHistory(): void {
    this.proxy.sendMessage(
        7,
        WallpaperSearchHandler_UpdateHistory_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setUserFeedback(
      selectedOption: UserFeedback): void {
    this.proxy.sendMessage(
        8,
        WallpaperSearchHandler_SetUserFeedback_ParamsSpec.$,
        null,
        [
          selectedOption
        ],
        false);
  }

  openHelpArticle(): void {
    this.proxy.sendMessage(
        9,
        WallpaperSearchHandler_OpenHelpArticle_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  launchHatsSurvey(): void {
    this.proxy.sendMessage(
        10,
        WallpaperSearchHandler_LaunchHatsSurvey_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WallpaperSearchHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WallpaperSearchHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WallpaperSearchHandlerRemote, WallpaperSearchHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WallpaperSearchHandlerRemote, WallpaperSearchHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: WallpaperSearchHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WallpaperSearchHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WallpaperSearchHandler_GetDescriptors_ParamsSpec.$,
        WallpaperSearchHandler_GetDescriptors_ResponseParamsSpec.$,
        impl.getDescriptors.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WallpaperSearchHandler_GetInspirations_ParamsSpec.$,
        WallpaperSearchHandler_GetInspirations_ResponseParamsSpec.$,
        impl.getInspirations.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WallpaperSearchHandler_GetWallpaperSearchResults_ParamsSpec.$,
        WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsSpec.$,
        impl.getWallpaperSearchResults.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WallpaperSearchHandler_SetResultRenderTime_ParamsSpec.$,
        null,
        impl.setResultRenderTime.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsSpec.$,
        null,
        impl.setBackgroundToHistoryImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsSpec.$,
        null,
        impl.setBackgroundToInspirationImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsSpec.$,
        null,
        impl.setBackgroundToWallpaperSearchResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WallpaperSearchHandler_UpdateHistory_ParamsSpec.$,
        null,
        impl.updateHistory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WallpaperSearchHandler_SetUserFeedback_ParamsSpec.$,
        null,
        impl.setUserFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        WallpaperSearchHandler_OpenHelpArticle_ParamsSpec.$,
        null,
        impl.openHelpArticle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        WallpaperSearchHandler_LaunchHatsSurvey_ParamsSpec.$,
        null,
        impl.launchHatsSurvey.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WallpaperSearchHandler {
  static get $interfaceName(): string {
    return "side_panel.customize_chrome.mojom.WallpaperSearchHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): WallpaperSearchHandlerRemote {
    let remote = new WallpaperSearchHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the WallpaperSearchHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WallpaperSearchHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WallpaperSearchHandlerRemote, WallpaperSearchHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WallpaperSearchHandlerRemote, WallpaperSearchHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getDescriptors: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getInspirations: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getWallpaperSearchResults: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setResultRenderTime: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setBackgroundToHistoryImage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setBackgroundToInspirationImage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setBackgroundToWallpaperSearchResult: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateHistory: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setUserFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openHelpArticle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  launchHatsSurvey: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WallpaperSearchHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getDescriptors =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WallpaperSearchHandler_GetDescriptors_ParamsSpec.$,
        WallpaperSearchHandler_GetDescriptors_ResponseParamsSpec.$,
        this.getDescriptors.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getInspirations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WallpaperSearchHandler_GetInspirations_ParamsSpec.$,
        WallpaperSearchHandler_GetInspirations_ResponseParamsSpec.$,
        this.getInspirations.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getWallpaperSearchResults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WallpaperSearchHandler_GetWallpaperSearchResults_ParamsSpec.$,
        WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsSpec.$,
        this.getWallpaperSearchResults.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setResultRenderTime =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WallpaperSearchHandler_SetResultRenderTime_ParamsSpec.$,
        null,
        this.setResultRenderTime.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setBackgroundToHistoryImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsSpec.$,
        null,
        this.setBackgroundToHistoryImage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setBackgroundToInspirationImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsSpec.$,
        null,
        this.setBackgroundToInspirationImage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setBackgroundToWallpaperSearchResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsSpec.$,
        null,
        this.setBackgroundToWallpaperSearchResult.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateHistory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WallpaperSearchHandler_UpdateHistory_ParamsSpec.$,
        null,
        this.updateHistory.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setUserFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WallpaperSearchHandler_SetUserFeedback_ParamsSpec.$,
        null,
        this.setUserFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openHelpArticle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        WallpaperSearchHandler_OpenHelpArticle_ParamsSpec.$,
        null,
        this.openHelpArticle.createReceiverHandler(false /* expectsResponse */),
        false);
    this.launchHatsSurvey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        WallpaperSearchHandler_LaunchHatsSurvey_ParamsSpec.$,
        null,
        this.launchHatsSurvey.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type WallpaperSearchClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<WallpaperSearchClientPendingReceiver>;

export class WallpaperSearchClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<WallpaperSearchClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<WallpaperSearchClientPendingReceiver>;
  constructor(handle: MojoHandle|WallpaperSearchClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.customize_chrome.mojom.WallpaperSearchClient',
        scope);
  }
}

export interface WallpaperSearchClientInterface {
  setHistory(history: WallpaperSearchResult[]): void;
}

export class WallpaperSearchClientRemote implements WallpaperSearchClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<WallpaperSearchClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<WallpaperSearchClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|WallpaperSearchClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WallpaperSearchClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setHistory(
      history: WallpaperSearchResult[]): void {
    this.proxy.sendMessage(
        0,
        WallpaperSearchClient_SetHistory_ParamsSpec.$,
        null,
        [
          history
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WallpaperSearchClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WallpaperSearchClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WallpaperSearchClientRemote, WallpaperSearchClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WallpaperSearchClientRemote, WallpaperSearchClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: WallpaperSearchClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WallpaperSearchClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WallpaperSearchClient_SetHistory_ParamsSpec.$,
        null,
        impl.setHistory.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WallpaperSearchClient {
  static get $interfaceName(): string {
    return "side_panel.customize_chrome.mojom.WallpaperSearchClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): WallpaperSearchClientRemote {
    let remote = new WallpaperSearchClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the WallpaperSearchClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WallpaperSearchClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WallpaperSearchClientRemote, WallpaperSearchClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WallpaperSearchClientRemote, WallpaperSearchClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setHistory: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WallpaperSearchClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setHistory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WallpaperSearchClient_SetHistory_ParamsSpec.$,
        null,
        this.setHistory.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const KeyLabelSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GroupSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DescriptorBSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DescriptorsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const InspirationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const InspirationDescriptorsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const InspirationGroupSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ResultDescriptorsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_GetDescriptors_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_GetDescriptors_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_GetInspirations_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_GetInspirations_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_GetWallpaperSearchResults_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_SetResultRenderTime_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_UpdateHistory_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_SetUserFeedback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_OpenHelpArticle_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchHandler_LaunchHatsSurvey_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WallpaperSearchClient_SetHistory_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DescriptorDValueSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface KeyLabelMojoType {
  key: string;
  label: string;
}


export type KeyLabel = KeyLabelMojoType;
mojo.internal.Struct<KeyLabelMojoType>(
    KeyLabelSpec.$,
    'KeyLabel',
    [
      mojo.internal.StructField<KeyLabelMojoType, string>(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<KeyLabelMojoType, string>(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface GroupMojoType {
  category: string;
  descriptorAs: KeyLabel[];
}


export type Group = GroupMojoType;
mojo.internal.Struct<GroupMojoType>(
    GroupSpec.$,
    'Group',
    [
      mojo.internal.StructField<GroupMojoType, string>(
        'category', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GroupMojoType, KeyLabel[]>(
        'descriptorAs', 8,
        0,
        mojo.internal.Array(KeyLabelSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface DescriptorBMojoType {
  key: string;
  label: string;
  imagePath: string;
}


export type DescriptorB = DescriptorBMojoType;
mojo.internal.Struct<DescriptorBMojoType>(
    DescriptorBSpec.$,
    'DescriptorB',
    [
      mojo.internal.StructField<DescriptorBMojoType, string>(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DescriptorBMojoType, string>(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DescriptorBMojoType, string>(
        'imagePath', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface DescriptorsMojoType {
  groups: Group[];
  descriptorB: DescriptorB[];
  descriptorC: KeyLabel[];
}


export type Descriptors = DescriptorsMojoType;
mojo.internal.Struct<DescriptorsMojoType>(
    DescriptorsSpec.$,
    'Descriptors',
    [
      mojo.internal.StructField<DescriptorsMojoType, Group[]>(
        'groups', 0,
        0,
        mojo.internal.Array(GroupSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DescriptorsMojoType, DescriptorB[]>(
        'descriptorB', 8,
        0,
        mojo.internal.Array(DescriptorBSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DescriptorsMojoType, KeyLabel[]>(
        'descriptorC', 16,
        0,
        mojo.internal.Array(KeyLabelSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface InspirationMojoType {
  id: mojoBase_mojom_Token;
  description: string;
  backgroundUrl: url_mojom_Url;
  thumbnailUrl: url_mojom_Url;
}


export type Inspiration = InspirationMojoType;
mojo.internal.Struct<InspirationMojoType>(
    InspirationSpec.$,
    'Inspiration',
    [
      mojo.internal.StructField<InspirationMojoType, mojoBase_mojom_Token>(
        'id', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InspirationMojoType, string>(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InspirationMojoType, url_mojom_Url>(
        'backgroundUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InspirationMojoType, url_mojom_Url>(
        'thumbnailUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface InspirationDescriptorsMojoType {
  subject: (KeyLabel | null);
  style: (KeyLabel | null);
  mood: (KeyLabel | null);
  color: (DescriptorDValue | null);
}


export type InspirationDescriptors = InspirationDescriptorsMojoType;
mojo.internal.Struct<InspirationDescriptorsMojoType>(
    InspirationDescriptorsSpec.$,
    'InspirationDescriptors',
    [
      mojo.internal.StructField<InspirationDescriptorsMojoType, KeyLabel>(
        'subject', 0,
        0,
        KeyLabelSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InspirationDescriptorsMojoType, KeyLabel>(
        'style', 8,
        0,
        KeyLabelSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InspirationDescriptorsMojoType, KeyLabel>(
        'mood', 16,
        0,
        KeyLabelSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InspirationDescriptorsMojoType, DescriptorDValue>(
        'color', 24,
        0,
        DescriptorDValueSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface InspirationGroupMojoType {
  descriptors: InspirationDescriptors;
  inspirations: Inspiration[];
}


export type InspirationGroup = InspirationGroupMojoType;
mojo.internal.Struct<InspirationGroupMojoType>(
    InspirationGroupSpec.$,
    'InspirationGroup',
    [
      mojo.internal.StructField<InspirationGroupMojoType, InspirationDescriptors>(
        'descriptors', 0,
        0,
        InspirationDescriptorsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InspirationGroupMojoType, Inspiration[]>(
        'inspirations', 8,
        0,
        mojo.internal.Array(InspirationSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WallpaperSearchResultMojoType {
  id: mojoBase_mojom_Token;
  image: string;
  descriptors: (ResultDescriptors | null);
}


export type WallpaperSearchResult = WallpaperSearchResultMojoType;
mojo.internal.Struct<WallpaperSearchResultMojoType>(
    WallpaperSearchResultSpec.$,
    'WallpaperSearchResult',
    [
      mojo.internal.StructField<WallpaperSearchResultMojoType, mojoBase_mojom_Token>(
        'id', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchResultMojoType, string>(
        'image', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchResultMojoType, ResultDescriptors>(
        'descriptors', 16,
        0,
        ResultDescriptorsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ResultDescriptorsMojoType {
  subject: (string | null);
  style: (string | null);
  mood: (string | null);
  color: (DescriptorDValue | null);
}


export type ResultDescriptors = ResultDescriptorsMojoType;
mojo.internal.Struct<ResultDescriptorsMojoType>(
    ResultDescriptorsSpec.$,
    'ResultDescriptors',
    [
      mojo.internal.StructField<ResultDescriptorsMojoType, string>(
        'subject', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ResultDescriptorsMojoType, string>(
        'style', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ResultDescriptorsMojoType, string>(
        'mood', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ResultDescriptorsMojoType, DescriptorDValue>(
        'color', 24,
        0,
        DescriptorDValueSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsMojoType {
  client: WallpaperSearchClientRemote;
  handler: WallpaperSearchHandlerPendingReceiver;
}


export type WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params = WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsMojoType>(
    WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsSpec.$,
    'WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params',
    [
      mojo.internal.StructField<WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsMojoType, WallpaperSearchClientRemote>(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(WallpaperSearchClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsMojoType, WallpaperSearchHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(WallpaperSearchHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WallpaperSearchHandler_GetDescriptors_ParamsMojoType {
}


export type WallpaperSearchHandler_GetDescriptors_Params = WallpaperSearchHandler_GetDescriptors_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_GetDescriptors_ParamsMojoType>(
    WallpaperSearchHandler_GetDescriptors_ParamsSpec.$,
    'WallpaperSearchHandler_GetDescriptors_Params',
    [
    ],
    [[0, 8],]);





export interface WallpaperSearchHandler_GetDescriptors_ResponseParamsMojoType {
  descriptors: (Descriptors | null);
}


export type WallpaperSearchHandler_GetDescriptors_ResponseParams = WallpaperSearchHandler_GetDescriptors_ResponseParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_GetDescriptors_ResponseParamsMojoType>(
    WallpaperSearchHandler_GetDescriptors_ResponseParamsSpec.$,
    'WallpaperSearchHandler_GetDescriptors_ResponseParams',
    [
      mojo.internal.StructField<WallpaperSearchHandler_GetDescriptors_ResponseParamsMojoType, Descriptors>(
        'descriptors', 0,
        0,
        DescriptorsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WallpaperSearchHandler_GetInspirations_ParamsMojoType {
}


export type WallpaperSearchHandler_GetInspirations_Params = WallpaperSearchHandler_GetInspirations_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_GetInspirations_ParamsMojoType>(
    WallpaperSearchHandler_GetInspirations_ParamsSpec.$,
    'WallpaperSearchHandler_GetInspirations_Params',
    [
    ],
    [[0, 8],]);





export interface WallpaperSearchHandler_GetInspirations_ResponseParamsMojoType {
  inspirationGroups: (InspirationGroup[] | null);
}


export type WallpaperSearchHandler_GetInspirations_ResponseParams = WallpaperSearchHandler_GetInspirations_ResponseParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_GetInspirations_ResponseParamsMojoType>(
    WallpaperSearchHandler_GetInspirations_ResponseParamsSpec.$,
    'WallpaperSearchHandler_GetInspirations_ResponseParams',
    [
      mojo.internal.StructField<WallpaperSearchHandler_GetInspirations_ResponseParamsMojoType, InspirationGroup[]>(
        'inspirationGroups', 0,
        0,
        mojo.internal.Array(InspirationGroupSpec.$, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WallpaperSearchHandler_GetWallpaperSearchResults_ParamsMojoType {
  resultDescriptors: ResultDescriptors;
}


export type WallpaperSearchHandler_GetWallpaperSearchResults_Params = WallpaperSearchHandler_GetWallpaperSearchResults_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_GetWallpaperSearchResults_ParamsMojoType>(
    WallpaperSearchHandler_GetWallpaperSearchResults_ParamsSpec.$,
    'WallpaperSearchHandler_GetWallpaperSearchResults_Params',
    [
      mojo.internal.StructField<WallpaperSearchHandler_GetWallpaperSearchResults_ParamsMojoType, ResultDescriptors>(
        'resultDescriptors', 0,
        0,
        ResultDescriptorsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsMojoType {
  status: WallpaperSearchStatus;
  results: WallpaperSearchResult[];
}


export type WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams = WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsMojoType>(
    WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsSpec.$,
    'WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams',
    [
      mojo.internal.StructField<WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsMojoType, WallpaperSearchStatus>(
        'status', 0,
        0,
        WallpaperSearchStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsMojoType, WallpaperSearchResult[]>(
        'results', 8,
        0,
        mojo.internal.Array(WallpaperSearchResultSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WallpaperSearchHandler_SetResultRenderTime_ParamsMojoType {
  resultIds: mojoBase_mojom_Token[];
  time: number;
}


export type WallpaperSearchHandler_SetResultRenderTime_Params = WallpaperSearchHandler_SetResultRenderTime_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_SetResultRenderTime_ParamsMojoType>(
    WallpaperSearchHandler_SetResultRenderTime_ParamsSpec.$,
    'WallpaperSearchHandler_SetResultRenderTime_Params',
    [
      mojo.internal.StructField<WallpaperSearchHandler_SetResultRenderTime_ParamsMojoType, mojoBase_mojom_Token[]>(
        'resultIds', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_TokenSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchHandler_SetResultRenderTime_ParamsMojoType, number>(
        'time', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsMojoType {
  resultId: mojoBase_mojom_Token;
  descriptors: ResultDescriptors;
}


export type WallpaperSearchHandler_SetBackgroundToHistoryImage_Params = WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsMojoType>(
    WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsSpec.$,
    'WallpaperSearchHandler_SetBackgroundToHistoryImage_Params',
    [
      mojo.internal.StructField<WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsMojoType, mojoBase_mojom_Token>(
        'resultId', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsMojoType, ResultDescriptors>(
        'descriptors', 8,
        0,
        ResultDescriptorsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsMojoType {
  id: mojoBase_mojom_Token;
  backgroundUrl: url_mojom_Url;
}


export type WallpaperSearchHandler_SetBackgroundToInspirationImage_Params = WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsMojoType>(
    WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsSpec.$,
    'WallpaperSearchHandler_SetBackgroundToInspirationImage_Params',
    [
      mojo.internal.StructField<WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsMojoType, mojoBase_mojom_Token>(
        'id', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsMojoType, url_mojom_Url>(
        'backgroundUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsMojoType {
  resultId: mojoBase_mojom_Token;
  time: number;
  descriptors: ResultDescriptors;
}


export type WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params = WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsMojoType>(
    WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsSpec.$,
    'WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params',
    [
      mojo.internal.StructField<WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsMojoType, mojoBase_mojom_Token>(
        'resultId', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsMojoType, number>(
        'time', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsMojoType, ResultDescriptors>(
        'descriptors', 16,
        0,
        ResultDescriptorsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface WallpaperSearchHandler_UpdateHistory_ParamsMojoType {
}


export type WallpaperSearchHandler_UpdateHistory_Params = WallpaperSearchHandler_UpdateHistory_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_UpdateHistory_ParamsMojoType>(
    WallpaperSearchHandler_UpdateHistory_ParamsSpec.$,
    'WallpaperSearchHandler_UpdateHistory_Params',
    [
    ],
    [[0, 8],]);





export interface WallpaperSearchHandler_SetUserFeedback_ParamsMojoType {
  selectedOption: UserFeedback;
}


export type WallpaperSearchHandler_SetUserFeedback_Params = WallpaperSearchHandler_SetUserFeedback_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_SetUserFeedback_ParamsMojoType>(
    WallpaperSearchHandler_SetUserFeedback_ParamsSpec.$,
    'WallpaperSearchHandler_SetUserFeedback_Params',
    [
      mojo.internal.StructField<WallpaperSearchHandler_SetUserFeedback_ParamsMojoType, UserFeedback>(
        'selectedOption', 0,
        0,
        UserFeedbackSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WallpaperSearchHandler_OpenHelpArticle_ParamsMojoType {
}


export type WallpaperSearchHandler_OpenHelpArticle_Params = WallpaperSearchHandler_OpenHelpArticle_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_OpenHelpArticle_ParamsMojoType>(
    WallpaperSearchHandler_OpenHelpArticle_ParamsSpec.$,
    'WallpaperSearchHandler_OpenHelpArticle_Params',
    [
    ],
    [[0, 8],]);





export interface WallpaperSearchHandler_LaunchHatsSurvey_ParamsMojoType {
}


export type WallpaperSearchHandler_LaunchHatsSurvey_Params = WallpaperSearchHandler_LaunchHatsSurvey_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchHandler_LaunchHatsSurvey_ParamsMojoType>(
    WallpaperSearchHandler_LaunchHatsSurvey_ParamsSpec.$,
    'WallpaperSearchHandler_LaunchHatsSurvey_Params',
    [
    ],
    [[0, 8],]);





export interface WallpaperSearchClient_SetHistory_ParamsMojoType {
  history: WallpaperSearchResult[];
}


export type WallpaperSearchClient_SetHistory_Params = WallpaperSearchClient_SetHistory_ParamsMojoType;
mojo.internal.Struct<WallpaperSearchClient_SetHistory_ParamsMojoType>(
    WallpaperSearchClient_SetHistory_ParamsSpec.$,
    'WallpaperSearchClient_SetHistory_Params',
    [
      mojo.internal.StructField<WallpaperSearchClient_SetHistory_ParamsMojoType, WallpaperSearchResult[]>(
        'history', 0,
        0,
        mojo.internal.Array(WallpaperSearchResultSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    DescriptorDValueSpec.$, 'DescriptorDValue',
    {
      'color': {
        'ordinal': 0,
        'type': skia_mojom_SkColorSpec.$,
      },
      'hue': {
        'ordinal': 1,
        'type': mojo.internal.Float,
      },
      'name': {
        'ordinal': 2,
        'type': DescriptorDNameSpec.$,
      },
    });

export interface DescriptorDValue {
  color?: skia_mojom_SkColor,
  hue?: number,
  name?: DescriptorDName,
}

export enum DescriptorDValueFieldTags {
  COLOR,
  HUE,
  NAME,
}

export function whichDescriptorDValue(u: DescriptorDValue): DescriptorDValueFieldTags {
  if (u.color !== null && u.color !== undefined) {
    return DescriptorDValueFieldTags.COLOR;
  }
  if (u.hue !== null && u.hue !== undefined) {
    return DescriptorDValueFieldTags.HUE;
  }
  if (u.name !== null && u.name !== undefined) {
    return DescriptorDValueFieldTags.NAME;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
