// chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const ActionIdSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ActionId {

  MIN_VALUE = 0,
  MAX_VALUE = 25,
  kShowBookmarks = 0,
  kShowHistoryCluster = 1,
  kShowReadAnything = 2,
  kShowReadingList = 3,
  kShowLensOverlay = 4,
  kShowSearchCompanion = 5,
  kHome = 6,
  kForward = 7,
  kNewIncognitoWindow = 8,
  kShowPasswordManager = 9,
  kShowPaymentMethods = 10,
  kShowAddresses = 11,
  kShowDownloads = 12,
  kClearBrowsingData = 13,
  kPrint = 14,
  kShowTranslate = 15,
  kSendTabToSelf = 16,
  kQrCodeGenerator = 17,
  kRouteMedia = 18,
  kTaskManager = 19,
  kDevTools = 20,
  kShowChromeLabs = 21,
  kCopyLink = 22,
  kTabSearch = 23,
  kSplitTab = 24,
  kContextualTasks = 25,
}

export const CategoryIdSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CategoryId {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kNavigation = 0,
  kYourChrome = 1,
  kTools = 2,
}



export type CustomizeToolbarHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarHandlerFactoryPendingReceiver>;

export class CustomizeToolbarHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CustomizeToolbarHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|CustomizeToolbarHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.customize_chrome.mojom.CustomizeToolbarHandlerFactory',
        scope);
  }
}

export interface CustomizeToolbarHandlerFactoryInterface {
  createCustomizeToolbarHandler(client: CustomizeToolbarClientRemote, handler: CustomizeToolbarHandlerPendingReceiver): void;
}

export class CustomizeToolbarHandlerFactoryRemote implements CustomizeToolbarHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CustomizeToolbarHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeToolbarHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CustomizeToolbarHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CustomizeToolbarHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createCustomizeToolbarHandler(
      client: CustomizeToolbarClientRemote,
      handler: CustomizeToolbarHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsSpec.$,
        null,
        [
          client,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CustomizeToolbarHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CustomizeToolbarHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeToolbarHandlerFactoryRemote, CustomizeToolbarHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeToolbarHandlerFactoryRemote, CustomizeToolbarHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CustomizeToolbarHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CustomizeToolbarHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsSpec.$,
        null,
        impl.createCustomizeToolbarHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CustomizeToolbarHandlerFactory {
  static get $interfaceName(): string {
    return "side_panel.customize_chrome.mojom.CustomizeToolbarHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CustomizeToolbarHandlerFactoryRemote {
    let remote = new CustomizeToolbarHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CustomizeToolbarHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CustomizeToolbarHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeToolbarHandlerFactoryRemote, CustomizeToolbarHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeToolbarHandlerFactoryRemote, CustomizeToolbarHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createCustomizeToolbarHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CustomizeToolbarHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createCustomizeToolbarHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsSpec.$,
        null,
        this.createCustomizeToolbarHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CustomizeToolbarHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarHandlerPendingReceiver>;

export class CustomizeToolbarHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CustomizeToolbarHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarHandlerPendingReceiver>;
  constructor(handle: MojoHandle|CustomizeToolbarHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.customize_chrome.mojom.CustomizeToolbarHandler',
        scope);
  }
}

export interface CustomizeToolbarHandlerInterface {
  listActions(): Promise<{
        actions: Action[], }>;
  listCategories(): Promise<{
        categories: Category[], }>;
  pinAction(actionId: ActionId, pinned: boolean): void;
  getIsCustomized(): Promise<{
        customized: boolean, }>;
  resetToDefault(): void;
}

export class CustomizeToolbarHandlerRemote implements CustomizeToolbarHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CustomizeToolbarHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeToolbarHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CustomizeToolbarHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CustomizeToolbarHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  listActions(): Promise<{
        actions: Action[], }> {
    return this.proxy.sendMessage(
        0,
        CustomizeToolbarHandler_ListActions_ParamsSpec.$,
        CustomizeToolbarHandler_ListActions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  listCategories(): Promise<{
        categories: Category[], }> {
    return this.proxy.sendMessage(
        1,
        CustomizeToolbarHandler_ListCategories_ParamsSpec.$,
        CustomizeToolbarHandler_ListCategories_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  pinAction(
      actionId: ActionId,
      pinned: boolean): void {
    this.proxy.sendMessage(
        2,
        CustomizeToolbarHandler_PinAction_ParamsSpec.$,
        null,
        [
          actionId,
          pinned
        ],
        false);
  }

  getIsCustomized(): Promise<{
        customized: boolean, }> {
    return this.proxy.sendMessage(
        3,
        CustomizeToolbarHandler_GetIsCustomized_ParamsSpec.$,
        CustomizeToolbarHandler_GetIsCustomized_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  resetToDefault(): void {
    this.proxy.sendMessage(
        4,
        CustomizeToolbarHandler_ResetToDefault_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CustomizeToolbarHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CustomizeToolbarHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeToolbarHandlerRemote, CustomizeToolbarHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeToolbarHandlerRemote, CustomizeToolbarHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CustomizeToolbarHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CustomizeToolbarHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CustomizeToolbarHandler_ListActions_ParamsSpec.$,
        CustomizeToolbarHandler_ListActions_ResponseParamsSpec.$,
        impl.listActions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CustomizeToolbarHandler_ListCategories_ParamsSpec.$,
        CustomizeToolbarHandler_ListCategories_ResponseParamsSpec.$,
        impl.listCategories.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CustomizeToolbarHandler_PinAction_ParamsSpec.$,
        null,
        impl.pinAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CustomizeToolbarHandler_GetIsCustomized_ParamsSpec.$,
        CustomizeToolbarHandler_GetIsCustomized_ResponseParamsSpec.$,
        impl.getIsCustomized.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CustomizeToolbarHandler_ResetToDefault_ParamsSpec.$,
        null,
        impl.resetToDefault.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CustomizeToolbarHandler {
  static get $interfaceName(): string {
    return "side_panel.customize_chrome.mojom.CustomizeToolbarHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CustomizeToolbarHandlerRemote {
    let remote = new CustomizeToolbarHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CustomizeToolbarHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CustomizeToolbarHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeToolbarHandlerRemote, CustomizeToolbarHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeToolbarHandlerRemote, CustomizeToolbarHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  listActions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  listCategories: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  pinAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getIsCustomized: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resetToDefault: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CustomizeToolbarHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.listActions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CustomizeToolbarHandler_ListActions_ParamsSpec.$,
        CustomizeToolbarHandler_ListActions_ResponseParamsSpec.$,
        this.listActions.createReceiverHandler(true /* expectsResponse */),
        false);
    this.listCategories =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CustomizeToolbarHandler_ListCategories_ParamsSpec.$,
        CustomizeToolbarHandler_ListCategories_ResponseParamsSpec.$,
        this.listCategories.createReceiverHandler(true /* expectsResponse */),
        false);
    this.pinAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CustomizeToolbarHandler_PinAction_ParamsSpec.$,
        null,
        this.pinAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getIsCustomized =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CustomizeToolbarHandler_GetIsCustomized_ParamsSpec.$,
        CustomizeToolbarHandler_GetIsCustomized_ResponseParamsSpec.$,
        this.getIsCustomized.createReceiverHandler(true /* expectsResponse */),
        false);
    this.resetToDefault =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CustomizeToolbarHandler_ResetToDefault_ParamsSpec.$,
        null,
        this.resetToDefault.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CustomizeToolbarClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarClientPendingReceiver>;

export class CustomizeToolbarClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CustomizeToolbarClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<CustomizeToolbarClientPendingReceiver>;
  constructor(handle: MojoHandle|CustomizeToolbarClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.customize_chrome.mojom.CustomizeToolbarClient',
        scope);
  }
}

export interface CustomizeToolbarClientInterface {
  setActionPinned(actionId: ActionId, pinned: boolean): void;
  notifyActionsUpdated(): void;
}

export class CustomizeToolbarClientRemote implements CustomizeToolbarClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CustomizeToolbarClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeToolbarClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CustomizeToolbarClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CustomizeToolbarClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setActionPinned(
      actionId: ActionId,
      pinned: boolean): void {
    this.proxy.sendMessage(
        0,
        CustomizeToolbarClient_SetActionPinned_ParamsSpec.$,
        null,
        [
          actionId,
          pinned
        ],
        false);
  }

  notifyActionsUpdated(): void {
    this.proxy.sendMessage(
        1,
        CustomizeToolbarClient_NotifyActionsUpdated_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CustomizeToolbarClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CustomizeToolbarClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeToolbarClientRemote, CustomizeToolbarClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeToolbarClientRemote, CustomizeToolbarClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CustomizeToolbarClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CustomizeToolbarClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CustomizeToolbarClient_SetActionPinned_ParamsSpec.$,
        null,
        impl.setActionPinned.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CustomizeToolbarClient_NotifyActionsUpdated_ParamsSpec.$,
        null,
        impl.notifyActionsUpdated.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CustomizeToolbarClient {
  static get $interfaceName(): string {
    return "side_panel.customize_chrome.mojom.CustomizeToolbarClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CustomizeToolbarClientRemote {
    let remote = new CustomizeToolbarClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CustomizeToolbarClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CustomizeToolbarClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeToolbarClientRemote, CustomizeToolbarClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeToolbarClientRemote, CustomizeToolbarClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setActionPinned: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyActionsUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CustomizeToolbarClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setActionPinned =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CustomizeToolbarClient_SetActionPinned_ParamsSpec.$,
        null,
        this.setActionPinned.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyActionsUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CustomizeToolbarClient_NotifyActionsUpdated_ParamsSpec.$,
        null,
        this.notifyActionsUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ActionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CategorySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandler_ListActions_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandler_ListActions_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandler_ListCategories_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandler_ListCategories_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandler_PinAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandler_GetIsCustomized_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandler_GetIsCustomized_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarHandler_ResetToDefault_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarClient_SetActionPinned_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeToolbarClient_NotifyActionsUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ActionMojoType {
  id: ActionId;
  pinned: boolean;
  hasEnterpriseControlledPinnedState: boolean;
  displayName: string;
  category: CategoryId;
  iconUrl: url_mojom_Url;
}


export type Action = ActionMojoType;
mojo.internal.Struct<ActionMojoType>(
    ActionSpec.$,
    'Action',
    [
      mojo.internal.StructField<ActionMojoType, ActionId>(
        'id', 0,
        0,
        ActionIdSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionMojoType, string>(
        'displayName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionMojoType, boolean>(
        'pinned', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionMojoType, boolean>(
        'hasEnterpriseControlledPinnedState', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionMojoType, CategoryId>(
        'category', 16,
        0,
        CategoryIdSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionMojoType, url_mojom_Url>(
        'iconUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface CategoryMojoType {
  id: CategoryId;
  displayName: string;
}


export type Category = CategoryMojoType;
mojo.internal.Struct<CategoryMojoType>(
    CategorySpec.$,
    'Category',
    [
      mojo.internal.StructField<CategoryMojoType, CategoryId>(
        'id', 0,
        0,
        CategoryIdSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CategoryMojoType, string>(
        'displayName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsMojoType {
  client: CustomizeToolbarClientRemote;
  handler: CustomizeToolbarHandlerPendingReceiver;
}


export type CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params = CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsMojoType>(
    CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsSpec.$,
    'CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params',
    [
      mojo.internal.StructField<CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsMojoType, CustomizeToolbarClientRemote>(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(CustomizeToolbarClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsMojoType, CustomizeToolbarHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(CustomizeToolbarHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CustomizeToolbarHandler_ListActions_ParamsMojoType {
}


export type CustomizeToolbarHandler_ListActions_Params = CustomizeToolbarHandler_ListActions_ParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandler_ListActions_ParamsMojoType>(
    CustomizeToolbarHandler_ListActions_ParamsSpec.$,
    'CustomizeToolbarHandler_ListActions_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeToolbarHandler_ListActions_ResponseParamsMojoType {
  actions: Action[];
}


export type CustomizeToolbarHandler_ListActions_ResponseParams = CustomizeToolbarHandler_ListActions_ResponseParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandler_ListActions_ResponseParamsMojoType>(
    CustomizeToolbarHandler_ListActions_ResponseParamsSpec.$,
    'CustomizeToolbarHandler_ListActions_ResponseParams',
    [
      mojo.internal.StructField<CustomizeToolbarHandler_ListActions_ResponseParamsMojoType, Action[]>(
        'actions', 0,
        0,
        mojo.internal.Array(ActionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeToolbarHandler_ListCategories_ParamsMojoType {
}


export type CustomizeToolbarHandler_ListCategories_Params = CustomizeToolbarHandler_ListCategories_ParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandler_ListCategories_ParamsMojoType>(
    CustomizeToolbarHandler_ListCategories_ParamsSpec.$,
    'CustomizeToolbarHandler_ListCategories_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeToolbarHandler_ListCategories_ResponseParamsMojoType {
  categories: Category[];
}


export type CustomizeToolbarHandler_ListCategories_ResponseParams = CustomizeToolbarHandler_ListCategories_ResponseParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandler_ListCategories_ResponseParamsMojoType>(
    CustomizeToolbarHandler_ListCategories_ResponseParamsSpec.$,
    'CustomizeToolbarHandler_ListCategories_ResponseParams',
    [
      mojo.internal.StructField<CustomizeToolbarHandler_ListCategories_ResponseParamsMojoType, Category[]>(
        'categories', 0,
        0,
        mojo.internal.Array(CategorySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeToolbarHandler_PinAction_ParamsMojoType {
  actionId: ActionId;
  pinned: boolean;
}


export type CustomizeToolbarHandler_PinAction_Params = CustomizeToolbarHandler_PinAction_ParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandler_PinAction_ParamsMojoType>(
    CustomizeToolbarHandler_PinAction_ParamsSpec.$,
    'CustomizeToolbarHandler_PinAction_Params',
    [
      mojo.internal.StructField<CustomizeToolbarHandler_PinAction_ParamsMojoType, ActionId>(
        'actionId', 0,
        0,
        ActionIdSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeToolbarHandler_PinAction_ParamsMojoType, boolean>(
        'pinned', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeToolbarHandler_GetIsCustomized_ParamsMojoType {
}


export type CustomizeToolbarHandler_GetIsCustomized_Params = CustomizeToolbarHandler_GetIsCustomized_ParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandler_GetIsCustomized_ParamsMojoType>(
    CustomizeToolbarHandler_GetIsCustomized_ParamsSpec.$,
    'CustomizeToolbarHandler_GetIsCustomized_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeToolbarHandler_GetIsCustomized_ResponseParamsMojoType {
  customized: boolean;
}


export type CustomizeToolbarHandler_GetIsCustomized_ResponseParams = CustomizeToolbarHandler_GetIsCustomized_ResponseParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandler_GetIsCustomized_ResponseParamsMojoType>(
    CustomizeToolbarHandler_GetIsCustomized_ResponseParamsSpec.$,
    'CustomizeToolbarHandler_GetIsCustomized_ResponseParams',
    [
      mojo.internal.StructField<CustomizeToolbarHandler_GetIsCustomized_ResponseParamsMojoType, boolean>(
        'customized', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeToolbarHandler_ResetToDefault_ParamsMojoType {
}


export type CustomizeToolbarHandler_ResetToDefault_Params = CustomizeToolbarHandler_ResetToDefault_ParamsMojoType;
mojo.internal.Struct<CustomizeToolbarHandler_ResetToDefault_ParamsMojoType>(
    CustomizeToolbarHandler_ResetToDefault_ParamsSpec.$,
    'CustomizeToolbarHandler_ResetToDefault_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeToolbarClient_SetActionPinned_ParamsMojoType {
  actionId: ActionId;
  pinned: boolean;
}


export type CustomizeToolbarClient_SetActionPinned_Params = CustomizeToolbarClient_SetActionPinned_ParamsMojoType;
mojo.internal.Struct<CustomizeToolbarClient_SetActionPinned_ParamsMojoType>(
    CustomizeToolbarClient_SetActionPinned_ParamsSpec.$,
    'CustomizeToolbarClient_SetActionPinned_Params',
    [
      mojo.internal.StructField<CustomizeToolbarClient_SetActionPinned_ParamsMojoType, ActionId>(
        'actionId', 0,
        0,
        ActionIdSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeToolbarClient_SetActionPinned_ParamsMojoType, boolean>(
        'pinned', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeToolbarClient_NotifyActionsUpdated_ParamsMojoType {
}


export type CustomizeToolbarClient_NotifyActionsUpdated_Params = CustomizeToolbarClient_NotifyActionsUpdated_ParamsMojoType;
mojo.internal.Struct<CustomizeToolbarClient_NotifyActionsUpdated_ParamsMojoType>(
    CustomizeToolbarClient_NotifyActionsUpdated_ParamsSpec.$,
    'CustomizeToolbarClient_NotifyActionsUpdated_Params',
    [
    ],
    [[0, 8],]);



