// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../check_mark_wrapper.js";import"./combobox/customize_chrome_combobox.js";import"chrome://customize-chrome-side-panel.top-chrome/shared/sp_heading.js";import"chrome://resources/cr_elements/cr_auto_img/cr_auto_img.js";import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_collapse/cr_collapse.js";import"chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js";import"chrome://resources/cr_elements/cr_grid/cr_grid.js";import"chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js";import"chrome://resources/cr_elements/cr_loading_gradient/cr_loading_gradient.js";import"chrome://resources/cr_elements/cr_ripple/cr_ripple.js";import"chrome://resources/cr_components/theme_color_picker/theme_hue_slider_dialog.js";import{getInstance as getAnnouncerInstance}from"chrome://resources/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{CrFeedbackOption}from"chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js";import{I18nMixinLit}from"chrome://resources/cr_elements/i18n_mixin_lit.js";import{assert}from"chrome://resources/js/assert.js";import{hexColorToSkColor}from"chrome://resources/js/color_utils.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{CustomizeChromeAction,recordCustomizeChromeAction}from"../common.js";import{CustomizeChromeApiProxy}from"../customize_chrome_api_proxy.js";import{DescriptorDName,UserFeedback,WallpaperSearchStatus}from"../wallpaper_search.mojom-webui.js";import{WindowProxy}from"../window_proxy.js";import{getCss}from"./wallpaper_search.css.js";import{getHtml}from"./wallpaper_search.html.js";import{WallpaperSearchProxy}from"./wallpaper_search_proxy.js";export const DESCRIPTOR_D_VALUE=[{hex:"#ef4837",name:"colorRed"},{hex:"#0984e3",name:"colorBlue"},{hex:"#f9cc18",name:"colorYellow"},{hex:"#23cc6a",name:"colorGreen"},{hex:"#474747",name:"colorBlack"}];function descriptorDNameToHex(name){switch(name){case DescriptorDName.kYellow:return"#f9cc18"}}function getRandomDescriptorA(groups){const descriptorAs=groups[Math.floor(Math.random()*groups.length)].descriptorAs;return descriptorAs[Math.floor(Math.random()*descriptorAs.length)].key}function recordStatusChange(status){chrome.metricsPrivate.recordEnumerationValue("NewTabPage.WallpaperSearch.Status",status,WallpaperSearchStatus.MAX_VALUE)}function getEventTargetIndex(e){return Number(e.currentTarget.dataset["index"])}const WallpaperSearchElementBase=I18nMixinLit(CrLitElement);export class WallpaperSearchElement extends WallpaperSearchElementBase{static get is(){return"customize-chrome-wallpaper-search"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{comboboxItems_:{type:Object},descriptors_:{type:Object},descriptorD_:{type:Array},errorState_:{type:Object},expandedCategories_:{type:Object},loading_:{type:Boolean},history_:{type:Array},inspirationCardEnabled_:{type:Boolean},inspirationGroups_:{type:Array},inspirationToggleIcon_:{type:String},openInspirations_:{type:Boolean},resultsDescriptors_:{type:Object},results_:{type:Object},selectedFeedbackOption_:{type:Number},selectedDescriptorA_:{type:String},selectedDescriptorB_:{type:String},selectedDescriptorC_:{type:String},selectedDescriptorD_:{type:Object},selectedHue_:{type:Number},shouldShowHistory_:{type:Boolean},shouldShowInspiration_:{type:Boolean},status_:{type:Number},theme_:{type:Object}}}#comboboxItems__accessor_storage={a:[],b:[],c:[]};get comboboxItems_(){return this.#comboboxItems__accessor_storage}set comboboxItems_(value){this.#comboboxItems__accessor_storage=value}#descriptors__accessor_storage=null;get descriptors_(){return this.#descriptors__accessor_storage}set descriptors_(value){this.#descriptors__accessor_storage=value}#descriptorD__accessor_storage=DESCRIPTOR_D_VALUE.map((value=>value.hex));get descriptorD_(){return this.#descriptorD__accessor_storage}set descriptorD_(value){this.#descriptorD__accessor_storage=value}errorCallback_;#errorState__accessor_storage=null;get errorState_(){return this.#errorState__accessor_storage}set errorState_(value){this.#errorState__accessor_storage=value}#expandedCategories__accessor_storage={};get expandedCategories_(){return this.#expandedCategories__accessor_storage}set expandedCategories_(value){this.#expandedCategories__accessor_storage=value}#history__accessor_storage=[];get history_(){return this.#history__accessor_storage}set history_(value){this.#history__accessor_storage=value}#inspirationGroups__accessor_storage=[];get inspirationGroups_(){return this.#inspirationGroups__accessor_storage}set inspirationGroups_(value){this.#inspirationGroups__accessor_storage=value}#inspirationCardEnabled__accessor_storage=loadTimeData.getBoolean("wallpaperSearchInspirationCardEnabled");get inspirationCardEnabled_(){return this.#inspirationCardEnabled__accessor_storage}set inspirationCardEnabled_(value){this.#inspirationCardEnabled__accessor_storage=value}#inspirationToggleIcon__accessor_storage="";get inspirationToggleIcon_(){return this.#inspirationToggleIcon__accessor_storage}set inspirationToggleIcon_(value){this.#inspirationToggleIcon__accessor_storage=value}#loading__accessor_storage=false;get loading_(){return this.#loading__accessor_storage}set loading_(value){this.#loading__accessor_storage=value}#openInspirations__accessor_storage=false;get openInspirations_(){return this.#openInspirations__accessor_storage}set openInspirations_(value){this.#openInspirations__accessor_storage=value}#results__accessor_storage=[];get results_(){return this.#results__accessor_storage}set results_(value){this.#results__accessor_storage=value}#resultsDescriptors__accessor_storage=null;get resultsDescriptors_(){return this.#resultsDescriptors__accessor_storage}set resultsDescriptors_(value){this.#resultsDescriptors__accessor_storage=value}resultsPromises_=[];selectedDefaultColor_;#selectedDescriptorA__accessor_storage=null;get selectedDescriptorA_(){return this.#selectedDescriptorA__accessor_storage}set selectedDescriptorA_(value){this.#selectedDescriptorA__accessor_storage=value}#selectedDescriptorB__accessor_storage=null;get selectedDescriptorB_(){return this.#selectedDescriptorB__accessor_storage}set selectedDescriptorB_(value){this.#selectedDescriptorB__accessor_storage=value}#selectedDescriptorC__accessor_storage=null;get selectedDescriptorC_(){return this.#selectedDescriptorC__accessor_storage}set selectedDescriptorC_(value){this.#selectedDescriptorC__accessor_storage=value}#selectedDescriptorD__accessor_storage=null;get selectedDescriptorD_(){return this.#selectedDescriptorD__accessor_storage}set selectedDescriptorD_(value){this.#selectedDescriptorD__accessor_storage=value}#selectedFeedbackOption__accessor_storage=CrFeedbackOption.UNSPECIFIED;get selectedFeedbackOption_(){return this.#selectedFeedbackOption__accessor_storage}set selectedFeedbackOption_(value){this.#selectedFeedbackOption__accessor_storage=value}#selectedHue__accessor_storage=null;get selectedHue_(){return this.#selectedHue__accessor_storage}set selectedHue_(value){this.#selectedHue__accessor_storage=value}#shouldShowHistory__accessor_storage=false;get shouldShowHistory_(){return this.#shouldShowHistory__accessor_storage}set shouldShowHistory_(value){this.#shouldShowHistory__accessor_storage=value}#shouldShowInspiration__accessor_storage=false;get shouldShowInspiration_(){return this.#shouldShowInspiration__accessor_storage}set shouldShowInspiration_(value){this.#shouldShowInspiration__accessor_storage=value}#status__accessor_storage=WallpaperSearchStatus.kOk;get status_(){return this.#status__accessor_storage}set status_(value){this.#status__accessor_storage=value}#theme__accessor_storage;get theme_(){return this.#theme__accessor_storage}set theme_(value){this.#theme__accessor_storage=value}callbackRouter_;pageHandler_;wallpaperSearchCallbackRouter_;wallpaperSearchHandler_;setThemeListenerId_=null;setHistoryListenerId_=null;loadingUiResizeObserver_=null;constructor(){super();this.callbackRouter_=CustomizeChromeApiProxy.getInstance().callbackRouter;this.pageHandler_=CustomizeChromeApiProxy.getInstance().handler;this.wallpaperSearchHandler_=WallpaperSearchProxy.getInstance().handler;this.wallpaperSearchCallbackRouter_=WallpaperSearchProxy.getInstance().callbackRouter;this.fetchDescriptors_();if(this.inspirationCardEnabled_){this.wallpaperSearchHandler_.getInspirations().then((({inspirationGroups:inspirationGroups})=>{this.inspirationGroups_=inspirationGroups||[]}))}}connectedCallback(){super.connectedCallback();this.setThemeListenerId_=this.callbackRouter_.setTheme.addListener((theme=>{this.theme_=theme}));this.pageHandler_.updateTheme();this.setHistoryListenerId_=this.wallpaperSearchCallbackRouter_.setHistory.addListener((history=>{this.history_=history;this.openInspirations_=!this.computeShouldShowHistory_()}));this.wallpaperSearchHandler_.updateHistory();this.loadingUiResizeObserver_=new ResizeObserver((()=>{this.generateLoadingUi_()}));this.loadingUiResizeObserver_.observe(this)}disconnectedCallback(){super.disconnectedCallback();assert(this.setThemeListenerId_);assert(this.setHistoryListenerId_);this.callbackRouter_.removeListener(this.setThemeListenerId_);this.wallpaperSearchCallbackRouter_.removeListener(this.setHistoryListenerId_);this.loadingUiResizeObserver_.disconnect();this.loadingUiResizeObserver_=null}willUpdate(changedProperties){super.willUpdate(changedProperties);this.shouldShowInspiration_=this.computeShouldShowInspiration_();this.inspirationToggleIcon_=this.computeInspirationToggleIcon_();this.shouldShowHistory_=this.computeShouldShowHistory_();this.errorState_=this.computeErrorState_()}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("status_")){this.onStatusChange_()}}focusOnBackButton(){this.$.heading.getBackButton().focus()}computeErrorState_(){switch(this.status_){case WallpaperSearchStatus.kOk:return null;case WallpaperSearchStatus.kError:let errorDescription;if(this.shouldShowHistory_&&this.shouldShowInspiration_){errorDescription=this.i18n("genericErrorDescriptionWithHistoryAndInspiration")}else if(this.shouldShowHistory_){errorDescription=this.i18n("genericErrorDescriptionWithHistory")}else if(this.shouldShowInspiration_){errorDescription=this.i18n("genericErrorDescriptionWithInspiration")}else{errorDescription=this.i18n("genericErrorDescription")}return{title:this.i18n("genericErrorTitle"),description:errorDescription,callToAction:this.i18n("tryAgain")};case WallpaperSearchStatus.kRequestThrottled:return{title:this.i18n("requestThrottledTitle"),description:this.i18n("requestThrottledDescription"),callToAction:this.i18n("ok")};case WallpaperSearchStatus.kOffline:return{title:this.i18n("offlineTitle"),description:this.shouldShowHistory_?this.i18n("offlineDescriptionWithHistory"):this.i18n("offlineDescription"),callToAction:this.i18n("ok")};case WallpaperSearchStatus.kSignedOut:return{title:this.i18n("signedOutTitle"),description:this.i18n("signedOutDescription"),callToAction:this.i18n("ok")}}}computeInspirationToggleIcon_(){return this.openInspirations_?"collapse-carets":"expand-carets"}computeShouldShowHistory_(){return this.history_.length>0}computeShouldShowInspiration_(){return!!this.inspirationGroups_&&this.inspirationGroups_.length>0}expandCategoryForDescriptorA_(key){if(!this.descriptors_){return}const categoryGroupIndex=this.descriptors_.groups.findIndex((group=>group.descriptorAs.some((descriptor=>descriptor.key===key))));if(categoryGroupIndex>=0){this.expandedCategories_[categoryGroupIndex]=true;this.requestUpdate()}}fetchDescriptors_(){this.wallpaperSearchHandler_.getDescriptors().then((({descriptors:descriptors})=>{if(descriptors){descriptors.groups.sort(((a,b)=>a.category.localeCompare(b.category)));descriptors.groups.forEach((group=>group.descriptorAs.sort(((a,b)=>a.label.localeCompare(b.label)))));descriptors.descriptorB.sort(((a,b)=>a.label.localeCompare(b.label)));descriptors.descriptorC.sort(((a,b)=>a.label.localeCompare(b.label)));this.descriptors_=descriptors;this.comboboxItems_={a:descriptors.groups.map((group=>({key:group.category,label:group.category,items:group.descriptorAs}))),b:descriptors.descriptorB,c:descriptors.descriptorC};this.errorCallback_=undefined;recordStatusChange(WallpaperSearchStatus.kOk)}else{this.errorCallback_=()=>this.dispatchEvent(new Event("back-click"));this.status_=WindowProxy.getInstance().onLine?WallpaperSearchStatus.kError:WallpaperSearchStatus.kOffline;recordStatusChange(this.status_)}}))}generateLoadingUi_(){const availableWidth=this.$.wallpaperSearch.offsetWidth;if(availableWidth===0){return}const columns=3;const gapBetweenTiles=10;const tileSize=(availableWidth-gapBetweenTiles*(columns-1))/columns;const svg=this.$.loading.querySelector("svg");const rects=svg.querySelectorAll("rect");const rows=Math.ceil(rects.length/columns);svg.setAttribute("width",`${availableWidth}`);svg.setAttribute("height",`${rows*tileSize+(rows-1)*gapBetweenTiles}`);for(let row=0;row<rows;row++){for(let column=0;column<columns;column++){const rect=rects[column+row*columns];if(!rect){return}rect.setAttribute("height",`${tileSize}`);rect.setAttribute("width",`${tileSize}`);rect.setAttribute("x",`${column*(tileSize+gapBetweenTiles)}`);rect.setAttribute("y",`${row*(tileSize+gapBetweenTiles)}`)}}}getColorLabel_(defaultColor){const descriptor=DESCRIPTOR_D_VALUE.find((color=>color.hex===defaultColor));return descriptor?loadTimeData.getString(descriptor.name):""}isCustomColorSelected_(){return this.selectedHue_!==null}getInspirationDescriptorsCheckedStatus_(groupDescriptors){const groupDescriptorColor=groupDescriptors.color?.name!==undefined?descriptorDNameToHex(groupDescriptors.color.name):undefined;return(groupDescriptors.subject?.key||null)===this.selectedDescriptorA_&&(groupDescriptors.style?.key||null)===this.selectedDescriptorB_&&(groupDescriptors.mood?.key||null)===this.selectedDescriptorC_&&groupDescriptorColor===this.selectedDefaultColor_?"true":"false"}getInspirationGroupTitle_(descriptors){let colorName;if(descriptors.color?.name!==undefined){const hex=descriptorDNameToHex(descriptors.color.name);if(hex){colorName=this.getColorLabel_(hex)}}return[descriptors.subject?.label,descriptors.style?.label,descriptors.mood?.label,colorName].filter(Boolean).join(this.i18n("separator"))}getHistoryResultAriaLabel_(index,result){if(!result.descriptors||!result.descriptors.subject){return loadTimeData.getStringF("wallpaperSearchHistoryResultLabelNoDescriptor",index+1)}else if(result.descriptors.style&&result.descriptors.mood){return loadTimeData.getStringF("wallpaperSearchHistoryResultLabelBC",index+1,result.descriptors.subject,result.descriptors.style,result.descriptors.mood)}else if(result.descriptors.style){return loadTimeData.getStringF("wallpaperSearchHistoryResultLabelB",index+1,result.descriptors.subject,result.descriptors.style)}else if(result.descriptors.mood){return loadTimeData.getStringF("wallpaperSearchHistoryResultLabelC",index+1,result.descriptors.subject,result.descriptors.mood)}return loadTimeData.getStringF("wallpaperSearchHistoryResultLabel",index+1,result.descriptors.subject)}getResultAriaLabel_(index){assert(this.resultsDescriptors_&&this.resultsDescriptors_.subject);if(this.resultsDescriptors_.style&&this.resultsDescriptors_.mood){return loadTimeData.getStringF("wallpaperSearchResultLabelBC",index+1,this.resultsDescriptors_.subject,this.resultsDescriptors_.style,this.resultsDescriptors_.mood)}else if(this.resultsDescriptors_.style){return loadTimeData.getStringF("wallpaperSearchResultLabelB",index+1,this.resultsDescriptors_.subject,this.resultsDescriptors_.style)}else if(this.resultsDescriptors_.mood){return loadTimeData.getStringF("wallpaperSearchResultLabelC",index+1,this.resultsDescriptors_.subject,this.resultsDescriptors_.mood)}return loadTimeData.getStringF("wallpaperSearchResultLabel",index+1,this.resultsDescriptors_.subject)}isBackgroundSelected_(id){return!!(this.theme_&&this.theme_.backgroundImage&&this.theme_.backgroundImage.localBackgroundId&&this.theme_.backgroundImage.localBackgroundId.low===id.low&&this.theme_.backgroundImage.localBackgroundId.high===id.high)}isColorSelected_(defaultColor){return defaultColor===this.selectedDefaultColor_}isOptionSelectedInDescriptorB_(option){return option.key===this.selectedDescriptorB_}onBackClick_(){this.dispatchEvent(new Event("back-click"))}onButtonKeydown_(e){if(["Enter"," "].includes(e.key)){e.preventDefault();e.stopPropagation();e.target.click()}}onComboboxCategoryClick_(e){const index=getEventTargetIndex(e);const previous=this.expandedCategories_[index];this.expandedCategories_[index]=!previous;this.requestUpdate()}onCustomColorClick_(){this.$.hueSlider.showAt(this.$.customColorContainer)}onErrorClick_(){this.status_=WallpaperSearchStatus.kOk;recordStatusChange(this.status_);if(this.errorCallback_){this.errorCallback_()}}onDefaultColorClick_(e){const index=getEventTargetIndex(e);const item=this.descriptorD_[index];this.selectedHue_=null;if(this.selectedDefaultColor_===item){this.selectedDefaultColor_=undefined;this.selectedDescriptorD_=null}else{this.selectedDefaultColor_=item;this.selectedDescriptorD_={color:hexColorToSkColor(this.selectedDefaultColor_)}}recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_COLOR_DESCRIPTOR_UPDATED)}onMoodDescriptorChange_(e){if(this.selectedDescriptorC_!==e.detail.value){recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_MOOD_DESCRIPTOR_UPDATED)}this.selectedDescriptorC_=e.detail.value}onStyleDescriptorChange_(e){if(this.selectedDescriptorB_!==e.detail.value){recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_STYLE_DESCRIPTOR_UPDATED)}this.selectedDescriptorB_=e.detail.value}onSubjectDescriptorChange_(e){if(this.selectedDescriptorA_!==e.detail.value){recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_SUBJECT_DESCRIPTOR_UPDATED)}this.selectedDescriptorA_=e.detail.value}onFeedbackSelectedOptionChanged_(e){this.selectedFeedbackOption_=e.detail.value;switch(e.detail.value){case CrFeedbackOption.UNSPECIFIED:this.wallpaperSearchHandler_.setUserFeedback(UserFeedback.kUnspecified);return;case CrFeedbackOption.THUMBS_UP:recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_THUMBS_UP_SELECTED);this.wallpaperSearchHandler_.setUserFeedback(UserFeedback.kThumbsUp);return;case CrFeedbackOption.THUMBS_DOWN:recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_THUMBS_DOWN_SELECTED);this.wallpaperSearchHandler_.setUserFeedback(UserFeedback.kThumbsDown);return}}onHistoryImageClick_(e){const index=getEventTargetIndex(e);const item=this.history_[index];recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_HISTORY_IMAGE_SELECTED);this.wallpaperSearchHandler_.setBackgroundToHistoryImage(item.id,item.descriptors??{subject:null,style:null,mood:null,color:null})}onInspirationGroupTitleClick_(e){assert(this.inspirationGroups_);const index=getEventTargetIndex(e);const item=this.inspirationGroups_[index];this.selectDescriptorsFromInspirationGroup_(item)}onInspirationToggleClick_(){this.openInspirations_=!this.openInspirations_}onInspirationImageClick_(e){const groupIndex=Number(e.currentTarget.dataset["groupIndex"]);const inspirationGroup=this.inspirationGroups_[groupIndex];const index=getEventTargetIndex(e);const item=inspirationGroup.inspirations[index];recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_INSPIRATION_THEME_SELECTED);this.wallpaperSearchHandler_.setBackgroundToInspirationImage(item.id,item.backgroundUrl);this.selectDescriptorsFromInspirationGroup_(inspirationGroup)}onLearnMoreClick_(e){e.preventDefault();this.wallpaperSearchHandler_.openHelpArticle()}onSelectedHueChanged_(){this.selectedDefaultColor_=undefined;this.selectedHue_=this.$.hueSlider.selectedHue;this.selectedDescriptorD_={hue:this.selectedHue_};recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_COLOR_DESCRIPTOR_UPDATED)}onSelectedHueDelete_(){this.selectedHue_=null;this.selectedDescriptorD_=null;this.$.hueSlider.hide();this.$.customColorContainer.focus()}async onSearchClick_(){if(!WindowProxy.getInstance().onLine){this.status_=WallpaperSearchStatus.kOffline;recordStatusChange(this.status_);return}const announcer=getAnnouncerInstance();recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_PROMPT_SUBMITTED);assert(this.descriptors_);const selectedDescriptorA=this.selectedDescriptorA_||getRandomDescriptorA(this.descriptors_.groups);this.expandCategoryForDescriptorA_(selectedDescriptorA);this.selectedDescriptorA_=selectedDescriptorA;this.loading_=true;this.results_=[];announcer.announce(this.i18n("wallpaperSearchLoadingA11yMessage"));const descriptors={subject:this.selectedDescriptorA_,style:this.selectedDescriptorB_??null,mood:this.selectedDescriptorC_??null,color:this.selectedDescriptorD_??null};this.resultsPromises_.push(this.wallpaperSearchHandler_.getWallpaperSearchResults(descriptors));if(this.resultsPromises_.length<=1){while(this.resultsPromises_.length>0){const{status:status,results:results}=await this.resultsPromises_[0];this.resultsPromises_.shift();if(this.resultsPromises_.length===0){this.loading_=false;this.results_=results;this.updateComplete.then(this.onResultsRender_.bind(this));this.resultsDescriptors_=descriptors;this.status_=status;if(this.status_===WallpaperSearchStatus.kOk){announcer.announce(this.i18n("wallpaperSearchSuccessA11yMessage",results.length));this.wallpaperSearchHandler_.launchHatsSurvey()}recordStatusChange(status);this.selectedFeedbackOption_=CrFeedbackOption.UNSPECIFIED}}}else{return}}onResultsRender_(){this.wallpaperSearchHandler_.setResultRenderTime(this.results_.map((r=>r.id)),WindowProxy.getInstance().now())}onResultClick_(e){const index=getEventTargetIndex(e);const item=this.results_[index];assert(this.resultsDescriptors_);recordCustomizeChromeAction(CustomizeChromeAction.WALLPAPER_SEARCH_RESULT_IMAGE_SELECTED);this.wallpaperSearchHandler_.setBackgroundToWallpaperSearchResult(item.id,WindowProxy.getInstance().now(),this.resultsDescriptors_)}onStatusChange_(){if(this.status_===WallpaperSearchStatus.kOk){this.$.wallpaperSearch.focus()}else{const error=this.shadowRoot.querySelector("#error");assert(error);error.focus()}}selectDescriptorsFromInspirationGroup_(group){const announcer=getAnnouncerInstance();const groupDescriptors=group.descriptors;this.selectedDescriptorA_=groupDescriptors.subject?.key||null;this.selectedDescriptorB_=groupDescriptors.style?.key||null;this.selectedDescriptorC_=groupDescriptors.mood?.key||null;if(groupDescriptors.color?.name!==undefined){const hex=descriptorDNameToHex(groupDescriptors.color.name);this.selectedDefaultColor_=hex;this.selectedHue_=null;this.selectedDescriptorD_={color:hexColorToSkColor(this.selectedDefaultColor_)}}else{this.selectedDefaultColor_=undefined;this.selectedHue_=null;this.selectedDescriptorD_=null}announcer.announce(this.i18n("wallpaperSearchDescriptorsChangedA11yMessage"))}shouldShowDeleteSelectedHueButton_(){return this.selectedHue_!==null}shouldShowFeedbackButtons_(){return!this.loading_&&this.results_.length>0}}customElements.define(WallpaperSearchElement.is,WallpaperSearchElement);