import '/strings.m.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/d3/d3.min.js';
import type { PricePoint } from '//resources/cr_components/commerce/shopping_service.mojom-webui.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface ShoppingInsightsHistoryGraphElement {
    $: {
        historyGraph: HTMLElement;
    };
}
export declare class ShoppingInsightsHistoryGraphElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        data: ArrayConstructor;
        locale: StringConstructor;
        currency: StringConstructor;
    };
    data: PricePoint[];
    locale: string;
    currency: string;
    private points;
    private isGraphInteracted_;
    private currentPricePointIndex_?;
    private resizeObserver_;
    private currentWidth_;
    private graphSvg_;
    private dateTopMarginPx_;
    private priceRightMarginPx_;
    private bubbleHorizontalPaddingPx_;
    private bubbleTopPaddingPx_;
    private bubbleBottomPaddingPx_;
    private bubbleCornerRadiusPx_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private stringToDate_;
    private onResize_;
    private getTooltipText_;
    private drawHistoryGraph_;
    private getAxisTicksY_;
    private getAxisTicksX_;
    private getLabelSize_;
    private getTooltipHeight_;
    private showTooltip_;
}
declare global {
    interface HTMLElementTagNameMap {
        'shopping-insights-history-graph': ShoppingInsightsHistoryGraphElement;
    }
}
