import '/strings.m.js';
import './commerce/shopping_list.js';
import './icons.html.js';
import './power_bookmarks_context_menu.js';
import './power_bookmarks_labels.js';
import './power_bookmark_row.js';
import './power_bookmarks_context_menu.js';
import './power_bookmarks_edit_dialog.js';
import '//bookmarks-side-panel.top-chrome/shared/sp_empty_state.js';
import '//bookmarks-side-panel.top-chrome/shared/sp_footer.js';
import '//bookmarks-side-panel.top-chrome/shared/sp_heading.js';
import '//bookmarks-side-panel.top-chrome/shared/sp_icons.html.js';
import '//bookmarks-side-panel.top-chrome/shared/sp_list_item_badge.js';
import '//bookmarks-side-panel.top-chrome/shared/sp_shared_style.css.js';
import '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_dialog/cr_dialog.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import '//resources/cr_elements/cr_toast/cr_toast.js';
import '//resources/cr_elements/cr_toolbar/cr_toolbar_search_field.js';
import '//resources/cr_elements/cr_toolbar/cr_toolbar_selection_overlay.js';
import '//resources/cr_elements/icons.html.js';
import '//resources/polymer/v3_0/iron-list/iron-list.js';
import type { SpEmptyStateElement } from '//bookmarks-side-panel.top-chrome/shared/sp_empty_state.js';
import type { BookmarkProductInfo } from '//resources/cr_components/commerce/shared.mojom-webui.js';
import type { CrActionMenuElement } from '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrDialogElement } from '//resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrLazyRenderElement } from '//resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import type { CrToastElement } from '//resources/cr_elements/cr_toast/cr_toast.js';
import type { CrToolbarSearchFieldElement } from '//resources/cr_elements/cr_toolbar/cr_toolbar_search_field.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { SortOrder } from './bookmarks.mojom-webui.js';
import type { BookmarksTreeNode } from './bookmarks.mojom-webui.js';
import { KeyArrowNavigationService } from './keyboard_arrow_navigation_service.js';
import type { PowerBookmarksContextMenuElement } from './power_bookmarks_context_menu.js';
import { PowerBookmarksDragManager } from './power_bookmarks_drag_manager.js';
import type { PowerBookmarksEditDialogElement } from './power_bookmarks_edit_dialog.js';
import type { PowerBookmarksLabelsElement } from './power_bookmarks_labels.js';
import type { PowerBookmarksDelegate } from './power_bookmarks_service.js';
export declare enum SearchAction {
    SHOWN = 0,
    SEARCHED = 1,
    COUNT = 2
}
export interface SortOption {
    sortOrder: SortOrder;
    label: string;
    lowerLabel: string;
}
export interface PowerBookmarksListElement {
    $: {
        bookmarks: HTMLElement;
        contextMenu: PowerBookmarksContextMenuElement;
        deletionToast: CrLazyRenderElement<CrToastElement>;
        powerBookmarksContainer: HTMLElement;
        searchField: CrToolbarSearchFieldElement;
        sortMenu: CrActionMenuElement;
        editDialog: PowerBookmarksEditDialogElement;
        disabledFeatureDialog: CrDialogElement;
        topLevelEmptyState: SpEmptyStateElement;
        folderEmptyState: SpEmptyStateElement;
        heading: HTMLElement;
        footer: HTMLElement;
        labels: PowerBookmarksLabelsElement;
    };
}
export declare class PowerBookmarksListElement extends PolymerElement implements PowerBookmarksDelegate {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        displayLists_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        compact_: {
            type: BooleanConstructor;
            value: () => boolean;
            observer: string;
        };
        contextMenuBookmark_: ObjectConstructor;
        activeFolderPath_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        currentUrl_: StringConstructor;
        imageUrls_: {
            type: ObjectConstructor;
            value: () => {};
        };
        labels_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        activeSortIndex_: {
            type: NumberConstructor;
            value: () => number;
        };
        sortTypes_: {
            type: ArrayConstructor;
            value: () => {
                sortOrder: SortOrder;
                label: string;
                lowerLabel: string;
            }[];
        };
        editing_: {
            type: BooleanConstructor;
            value: boolean;
        };
        selectedBookmarks_: {
            type: ObjectConstructor;
            value: () => {};
        };
        guestMode_: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        renamingId_: {
            type: StringConstructor;
            value: string;
        };
        bookmarksTreeViewEnabled_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        deletionDescription_: {
            type: StringConstructor;
            value: string;
        };
        hasScrollbars_: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        hasLoadedData_: {
            type: BooleanConstructor;
            value: boolean;
        };
        searchQuery_: StringConstructor;
        shoppingCollectionFolderId_: StringConstructor;
        trackedProductInfos_: {
            type: ObjectConstructor;
            value: () => {};
        };
        updatedElementIds_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        hasSomeActiveFilter_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        hasShownBookmarks_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        canDrag_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
            observer: string;
        };
        hasActiveDrag_: {
            type: BooleanConstructor;
            value: boolean;
        };
        sectionVisibility_: {
            type: ObjectConstructor;
            computed: string;
        };
        hasFolders_: {
            type: BooleanConstructor;
            computed: string;
            reflect: boolean;
        };
    };
    static get observers(): string[];
    private bookmarksApi_;
    private priceTrackingProxy_;
    private shoppingListenerIds_;
    private displayLists_;
    private trackedProductInfos_;
    private availableProductInfos_;
    private bookmarksService_;
    private keyArrowNavigationService_;
    private bookmarksDragManager_;
    private focusOutlineManager_;
    private compact_;
    private activeFolderPath_;
    private labels_;
    private imageUrls_;
    private activeSortIndex_;
    private sortTypes_;
    private searchQuery_;
    private currentUrl_;
    private editing_;
    private selectedBookmarks_;
    private guestMode_;
    private renamingId_;
    private deletionDescription_;
    private shownBookmarksResizeObserver_?;
    private hasScrollbars_;
    private contextMenuBookmark_;
    private hasLoadedData_;
    private canDrag_;
    private hasActiveDrag_;
    private hasSomeActiveFilter_;
    private hasShownBookmarks_;
    private sectionVisibility_;
    private hasFolders_;
    private shoppingCollectionFolderId_;
    private recordCountMetricsOnNextUpdate_;
    private updatedElementIds_;
    private bookmarksTreeViewEnabled_;
    private isBookmarksInTransportModeEnabled;
    private rebuildNavigationElementsDebouncer_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    setCurrentUrl(url: string): void;
    getCurrentUrlForTesting(): string | undefined;
    setImageUrl(bookmark: BookmarksTreeNode, url: string): void;
    onBookmarksLoaded(): void;
    onBookmarkChanged(id: string): void;
    onBookmarkAdded(bookmark: BookmarksTreeNode, parent: BookmarksTreeNode): void;
    onBookmarkMoved(bookmark: BookmarksTreeNode, oldParent: BookmarksTreeNode, newParent: BookmarksTreeNode): void;
    onBookmarkRemoved(bookmark: BookmarksTreeNode): void;
    getTrackedProductInfos(): {
        [key: string]: BookmarkProductInfo;
    };
    getAvailableProductInfos(): Map<string, BookmarkProductInfo>;
    getProductImageUrl(bookmark: BookmarksTreeNode): string;
    /** PowerBookmarksDragDelegate */
    getFallbackBookmark(): BookmarksTreeNode;
    /** PowerBookmarksDragDelegate */
    getFallbackDropTargetElement(): HTMLElement;
    /** PowerBookmarksDragDelegate */
    onFinishDrop(dropTarget: BookmarksTreeNode): void;
    /** PowerBookmarksDragDelegate */
    setHasActiveDrag(hasActiveDrag: boolean): void;
    clickBookmarkRowForTests(bookmark: BookmarksTreeNode): void;
    setRenamingIdForTests(id: string): void;
    /**
     * Returns the KeyboardNavigationService instance for testing.
     */
    getKeyboardNavigationServiceforTesting(): KeyArrowNavigationService;
    getDragManagerForTesting(): PowerBookmarksDragManager;
    private notifyPathIfVisible_;
    private computeHasFolders_;
    private computeCanDrag_;
    private focusBookmark_;
    private onBookmarkPriceTracked_;
    private onBookmarkPriceUntracked_;
    private bookmarkIsShowing_;
    private removeNodeFromDisplayLists_;
    /**
     * Returns true if the given node is either the current active folder or a
     * root folder that isn't shown itself while the all bookmarks list is shown.
     */
    private visibleParent_;
    private bookmarkShouldShow_;
    private getActiveFolder_;
    private getBackButtonLabel_;
    private getBookmarksListRole_;
    private getViewButtonIcon_;
    private getViewButtonTooltip_;
    private updateShoppingCollectionFolderId_;
    private getActiveFolderLabel_;
    private getSortLabel_;
    private updateShoppingData_;
    private setAvailableProductInfo_;
    /**
     * Update the lists of bookmarks and folders displayed to the user.
     */
    private updateDisplayLists_;
    private updateListScrollOffset_;
    private onCanDragChange_;
    private recordMetricsOnConnected_;
    private recordBookmarkCountMetrics_;
    private canAddCurrentUrl_;
    private getSortMenuItemLabel_;
    private getSortMenuItemLowerLabel_;
    private sortMenuItemIsSelected_;
    private onRowToggled_;
    /**
     * Invoked when the user clicks a power bookmarks row. This will either
     * display children in the case of a folder row, or open the URL in the case
     * of a bookmark row.
     */
    private onRowClicked_;
    private onRowSelectedChange_;
    private onBookmarksEdited_;
    private setRenamingId_;
    private onRename_;
    private getDisplayListElement_;
    private notifyBookmarksListResize_;
    private getFilterHeading_;
    private getSelectedDescription_;
    private getSelectedBookmarksList_;
    private getSelectedBookmarksLength_;
    /**
     * Toggles the given label between active and inactive.
     */
    private onLabelsChanged_;
    /**
     * Moves the displayed folders up one level when the back button is clicked.
     */
    private onBackClicked_;
    private shouldHideBackButton_;
    private onSearchChanged_;
    private onSearchBlurred_;
    private onContextMenuShown_;
    private onShowContextMenuClicked_;
    private getParentFolder_;
    private onShowSortMenuClicked_;
    private onAddNewFolderClicked_;
    private onBulkEditClicked_;
    private onDeleteClicked_;
    private onContextMenuEditClicked_;
    private onContextMenuDeleteClicked_;
    private onContextMenuClosed_;
    private showDeletionToastWithCount_;
    private showDisabledFeatureDialog_;
    private closeDisabledFeatureDialog_;
    private onUndoClicked_;
    private onMoveClicked_;
    private showEditDialog_;
    private onBulkEditMenuClicked_;
    private onSortTypeClicked_;
    private onViewToggleClicked_;
    private onAddTabClicked_;
    private hideAddTabButton_;
    private disableBackButton_;
    private getEmptyTitle_;
    private getEmptyBody_;
    private getEmptyImagePath_;
    private getEmptyImagePathDark_;
    private computeHasSomeActiveFilter_;
    private computeHasShownBookmarks_;
    private computeSectionVisibility_;
    private onShownBookmarksResize_;
}
declare global {
    interface HTMLElementTagNameMap {
        'power-bookmarks-list': PowerBookmarksListElement;
    }
}
