// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{PageImageServiceBrowserProxy}from"//resources/cr_components/page_image_service/browser_proxy.js";import{ClientId as PageImageServiceClientId}from"//resources/cr_components/page_image_service/page_image_service.mojom-webui.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{assert}from"chrome://resources/js/assert.js";import{BookmarksApiProxyImpl}from"./bookmarks_api_proxy.js";const MAX_IMAGE_SERVICE_REQUESTS=30;export function editingDisabledByPolicy(bookmarks){if(!loadTimeData.getBoolean("editBookmarksEnabled")){return true}if(loadTimeData.getBoolean("hasManagedBookmarks")){const managedNodeId=loadTimeData.getString("managedBookmarksFolderId");for(const bookmark of bookmarks){if(bookmark.id===managedNodeId||bookmark.parentId===managedNodeId){return true}}}return false}export function getFolderDescendants(folder,excludeFolder=undefined){if(folder===excludeFolder){return[]}let expanded=[folder];if(folder.children){folder.children.forEach((child=>{expanded=expanded.concat(getFolderDescendants(child,excludeFolder))}))}return expanded}function compareNewest(a,b){let aValue;let bValue;getFolderDescendants(a).forEach((descendant=>{if(descendant.dateAdded!==null&&(!aValue||descendant.dateAdded>aValue)){aValue=descendant.dateAdded}}));getFolderDescendants(b).forEach((descendant=>{if(descendant.dateAdded!==null&&(!bValue||descendant.dateAdded>bValue)){bValue=descendant.dateAdded}}));return bValue-aValue}function compareOldest(a,b){let aValue;let bValue;getFolderDescendants(a).forEach((descendant=>{if(descendant.dateAdded!==null&&(!aValue||descendant.dateAdded<aValue)){aValue=descendant.dateAdded}}));getFolderDescendants(b).forEach((descendant=>{if(descendant.dateAdded!==null&&(!bValue||descendant.dateAdded<bValue)){bValue=descendant.dateAdded}}));return aValue-bValue}function compareLastOpened(a,b){let aValue;let bValue;getFolderDescendants(a).forEach((descendant=>{const descendantValue=descendant.dateLastUsed!==null?descendant.dateLastUsed:descendant.dateAdded;if(!aValue||descendantValue>aValue){aValue=descendantValue}}));getFolderDescendants(b).forEach((descendant=>{const descendantValue=descendant.dateLastUsed!==null?descendant.dateLastUsed:descendant.dateAdded;if(!bValue||descendantValue>bValue){bValue=descendantValue}}));return bValue-aValue}function compareAlphabetical(a,b){return a.title.localeCompare(b.title)}function compareReverseAlphabetical(a,b){return b.title.localeCompare(a.title)}export class PowerBookmarksService{delegate_;bookmarksApi_=BookmarksApiProxyImpl.getInstance();listeners_=new Map;folders_=[];bookmarksWithCachedImages_=new Set;activeImageServiceRequestCount_=0;inactiveImageServiceRequests_=new Map;maxImageServiceRequests_=MAX_IMAGE_SERVICE_REQUESTS;constructor(delegate){this.delegate_=delegate}startListening(){this.bookmarksApi_.getActiveUrl().then((url=>this.delegate_.setCurrentUrl(url)));this.bookmarksApi_.getAllBookmarks().then((result=>{this.folders_=result.nodes;this.addListener_("onTabActivated",(_info=>{this.bookmarksApi_.getActiveUrl().then((url=>this.delegate_.setCurrentUrl(url)))}));this.addListener_("onTabUpdated",((_tabId,_changeInfo,tab)=>{if(tab.active){this.delegate_.setCurrentUrl(tab.url)}}));this.bookmarksApi_.pageCallbackRouter.onBookmarkNodeAdded.addListener(this.onBookmarkNodeAdded_.bind(this));this.bookmarksApi_.pageCallbackRouter.onBookmarkNodesRemoved.addListener(this.onBookmarkNodesRemoved_.bind(this));this.bookmarksApi_.pageCallbackRouter.onBookmarkParentFolderChildrenReordered.addListener(this.onBookmarkParentFolderChildrenReordered_.bind(this));this.bookmarksApi_.pageCallbackRouter.onBookmarkNodeMoved.addListener(this.onBookmarkNodeMoved_.bind(this));this.bookmarksApi_.pageCallbackRouter.onBookmarkNodeChanged.addListener(this.onBookmarkNodeChanged_.bind(this));this.delegate_.onBookmarksLoaded()}))}stopListening(){for(const[eventName,callback]of this.listeners_.entries()){this.bookmarksApi_.callbackRouter[eventName].removeListener(callback)}}getFolders(){return this.folders_}getTopLevelBookmarks(){return this.filterBookmarks(undefined,0,undefined,[])}filterBookmarks(activeFolder,activeSortIndex,searchQuery,labels,excludeFolder){let bookmarks=[];if(activeFolder){bookmarks=activeFolder.children.slice()}else{let topLevelBookmarks=[];this.folders_.forEach((folder=>topLevelBookmarks=topLevelBookmarks.concat(folder.id===loadTimeData.getString("otherBookmarksId")||folder.id===loadTimeData.getString("mobileBookmarksId")?folder.children:[folder])));bookmarks=topLevelBookmarks}if(searchQuery||labels.find((label=>label.active))){bookmarks=this.applySearchQueryAndLabels_(labels,searchQuery,bookmarks,excludeFolder)}const sortChangedPosition=this.sortBookmarks(bookmarks,activeSortIndex);return sortChangedPosition?bookmarks.slice():bookmarks}sortBookmarks(bookmarks,activeSortIndex){let changedPosition=false;bookmarks.sort((function(a,b){if(!a.url&&b.url){return-1}else if(a.url&&!b.url){changedPosition=true;return 1}else{let toReturn;if(activeSortIndex===0){toReturn=compareNewest(a,b)}else if(activeSortIndex===1){toReturn=compareOldest(a,b)}else if(activeSortIndex===2){toReturn=compareLastOpened(a,b)}else if(activeSortIndex===3){toReturn=compareAlphabetical(a,b)}else{toReturn=compareReverseAlphabetical(a,b)}if(toReturn>0){changedPosition=true}return toReturn}}));return changedPosition}refreshDataForBookmarks(bookmarks){bookmarks.forEach((bookmark=>this.findBookmarkImageUrls_(bookmark,true,false)))}findBookmarkWithId(id){if(id){const path=this.findPathToId(id);if(path){return path[path.length-1]}}return undefined}canAddUrl(url,folder){if(!folder){folder=this.findBookmarkWithId(loadTimeData.getString("otherBookmarksId"));if(!folder){return false}}return folder.children.findIndex((b=>b.url===url))===-1}bookmarkMatchesSearchQueryAndLabels(bookmark,labels,searchQuery){return this.nodeMatchesContentFilters_(bookmark,labels)&&(!searchQuery||!!bookmark.title&&bookmark.title.toLocaleLowerCase().includes(searchQuery)||!!bookmark.url&&bookmark.url.toLocaleLowerCase().includes(searchQuery))}setMaxImageServiceRequestsForTesting(max){this.maxImageServiceRequests_=max}getPriceTrackedInfo(bookmark){const trackedProductInfos=this.delegate_.getTrackedProductInfos();const priceTrackValue=Object.entries(trackedProductInfos).find((([key,_val])=>key===bookmark.id))?.[1];return priceTrackValue}getAvailableProductInfo(bookmark){const availableProductInfos=this.delegate_.getAvailableProductInfos();return availableProductInfos.get(bookmark.id)}applySearchQueryAndLabels_(labels,searchQuery,shownBookmarks,excludeFolder){let searchSpace=[];shownBookmarks.forEach((bookmark=>{searchSpace=searchSpace.concat(getFolderDescendants(bookmark,excludeFolder))}));return searchSpace.filter((bookmark=>this.bookmarkMatchesSearchQueryAndLabels(bookmark,labels,searchQuery)))}nodeMatchesContentFilters_(bookmark,labels){const isPriceTracked=!!this.getPriceTrackedInfo(bookmark);if(labels[0]&&labels[0].active&&!isPriceTracked){return false}return true}addListener_(eventName,callback){this.bookmarksApi_.callbackRouter[eventName].addListener(callback);this.listeners_.set(eventName,callback)}onBookmarkNodeChanged_(id,newTitle,newUrl){const bookmark=this.findBookmarkWithId(id);bookmark.title=newTitle;if(bookmark.url&&newUrl){bookmark.url=newUrl}const deepCopyBookmark=structuredClone(bookmark);const parent=this.findBookmarkWithId(bookmark.parentId);if(parent){const index=parent.children.findIndex((child=>child.id===bookmark.id));parent.children[index]=deepCopyBookmark}this.findBookmarkImageUrls_(deepCopyBookmark,false,true);this.delegate_.onBookmarkChanged(id)}onBookmarkNodeAdded_(addedNode){const parent=this.findBookmarkWithId(addedNode.parentId);if(!addedNode.url&&!addedNode.children){addedNode.children=[]}parent.children.splice(addedNode.index,0,addedNode);this.delegate_.onBookmarkAdded(addedNode,parent);this.findBookmarkImageUrls_(addedNode,false,false)}onBookmarkNodeMoved_(oldParentId,oldIndex,newParentId,newIndex){const oldParent=this.findBookmarkWithId(oldParentId);const movedNode=oldParent.children[oldIndex];Object.assign(movedNode,{index:newIndex,parentId:newParentId});oldParent.children.splice(oldIndex,1);const newParent=this.findBookmarkWithId(newParentId);if(!newParent.children){newParent.children=[]}newParent.children.splice(newIndex,0,movedNode);this.delegate_.onBookmarkMoved(movedNode,oldParent,newParent)}onBookmarkNodesRemoved_(removedNodeIds){for(const id of removedNodeIds){const path=this.findPathToId(id);const removedNode=path.pop();const parent=path[path.length-1];parent.children.splice(parent.children.indexOf(removedNode),1);this.delegate_.onBookmarkRemoved(removedNode)}}onBookmarkParentFolderChildrenReordered_(folderId,childrenOrderedIds){const folder=this.findBookmarkWithId(folderId);if(!folder.children){assert(childrenOrderedIds.length===0);return}assert(folder.children.length===childrenOrderedIds.length);const childrenMap=new Map;for(const child of folder.children){childrenMap.set(child.id,child)}folder.children=[];for(const id of childrenOrderedIds){folder.children.push(childrenMap.get(id))}}findPathToId(id){const path=[];function findPathByIdInternal(id,node){if(node.id===id){path.push(node);return true}if(!node.children){return false}path.push(node);const foundInChildren=node.children.some((child=>findPathByIdInternal(id,child)));if(!foundInChildren){path.pop()}return foundInChildren}this.folders_.some((bookmark=>findPathByIdInternal(id,bookmark)));return path}findBookmarkImageUrls_(bookmark,recurse,forceUpdate){const hasImage=this.bookmarksWithCachedImages_.has(bookmark.id.toString());if(forceUpdate||!hasImage){this.delegate_.setImageUrl(bookmark,"");if(bookmark.url){const productImageUrl=this.delegate_.getProductImageUrl(bookmark);if(productImageUrl){this.delegate_.setImageUrl(bookmark,productImageUrl);this.bookmarksWithCachedImages_.add(bookmark.id.toString())}else{if(this.activeImageServiceRequestCount_<this.maxImageServiceRequests_){this.findBookmarkImageUrl_(bookmark)}else{this.inactiveImageServiceRequests_.set(bookmark.id,bookmark)}}}}if(recurse&&bookmark.children){bookmark.children.forEach((child=>this.findBookmarkImageUrls_(child,false,forceUpdate)))}}async findBookmarkImageUrl_(bookmark){this.inactiveImageServiceRequests_.delete(bookmark.id);if(!bookmark.url){return}const url={url:bookmark.url};this.activeImageServiceRequestCount_++;const{result:result}=await PageImageServiceBrowserProxy.getInstance().handler.getPageImageUrl(PageImageServiceClientId.Bookmarks,url,{suggestImages:false,optimizationGuideImages:true});this.activeImageServiceRequestCount_--;this.delegate_.setImageUrl(bookmark,result?result.imageUrl.url:"");this.bookmarksWithCachedImages_.add(bookmark.id.toString());if(this.inactiveImageServiceRequests_.size>0){this.findBookmarkImageUrl_(this.inactiveImageServiceRequests_.values().next().value)}}static getInstance(){assert(instance);return instance}static setInstance(obj){instance=obj}}let instance=null;